/* c_block.hh 1.3 95/12/23 03:11:46 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// The game window is divided into rows/cols of 9x15 blocks.
// The rows range from 0 to GAMEROWS-1 and columns range from 0
// to GAMECOLS-1. This header describes these blocks. See
// c_block.cc for member function definitions. This class is most
// useful for obtaining the pixel position of a point in a 9x15
// block given the row/col position of the block within the game
// window.


#ifndef _BLOCK_
#define _BLOCK_

#include "common.hh"
#include "params.hh"

// Pixel dimensions of a 9x15 block:

#define BLOCKW 9		// width
#define BLOCKH 15		// height

// Half of the pixel width / pixel height of a 9x15 block:

#define BLOCKHALFW 4
#define BLOCKHALFH 7

// Pixel position of the "text origin" of a 9x15 block, ie where
// to place a character within a 9x15 block so it will stay
// completely within the block

#define TEXTORIGINX 0
#define TEXTORIGINY 12

// class for handling a 9x15 pixel block

class Block
{
public:
  Block();
  Block(int r, int c);		// args are row/col position in game window
  Block(const Block& b);
  Block& operator=(const Block& b);
  void setrow(int r);
  void setcol(int c);
  int getrow() const {return (row);}
  int getcol() const {return (col);}
  Point origin() const;
  Point center() const;
  Point northwest() const;
  Point northeast() const;
  Point southeast() const;
  Point southwest() const;
private:
  int row, col;
};


#endif				// _BLOCK_


// Anatomy of a 9x15 pixel block:

//       0  1  2  3  4  5  6  7  8  
//      ----------------------------
// 0    |  |  |  |  |  |  |  |  |  |
//      ----------------------------
// 1    |  |  |  |  |  |  |  |  |  |		 
//      ----------------------------
// 2    |  |  |  |  |  |  |  |  |  |
//      ----------------------------
// 3    |  |  |  |  |  |  |  |  |  |				 
//      ----------------------------
// 4    |  |  |  |  |  |  |  |  |  |				 
//      ----------------------------
// 5    |  |  |  |  |  |  |  |  |  |				 
//      ----------------------------
// 6    |  |  |  |  |  |  |  |  |  |				 
//      ----------------------------
// 7    |  |  |  |  |XX|  |  |  |  |				 
//      ----------------------------
// 8    |  |  |  |  |  |  |  |  |  |				 
//      ----------------------------
// 9    |  |  |  |  |  |  |  |  |  |				 
//      ----------------------------
// 10   |  |  |  |  |  |  |  |  |  |				 
//      ----------------------------
// 11   |  |  |  |  |  |  |  |  |  |				 
//      ----------------------------
// 12   |OO|  |  |  |  |  |  |  |  |				 
//      ----------------------------
// 13   |  |  |  |  |  |  |  |  |  |				 
//      ----------------------------
// 14   |  |  |  |  |  |  |  |  |  |				 
//      ----------------------------

// Position "OO" is the text origin, and "XX" is the position returned
// by center() defined above.

// end
