/******************************************************************************
Copyright (c) 1994, 1997 by Jin Yu.
All rights reserved.

The software provided hereunder is on an "AS IS" basis. Permission to
use, copy, modify, and distribute this software and its documentation
for any non-commercial purpose, without fee, and without written
agreement is hereby granted, provided that the above copyright notice
appears in all copies of this software.
******************************************************************************/

#include "xminehunter.h"


void mine_hunter_T::init_gui(int argc, char** argv)
{
  Arg args[2];
  String fallbacks[] = {
    "XMinehunter*background: gray",
    "XMinehunter*highlightThickness: 0",
    "XMinehunter*fontList: -*-helvetica-bold-r-normal--14-140*=TAG1,\
                           -*-helvetica-bold-r-normal--12-120*=TAG2",
    NULL
  };


  // setting up initial interface

  //XtSetArg(args[0], XmNnoResize, TRUE);
  //XtSetArg(args[0], XmNresizable, FALSE);
  XtSetArg(args[0], XmNallowShellResize, TRUE);
  gui_part->MainShellW = XtAppInitialize(&gui_part->AppCon, "XMinehunter",
			   NULL, 0, &argc, argv, fallbacks, args, 1);

  Widget xm_get_xm_dpy = XmGetXmDisplay(XtDisplay(gui_part->MainShellW));
  XtSetArg(args[0], XmNdragInitiatorProtocolStyle, XmDRAG_NONE);
  XtSetArg(args[1], XmNdragReceiverProtocolStyle, XmDRAG_NONE);
  XtSetValues(xm_get_xm_dpy, args, 2);

  gui_part->MainWinW = XmCreateMainWindow(gui_part->MainShellW,
				"MainWindow", NULL, 0);

  unsigned long bgpix;

  Display* dpy = XtDisplay(gui_part->MainShellW);
  int scr = DefaultScreen(dpy);

  bgpix = WhitePixel(dpy, scr);

  create_pixmaps();

  // create menubar
  gui_part->MenuBarW =
        XmVaCreateSimpleMenuBar(gui_part->MainWinW, "MenuBar",
                XmVaCASCADEBUTTON,
		  XmStringCreateLocalized("File"), 'F',
                XmVaCASCADEBUTTON,
		  XmStringCreateLocalized("Game"), 'G',
		XmVaCASCADEBUTTON,
		  XmStringCreateLocalized("Help"), 'H',
                NULL);

  // indicate help menu
  XtSetArg(args[0], XmNmenuHelpWidget,
                XtNameToWidget(gui_part->MenuBarW, "button_2"));
  XtSetValues(gui_part->MenuBarW, args, 1);

  // setup each pull-down menus

  gui_part->FileMenuW =
        XmVaCreateSimplePulldownMenu(gui_part->MenuBarW, "File",
                0, NULL,
                XmVaPUSHBUTTON, XmStringCreateLocalized("New"),
                        'N', NULL, NULL,
		XmVaPUSHBUTTON, XmStringCreateLocalized("High Scores..."),
			'H', NULL, NULL,
		XmVaSEPARATOR,
                XmVaPUSHBUTTON, XmStringCreateLocalized("Quit"),
                        'Q', NULL, NULL,
                NULL);

  XtAddCallback(XtNameToWidget(gui_part->FileMenuW, "button_0"),
		XmNactivateCallback,
                XtCallbackProc(&mine_hunter_T::new_game_cb), XtPointer(this));
  XtAddCallback(XtNameToWidget(gui_part->FileMenuW, "button_1"),
		XmNactivateCallback,
                XtCallbackProc(&mine_hunter_T::high_score_cb),XtPointer(this));
  XtAddCallback(XtNameToWidget(gui_part->FileMenuW, "button_2"),
		XmNactivateCallback,
                XtCallbackProc(&mine_hunter_T::file_quit_cb), XtPointer(this));


  gui_part->GameMenuW =
        XmVaCreateSimplePulldownMenu(gui_part->MenuBarW, "Game",
                1, NULL,
                XmVaPUSHBUTTON, XmStringCreateLocalized("Easy"),
                        'E', NULL, NULL,
                XmVaPUSHBUTTON, XmStringCreateLocalized("Medium"),
                        'M', NULL, NULL,        
                XmVaPUSHBUTTON, XmStringCreateLocalized("Hard"),
                        'H', NULL, NULL,
		XmVaSEPARATOR,
                XmVaPUSHBUTTON, XmStringCreateLocalized("Customized..."),
                        'C', NULL, NULL,
                NULL);

  XtAddCallback(XtNameToWidget(gui_part->GameMenuW, "button_0"),
                XmNactivateCallback,
                XtCallbackProc(&mine_hunter_T::game_easy_cb),
		XtPointer(this));
  XtAddCallback(XtNameToWidget(gui_part->GameMenuW, "button_1"),
                XmNactivateCallback,
                XtCallbackProc(&mine_hunter_T::game_medium_cb),
		XtPointer(this));
  XtAddCallback(XtNameToWidget(gui_part->GameMenuW, "button_2"),
                XmNactivateCallback,
                XtCallbackProc(&mine_hunter_T::game_hard_cb),
		XtPointer(this));
  XtAddCallback(XtNameToWidget(gui_part->GameMenuW, "button_3"),
                XmNactivateCallback,
                XtCallbackProc(&mine_hunter_T::game_customized_cb),
		XtPointer(this));

  gui_part->HelpMenuW =
        XmVaCreateSimplePulldownMenu(gui_part->MenuBarW, "Help",
                2, NULL,
                XmVaPUSHBUTTON, XmStringCreateLocalized("About..."),
                        'A', NULL, NULL,
	        XmVaSEPARATOR,
                XmVaPUSHBUTTON, XmStringCreateLocalized("How To Play..."),
                        'H', NULL, NULL,
                NULL);
  XtAddCallback(XtNameToWidget(gui_part->HelpMenuW, "button_0"),
                XmNactivateCallback,
                XtCallbackProc(&mine_hunter_T::about_cb),
		XtPointer(this));
  XtAddCallback(XtNameToWidget(gui_part->HelpMenuW, "button_1"),
                XmNactivateCallback,
                XtCallbackProc(&mine_hunter_T::help_cb),
		XtPointer(this));


  // manage the command window
  gui_part->CommandW = XmCreateForm(gui_part->MainWinW, "CommandWindow",
					NULL, 0);
  Widget time_label = XmCreateLabel(gui_part->CommandW, "Time:", NULL, 0);
  XtVaSetValues(time_label,
		XmNtopAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		XmNtopOffset, 3,
		XmNbottomOffset, 3,
		XmNleftOffset, 3,
		XmNrightOffset, 3,
		NULL);
  Widget time_frame = XmCreateFrame(gui_part->CommandW, "Time Frame", NULL, 0);
  XtVaSetValues(time_frame,
		XmNshadowType, XmSHADOW_IN,
		XmNshadowThickness, 3,
                XmNtopAttachment, XmATTACH_FORM,
                XmNbottomAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_WIDGET,
		XmNleftWidget, time_label,
                XmNtopOffset, 10,
                XmNbottomOffset, 10,
		XmNleftOffset, 3,
		NULL);
  gui_part->TimeW = XmCreateLabel(time_frame, "0", NULL, 0);
  XtVaSetValues(gui_part->TimeW,
		XmNbackground, bgpix,
		NULL);

  if (gui_part->normal_pmap == XtUnspecifiedPixmap)
    gui_part->NewGameW = XtVaCreateWidget("New Game", xmPushButtonWidgetClass,
					  gui_part->CommandW,
					  NULL);
  else
    gui_part->NewGameW = XtVaCreateWidget("", xmPushButtonWidgetClass,
					  gui_part->CommandW,
				  XmNlabelType, XmPIXMAP,
				  XmNlabelPixmap, gui_part->normal_pmap,
					  NULL);
  XtAddCallback(gui_part->NewGameW, XmNactivateCallback,
                XtCallbackProc(&mine_hunter_T::new_game_cb), XtPointer(this));

  Widget count_frame = XmCreateFrame(gui_part->CommandW, "Count Frame", NULL, 0);
  XtVaSetValues(count_frame,
		XmNshadowType, XmSHADOW_IN,
		XmNshadowThickness, 3,
                XmNtopAttachment, XmATTACH_FORM,
                XmNbottomAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
                XmNtopOffset, 10,
                XmNbottomOffset, 10,
		XmNleftOffset, 3,
		XmNrightOffset, 6,
		NULL);
  char count_str[80];
  sprintf(count_str, "%d", app_part->num_of_mines);
  gui_part->MineCountW = XmCreateLabel(count_frame, count_str, NULL, 0);
  XtVaSetValues(gui_part->MineCountW,
		XmNbackground, bgpix,
		NULL);
  Widget count_label = XmCreateLabel(gui_part->CommandW, "Mines:", NULL, 0);
  XtVaSetValues(count_label,
		XmNtopAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_WIDGET,
		XmNrightWidget, count_frame,
		XmNtopOffset, 3,
		XmNbottomOffset, 3,
		XmNrightOffset, 3,
		NULL);


  // manage the message window
  gui_part->MessageString = XmStringCreateLtoR(
	    "XMinehunter, version 0.4, by jyu@acm.org\nFor My Mother", "TAG2");
  gui_part->MessageW = XmCreateLabel(gui_part->MainWinW,
				     "MessageWindow", NULL, 0);
  XtVaSetValues(gui_part->MessageW,
		XmNlabelString, gui_part->MessageString,
		NULL);


  XtVaSetValues(gui_part->MainWinW, XmNshowSeparator, TRUE,
		XmNmenuBar, gui_part->MenuBarW,
		XmNcommandWindow, gui_part->CommandW,
		XmNmessageWindow, gui_part->MessageW, NULL);

  XtManageChild(gui_part->MessageW);
  XtManageChild(time_label);
  XtManageChild(gui_part->TimeW);
  XtManageChild(time_frame);
  XtManageChild(count_label);
  XtManageChild(gui_part->MineCountW);
  XtManageChild(count_frame);
  XtManageChild(gui_part->NewGameW);
  XtManageChild(gui_part->CommandW);
  XtManageChild(gui_part->MenuBarW);
  XtManageChild(gui_part->MainWinW);

  setup_blocks();

}


void mine_hunter_T::setup_blocks(void)
{
  Arg args[5];
  int i, j;

  gui_part->FieldW = XmCreateRowColumn(gui_part->MainWinW, "MineField",
				       NULL, 0);
  XtVaSetValues(gui_part->FieldW,
                XmNorientation, XmHORIZONTAL,
                XmNpacking, XmPACK_COLUMN,
		XmNnumColumns, app_part->field_height,
                XmNadjustLast, FALSE,
                XmNmarginHeight, 0,
                XmNmarginWidth, 0,
                XmNspacing, 0,
                NULL);

  XtVaSetValues(gui_part->MainWinW, XmNworkWindow, gui_part->FieldW, NULL);

  gui_part->BlockW = new Widget* [app_part->field_height];
  for (i=0; i<app_part->field_height; i++) {
    gui_part->BlockW[i] = new Widget[app_part->field_width];
    for (j=0; j<app_part->field_width; j++) {
      XtSetArg(args[0], XmNwidth, gui_part->mine_width);
      XtSetArg(args[1], XmNheight, gui_part->mine_width);
      XtSetArg(args[2], XmNlabelType, XmPIXMAP);
      XtSetArg(args[3], XmNlabelPixmap, gui_part->cover_bmap);
      gui_part->BlockW[i][j] =
		XmCreatePushButton(gui_part->FieldW, "Block", args, 4);
      XtManageChild(gui_part->BlockW[i][j]);
      XtAddCallback(gui_part->BlockW[i][j], XmNactivateCallback,
  		XtCallbackProc(&mine_hunter_T::open_mine_cb), XtPointer(this));
      XtAddEventHandler(gui_part->BlockW[i][j], ButtonReleaseMask, False,
	        XtEventHandler(&mine_hunter_T::put_flag_eh), XtPointer(this));
    }
  }

  XtManageChild(gui_part->FieldW);

}


void mine_hunter_T::lose(void)
{
  int i, j;
  Arg args[2];

  for (i=0; i<app_part->field_height; i++)
    for (j=0; j<app_part->field_width; j++) {
      if ( !app_part->state[i][j].open ) {
	if ( app_part->state[i][j].surface == Flag &&
	     app_part->state[i][j].bottom != Bomb ) {
	  XtSetArg(args[0], XmNlabelPixmap, gui_part->wrongflag_bmap);
	  XtSetValues(gui_part->BlockW[i][j], args, 1);
	}
	if ( app_part->state[i][j].surface != Flag
	     && app_part->state[i][j].bottom == Bomb )
	  show_bottom(i, j);
      }
      XtRemoveCallback(gui_part->BlockW[i][j], XmNactivateCallback,
  		XtCallbackProc(&mine_hunter_T::open_mine_cb), XtPointer(this));
      XtRemoveEventHandler(gui_part->BlockW[i][j], ButtonReleaseMask, False,
	        XtEventHandler(&mine_hunter_T::put_flag_eh), XtPointer(this));
    }
      
  XBell(XtDisplay(gui_part->MainShellW), 0);
  XmString xm_str = XmStringCreate("You Lost!", "TAG2");
  XtVaSetValues(gui_part->MessageW, XmNlabelString, xm_str, NULL);
  XmStringFree(xm_str);

  XtRemoveTimeOut(gui_part->Timer);
  gui_part->Timer = XtIntervalId(0);

  if (gui_part->cry_pmap != XtUnspecifiedPixmap)
    XtVaSetValues(gui_part->NewGameW,
		  XmNlabelPixmap, gui_part->cry_pmap,
		  NULL);

}


void mine_hunter_T::win(void)
{
  int i, j;
  int fd;

  for (i=0; i<app_part->field_height; i++)
    for (j=0; j<app_part->field_width; j++) {
      XtRemoveCallback(gui_part->BlockW[i][j], XmNactivateCallback,
  		XtCallbackProc(&mine_hunter_T::open_mine_cb), XtPointer(this));
      XtRemoveEventHandler(gui_part->BlockW[i][j], ButtonReleaseMask, False,
	        XtEventHandler(&mine_hunter_T::put_flag_eh), XtPointer(this));
    }

  XBell(XtDisplay(gui_part->MainShellW), 0);
  XmString xm_str =  XmStringCreate("You Won!", "TAG2");
  XtVaSetValues(gui_part->MessageW, XmNlabelString, xm_str, NULL);
  XmStringFree(xm_str);

  XtRemoveTimeOut(gui_part->Timer);
  gui_part->Timer = XtIntervalId(0);

  if (gui_part->smile_pmap != XtUnspecifiedPixmap)
    XtVaSetValues(gui_part->NewGameW,
		  XmNlabelPixmap, gui_part->smile_pmap,
		  NULL);

  if ( (fd = lock()) == -1 ) return;
  if ( compare_score() == -1 ) {
    unlock(fd);
    return;
  }
  if ( ! unlock(fd) ) return;

  XtManageChild(gui_part->EnterNameDialogW);
}


void mine_hunter_T::show_bottom(int i, int j)
{
  Arg args[2];

  XtSetArg(args[0], XmNshadowThickness, 0);

  switch (app_part->state[i][j].bottom) {
    case Bomb:
      XtSetArg(args[1], XmNlabelPixmap, gui_part->bomb_bmap);
      break;
    case Empty:
      XtSetArg(args[1], XmNlabelPixmap, gui_part->empty_bmap);
      break;
    case Near1:
      XtSetArg(args[1], XmNlabelPixmap, gui_part->near1_bmap);
      break;
    case Near2:
      XtSetArg(args[1], XmNlabelPixmap, gui_part->near2_bmap);
      break;
    case Near3:
      XtSetArg(args[1], XmNlabelPixmap, gui_part->near3_bmap);
      break;
    case Near4:
      XtSetArg(args[1], XmNlabelPixmap, gui_part->near4_bmap);
      break;
    case Near5:
      XtSetArg(args[1], XmNlabelPixmap, gui_part->near5_bmap);
      break;
    case Near6:
      XtSetArg(args[1], XmNlabelPixmap, gui_part->near6_bmap);
      break;
    case Near7:
      XtSetArg(args[1], XmNlabelPixmap, gui_part->near7_bmap);
      break;
    case Near8:
      XtSetArg(args[1], XmNlabelPixmap, gui_part->near8_bmap);
      break;
  }

  XtSetValues(gui_part->BlockW[i][j], args, 2);

  app_part->state[i][j].open = True;

}


void mine_hunter_T::get_coordinates(Widget w, int& x, int& y)
{
  XtWidgetGeometry pr;

  XtQueryGeometry(w, NULL, &pr);

  // since i used XmHORIZONTAL, so the coordinates will be exchanged
  x = pr.y / gui_part->mine_width;
  y = pr.x / gui_part->mine_width;
}


void mine_hunter_T::run_game(void)
{
  int i;

  XtRealizeWidget(gui_part->MainShellW);

  Dimension cmd_form_width, game_button_width;
  XtVaGetValues(gui_part->CommandW, XmNwidth, &cmd_form_width, NULL);
  XtVaGetValues(gui_part->NewGameW, XmNwidth, &game_button_width, NULL);

  XtVaSetValues(gui_part->NewGameW,
		XmNleftAttachment, XmATTACH_NONE,
		XmNx, (cmd_form_width - game_button_width) / 2,
		XmNtopAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNtopOffset, 3,
		XmNbottomOffset, 3,
		NULL);

  // creating dialog
  gui_part->GameDialogW = XmCreateMessageDialog(gui_part->MainShellW,
						"Customized", NULL, 0);
  XtVaSetValues(gui_part->GameDialogW,
		XmNdialogTitle, XmStringCreateLocalized("Customized"),
		XmNmessageAlignment, XmALIGNMENT_CENTER,
		XmNmessageString, XmStringCreate("Customized Game", "TAG1"),
		NULL);

  XtUnmanageChild(XmMessageBoxGetChild(gui_part->GameDialogW,
				       XmDIALOG_HELP_BUTTON));

  Widget rc = XmCreateRowColumn(gui_part->GameDialogW, "InputFields", NULL, 0);
  XtVaSetValues(rc,
		XmNpacking, XmPACK_COLUMN,
		XmNnumColumns, 3,
		XmNorientation, XmHORIZONTAL,
		XmNisAligned, TRUE,
		XmNentryAlignment, XmALIGNMENT_BEGINNING,
		NULL);
  Widget l1 = XmCreateLabel(rc, "Number of mines:", NULL, 0);
  gui_part->NumOfMinesTextFW = XmCreateTextField(rc, "NumOfMines", NULL, 0);
  Widget l2 = XmCreateLabel(rc, "Field width:", NULL, 0);
  gui_part->FieldWidthTextFW = XmCreateTextField(rc, "FieldWidth", NULL, 0);
  Widget l3 = XmCreateLabel(rc, "Field height:", NULL, 0);
  gui_part->FieldHeightTextFW = XmCreateTextField(rc, "FieldHeight", NULL, 0);
  XtAddCallback(gui_part->GameDialogW, XmNokCallback,
                XtCallbackProc(&mine_hunter_T::game_dialog_ok_cb),
		XtPointer(this));

  XtManageChild(l1);
  XtManageChild(gui_part->NumOfMinesTextFW);
  XtManageChild(l2);
  XtManageChild(gui_part->FieldWidthTextFW);
  XtManageChild(l3);
  XtManageChild(gui_part->FieldHeightTextFW);
  XtManageChild(rc);

  gui_part->WarningW = XmCreateWarningDialog(gui_part->MainShellW,
                                            "Warning", NULL, 0);
  XtUnmanageChild(XmMessageBoxGetChild(gui_part->WarningW,
                                       XmDIALOG_HELP_BUTTON));
  XtUnmanageChild(XmMessageBoxGetChild(gui_part->WarningW,
                                       XmDIALOG_CANCEL_BUTTON));
  XtVaSetValues(gui_part->WarningW,
		XmNdialogTitle, XmStringCreateLocalized("Warning"),
 	        XmNmessageString,
		XmStringCreate("Wrong Input", "TAG1"),
                NULL);
  

  gui_part->AboutDialogW = XmCreateMessageDialog(gui_part->MainShellW,
						"About", NULL, 0);
  XtVaSetValues(gui_part->AboutDialogW, XmNdialogTitle,
		XmStringCreateLocalized("About"), NULL);
  XtUnmanageChild(XmMessageBoxGetChild(gui_part->AboutDialogW,
				       XmDIALOG_CANCEL_BUTTON));
  XtUnmanageChild(XmMessageBoxGetChild(gui_part->AboutDialogW,
				       XmDIALOG_HELP_BUTTON));

  XmString about_str = XmStringCreateLtoR(
    "XMinehunter, version 0.4\nCopyright 1994 - 1997 by Jin Yu\n\nFor My Mother", "TAG1");
  Widget about_label = XtVaCreateManagedWidget("about_label",
					       xmLabelWidgetClass,
					       gui_part->AboutDialogW,
					       XmNlabelString, about_str,
					       NULL);
  XmStringFree(about_str);


  gui_part->HelpDialogW = XmCreateMessageDialog(gui_part->MainShellW,
						"Help", NULL, 0);
  XtVaSetValues(gui_part->HelpDialogW, XmNdialogTitle,
		XmStringCreateLocalized("Help"), NULL);
  XtUnmanageChild(XmMessageBoxGetChild(gui_part->HelpDialogW,
				       XmDIALOG_CANCEL_BUTTON));
  XtUnmanageChild(XmMessageBoxGetChild(gui_part->HelpDialogW,
				       XmDIALOG_HELP_BUTTON));

  XmString help_str = XmStringCreateLtoR(
    "Left mouse button to uncover squares\nRight mouse button to mark mines\nMiddle mouse button to quick-uncover squares", "TAG1");
  Widget help_label = XtVaCreateManagedWidget("help_label",
					       xmLabelWidgetClass,
					       gui_part->HelpDialogW,
					       XmNlabelString, help_str,
					       NULL);
  XmStringFree(help_str);


  gui_part->HighScoreDialogW = XmCreateMessageDialog(gui_part->MainShellW,
						     "HighScore",
						     NULL, 0);
  XtVaSetValues(gui_part->HighScoreDialogW,
		XmNdialogTitle, XmStringCreateLocalized("High Scores"),
		XmNmessageAlignment, XmALIGNMENT_CENTER, NULL);
  XtUnmanageChild(XmMessageBoxGetChild(gui_part->HighScoreDialogW,
				       XmDIALOG_CANCEL_BUTTON));
  XtUnmanageChild(XmMessageBoxGetChild(gui_part->HighScoreDialogW,
				       XmDIALOG_HELP_BUTTON));

  rc = XmCreateRowColumn(gui_part->HighScoreDialogW, "rc", NULL, 0);
  XtVaSetValues(rc,
		XmNpacking, XmPACK_COLUMN,
		XmNnumColumns, 11,
		XmNorientation, XmHORIZONTAL,
		XmNisAligned, True,
		XmNentryAlignment, XmALIGNMENT_BEGINNING,
		NULL);

  XmString place_title = XmStringCreate("Place", "TAG1");
  XmString name_title = XmStringCreate("Name", "TAG1");
  XmString score_title = XmStringCreate("Score", "TAG1");
  XtVaCreateManagedWidget("Place", xmLabelWidgetClass, rc,
			  XmNlabelString, place_title,
			  NULL);
  XtVaCreateManagedWidget("Name", xmLabelWidgetClass, rc,
			  XmNlabelString, name_title,
			  NULL);
  XtVaCreateManagedWidget("Score", xmLabelWidgetClass, rc,
			  XmNlabelString, score_title,
			  NULL);
  XmStringFree(place_title);
  XmStringFree(name_title);
  XmStringFree(score_title);

  char num_str[80];
  XmString place_str;
  XmString name_str = XmStringCreate("Anonymous", "TAG2");
  XmString score_str = XmStringCreate("", "TAG2");

  for (i=0; i<10; i++) {
    sprintf(num_str, "%d.", i+1);
    place_str = XmStringCreate(num_str, "TAG2");
    XtVaCreateManagedWidget("", xmLabelWidgetClass, rc,
			    XmNlabelString, place_str,
			    NULL);
    XmStringFree(place_str);
    Widget frame1 = XtVaCreateManagedWidget("frame1", xmFrameWidgetClass, rc,
					    XmNshadowType, XmSHADOW_ETCHED_OUT,
					    NULL);
    gui_part->NameW[i] = XtVaCreateManagedWidget("", xmLabelWidgetClass,
						 frame1,
						 XmNlabelString, name_str,
						 NULL);
    Widget frame2 = XtVaCreateManagedWidget("frame2", xmFrameWidgetClass, rc,
					    XmNshadowType, XmSHADOW_ETCHED_OUT,
					    NULL);
    gui_part->ScoreW[i] = XtVaCreateManagedWidget("", xmLabelWidgetClass,
						  frame2,
						  XmNlabelString, score_str,
						  NULL);
  }

  XmStringFree(name_str);
  XmStringFree(score_str);

  XtManageChild(rc);


  gui_part->EnterNameDialogW = XmCreatePromptDialog(gui_part->MainShellW,
						    "", NULL, 0);
  XtVaSetValues(gui_part->EnterNameDialogW,
		XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
		XmNdialogTitle, XmStringCreateLocalized("Enter Name"),
		XmNselectionLabelString, XmStringCreate("Your Name:", "TAG1"),
		NULL);
  XtUnmanageChild(XmSelectionBoxGetChild(gui_part->EnterNameDialogW,
					 XmDIALOG_HELP_BUTTON));
  XtAddCallback(gui_part->EnterNameDialogW, XmNokCallback,
                XtCallbackProc(&mine_hunter_T::enter_name_ok_cb),
		XtPointer(this));


  XtAppMainLoop(gui_part->AppCon);
}


void mine_hunter_T::del(void)
{
  int i;

  if (gui_part->Timer) {
    XtRemoveTimeOut(gui_part->Timer);
    gui_part->Timer = XtIntervalId(0);
  }

  for (i=0; i<app_part->field_height; i++) {
    delete [] gui_part->BlockW[i];
    delete [] app_part->state[i];
  }

  delete [] gui_part->BlockW;
  delete [] app_part->state;

  XtDestroyWidget(gui_part->FieldW);

}
