#include <Xm/RowColumn.h>
#include "xfibs.h"
#include "FibwP.h"
#include "popup.h"
#include "mouse.h"


Widget movemenu, doublemenu, rollmenu, joinmenu, nomenu, resignmenu,
       movesub,  rollsub, 
       moveBear, mBearsub, rollBear, rBearsub,
       move_pane[5], double_pane[2], roll_pane[3], join_pane[2], no_pane,
       movesub_pane[3], rollsub_pane[3], resign_pane[2],
       mBear_pane[6], mBearsub_pane[3], rBear_pane[5], rBearsub_pane[3];


static void removeHandler(fw, oldhandle)
FibwWidget	fw;
XtPointer	oldhandle;
{
    XtRemoveEventHandler((Widget) fw, ButtonPressMask, False, 
	(XtEventHandler) post_popup, oldhandle);
    XtRemoveEventHandler((Widget) intext, ButtonPressMask, False, 
	(XtEventHandler) post_popup, oldhandle);
    XtRemoveEventHandler((Widget) outtext, ButtonPressMask, False, 
	(XtEventHandler) post_popup, oldhandle);
}

static void addHandler(fw, newhandle)
FibwWidget	fw;
XtPointer	newhandle;
{
    XtAddEventHandler((Widget) fw, ButtonPressMask, False, 
	(XtEventHandler) post_popup, newhandle);
    XtAddEventHandler((Widget) intext, ButtonPressMask, False, 
	(XtEventHandler) post_popup, newhandle);
    XtAddEventHandler((Widget) outtext, ButtonPressMask, False, 
	(XtEventHandler) post_popup, newhandle);
}

void use_popup(fw, new_popup)
FibwWidget	fw;
int		new_popup;
{
    int	oldPopup = fw->fibw.popupmenu;

    if (fw->fibw.debug)
	fprintf(stderr,"Popup %d->%d\n", oldPopup, new_popup);
    /* Select something that has no popup associated with it. Then remove the
     * current popup, add the new one, _then_ let the rest of the world at it.
     */
    fw->fibw.popupmenu = startup_id;
    switch(oldPopup) {
        case no_popup_id:
	    removeHandler(fw, (XtPointer) nomenu);
	    break;
        case mBearPopup_id: 
	    removeHandler(fw, (XtPointer) moveBear);
	    break;
        case move_popup_id: 
	    removeHandler(fw, (XtPointer) movemenu);
	    break;
        case double_popup_id: 
	    removeHandler(fw, (XtPointer) doublemenu);
	    break;
        case rBearPopup_id: 
	    removeHandler(fw, (XtPointer) rollBear);
	    break;
        case roll_popup_id: 
	    removeHandler(fw, (XtPointer) rollmenu);
	    break;
        case join_popup_id:
	    removeHandler(fw, (XtPointer) joinmenu);
	    break;
        case resign_popup_id:
	    removeHandler(fw, (XtPointer) resignmenu);
	    break;
	default:	/* Only on start-up when there's nothing there */
	    break;
    }

    switch(new_popup) {
        case no_popup_id: 
	    addHandler(fw, (XtPointer) nomenu);
	    break;
        case mBearPopup_id: 
        case move_popup_id: 
	    if (fw->fibw.move_off) {
		addHandler(fw, (XtPointer) moveBear);
		new_popup = mBearPopup_id;
	    }
	    else addHandler(fw, (XtPointer) movemenu);
	    break;
        case double_popup_id: 
	    addHandler(fw, (XtPointer) doublemenu);
	    break;
        case rBearPopup_id: 
        case roll_popup_id: 
	    if (fw->fibw.move_off) {
		addHandler(fw, (XtPointer) rollBear);
		new_popup = rBearPopup_id;
	    }
	    else addHandler(fw, (XtPointer) rollmenu);
	    break;
        case join_popup_id: 
	    addHandler(fw, (XtPointer) joinmenu);
	    break;
        case resign_popup_id: 
	    addHandler(fw, (XtPointer) resignmenu);
	    break;
    }
    fw->fibw.popupmenu = new_popup;
}


static void build_move(move)
char	*move;
{
    FibwWidget	fw = (FibwWidget) bgboard;
    int		i, j;
    /* This section may seem strange, but imagine you have 2 pieces on
     * the bar and you roll 1-1. Now, you can pick the first piece up and
     * drop it on the 3 point & move the 2nd piece to the 1... this code
     * untangles this mess and presents FIBS with 2 moves off the bar,
     * followed by the other rubbish, hence a legal move.
     */
    strcpy (move, "move ");
    /* Look for moves off the bar first.. */
    for (i = 0; i < 4; i++)
	for (j = 0; j < 4; j++) {
	    if (fw->fibw.dice[j].used == i + 1) {
		if ((fw->fibw.dice[j].from == 25) ||
			(fw->fibw.dice[j].from == 0))
		    strcat(move, fw->fibw.dice[j].move);
	    }
	}
    /* Then do the remaining moves in order */
    for (i = 0; i < 4; i++)
	for (j = 0; j < 4; j++) {
	    if (fw->fibw.dice[j].used == i + 1)
		if ((fw->fibw.dice[j].from != 25) &&
			(fw->fibw.dice[j].from != 0))
		    strcat(move, fw->fibw.dice[j].move);
	}
}


/*ARGSUSED*/
static void accept_move(w, unused, unused2)
Widget w;
XtPointer unused;
XtPointer unused2;
{
    FibwWidget	fw = (FibwWidget) bgboard;
    char	move[40], str[40];

    if (!fw->fibw.pieces_moved) return;
    if (fw->fibw.pieces_moved != fw->fibw.moves_left) return;

    fw->fibw.pieces_moved = 0;
    fw->fibw.moves_left = 0;
    fw->fibw.fibs_rec.turn = -fw->fibw.fibs_rec.turn;

    build_move(&move[0]);
    add_to_pending_list(move);
    sprintf(str, "You %s\n", move);
    XmTextInsert(outtext, XmTextGetLastPosition(outtext), str);
    return;
}

/*ARGSUSED*/
static void reject_move(w, unused, unused2)
Widget w;
XtPointer unused;
XtPointer unused2;
{
    FibwWidget fw = (FibwWidget) bgboard;
    int i;

    if (!fw->fibw.pieces_moved) return;
    /* Put back the old board layout */
    for (i = 0; i <= 27; i++)
        fw->fibw.fibs_rec.board[i] = fw->fibw.oldboard[i];

    redrawBoard(fw);

    fw->fibw.moving = 0;
    fw->fibw.pieces_moved = 0;
    for (i = 0; i < 4; i++) {
        fw->fibw.dice[i].used = 0;
    }
    checkBearOff(fw);
    use_popup(fw, roll_popup_id);
    return;
}


/*ARGSUSED*/
static void off_move(w, unused, unused2)
Widget w;
XtPointer unused;
XtPointer unused2;
{
    add_to_pending_list("off");
    return;
}


static void move_back(w, unused, unused2)
Widget w;
XtPointer unused;
XtPointer unused2;
{
    FibwWidget fw = (FibwWidget) bgboard;

    undoLastMove(fw);
    redrawBoard(fw);
}


/*ARGSUSED*/
static void resend_move(w, unused, unused2)
Widget w;
XtPointer unused;
XtPointer unused2;
{
    FibwWidget	fw = (FibwWidget) bgboard;
    char	move[40];

    if (fw->fibw.pieces_moved)
	return;

    build_move(&move[0]);
    add_to_pending_list(move);
    return;
}



/*ARGSUSED*/
static void accept_double(w, unused, unused2)
Widget w;
XtPointer unused;
XtPointer unused2;
{
    add_to_pending_list("accept");
    return;
}


/*ARGSUSED*/
static void reject_double(w, unused, unused2)
Widget w;
XtPointer unused;
XtPointer unused2;
{
    add_to_pending_list("reject");
    return;
}


/*ARGSUSED*/
static void join_game(w, unused, unused2)
Widget w;
XtPointer unused;
XtPointer unused2;
{
    FibwWidget fw = (FibwWidget) bgboard;
    char commandstring[STRING_LENGTH];

    if (fw->fibw.invited_name[0]!='\0') {
        strcpy(commandstring,"join ");
        strcat(commandstring,fw->fibw.invited_name);
        add_to_pending_list(commandstring);
    }
    else
        add_to_pending_list("join");
    add_to_pending_list("board");
    return;
}


/*ARGSUSED*/
static void leave_game(w, unused, unused2)
Widget w;
XtPointer unused;
XtPointer unused2;
{
    add_to_pending_list("leave");
    return;
}


/*ARGSUSED*/
static void roll(w, unused, unused2)
Widget w;
XtPointer unused;
XtPointer unused2;
{
    add_to_pending_list("roll");
    return;
}



/*ARGSUSED*/
static void do_double(w, unused, unused2)
Widget w;
XtPointer unused;
XtPointer unused2;
{
    add_to_pending_list("double");
    return;
}



/*ARGSUSED*/
static void resign_normal(w, unused, unused2)
Widget w;
XtPointer unused;
XtPointer unused2;
{
    add_to_pending_list("resign n");
    return;
}



/*ARGSUSED*/
static void resign_gammon(w, unused, unused2)
Widget w;
XtPointer unused;
XtPointer unused2;
{
    add_to_pending_list("resign g");
    return;
}



/*ARGSUSED*/
static void resign_backgammon(w, unused, unused2)
Widget w;
XtPointer unused;
XtPointer unused2;
{
    add_to_pending_list("resign b");
    return;
}



/*ARGSUSED*/
static void dummy_func(w, unused, unused2)
Widget w;
XtPointer unused;
XtPointer unused2;
{
    return;
}



/*ARGSUSED*/
void post_popup(w, client_data, event)
Widget w;
XtPointer client_data;
XEvent *event;
{
    Widget popup = (Widget) client_data;

    if (event->xbutton.button != Button3)
	return;

    /* ignore calls to routine with empty data, fix bug when press 3rd button */
    if (client_data != NULL) {
	XmMenuPosition(popup, (XButtonPressedEvent *) event);
	XtManageChild(popup);
    }
}


void createMovePopup(parent)
Widget	parent;
{
    movemenu = XmCreatePopupMenu(parent, "movepopup", NULL, 0);
    move_pane[0]=XtCreateManagedWidget("Accept move",
	xmPushButtonGadgetClass, movemenu, NULL, 0);
    XtAddCallback(move_pane[0], XmNactivateCallback, accept_move, 0);
    move_pane[1]=XtCreateManagedWidget("Undo move",
	xmPushButtonGadgetClass, movemenu, NULL, 0);
    XtAddCallback(move_pane[1], XmNactivateCallback, move_back, 0);
    move_pane[2]=XtCreateManagedWidget("Reject move",
	xmPushButtonGadgetClass, movemenu, NULL, 0);
    XtAddCallback(move_pane[2], XmNactivateCallback, reject_move, 0);
    XtCreateManagedWidget("separator",
	xmSeparatorGadgetClass, movemenu, NULL, 0);
    move_pane[3] = XtCreateManagedWidget("Retransmit move",
	xmPushButtonGadgetClass, movemenu, NULL, 0);
    XtAddCallback(move_pane[3], XmNactivateCallback, resend_move, 0);

    /* Creating sub-menu containing all the resign stuff... */
    movesub=XmCreatePulldownMenu(movemenu, "submovemenu", NULL, 0);
    move_pane[4] = XtVaCreateManagedWidget("Resign",
	xmCascadeButtonGadgetClass, movemenu, XmNsubMenuId, movesub, NULL);

    movesub_pane[0]=XtCreateManagedWidget("normal",
	xmPushButtonGadgetClass, movesub, NULL, 0);
    XtAddCallback(movesub_pane[0], XmNactivateCallback, resign_normal, 0);
    movesub_pane[1]=XtCreateManagedWidget("gammon",
	xmPushButtonGadgetClass, movesub, NULL, 0);
    XtAddCallback(movesub_pane[1], XmNactivateCallback, resign_gammon, 0);
    movesub_pane[2]=XtCreateManagedWidget("backgammon",
	xmPushButtonGadgetClass, movesub, NULL, 0);
    XtAddCallback(movesub_pane[2],XmNactivateCallback, resign_backgammon, 0);

    return;
}


void createMoveBear(parent)
Widget	parent;
{
    moveBear = XmCreatePopupMenu(parent, "moveBearPopup", NULL, 0);
    mBear_pane[0] = XtCreateManagedWidget("Accept move",
	xmPushButtonGadgetClass, moveBear, NULL, 0);
    XtAddCallback(mBear_pane[0], XmNactivateCallback, accept_move, 0);
    mBear_pane[1]=XtCreateManagedWidget("Undo move",
	xmPushButtonGadgetClass, moveBear, NULL, 0);
    XtAddCallback(mBear_pane[1], XmNactivateCallback, move_back, 0);
    mBear_pane[2] = XtCreateManagedWidget("Reject move",
	xmPushButtonGadgetClass, moveBear, NULL, 0);
    XtAddCallback(mBear_pane[2], XmNactivateCallback, reject_move, 0);
    XtCreateManagedWidget("separator",
	xmSeparatorGadgetClass, moveBear, NULL, 0);

    /* Extra menu item for bear-off */
    mBear_pane[3] = XtCreateManagedWidget("Off",
	xmPushButtonGadgetClass, moveBear, NULL, 0);
    XtAddCallback(mBear_pane[3], XmNactivateCallback, off_move, 0);
    XtCreateManagedWidget("separator",
	xmSeparatorGadgetClass, moveBear, NULL, 0);

    mBear_pane[4] = XtCreateManagedWidget("Retransmit move",
	xmPushButtonGadgetClass, moveBear, NULL, 0);
    XtAddCallback(mBear_pane[4], XmNactivateCallback, resend_move, 0);

    /* Creating sub-menu containing all the resign stuff... */
    mBearsub=XmCreatePulldownMenu(movemenu, "submoveBear", NULL, 0);
    mBear_pane[5] = XtVaCreateManagedWidget("Resign",
	xmCascadeButtonGadgetClass, moveBear, XmNsubMenuId, mBearsub, NULL);

    mBearsub_pane[0] = XtCreateManagedWidget("normal",
	xmPushButtonGadgetClass, mBearsub, NULL, 0);
    XtAddCallback(mBearsub_pane[0], XmNactivateCallback, resign_normal, 0);
    mBearsub_pane[1] = XtCreateManagedWidget("gammon",
	xmPushButtonGadgetClass, mBearsub, NULL, 0);
    XtAddCallback(mBearsub_pane[1], XmNactivateCallback, resign_gammon, 0);
    mBearsub_pane[2] = XtCreateManagedWidget("backgammon",
	xmPushButtonGadgetClass, mBearsub, NULL, 0);
    XtAddCallback(mBearsub_pane[2],XmNactivateCallback, resign_backgammon, 0);

    return;
}


void createDoublePopup(parent)
Widget parent;
{
    doublemenu=XmCreatePopupMenu(parent,"doublepopup",NULL,0);
    double_pane[0]=XtCreateManagedWidget("Accept double",
	xmPushButtonGadgetClass, doublemenu,NULL,0);
    XtAddCallback(double_pane[0],XmNactivateCallback,accept_double,0);
    double_pane[1]=XtCreateManagedWidget("Reject double",
	xmPushButtonGadgetClass, doublemenu,NULL,0);
    XtAddCallback(double_pane[1],XmNactivateCallback,reject_double,0);
    
    /* No resign here. Has to accept or reject */

    return;
}


void createResignPopup(parent)
Widget parent;
{
    resignmenu=XmCreatePopupMenu(parent,"resignpopup",NULL,0);
    resign_pane[0]=XtCreateManagedWidget("Accept resignation",
	xmPushButtonGadgetClass, resignmenu,NULL,0);
    XtAddCallback(resign_pane[0],XmNactivateCallback,accept_double,0);
    resign_pane[1]=XtCreateManagedWidget("Reject resignation",
	xmPushButtonGadgetClass, resignmenu,NULL,0);
    XtAddCallback(resign_pane[1],XmNactivateCallback,reject_double,0);
    
    /* No resign here. Has to accept or reject */

    return;
}


void createRollPopup(parent)
Widget parent;
{
    rollmenu=XmCreatePopupMenu(parent,"rollpopup",NULL,0);
    roll_pane[0]=XtCreateManagedWidget("roll",
	xmPushButtonGadgetClass, rollmenu,NULL,0);
    XtAddCallback(roll_pane[0],XmNactivateCallback,roll,0);
    XtCreateManagedWidget("separator",xmSeparatorGadgetClass,rollmenu,NULL,0);

    /* Creating sub-menu containing all the resign stuff... */
    rollsub=XmCreatePulldownMenu(rollmenu,"subrollmovemenu",NULL,0);
    roll_pane[2] = XtVaCreateManagedWidget("Resign...",
	xmCascadeButtonGadgetClass, rollmenu,XmNsubMenuId,rollsub,NULL);

    rollsub_pane[0]=XtCreateManagedWidget("normal",
	xmPushButtonGadgetClass, rollsub,NULL,0);
    XtAddCallback(rollsub_pane[0],XmNactivateCallback,resign_normal,0);
    rollsub_pane[1]=XtCreateManagedWidget("gammon",
	xmPushButtonGadgetClass, rollsub,NULL,0);
    XtAddCallback(rollsub_pane[1],XmNactivateCallback,resign_gammon,0);
    rollsub_pane[2]=XtCreateManagedWidget("backgammon",
	xmPushButtonGadgetClass, rollsub,NULL,0);
    XtAddCallback(rollsub_pane[2],XmNactivateCallback,resign_backgammon,0);

    XtCreateManagedWidget("separator",xmSeparatorGadgetClass,rollmenu,NULL,0);
    roll_pane[1]=XtCreateManagedWidget("double",
	xmPushButtonGadgetClass, rollmenu,NULL,0);
    XtAddCallback(roll_pane[1],XmNactivateCallback,do_double,0);
    return;
}


void createRollBear(parent)
Widget parent;
{
    rollBear = XmCreatePopupMenu(parent, "rollpopup" ,NULL, 0);
    rBear_pane[0] = XtCreateManagedWidget("roll",
	xmPushButtonGadgetClass, rollBear, NULL, 0);
    XtAddCallback(rBear_pane[0], XmNactivateCallback, roll, 0);

    /* Extra menu item for bear-off */
    rBear_pane[1] = XtCreateManagedWidget("Off",
	xmPushButtonGadgetClass, rollBear, NULL, 0);
    XtAddCallback(rBear_pane[1], XmNactivateCallback, off_move, 0);
    XtCreateManagedWidget("separator", xmSeparatorGadgetClass, rollBear, NULL, 0);

    /* Creating sub-menu containing all the resign stuff... */
    rBearsub = XmCreatePulldownMenu(rollBear, "subrollmovemenu", NULL, 0);
    rBear_pane[2] = XtVaCreateManagedWidget("Resign...",
	xmCascadeButtonGadgetClass, rollBear, XmNsubMenuId, rBearsub, NULL);

    rBearsub_pane[0]=XtCreateManagedWidget("normal",
	xmPushButtonGadgetClass, rBearsub, NULL, 0);
    XtAddCallback(rBearsub_pane[0], XmNactivateCallback, resign_normal, 0);
    rBearsub_pane[1]=XtCreateManagedWidget("gammon",
	xmPushButtonGadgetClass, rBearsub,NULL,0);
    XtAddCallback(rBearsub_pane[1], XmNactivateCallback, resign_gammon, 0);
    rBearsub_pane[2]=XtCreateManagedWidget("backgammon",
	xmPushButtonGadgetClass, rBearsub,NULL,0);
    XtAddCallback(rBearsub_pane[2], XmNactivateCallback, resign_backgammon, 0);

    XtCreateManagedWidget("separator", xmSeparatorGadgetClass, rollBear, NULL, 0);
    rBear_pane[3]=XtCreateManagedWidget("double",
	xmPushButtonGadgetClass, rollBear, NULL, 0);
    XtAddCallback(rBear_pane[3], XmNactivateCallback, do_double, 0);
    return;
}


void createJoinPopup(parent)
Widget parent;
{
    joinmenu=XmCreatePopupMenu(parent,"joinpopup",NULL,0);
    join_pane[0]=XtCreateManagedWidget("join",
	xmPushButtonGadgetClass, joinmenu,NULL,0);
    XtAddCallback(join_pane[0],XmNactivateCallback,join_game,0);
    join_pane[1]=XtCreateManagedWidget("leave",
	xmPushButtonGadgetClass, joinmenu,NULL,0);
    XtAddCallback(join_pane[1],XmNactivateCallback,leave_game,0);
    
    /* No resign here. Has to join or leave */

    return;
}


void createNoPopup(parent)
Widget parent;
{
    nomenu=XmCreatePopupMenu(parent,"nopopup",NULL,0);
    no_pane=XtCreateManagedWidget("no choices available",
	xmPushButtonGadgetClass, nomenu,NULL,0);
    XtAddCallback(no_pane,XmNactivateCallback,dummy_func,0);
    return;
}
