#ifndef _config_h
#define _config_h

/* #define DEBUG */
/* I like my X-programs to get into the background as soon as they are 
 * up and running. define RUNBACK for this to happen automatically
*/
#ifndef DEBUG
#define RUNBACK 
#endif

/*
 * Name of file where the host name, port number, user name etc. resides 
 * Put it in your home directory
*/
#define STARTUPFILE ".xfibsrc"

/* Default host and port */
#define DEFAULT_HOST "fraggel65.mdstud.chalmers.se"
#define DEFAULT_PORT 4321

/* Isn't used yet, so don't worry about it */
#define MOTIF

/* How many characters should be stored in the output window? When this many
   has been reached, approx. 10% is removed from the top. */
#define OUTBUFLENGTH 60000

/* How many characters to expect from the server at one time. I guess the one
   I've chosen should be enough!!! :) */
#define LINELENGTH 5000

/* create length for very un-average strings in text processing */
#define STRING_LENGTH 1024
/**/

/* All of the things below may be changed from a app-default file */

/* Default pixmap size */
#define DEFAULT_PIXMAP_HEIGHT  400 /* in pixels */
#define DEFAULT_PIXMAP_WIDTH   700 /* in pixels */

/* Default font for the bgboard window. */
#define DEFAULT_FONT "fixed"

/* Default color scheme. If changing, you better know something more on 
   how the colors are used:
	TABLE:		The color of the "table" where the bgboard are
	FRAMECOL:	Color of the "wooden" stuff
	BASECOL:	The base of bgboard.
	WTRIANGLE:	One color for the triangles on the board
	BTRIANGLE:	And this is the other
	WPIECE:		Color of one of the pieces, and one of the dices, and
			the text color for one of the players, and for each 
			second of the numbers on the board layout. (Phew)
	BPIECE:		Look above, and I forgot. The eyes of the white dices
			are colored in black, and vice versa (or whatever
			colors you choose)
	DBLCUBE:	Color of double cube
	NUMBERS:	Flag True or False if there are numbers round the board
	DEBUG:		Flag True or False if debugging

   Not shown here: By specifying xfibs*bgboard.foreground: something, you
   specify the color used for the rest of the text, and for some other lines 
   here and there. Probably best to leave it as "black"
*/

#define DEFAULT_TABLE	"aquamarine4"
#define DEFAULT_FRAME	"burlywood4"
#define DEFAULT_BASE	"violetred4"
#define DEFAULT_WPOINT	"antiquewhite3"
#define DEFAULT_BPOINT	"darkslateblue"
#define DEFAULT_WPIECE	"antiquewhite2"
#define DEFAULT_BPIECE	"slateblue3"
#define DEFAULT_DBLCUBE	"antiquewhite2"
#define DEFAULT_DBLTEXT	"slateblue3"
#define DEFAULT_WTEXT	"white"
#define DEFAULT_BTEXT	"black"
#define DEFAULT_REVERSE	False
#define DEFAULT_NUMBERS	True
#define DEFAULT_ONFRAME	False
#define DEFAULT_DEBUG	False


/* Logfile style types - use bit flags & mask tests */
#define	LOGALL		0xFF
#define	LOGNONE		0x00			/* Log nothing! */
#define LOGBOARDS	0x80			/* Top bit - ascii boards */
#define LOGINPUT	(LOGALL - LOGBOARDS)	/* Everything except boards */
#define	LOGPLAY		0x01			/* Just moves, rolls etc. */
#define	DEFAULT_LOG	LOGINPUT		/* Normal Logging */

#endif /* _config_h */
