/*
 * Progra XBLAST V2.5.8 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * April 27th 1997
 * started August 1993
 *
 * File: sprite.h
 * header file for sprite.c
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: sprite.h,v 1.1 1998/01/03 14:08:25 xblast Exp $
 * $Log: sprite.h,v $
 * Revision 1.1  1998/01/03 14:08:25  xblast
 * Initial revision
 *
 */

#ifndef _SPRITE_H
#define _SPRITE_H

#ifdef _SPRITE_C
#define _EXTERN
#else
#define _EXTERN extern
#endif

#ifdef __STDC__
_EXTERN Sprite *create_player_sprite (int p, int x, int y, int a, int m);
_EXTERN Sprite *create_bomb_sprite (int b, int x, int y, int a, int m);
_EXTERN void delete_sprite (Sprite *spr);
_EXTERN void move_sprite (Sprite *sprite, int x, int y);
_EXTERN void set_sprite_mode (Sprite *sprite, int mode);
_EXTERN void set_sprite_anime (Sprite *sprite, int anime);
_EXTERN void shuffle_all_sprites (void);
_EXTERN void mark_all_sprites (void);
_EXTERN void draw_all_sprites (void);
#else
_EXTERN Sprite *create_player_sprite ();
_EXTERN Sprite *create_bomb_sprite ();
_EXTERN void delete_sprite ();
_EXTERN void move_sprite ();
_EXTERN void set_sprite_mode ();
_EXTERN void set_sprite_anime ();
_EXTERN void shuffle_all_sprites ();
_EXTERN void mark_all_sprites ();
_EXTERN void draw_all_sprites ();
#endif

#undef _EXTERN

#endif

/*
 * end fo file sprite.h
 */
