//
// Program XBLAST V2.6 or higher
// (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2; or (at your option)
// any later version
//
// This program is distributed in the hope that it will be entertaining,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.
// 675 Mass Ave, Cambridge, MA 02139, USA.
//
#include "colors.inc"
#include "textures.inc"

#declare myClock = int((2*4-1)*clock + 0.5)
// 2 shots for each animation
// 4 directions

#declare frameClock = div(myClock,2)

// draw floor
plane {
  y, 0
  #if (mod(myClock,2) = 0)
    pigment {color rgb <0,0,0>}
  #else
    pigment {color rgb <1,1,1>}
  #end
  finish {ambient 0.0 diffuse 1.0}
}

// background (sky) color
background {color SkyBlue}


// light source
light_source {
  <-100,500,-250>
  color rgb <1.2,1.2,1.2>
}

// camera
#declare Entf = 200.0
camera
{
  location  <0, 0, -Entf>
  direction <0, 0,  Entf>
  up        6.0*y
  right     4.0*x
  look_at   <0.0, 0.0, 0.0>
  rotate x*48.60
}

#include "XBlast Skeleton.inc"

#ifndef (playerWalkHeight)
  #declare playerWalkHeight = 0.0
#end

union {
  object {PlayerHead     translate < 0.00, 3.25, 0.00> }
  object {PlayerBody     translate < 0.00, 1.90, 0.00> }
  object {PlayerLeftArm  translate < 0.70, 2.35, 0.00> }
  object {PlayerRightArm translate <-0.70, 2.35, 0.00> }
  object {PlayerRightLeg translate <-0.40, 1.20, 0.00> }
  object {PlayerLeftLeg  translate < 0.40, 1.20, 0.00> }
  translate <0.0, -1.20, 0.0>
  rotate bodyAngle
  translate <0.0,  1.20, 0.0>
  translate y*playerWalkHeight
  rotate y*frameClock*90
  translate <0,0,-2.667>
}

