/*
 * xacursor.c - X11 client that make animated cursors in a window
 *
 * Copyright (c) by Kam-Hung WONG
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * This file is provided AS IS with no warranties of any kind.  The author
 * shall have no liability with respect to the infringement of copyrights,
 * trade secrets or any patents by this file or any part thereof.  In no
 * event will the author be liable for any lost revenue or profits or
 * other special, indirect and consequential damages.
 *
 * Please send any suggestion and comments to:
 *		k2wong@noether.math.uwaterloo.ca
*/


#include "decor.h"
#include "cursor.h"
#include "note_d.xbm"
#include "note_m.xbm"




void printError (prog)
	char	*prog;
	{
	static char		*msg[]= {	"options:",
		"        -display [display]",
		"        -r                         set the cursor at the root window",
		"        -fg [color]",
		"        -bg [color]",
		"        -cursor [file]             show only this cursor", 
		"        -mask [file]               default mask",
		"        -path [directory]          where the bitmaps are (optional)", 
		"        -mode [swing | random | rswing | vibrate]",
		"        -wait [msecond]            delay between curosrs",
		"        -demo                      show standard demo",
		"        -h                         display help message",
		"",
		"",
		"",
		"",
		"file:  (contains the path of the cursors, listed in this manner)",
		"        cursor1.xbm    mask1.xbm    fg1    bg1",
		"        cursor2.xbm    mask2.xbm    fg2    bg2",
		"             .             .         .      .",
		"        cursorN.xbm    maskN.xbm    fgN    bgN",
		"",
		"       (`mask', `fg', `bg' can be omitted; or they can be replaced",
		"        by `NA', which acts as a place holder and is ignored.)",
		"",
		"",
		"        e.g.     earth1.xbm    NA             goldenrod",
		"                 earth2.xbm    earth_m.xbm    hotpink    blue", 
		"                 earth3.xbm",
		"",
		"",
		"",
		"",
	"Version 1.01, written by Kam-Hung Wong, University of Waterloo, Canada."
		};
	int		m= sizeof (msg)/ sizeof (char *),
			i;
		

	printf ("%s [options] [file]\n\n", prog);
	for (i=0; i<m; i++)
		printf ("%s\n", msg[i]); 


	/*** end the program after printing out the message ***/
	exit (0);
	}




Window getWindow (display)
	Display	*display;
	{
	Window	root= DefaultRootWindow (display),
			target;
	XEvent	event;
	Cursor	select_ptr;
	Pixmap	pix, mask;
	XColor	*fg= (XColor *)malloc (sizeof(XColor)),
			*bg= (XColor *)malloc (sizeof(XColor));
	int		screen= DefaultScreen (display),
			button,
			i;


	pix= XCreatePixmapFromBitmapData (display, root, note_bits, 
	note_width, note_height, 1, 0, 1);
	mask= XCreatePixmapFromBitmapData (display, root, note_m_bits, 
	note_m_width, note_m_height, 1, 0, 1);
	XParseColor (display, DefaultColormap (display, screen), "black", fg);
    XParseColor (display, DefaultColormap (display, screen), "white", bg);

	select_ptr= XCreatePixmapCursor (display, pix, mask, fg, bg, 
	note_x_hot, note_y_hot);


	if (XGrabPointer (display, root, False, 
	ButtonPressMask | ButtonReleaseMask, GrabModeSync, GrabModeAsync, 
	None, select_ptr, CurrentTime)!= GrabSuccess)
		{
		printf ("### Error:  The pointer is not released!\n");
		exit (0);
		}


	/*** have the user click on the same window, with the same button ***/
	do
		{
		printf ("Please select a window...\n");

		/*** detect a button press ***/
		do
			{
			XAllowEvents (display, SyncPointer, CurrentTime);
			XWindowEvent (display, root, ButtonPressMask | ButtonReleaseMask, 
			&event);
			}
		while (event.type!= ButtonPress);


		/*** find out in which of the windows the button is pressed ***/
		target= event.xbutton.subwindow;


		/*** detect the release of the same button ***/
		button= event.xbutton.button;	

		do
			{
			XAllowEvents (display, SyncPointer, CurrentTime);
			XWindowEvent (display, root, 
			ButtonPressMask | ButtonReleaseMask, &event);
			}
		while (event.xbutton.button!= button);
		}
	while (event.xbutton.subwindow!= target);

	if (target== None)
		target= root;

	XUngrabPointer (display, CurrentTime);


	return (target);
	}




XColor *getcolor (display, name)
	Display	*display;
	char	*name;
	{
	XColor	*color= (XColor *)malloc (sizeof(XColor));
	int		screen= DefaultScreen (display);


	if (! XParseColor (display, DefaultColormap (display, screen), 
	name, color))
		printf ("### Error:  Can't allocate colour %s!\n", name);


	return (color);
	}




/*********************************************************************\
 *
 *	isComment ():	checks if a particular line in the cursor
 *					list is an empty line or a comment
 *
\*********************************************************************/
int isComment (str)
	char	*str;
	{
	char	c= ' ';
	int		comment= FALSE,
			i;


	/*** scan for the first character that is not a TAB or space ***/
	for (i=0; i<strlen(str); i++)
		if ((str[i]!= '\t') && (str[i]!= ' '))
			{
			c= str[i];
			break;
			}
			
	if ((strcmp (str, "")== 0) || (c== '#') || (c== ' '))
		comment= TRUE;


	return (comment);
	}




int main (num_arg, arg)
	int		num_arg;
	char	*arg[];
	{
	Cursor		cursor[NUM_CURSOR];
	Display		*display;
	Window		win;
	FILE		*infile= NULL;
	XColor		*black= (XColor *)malloc (sizeof(XColor)),
				*white= (XColor *)malloc (sizeof(XColor)),
				*fg= (XColor *)malloc (sizeof(XColor)),
				*bg= (XColor *)malloc (sizeof(XColor));
	char		*disp= NULL,
				*in= (char *)malloc (STR_LENGTH* sizeof(char)),
				*mfile= (char *)malloc (STR_LENGTH* sizeof(char)),
				*mask= (char *)malloc (STR_LENGTH* sizeof(char)),
				*file= (char *)malloc (STR_LENGTH* sizeof(char)),
				*foreground= (char *)malloc (STR_LENGTH* sizeof(char)),
				*background= (char *)malloc (STR_LENGTH* sizeof(char)),
				*path= NULL,
				*token= (char *)malloc (STR_LENGTH* sizeof(char));
	long		wait= SLEEP_TIME;
	int			num_cursor= 0,
				mode= Normal,
				flag[10],
				i;




	/*** initialization: color and flags ***/
	strcpy (foreground, "Black");
	strcpy (background, "White");

	flag[Root_F]= FALSE;
	flag[Cursor_F]= FALSE;
	flag[Mask_F]= FALSE;
	flag[Demo_F]= FALSE;
	flag[File_F]= FALSE;
	

	/*** the user cannot just type "xacursor" with no arg. ***/
	if (num_arg== 1)
		printError(arg[0]);

	/*** readin the options from the command line ***/
	for (i=1; i<num_arg; i++)
		{
/*		printf ("arg[%d]: >%s<\n", i, arg[i]);*/


		if (! strcmp (arg[i], "-r"))
			flag[Root_F]= TRUE;

		/*** if user wants to see demo only ***/
		else if (! strcmp (arg[i], "-demo"))
			flag[Demo_F]= TRUE;

		/*** print help message ***/
		else if (! strcmp (arg[i], "-h"))
			printError (arg[0]);


		else /*** option with 1 arg. ***/
			if (i!= num_arg- 1)
				{
				/*** reset foreground colour if so specified ***/
				if (! strcmp (arg[i], "-fg"))
					strcpy (foreground, arg[++i]);

				/*** reset background colour if so specified ***/
				else if (! strcmp (arg[i], "-bg"))
					strcpy (background, arg[++i]);

				else if (! strcmp (arg[i], "-path"))
					{
					path= (char *)malloc (STR_LENGTH* sizeof (char));
					strcpy (path, arg[++i]);
					}

				/*** change the way the cursor cycles ***/
				else if (! strcmp (arg[i], "-mode"))
					{
					i++;

					if (! strcasecmp (arg[i], "swing"))
						mode= Swing;
					else if (! strcasecmp (arg[i], "vibrate"))
						mode= Vibrate;
					else if (! strcasecmp (arg[i], "rswing"))
						mode= Random_Swing;
					else if (! strcasecmp (arg[i], "random"))
						mode= Random;
					else
						printError (arg[0]);
					}


				/*** one single cursor only ***/
				else if (! strcmp (arg[i], "-cursor"))
					{
					flag[Cursor_F]= TRUE;

					strcpy (file, arg[++i]);
					if (flag[Mask_F]== FALSE)
						strcpy (mask, file);
					}

				/*** use the specified mask for all cursors ***/
				else if (! strcmp (arg[i], "-mask"))
					{
					strcpy (mask, arg[++i]);
					flag[Mask_F]= TRUE;
					}

				else if (! strcmp (arg[i], "-wait"))
					{
					/*** delay time in msec ***/
					wait= atol (arg[++i])* 1000;
					if (wait< 10000)
						wait= 10000;
					}

				/*** use the specified display ***/
				else if (! strcmp (arg[i], "-display"))
					{
					disp= (char *)malloc (STR_LENGTH* sizeof(char));
					strcpy (disp, arg[++i]);
					}

				/*** print the instruction of usage ***/
				else
					printError (arg[0]);
				}

			else
				flag[File_F]= TRUE;
		} /*** end parse arg. ***/


	/*** read the last file name iff it is not in the Demo or Cursor mode ***/
	if ((flag[Demo_F] | flag[Cursor_F])== 0)
		{
		if (flag[File_F]== TRUE)
			{
			infile= fopen (arg[num_arg- 1], "r");
			if (infile== NULL)
				{
				printf ("### Error:  Can't open file %s!\n", arg[num_arg- 1]);
				exit (0);
				}
			}
		else
			printError (arg[0]);
		}


	/*** attach "path" (if given) to the cursor file and the mask file ***/
	if (path!= NULL)
		{
		if (flag[Cursor_F]== TRUE)
			{
			strcpy (token, file);
			sprintf (file, "%s/%s", path, token);

			if (flag[Mask_F]== FALSE)
				sprintf (mask, "%s/%s", path, token);
			}
			
		if (flag[Mask_F]== TRUE)
			{
			strcpy (token, mask);
			sprintf (mask, "%s/%s", path, token);
			}
		}




	/*** "Bus error" when "display" is not defined ***/
	display= XOpenDisplay (disp);
	if (! display)
		printf ("### Error:  Cannot open display!\n");
	else
		{
		/*** find the window in which the cursor has to be set ***/
		if (flag[Root_F]== FALSE)
			win= getWindow (display);
		else
			win= DefaultRootWindow (display);


		/*** get the desired foreground and background colours ***/
		black= getcolor (display, foreground);
		white= getcolor (display, background);


		/*** show demo. if sepcified ***/
		if (flag[Demo_F]== TRUE)
			cursorDemo (display, win, mode, wait, black, white);


		/*** set the cursor to the one single bitmap if specified ***/
		else if (flag[Cursor_F]== TRUE)
			{
			if (cursorLoad (display, win, file, mask, black, white, 
			&cursor[0])== 0)
				cursorSet (display, win, cursor[0]);
			}


		else /*** read the information in the configuration file ***/
			{
			if (! feof (infile))	
				fscanf (infile, "%[^\n]", in);

			for (i=0; (i<NUM_CURSOR) && (! feof (infile)); i++)
				{
				fgetc (infile);

				/*** handle the line in the file that is not a comment ***/
				if (isComment (in)== FALSE)
					{
					fg= black;
					bg= white;

					token= (char *)malloc (STR_LENGTH* sizeof(char));
					token= strtok (in, " \t");
					if (token!= NULL)
						{
						/*** get the cursor file ***/
						if (path!= NULL)
							sprintf (file, "%s/%s", path, token);
						else
							strcpy (file, token);

						/*** get the mask file if present ***/
						token= strtok (NULL, " \t");
						if (token!= NULL)
							{
							if (strcmp (token, "NA")== 0)
								if (flag[Mask_F]== TRUE)
									strcpy (mfile, mask);
								else
									strcpy (mfile, file);

							else /*** if mask is specified ***/
								if (path!= NULL)
									sprintf (mfile, "%s/%s", path, token);
								else
									strcpy (mfile, token);


							/*** get the foreground if present ***/
							token= strtok (NULL, " \t");
							if (token)
								{
								if (strcmp (token, "NA")!= 0)
									fg= getcolor (display, token);

								/*** get the background if present ***/
								token= strtok (NULL, " \t");
								if (token)
									if (strcmp (token, "NA")!= 0)
										bg= getcolor (display, token);
								}
							}
						else
							if (flag[Mask_F]== TRUE)
								strcpy (mfile, mask);
							else
								strcpy (mfile, file);
						}


					/*** if both "file" is specified ***/
					if (file)
						{
/*						printf ("file: %s\t\tmask: %s\n", file, mfile);*/

						if (cursorLoad (display, win, file, mfile, fg, bg, 
						&cursor[num_cursor])== 0)
							num_cursor++;
						}
					}

				fscanf (infile, "%[^\n]", in);
				}


			fclose (infile);
			cursorLoop (display, win, mode, wait, cursor, num_cursor);
			}
		}


	exit (0);
	}
