// $Id: lp_desc.cxx,v 1.1 1995/04/07 14:32:14 beust Exp beust $

#include <assert.h>
#include "lp_lib.hxx"


///////////////////////////////////////////////////////////////////////////

CDescPacket::CDescPacket(CARD32 opCode, CDescField **fields, Cardinal fieldCount)
   : CMessage(opCode, fields, fieldCount)
{
}


///////////////////////////////////////////////////////////////////////////

CDescProtocol::CDescProtocol(CDescPacket *cdp[], Cardinal msgCount)
   : _messagesCount(msgCount)
{
   _messages = new CDescPacket * [_messagesCount];
   for (int i = 0; i < _messagesCount; i++)
      _messages[i] = cdp[i];
/*
   _msg = new messageList_t;

   for (int i = 0; i < fieldCount; i++) {
      if (cmd[i].fieldSize == sizeof(CARD32)) {
	 declareArgumentNum(cmd[i].fieldName, sizeof(CARD32));
	 assign(cmd[i].fieldName,
		cmd[i].defaultValue.numValue());
      }
      else {
	 declareArgumentBytes(cmd[i].fieldName);
	 assign(cmd[i].fieldName,
		cmd[i].defaultValue.bytesValue(),
		cmd[i].fieldSize);
      }
   }
*/
   
}

CDescProtocol::~CDescProtocol()
{
   delete [] _messages;
}

CMessage *
CDescProtocol::messageKit(CARD32 opCode)
{
   assert(opCode >= 0 && opCode < _messagesCount);

   CMessage *result = new CMessage(opCode,
				   _messages[opCode] -> getFields(),
				   _messages[opCode] -> getFieldsCount());
   return result;
}

CDescPacket **
CDescProtocol::getMessages(void) const
{
    return _messages;
}

ostream &
operator << (ostream &os, CDescField & cdf)
{
   cout << cdf._fieldName << ": " << *cdf._cfv;
   cout.flush();
   return os;
}

ostream &operator << (ostream &os, CFieldValue &cfv)
{
   cout << "(size:" << cfv.getSize() << ") ";
   cout.flush();
   return os;
}

#if 0
Boolean
CDescProtocol::isValidMessageName(String messageName)
{
   argDesc_t *ad;

   _msgList -> rewind();
   while (0 != (ad = _msgList -> next()))
      if (0 == strcmp(messageName, ad -> name))
	 return True;

   return False;
}

void
CDescProtocol::declareArgumentNum(const String argName, size_t size)
{
   argDesc_t *arg = new argDesc_t;
   arg -> size = size;
   arg -> type = argDesc_t::NUM;
   arg -> name = strdup(argName);
   _msgList -> add(arg);
}

void
CDescProtocol::declareArgumentBytes(const String argName)
{
   argDesc_t *arg = new argDesc_t;  // not known yet
   arg -> size = 0;
   arg -> type = argDesc_t::BYTES;
   arg -> name = strdup(argName);
   _msgList -> add(arg);
}
#endif


