#include "main.hxx"

// ctor
CooperativeBoard::CooperativeBoard(int height, int width,
				   Widget parent, int defaultColumn,
				   Bool want3D, Widget topLevel, String name,
				   String high)
   : Board(height, width, parent, defaultColumn, want3D, topLevel, name, high)
{
   // Initialize score
   {
      delete _Score;   // delete inherited score. yuck @@
      struct passwd *pwd;

      pwd = getpwuid(getuid());
      _Score = new MotifScore(high,
			      True,   // cooperative game
			      topLevel,
			      pwd -> pw_name, name);
   }

}

void
CooperativeBoard::drawRest(void)
{
   if (isOtherBlockValid()) mapBlock(*getOtherBlock());
}

Bool
CooperativeBoard::isActiveBlockBlocked(void)
{
   int *x1, *x2, *y1, *y2;
   Cardinal n1, n2;
   int newY;

   if (! isOtherBlockValid()) return False;

   Block *block1 = getActiveBlock(), *block2 = getOtherBlock();

   block2 -> getCoordinates(x1, y1, n1);

   for (int i = 0; i < n1; i++) {
      block1 -> getCoordinates(x2, y2, n2);
      newY = y2[i] + 1;
      for (int j = 0; j < n2; j++) {
	 if (x1[j] == x2[j] && y1[j] == newY) {
	    return True;
	 }
      }
   }

   return False;
}

#if 0
Bool
CooperativeBoard::canMoveRightOfBlock(Block &block1, Block &block2)
{
   Bool result;
   int *x1, *x2, *y1, *y2;
   Cardinal n1, n2;
   int newX;

   //
   // First check if block has reached bottom
   //
   result = Board::canMoveRight(block1);
   if (! isOtherBlockValid()) return result;

   if (result) {
      // no, then check if the other piece prevents it from moving down
      block2.getCoordinates(x1, y1, n1);

      for (int i = 0; i < n1; i++) {
	 block1.getCoordinates(x2, y2, n2);
	 newX = x2[i] + 1;
	 for (int j = 0; j < n2; j++) {
	    if (x1[j] == newX && y1[j] == y2[j]) {
	       return False;
	    }
	 }
      }
   }
   
   return result;
}

Bool
CooperativeBoard::canMoveLeftOfBlock(Block &block1, Block &block2)
{
   Bool result;
   int *x1, *x2, *y1, *y2;
   Cardinal n1, n2;
   int newX;

   //
   // First check if block has reached bottom
   //
   result = Board::canMoveLeft(block1);
   if (! isOtherBlockValid()) return result;

   if (result) {
      // no, then check if the other piece prevents it from moving down
      block2.getCoordinates(x1, y1, n1);

      for (int i = 0; i < n1; i++) {
	 block1.getCoordinates(x2, y2, n2);
	 newX = x2[i] - 1;
	 for (int j = 0; j < n2; j++) {
					 
	    if (x1[j] == newX && y1[j] == y2[j]) {
	       return False;
	    }
	 }
      }
   }

   return result;
}
#endif


Bool
CooperativeBoard::canFlipLeft(Block &block)
{
   Bool result;
   BlockDefinition *bd, *bd2;
   int newOrientation = (block.getCurrentOrientation() + 1) % 4;

   //
   // First check if block has reached bottom
   //
   result = Board::canFlipLeft(block);
   if (! isOtherBlockValid()) return result;

   if (result) {
      // no, then check if the other piece prevents it from moving down
      bd2 = _otherBlock -> getAbsCoo() [_otherBlock -> getCurrentOrientation()];
      bd = block.getAbsCoo() [newOrientation];
      for (int i = 0; i < 4; i++) {
	 int newLine = block.getCurrentColumn() + bd -> coo[i].y;
	 int newColumn = block.getCurrentColumn() + bd -> coo[i].x;
	 for (int j = 0; j < 4; j++) {
	    int otherLine = _otherBlock -> getCurrentColumn() + bd2 -> coo[j].y;
	    int otherColumn = _otherBlock -> getCurrentColumn() + bd2 -> coo[j].x;
	    if (newLine == otherLine || newColumn == otherColumn) {
	       return False;
	    }
	 }
      }
   }
   
   return result;
}

Bool
CooperativeBoard::canFlipRight(Block &block)
{
   Bool result;
   BlockDefinition *bd, *bd2;
   int newOrientation = block.getCurrentOrientation();
   if (newOrientation == 0) newOrientation = 3;
   else newOrientation = (newOrientation - 1) % 4;

   //
   // First check if block has reached bottom
   //
   result = Board::canFlipLeft(block);
   if (! isOtherBlockValid()) return result;

   if (result) {
      // no, then check if the other piece prevents it from moving down
      bd2 = _otherBlock -> getAbsCoo()[_otherBlock -> getCurrentOrientation()];
      bd = block.getAbsCoo() [newOrientation];
      for (int i = 0; i < 4; i++) {
	 int newLine = block.getCurrentColumn() + bd -> coo[i].y;
	 int newColumn = block.getCurrentColumn() + bd -> coo[i].x;
	 for (int j = 0; j < 4; j++) {
	    int otherLine = _otherBlock -> getCurrentColumn() + bd2 -> coo[j].y;
	    int otherColumn = _otherBlock -> getCurrentColumn() + bd2 -> coo[j].x;
	    if (newLine == otherLine || newColumn == otherColumn) {
	       return False;
	    }
	 }
      }
   }

   return result;
}



///////////////////////////////////////////////////////////////////////////




