
#include "libprot/lp_lib.hxx"
#include "main.hxx"



// static int OPCODE_COUNTER = 0;

static const int OPCODE_INIT = 0;
static const int OPCODE_BLOCK_COORDINATES = 1;
static const int OPCODE_NEW_BOARD = 2;
static const int OPCODE_ACCELERATE = 3;
static const int OPCODE_ADMIN = 4;
static const int OPCODE_SCORE_INCREMENT = 5;
static const int OPCODE_MY_NAME = 6;




///////////////////////////////////////////////////////////////////////////


//
// This packet is sent by the client to the server to inform
// it of the ICE location it is listening to
//

class CDescPacket1 : public CDescPacket
{
private:
   static CDescField *fields[];
public:
   CDescPacket1() : CDescPacket(OPCODE_INIT, fields, 2) {}
   virtual void handle()
   {
      MainWindow *mainW = MainWindow_g;
      CARD32 seed;
      void *iceLocation, *opponentName;
      size_t size;

      getField("iceLocation", iceLocation, size);
      mainW -> communicator -> setProtOut(
	 new CProtocolOut(* mainW -> communicator -> getProtDesc(),
			  (char *) iceLocation));

      getField("randomSeed", seed);
      mainW -> board1 -> customSRand(seed);

//      free(iceLocation);
   }
};

CDescField *CDescPacket1::fields[] = {
   new CDescField("iceLocation", new CFieldValue("tcp/indri:0", 12)),
   new CDescField("randomSeed", new CFieldValue(42))
};

///////////////////////////////////////////////////////////////////////////

//
// This packet gives general information about the games and
// the actions on the active block
//
class CDescPacket2 : public CDescPacket
{
private:
   static CDescField *fields[];
public:
   CDescPacket2() : CDescPacket(OPCODE_BLOCK_COORDINATES, fields, 4) {}
   virtual void handle()
   {
      MainWindow *mw = MainWindow_g;
      if (mw -> getPrefs() -> isCooperative) {
	 Board *board = mw -> board1;
	 Block *block = board -> getOtherBlock();
	 CARD32 mustCheckForLine, orientation, x, y;
	 getField("checkForLine", mustCheckForLine);
	 getField("orientation", orientation);
	 getField("x", x);
	 getField("y", y);
	 board -> unmapBlock(*block);
	 board -> setOtherBlock(42, orientation, x, y);
	 board -> mapBlock(*block);
	 if (mustCheckForLine) {
	    board -> addBlockToBoard(*block);
	    board -> invalidateOtherBlock();
	 }
      }
      else {
	 Board *board = mw -> board2;
	 Block *block = board -> getActiveBlock();
	 CARD32 mustCheckForLine, orientation, x, y;
	 getField("checkForLine", mustCheckForLine);
	 getField("orientation", orientation);
	 getField("x", x);
	 getField("y", y);
	 board -> unmapBlock(*block);
	 board -> setActiveBlock(42, orientation, x, y);
	 board -> mapBlock(*block);
	 if (mustCheckForLine) {
	    board -> addBlockToBoard(*block);
	    board -> invalidateActiveBlock();
	 }
      }
   }
};

CDescField *CDescPacket2::fields[] = {
   new CDescField("checkForLine", new CFieldValue(0)),
   new CDescField("orientation", new CFieldValue(0)),
   new CDescField("x", new CFieldValue(0)),
   new CDescField("y", new CFieldValue(0))
};

///////////////////////////////////////////////////////////////////////////

//
// This packet sends a board description
//
class CDescPacket3 : public CDescPacket
{
private:
   static CDescField *fields[];
public:
   CDescPacket3() : CDescPacket(OPCODE_NEW_BOARD, fields, 1) {}
   virtual void handle()
   {
      MainWindow *mw = MainWindow_g;
      void *bytes;
      size_t size;
      getField("board", bytes, size);
      if (mw -> getPrefs() -> isCooperative) {
	 mw -> board1 -> setBoardToRepresentation(bytes, size);
      }
      else {
	 mw -> board2 -> setBoardToRepresentation(bytes, size);
      }
      delete [] bytes;
   }
};

CDescField *CDescPacket3::fields[] = {
   new CDescField("board", new CFieldValue(0, 0))
};

///////////////////////////////////////////////////////////////////////////

//
// This packet sends an acceleration notification
//
class CDescPacket4 : public CDescPacket
{
private:
   static CDescField *fields[];
public:
   CDescPacket4() : CDescPacket(OPCODE_ACCELERATE, fields, 1) {}
   virtual void handle()
   {
      MainWindow *mw = MainWindow_g;
      CARD32 newTimeout;
      getField("newTimeout", newTimeout);
      mw -> currentTimeout = newTimeout;
   }
};

CDescField *CDescPacket4::fields[] = {
   new CDescField("newTimeout", new CFieldValue(0))
};

///////////////////////////////////////////////////////////////////////////

//
// This packet is an administration packet
//
class CDescPacket5 : public CDescPacket
{
private:
   static CDescField *fields[];
public:
   CDescPacket5() : CDescPacket(OPCODE_ADMIN, fields, 1) {}
   virtual void handle()
   {
      MainWindow *mw = MainWindow_g;
      CARD32 value;
      getField("action", value);
      mw -> communicator -> receiveValue(Communicator::Value(value), mw);
/*
      if (mw -> getPrefs().cooperative) {
	 assert(0);
      }
      else {
      }
*/
   }
};

CDescField *CDescPacket5::fields[] = {
   new CDescField("action", new CFieldValue(0))
};

///////////////////////////////////////////////////////////////////////////

//
// Send a score increment
//
class CDescPacket6 : public CDescPacket
{
private:
   static CDescField *fields[];
public:
   CDescPacket6() : CDescPacket(OPCODE_SCORE_INCREMENT, fields, 1) {}
   virtual void handle()
   {
      MainWindow *mw = MainWindow_g;
      Score *score = mw -> board1 -> getScore();
      CARD32 value;
      getField("score", value);
      score -> incrementScore(value);
      mw -> updateScoreLabel(score -> getScore());
/*
      mw -> communicator -> receiveValue(Communicator::Value(value), mw);
      if (mw -> getPrefs().cooperative) {
	 assert(0);
      }
      else {
      }
*/
   }
};

CDescField *CDescPacket6::fields[] = {
   new CDescField("score", new CFieldValue(0))
};

///////////////////////////////////////////////////////////////////////////


//
// This packet is sent to give my name to the opponent
//

class CDescPacket7 : public CDescPacket
{
private:
   static CDescField *fields[];
public:
   CDescPacket7() : CDescPacket(OPCODE_MY_NAME, fields, 1) {}
   virtual void handle()
   {
      MainWindow *mainW = MainWindow_g;
      void *opponentName;
      size_t size;

      getField("opponentName", opponentName, size);
      //
      // The opponent's name is meaningful only in a cooperative game
      //
      if (mainW -> getPrefs() -> isCooperative) {
	 mainW -> board1 -> getScore() -> setOtherUserName((String) opponentName);
      }

//      free(iceLocation);
   }
};

CDescField *CDescPacket7::fields[] = {
   new CDescField("opponentName", new CFieldValue("", 0)),
};

///////////////////////////////////////////////////////////////////////////
// The protocol itself

CDescPacket *MyProtocol[] = {
   new CDescPacket1,
   new CDescPacket2,
   new CDescPacket3,
   new CDescPacket4,
   new CDescPacket5,
   new CDescPacket6,
   new CDescPacket7
};

int MyProtocolCount = sizeof(MyProtocol) / sizeof(CDescPacket *);

///////////////////////////////////////////////////////////////////////////

// ctor
Communicator::Communicator(const String opponentLocation,
			   Bool isServer,
			   MainWindow *mainWindow)
   : MTETRIS_PROPERTY("MTETRIS_PROPERTY")
{
   Widget widget;

   CDescProtocol *protDesc;
   setProtDesc(protDesc = new CDescProtocol(MyProtocol, MyProtocolCount));

   CProtocolIn *protIn;
   CProtocolOut *protOut;
                                            // # of packets in this protocol
   if (isServer) {
      //
      // Initialize the protocols
      //
      setProtIn(protIn = new CProtocolIn(*protDesc));
      setProtOut(0);

   }

   else {
      //
      // Create our both protocols in and out
      //
      setProtIn(protIn = new CProtocolIn(*protDesc));
      setProtOut(protOut = new CProtocolOut(*protDesc, opponentLocation));

      //
      // Send an init packet
      //
      CMessage *msg = protDesc -> messageKit(OPCODE_INIT);
      String iceLocation = protIn -> getConnectionStrings();
      msg -> setField("iceLocation", iceLocation, strlen(iceLocation) + 1);
      msg -> setField("randomSeed", getpid());
      protOut -> send(msg);
      delete msg;
      delete iceLocation;

      //
      // ... and send my name
      //
      {
	 struct passwd *pwd;
	 pwd = getpwuid(getuid());
	 sendName(pwd -> pw_name);
      }

   }


}

void
Communicator::sendValue(Value value) 
{

   CProtocolOut *protOut = getProtOut();
   assert(value >= 6);
   if (0 != protOut) {
      CMessage *msg = getProtDesc() -> messageKit(OPCODE_ADMIN);
      msg -> setField("action", CARD32(value));
      protOut -> send(msg);
      delete msg;
   }
}

void
Communicator::sendBytes(char *bytes, Cardinal bytesCount) 
{
   CProtocolOut *protOut = getProtOut();
   if (0 != protOut) {
      CMessage *msg = getProtDesc() -> messageKit(OPCODE_NEW_BOARD);
      msg -> setField("board", bytes, bytesCount);
      protOut -> send(msg);
      delete msg;
   }
}

void
Communicator::sendName(String name) 
{
   CProtocolOut *protOut = getProtOut();
   if (0 != protOut) {
      CMessage *msg = getProtDesc() -> messageKit(OPCODE_MY_NAME);
      msg -> setField("opponentName", name, strlen(name) + 1);
      protOut -> send(msg);
      delete msg;
   }
}

void
Communicator::sendBlockDefinition(Block & block, Bool mustCheckForLine) 
{
   CProtocolOut *protOut = getProtOut();
   if (0 != protOut) {
      CMessage *msg = getProtDesc() -> messageKit(OPCODE_BLOCK_COORDINATES);
      msg -> setField("checkForLine", mustCheckForLine);
      msg -> setField("orientation", block.getCurrentOrientation());
      msg -> setField("x", block.getCurrentColumn());
      msg -> setField("y", block.getCurrentLine());
      protOut -> send(msg);
      delete msg;
   }
}

void
Communicator::receiveValue(Value value, MainWindow *mw)
{
   //
   // If this operation moves the activeBlock, make sure it is
   // valid
   //

   if (mw -> getPrefs() -> isCooperative) {
      interpretValue(value, *mw -> board1,
		     *mw -> board1 -> getOtherBlock(), mw);
   }
   else {
      interpretValue(value, *mw -> board2, *mw -> board2 -> getActiveBlock(), mw);
   }
}

void
Communicator::interpretValue(Value value, Board & bo,
			     Block & bl, MainWindow *mw)
{
   char opCode = value & 0xff;
   switch(opCode) {
      case VOID : {
	 cout << "communicator received VOID" << endl;
      }
      break;
      case STARTING_BLOCK : {
	 int blockIndex = value >> 8;
	 {
	    // @ ugly !
	    if (mw -> getPrefs() -> isCooperative) {
	       // new block must appear on correct side
	       Block *newBlock = bo.getIndexBlock(blockIndex);
	       Cardinal startColumn;
	       if (mw -> getPrefs() -> isClient)
		  startColumn = bo.getWidth() / 3;
	       else
		  startColumn = bo.getWidth() * 2 / 3;
	       newBlock -> setDefaultColumn(startColumn);
	       newBlock -> setCurrentColumn(startColumn);
	       bo.setOtherBlock(newBlock);
	    }
	    else  // non cooperative block
	       bo.setActiveBlock(bo.getIndexBlock(blockIndex));
	 }
      }
      break;
      case START_GAME : {
	 void cbStart(Widget wid, XtPointer client_data, XtPointer call_data);
	 cbStart(mw -> startB, mw, 0);   // kludge
      }
      break;
      case GAME_IS_LOST : {   // opponent lost
	 bo.setGameStatus(Board::GAME_WON);
	 mw -> setGameStatus(Board::GAME_WON);
      }
      break;
      case PAUSE_GAME : {   // pause wanted
	 bo.setGameStatus(Board::GAME_PAUSED);
	 mw -> setGameStatus(Board::GAME_PAUSED);
      }
      break;
      case UNPAUSE_GAME : {   // resume play
	 bo.setGameStatus(Board::GAME_RUNNING);
	 mw -> setGameStatus(Board::GAME_RUNNING);
      }
      break;
      default : {
	 cerr << "Unknown opcode received : " << value << endl;
      }
   }
}

void
Communicator::sendAccelerate(CARD32 newTimeout) 
{
   CProtocolOut *protOut = getProtOut();
   if (0 != protOut) {
      CMessage *msg = getProtDesc() -> messageKit(OPCODE_ACCELERATE);
      msg -> setField("newTimeout", newTimeout);
      protOut -> send(msg);
      delete msg;
   }
}

void
Communicator::sendScoreIncrement(Cardinal currentLine) 
{
   CARD32 line = currentLine;
   CProtocolOut *protOut = getProtOut();
   if (0 != protOut) {
      CMessage *msg = getProtDesc() -> messageKit(OPCODE_SCORE_INCREMENT);
      msg -> setField("score", line);
      protOut -> send(msg);
      delete msg;
   }
   
}
