// $Id: block.cxx,v 1.3 1995/06/02 15:42:40 beust Exp beust $

#include "main.hxx"

// ctor
Block::Block(int startCol, char color)
   : _CurrentLine(0), _CurrentColumn(startCol),
     _DefaultColumn(startCol), _name("Illegal"),
     _sizeOfBlock(4), _IsFalling(False)
{
   setCurrentOrientation(0);
   setColor(color);

   _x = new int [_sizeOfBlock];
   _y = new int [_sizeOfBlock];
   _AbsCoo = new BlockDefinition * [_sizeOfBlock];
}

Block::~Block()
{
//   for (int i = 0; i < 3; i++) delete absCoo[i];
   delete [] _x;
   delete [] _y;
   delete [] _AbsCoo;
}

void
Block::getCoordinates(int * & xCoo, int * & yCoo, Cardinal & count)
{
   xCoo = _x;
   yCoo = _y;
   count = _sizeOfBlock;
}

void
Block::updateCoordinates(void)
{
   for (int i = 0; i < _sizeOfBlock; i++) {
      int x = _x[i], y = _y[i];
      _x[i] = getAbsCoo() [getCurrentOrientation()] -> coo[i].x +
              getCurrentColumn();
      _y[i] = getAbsCoo() [getCurrentOrientation()] -> coo[i].y +
              getCurrentLine();
/*
      cout << "block:: col = " << getCurrentColumn() << " updated " <<
	  x << " " << _x[i] << "--" <<
	  y << " " << _y[i] << endl;
*/
   }
}

void
Block::flipLeft()
{
   int co = getCurrentOrientation();
   if (0 == co) setCurrentOrientation(3);
   else setCurrentOrientation(co - 1);

   updateCoordinates();
}

void
Block::flipRight()
{
   int co = getCurrentOrientation();
   if (3 == co) setCurrentOrientation(0);
   else setCurrentOrientation(co + 1);

   updateCoordinates();
}

void
Block::moveLeft()
{
   setCurrentColumn(getCurrentColumn() - 1);

   updateCoordinates();
}

void
Block::moveRight()
{
   setCurrentColumn(getCurrentColumn() + 1);

   updateCoordinates();
}

void
Block::moveDown()
{
   setCurrentLine(getCurrentLine() + 1);
   updateCoordinates();
}

Block *
Block::clone(int w)
{
   Block *result = new Block(getCurrentColumn(), getColor());
   result -> setDefaultColumn(getDefaultColumn());
   BlockDefinition **absCoo = getAbsCoo();
   for (int j = 0; j < 4; j++) {
      result -> _AbsCoo[j] = absCoo[j] -> clone();
      result -> _x[j] = _x[j];
      result -> _y[j] = _y[j];
   }
//   result -> updateCoordinates();

   return result;
}

void
Block::setCurrentColumn(int c)
{
   _CurrentColumn = c;
   updateCoordinates();
}

int
Block::getCurrentColumn(void)
{
   return _CurrentColumn;
}

void
Block::setCurrentLine(int l)
{
   _CurrentLine = l;
   updateCoordinates();
}

int
Block::getCurrentLine(void)
{
   return _CurrentLine;
}

void
Block::modify(int blockIndex, int orientation, int column, int line)
{
   setCurrentOrientation(orientation);
   setCurrentColumn(column);
   setCurrentLine(line);
   updateCoordinates();
}

/////////////////////////////////////////////////////////////////////


BlockDefinition::BlockDefinition(PointRec *p, int h)
{
   for (int j = 0; j < 4; j++) {
      coo[j].x = p[j].x; coo[j].y = p[j].y;
   }
   height = h;
}

BlockDefinition *
BlockDefinition::clone(void)
{
   BlockDefinition *result = new BlockDefinition(coo, height);
   return result;
}


//////////////////////////////////////////////////////////////////////

// ctor
BlockT::BlockT(int w) : Block(w, 1)
{
   _name = "T";
   //
   // Definining the shape
   //
   PointRec coo[4][4] =  {
      0, 1, 1, 1, 2, 1, 1, 2,   // T orientation 0
      1, 0, 0, 1, 1, 1, 1, 2,   // T orientation 1
      1, 0, 0, 1, 1, 1, 2, 1,
      1, 0, 1, 1, 1, 2, 2, 1

#if 0
      0, 0, 1, 0, 2, 0, 1, 1,   // L orientation 0
      2, 0, 1, 1, 2, 1, 2, 2,   // L orientation 1
      1, 1, 0, 2, 1, 2, 2, 2,   // L orientation 2
      0, 0, 0, 1, 1, 1, 0, 2,   // L orientation 3
#endif
   };
   int height[] = { 2, 2, 2, 2 };
   for (int j = 0; j < 4; j++)
      _AbsCoo[j] = new BlockDefinition(coo[j], height[j]);

   updateCoordinates();
}



//////////////////////////////////////////////////////////////////////

// ctor
BlockL::BlockL(int w) : Block(w, 2)
{
   _name = "L";
   //
   // Definining the shape
   //
   PointRec coo[4][4] =  {
      1, 0, 1, 1, 1, 2, 2, 2,   // L orientation 0
      0, 1, 1, 1, 2, 1, 0, 2,   // L orientation 1
      1, 0, 2, 0, 2, 1, 2, 2,   // L orientation 2
      2, 1, 0, 2, 1, 2, 2, 2,   // L orientation 3
   };
   int height[] = { 3, 2, 3, 2 };
   for (int j = 0; j < 4; j++)
      _AbsCoo[j] = new BlockDefinition(coo[j], height[j]);

   updateCoordinates();
}



//////////////////////////////////////////////////////////////////////

// ctor
BlockSquare::BlockSquare(int w) : Block(w, 3)
{
   _name = "Square";
   //
   // Definining the shape
   //
   PointRec coo[4][4] =  {
      0, 0, 0, 1, 1, 0, 1, 1,   // L orientation 0
      0, 0, 0, 1, 1, 0, 1, 1,   // L orientation 0
      0, 0, 0, 1, 1, 0, 1, 1,   // L orientation 0
      0, 0, 0, 1, 1, 0, 1, 1,   // L orientation 0
   };
   int height[] = {2, 2, 2, 2};
   for (int j = 0; j < 4; j++)
      _AbsCoo[j] = new BlockDefinition(coo[j], height[j]);

   updateCoordinates();
}



//////////////////////////////////////////////////////////////////////

// ctor
BlockI::BlockI(int w) : Block(w, 4)
{
   _name = "I";
   //
   // Definining the shape
   //
   PointRec coo[4][4] =  {
      1, 0, 1, 1, 1, 2, 1, 3,
      0, 1, 1, 1, 2, 1, 3, 1,
      1, 0, 1, 1, 1, 2, 1, 3,
      0, 1, 1, 1, 2, 1, 3, 1,
#if 0
      0, 0, 0, 1, 0, 2, 0, 3,
      0, 1, 1, 1, 2, 1, 3, 1,
      0, 0, 0, 1, 0, 2, 0, 3,
      0, 1, 1, 1, 2, 1, 3, 1,
#endif
   };
   int height[] = {4, 1, 4, 1};
   for (int j = 0; j < 4; j++)
      _AbsCoo[j] = new BlockDefinition(coo[j], height[j]);

   updateCoordinates();
}

//////////////////////////////////////////////////////////////////////

// ctor
BlockZ::BlockZ(int w) : Block(w, 5)
{
   _name = "Z";
   //
   // Definining the shape
   //
   PointRec coo[4][4] =  {
      1, 0, 0, 1, 1, 1, 0, 2,
      0, 0, 1, 0, 1, 1, 2, 1,
      1, 0, 0, 1, 1, 1, 0, 2,
      0, 0, 1, 0, 1, 1, 2, 1,
   };
   int height[] = {2, 2, 2, 2};
   for (int j = 0; j < 4; j++)
      _AbsCoo[j] = new BlockDefinition(coo[j], height[j]);

   updateCoordinates();
}
//////////////////////////////////////////////////////////////////////

// ctor
BlockS::BlockS(int w) : Block(w, 6)
{
   _name = "S";
   //
   // Definining the shape
   //
   PointRec coo[4][4] =  {
      0, 0, 0, 1, 1, 1, 1, 2,
      1, 0, 2, 0, 0, 1, 1, 1, 
      0, 0, 0, 1, 1, 1, 1, 2,
      1, 0, 2, 0, 0, 1, 1, 1, 
   };
   int height[] = {2, 2, 2, 2};
   for (int j = 0; j < 4; j++)
      _AbsCoo[j] = new BlockDefinition(coo[j], height[j]);

   updateCoordinates();
}
