#ifndef __smiletab_h
#define __smiletab_h

//
// The smiletab is the arry of smiley's from which xmemory takes it's symbols.
// The characters will be turned by 90 degrees and written from top to bottom
// Only ASCII-characters are allowed as letters of the smileys.
// The special character '\r' can be used to toggle the writing mode to
// uppside down.
//
// By the way:
//    Have a look at the David Sanderson compilation of smileys,
//    published by O'Reilly & Associates, to get more than 650 smileys ...
//

char *smiletab[]= {
":-)",	// standard
":-(",	// sad
":-o",	// amazed
":-]",	// sarcastic
":-[",
":-|",	// apathetic
//		":-||",	// angry
":)",		// happy
":-#",	// my lipps are sealed
":-()",	// I stubbed my toe
":-)8",	// man with bowtie
":-.)",	// Madonna
":-/",	// skeptical
";-)", "\r;-)",	// winking
";-(", "\r;-(",	// crying
"%-(", "\r%-(",	// confused
"%-)", "\r%-)",	// feeling better again
//		"%+{",	// lost a fight
//		"%*}",	// very drunk
"%-\\", "\r%-\\",	// hungover
"=|:-)",	// Abe Lincoln
"=):-)",	// Uncle Sam
"B-)",	// Batman
//		"8-o",	// shocked
"8)",		// frog
"8:)",	// pig
"8:]",	// gorilla
"8:-)",	// little girl
"8-]",
"!=(",	// black eye
"|:-)",	// with bushy eyebrows
"`:-)", "\r`:-)",	// with one eyebrow raised
"#-)",	// partied all night
"#:-)",	// matted hair
"#:-o",
"$-)", "\r$-)",	// yuppie
"&:-)",	// curly hair
"(:-\\",	// very sad
"(:-(",	// frowning
")8-)",
"):-)",
"):-(",
"*8-)",		// Beaker (muppet lab assistant
"*<:-)",		// small santa
//		"-=#:-)",	// wizzard
//		"*<|:-))",	// santa claus
".-(",	// always should wear safety glasses
"/:-|",	// Mr. Spock
"/;-)",	//has one big thick cockeyed eyebrow
"O-)",	// scuba diver
"O-(",	// with broken mask
"7:-)",	// Fred Flintstone
"3:]",	// pet smiley
":->",	// sarcastic
":-<",	// real sad
">:-)",	// devil
">:-<",	// mad
">:->",	// devilish
"[:-)",	// listening to walkman
"Q:-)",	// new graduate
};

#endif
