#ifndef __mem_image_h
#define __mem_image_h

#ifndef __gif_image_h
#	include "gif_image.H"
#endif

class MemImage : public GifImage {
	public:
		MemImage( const char *filename );
		// MemImage() : GifImage()				{}
		~MemImage()								{}

		int	Cols()							{ return width/pic_width; }
		int	Rows()							{ return height/pic_height; }
		int	PicWidth()						{ return pic_width; }
		int	PicHeight()						{ return pic_height; }
		int	PicNum()							{ return Cols()*Rows(); }

		const byte *SubImage(int x,int y) {
			return Data() + PicHeight()*width *y + PicWidth()*x;
		}
		const byte *SubImage(int id) {
			return SubImage(id%Cols(),id/Cols());
		}

		void SetupParams( struct parameter *par, int w, int h );
		void ShowInfoMsg();

	private:
		int	pic_width, pic_height;
};

#endif
