
#include <stdio.h>
#include <stdlib.h>
#include <X11/Xos.h>

#ifndef __mem_image_h
#	include "mem_image.H"
#endif
#ifndef __game_h
#	include "game.H"
#endif

MemImage::MemImage( const char *filename )
: GifImage( filename, 0 )
{
	const char *ext=GetExtensionData( SUBSIZE_EXTENSION );

	if (!ext||sscanf( ext, "%dx%d", &pic_width, &pic_height )!=2) {
		fprintf( stderr, "%s: no memory hints contained in image\n", filename );
		exit(-1);
	}
}

void MemImage::SetupParams( struct parameter *par, int width, int /*height*/ ) {
char	bestbuffer[1024];
int	size,best;
int	p[3], wx[3], wy[3];
int code;
const char *ext;

	best=0;
	for (ext=GetExtensionData(code=SCALEINFO_START); ext; ext=GetExtensionData(++code) ) {
		if (sscanf(ext,"%d:",&size)==1) {
			if (size>=width && (best==0 || size<best)) {
				best=size;
				strcpy( bestbuffer, ext );
			}
		}
	}

	if (sscanf( bestbuffer, "%d: %dx%d %d %dx%d %d %dx%d %d" , &size,
		&wx[0], &wy[0], &p[0], &wx[1], &wy[1], &p[1], &wx[2], &wy[2], &p[2] )!=10) {
			sscanf( "0: 5x4 100 7x4 100 8x5 80", "%d: %dx%d %d %dx%d %d %dx%d %d" , &size,
					&wx[0], &wy[0], &p[0], &wx[1], &wy[1], &p[1], &wx[2], &wy[2], &p[2] );
	}

	for (int i=0;i<3;i++) {
		par->dim[i].dwidth  = wx[i];
		par->dim[i].dheight = wy[i];
		par->dim[i].dsize   = PicWidth()*p[i]/100;
		par->dim[i].wsizex  = PicWidth();
		par->dim[i].wsizey  = PicHeight();

//		printf( "%d, %d, %d, %d, %d\n",
//			par->dim[i].dwidth, par->dim[i].dheight,
//			par->dim[i].dsize, par->dim[i].wsizex, par->dim[i].wsizey );
	}
}

void MemImage::ShowInfoMsg() {

	const char *ext=GetExtensionData( COMMENT_EXTENSION );

	if (ext) {
				printf( ext );
				putchar( '\n' );
	}
}
