#ifndef __color_h
#define __color_h

// ============================================================================
//
// Color is the class that allocates the necessary cells on the given port.
// At the moment this can only be done on a Display with PseudoColor-visual,
// since the puzzle-tile are drawn by using planes for the colors.
//
// Therefor the Color-class allocates 1 color and 2 planes, so that we have
// 4 (private) colors allocated per Color-instance per port. The planes
// are used for the 3D effect:
//   00 - Top Shadow
//   01 - Background
//   10 - Foreground
//   11 - Bottom Shadow
// By the way, this approach only works, as long as XAllocColorCells(...) always
// returns the same 2 planes, when asked for 2 plane. (This is not defined, but
// I haven't yet heard about problems due to this).
//
// ============================================================================

class Color {
	friend class Port;

public:

	Color( class Port *, int color_id, char *color );
	~Color();

	GC					gc_n;
	unsigned long	pixel;
	int				color_id;
	class Port		*p;

private:
	static void brighten( XColor *chg, XColor *org, double percent );
	Color				*next;
};

#endif
