/* motd.c for firepower

   read the motd into memory

   Copyright (c) 1995 Joe Rumsey
   */

#include <stdio.h>
#include <stdlib.h>
#include "struct.h"
#include "defs.h"
#include "global.h"

/* motd_read_motd()

   Read the motd from "./.motd"
   Save it memory, send it to each player when they log on

   Return: none
   */
void motd_read_motd()
{
    FILE *mf;
    char buf[100];
    int i;

    GLO_motdLines = 0;

    if ((mf = fopen("./.motd", "r")) == 0) {
        printf("No motd file, I'm bummed :-(\n");
        return;
    }
    /* count lines */
    while (!feof(mf)) {
        if (fgets(buf, 100, mf))
            GLO_motdLines++;
    }

    fclose(mf);

    /* get storage */
    GLO_motd = malloc(GLO_motdLines * sizeof(char *));

    /* read into motd array */
    mf = fopen("./.motd", "r");
    for (i = 0; i < GLO_motdLines; i++) {
        GLO_motd[i] = malloc(100);
        fgets(GLO_motd[i], 100, mf);
        GLO_motd[i][strlen(GLO_motd[i]) - 1] = 0;
    }
    fclose(mf);
}
