
/* life.c for firepower

   Makes the trees grow
   */
#include <stdio.h>
#include <string.h>
#include "global.h"
#include "defs.h"
#include "struct.h"

#include "network.h"

char lifemap[MAXMAPSIZE][MAXMAPSIZE];

/* life_do_life()

   Makes the trees grow.  if REAL_LIFE is defined, uses Conway's life algorithm to
   do it.  But that turned out to be pretty goofy, so I changed it to make a tree
   grow in any square surrounded by exactly 4 trees - no trees ever die except
   by being harvested

   Return: none
*/

void life_do_life()
{
    int x, y, i, j;
    int treecount;

    for (x = 0; x < GLO_map_info.m_width; x++) {
        for (y = 0; y < GLO_map_info.m_height; y++) {
            if (GLO_map[x][y] == T_GRASS || GLO_map[x][y] == T_TREE || GLO_map[x][y] == T_CRATER) {
                treecount = 0;
                for (i = x - 1; i < x + 2; i++) {
                    for (j = y - 1; j < y + 2; j++) {
                        if ((GLO_map[i][j] == T_TREE || GLO_map[i][j] == T_WATER) && !(i == x && j == y))
                            treecount++;
                    }
                }
#ifdef REAL_LIFE
                if (GLO_map[x][y] == T_TREE && (treecount < 2 || treecount > 3)) {
                    lifemap[x][y] = T_GRASS;
                } else if (treecount == 3) {
                    lifemap[x][y] = T_TREE;
                } else
                    lifemap[x][y] = GLO_map[x][y];
#else
                if (treecount > 3 && treecount < 5)
                    lifemap[x][y] = T_TREE;
                else
                    lifemap[x][y] = GLO_map[x][y];
#endif
            } else {
                lifemap[x][y] = GLO_map[x][y];
            }
            if (lifemap[x][y] != GLO_map[x][y])
                NET_update_mapsquare_value(x, y, lifemap[x][y]);
        }
    }
    memcpy(GLO_map, lifemap, MAXMAPSIZE * MAXMAPSIZE);
}
