/* defs.h for firepower

   Holds constant values for many compile time options
 */

#ifndef defs_h
#define defs_h

/* port to listen on */
#define XFIREPORT 12592
#define CLIENTVERSION 84
#define SERVERVERSION 84

/* size in pixels of the combat window */
#define WINWIDTH 300
#define WINHEIGHT 300

/* maximum width/height of the map */
#define MAXMAPSIZE 256

/* values for each sqaure of the map */
enum terrain_types {
    T_GRASS,
    T_ROAD,
    T_TREE,
    T_GWALL,
    T_POST,
    T_WALL_T,
    T_WALL_R,
    T_WALL_TR,
    T_WALL_B,
    T_WALL_TB,
    T_WALL_BR,
    T_WALL_TBR,
    T_WALL_L,
    T_WALL_TL,
    T_WALL_RL,
    T_WALL_TRL,
    T_WALL_BL,
    T_WALL_TBL,
    T_WALL_BRL,
    T_WALL_TBRL,
    T_WATER,
    T_CRATER,
    T_BASE1,
    T_BASE2,
    T_BRIDGE,
    NUMTERRAINS
};

/* how many pixels wide each square of the map is */
#define GRIDWIDTH 40
#define GRIDHEIGHT 40

/* how fast tanks turn */
#define TURNSPEED 1

#define MAXPLAYERS 32

/* number of microseconds between updates */
#define UTIMER 100000

/* fastest legal speed forward and in reverse for tanks */
#define MAXSPEED 40
#define MINSPEED -20

/* acceleration of tanks */
#define FORWARDACCEL 2
#define BACKACCEL 1
#define DECEL 2

#define ABS(a) (((a)>0) ? (a) : -(a))

/* obsolete - were used when steering was done by keyboard */
#define RKEY 1
#define LKEY 2
#define UKEY 4
#define DKEY 8

/* how fast shells move */
#define SHELLSPEED 200
#define SHELLSPERPLAYER 1

/* how many ticks shells live */
#define SHELLFUSE 10

/* for use by the server, client uses pixmap sizes */
#define TANKSIZE 20
#define EXPFUSE 5

/* how often to send updates about flags */
#define UPDATEFREQ 20

/* number of hits to a wall to destroy it */
#define WALLDESTROY 5

/* not possible to have more than 2 yet, leave this alone! */
#define NUMTEAMS 2

/* maximum number of flags allowed in game.  Up to map creator to make sure each team
   has the same number */

#define NUMFLAGS 20

/* how much damage a shell does to a tank */
#define SHELLDAMAGE 75

/* how much damage a tank can take before dying */
#define MAXDAMAGE 250

/* how fast a tank repairs on it's own (doubled when sitting at a base) */
#define REPAIRRATE 4

/* fuel, ammo carried by tanks */
#define MAXAMMO 30
#define MAXFUEL 20000

/* this much fuel for each tick multiplied by speed */
#define FUELRATE 1

/* how fast the base refuels/reloads tanks */
#define BASEREFUELRATE 500
#define BASERELOADTICKS 2

/* special message destinations */
#define M_ALL 255
#define M_SRV 254
#define M_RED 253
#define M_BLUE 252

/* MW_* used by client to keep track of windows */
#define MW_JOINED 0
#define MW_INDIV 1
#define MW_ALL 2
#define MW_TEAM 3
#define MW_MAX 4

#define MINESPERPLAYER 15
#define MINEDAMAGE 100
#define MINEARMFUSE 10

/* how many trees a tank can carry */
#define MAXTREES 6

/* take real coordinates and convert them to map squares */
#define MAPX(x) (x/(GRIDWIDTH<<4))
#define MAPY(y) (y/(GRIDHEIGHT<<4))

/* How many trees a player must be surrounded by in order to be hidden */
#define TREESTOHIDE 4

/* distance in map squares that hidden tanks become visible */
#define HIDEDISTANCE 3

#endif                          /* defs_h */
