#ifndef _GAME_
#define _GAME_

#include "creation.h"
#include "messages.h"

#define NORMAL		0
#define INVISIBLE 	1
#define CHEF		2    /* Caract */
#define TELEPORT	3

#define FORTERESSE	0
#define ARMEE		1
#define HOVERCRAFT	2    /* Type */

#define CASE_VIDE	-2
#define CASE_OCCUPEE 	-1

#define MYARMIE		1
#define ENNEMY		2

#define ANY		-3

typedef struct {
  int TIME_TO_PLACE;  /* en minutes */
  int TIME_TO_PLAY;   /* en secondes */
  int CREDITS_100;
  int SIZE_X;
  int SIZE_Z;
  int COST_FORTRESS;
  int COST_ARMIE;
  int COST_HOVERCRAFT;
  int COST_INVISIBILITY;
  int COST_TELEPORT;
  int DEF_FORTRESS;
  int DEF_ARMIE;
  int DEF_HOVERCRAFT;
  int ATT_ARMIE;
  int ATT_HOVERCRAFT;
  int MOV_ARMIE;
  int MOV_HOVERCRAFT;
  int TELEPORT_FIELD;
} Parameters;


int EqualCase(Case mycase, int p, int x, int y);

int IsNear(Univers *U, Case c1, Case c2, int Type, Parameters *params);

int IsUnique(OneMovement *Moves, int f1, int f2, int p, int x, int y);

int IsWhom(Univers *U, int caseZ, int caseX, int caseY, int Joueur);

int Place(Univers *U, int caseZ, int caseX, int caseY, int Joueur, int Type, int Caract, 
	  int *Pecule, Parameters *params);

int DefenseTotal(Univers *U, int p, int x, int y, Parameters *params);

int IsVoisin(Univers *U, int j1, int j2);

void ErasePlayer(Univers *U, int joueur);

void ChangeToPlayer(Univers *U, int Killed, int Alive);

#endif
