/*
   graphics.h
   
   for Final Battle
   
   By Mike Hufnagel and Bill Kendrick
   Previously modified: 11/26/95
   Last modified: 12/4/97

   Graphic routines.
*/

#ifndef GRAPHICS_H
#define GRAPHICS_H

#include <X11/Xlib.h>
#include <X11/Xutil.h>

void drawasteroid(int pln, int ast);
/* 
   Draws asteroid "ast" in player "pln"'s window, relative to player "pln".
   Position and frame are determined by global arrays reference by "pln"
   and "ast". 
*/

void drawdrone(int pln, int drn);
/* 
   Draws drone "drone" in player "pln"'s window, relative to player "pln".
   Position is determined by global arrays reference by "pln"
   and "drone". 
*/

void drawship(int pln, int opln);
/*
   Draws player "opln"'s ship in player "pln"'s window, relative to player 
   "pln". Position and frame (direction) are determined by global arrays 
   referenced by "pln" and "opln". 
*/

void drawstar(int pln, int str);
/*
   Draws star "star" in player "pln"'s window, relative to player "pln".
   Position is determined by global arrays reference by "pln" and "star".
*/

void drawweapon(int pln, int weap);
/*
   Draws weapon "weap" in player "pln"'s window, relative to player "pln".
   Position and frame are determined by global arrays reference by "pln"
   and "weap".
*/

void drawupgrade(int pln, int upg);
/* 
   Draws upgrade "upg" in player "pln"'s window, relative to player "pln".
   Position and frame are determined by global arrays reference by "pln"
   and "upg". 
*/

void drawdebris(int pln, int deb);
/* 
   Draws debris "deb" in player "pln"'s window, relative to player "pln".
   Position and shape are determined by global arrays reference by "pln"
   and "deb". 
*/

void drawbitmap(Display *display, Window w, GC gc, int x, int y, Pixmap b);
/*
  Draws bitmap b in window w at x,y with graphic context gc.
*/

void drawwormhole(int pln);
/*
  Draws the wormhole in "pln"'s window, relative to player "pln".
*/


#endif /* GRAPHICS_H */
