#include <stdio.h>
#include <tk.h>
#include <tcl.h>
#include "awelewish.h"
#include "awele.h"

/* rappel des variables globales */
char * levelname ;
char * awstr ;

void create_commands( Tcl_Interp * , Tk_Window );
void link_global_variables( Tcl_Interp * , Tk_Window ) ;

void create_commands(Tcl_Interp *interp , Tk_Window w )
{
    Tcl_CreateCommand( interp , "setlevel" , setlevel , NULL , NULL ) ;
    Tcl_CreateCommand( interp , "computer_play" , computer_play , NULL , NULL ) ;
    Tcl_CreateCommand( interp , "computer_rand_play" , computer_rand_play , NULL , NULL ) ;
    Tcl_CreateCommand( interp , "human_play" , human_play , NULL , NULL ) ;
}

void link_global_variables(Tcl_Interp *interp , Tk_Window w )
{
    levelname = (char *)malloc(80*sizeof(char)) ;
    awstr = (char *)malloc(80*sizeof(char)) ;
    if (levelname == NULL || awstr == NULL ) {
	fprintf(stderr,"Memory problem in link_global_variable");
	exit(0);
    }

    Tcl_LinkVar( interp , "levelname" , (char **) &levelname , TCL_LINK_STRING ) ;
    Tcl_LinkVar( interp , "awcur" , (char **) &awstr , TCL_LINK_STRING ) ;
    srand48(time(0));

}


/* actualise le nom du niveau */
int setlevel( ClientData dummy, Tcl_Interp *interp, int argc, char **argv )
{
    int level ;
    if ( argc !=3 ) {
	interp->result = "wrong number of args in function setlevel" ;
	return TCL_ERROR ;
    }
    sprintf(levelname , "%s" , argv[1]);
    sprintf(awstr,"%s",argv[2]);
    str2level( levelname , &level ) ;
    Tcl_SetVar( interp , "levelname" , levelname , 0 ) ; /* bicose ca chie avec textvariable*/
    awstr[2] = level/10 + 48 ;
    awstr[3] = level%10 + 48 ;
    return TCL_OK ;
}

/* 
produit un coup reflechi 
ARGS: (I/O) la chaine d'awele
*/
int computer_play( ClientData dummy, Tcl_Interp *interp, int argc, char **argv )
{
    int prof , level , cp ,n ;
    AWELE *a ;

    if ( argc !=2 ) {
	interp->result = "wrong number of args in function computer_play" ;
	return TCL_ERROR ;
    }
    a = create_awele() ;
    str2awele( argv[1] , a , &prof , &cp ) ;
    think(PLAYER2,a,prof,&cp,&n);
    play(cp,a,PLAYER2);
    awele2str(a,prof,cp,awstr);
    destroy_awele(&a);
    return TCL_OK ;
}

/* 
produit un coup aleatoire 
ARGS: (I/O) la chaine d'awele
*/
int computer_rand_play( ClientData dummy, Tcl_Interp *interp, int argc, char **argv )
{
    int prof , level , cp , n ;
    AWELE *a ;

    if ( argc !=2 ) {
	interp->result = "wrong number of args in function computer_rand_play" ;
	return TCL_ERROR ;
    }
    a = create_awele() ;
    str2awele( argv[1] , a , &prof , &cp ) ;
    randplay(a,&cp,&n);
    play(cp,a,PLAYER2);
    awele2str(a,prof,cp,awstr);
    destroy_awele(&a);
    return TCL_OK ;
}

/*
   coup humain
   arg: le coup (I) et la chaine d'awele (I/O)
*/
int human_play( ClientData dummy, Tcl_Interp *interp, int argc, char **argv )
{
    AWELE *a ;
    int prof , cp , oldcp ;    
    if ( argc !=3 ) {
	interp->result = "wrong number of args in function human_play" ;
	return TCL_ERROR ;
    }
    if ( Tcl_GetInt( interp , argv[1] , &cp ) != TCL_OK )
	return TCL_ERROR ;
    a = create_awele() ;
    str2awele( argv[2] , a , &prof , &oldcp ) ;
    play(cp,a,PLAYER1);
    awele2str( a , prof , 12 , awstr ) ;    
    destroy_awele(&a);
    return TCL_OK ;
}




