#include <stdio.h>
#include "awele.h"

char maxprof ;
static void alphabeta( TREE * , char , char ) ;

void randplay( AWELE *a , int *cp , int *note ) 
{
    int i;
    do {
	i = 6 + lrand48()%6 ;
    } while ( a->board[i] == 0 ) ;
    (*cp) = i ;
    (*note) = 0 ;
}
/*
   remontee max ( a la becane de jouer ) 
*/
static void alphabeta( TREE * t , char alpha , char beta )
{
    int i,j,n,is,ie ;
    char m,note,prune=FALSE ;

    /* si noeud terminal calcul note */
    if ( t->prof == maxprof || t->aw->p1+t->aw->p2 == ALLPIECES ) {
	t->note = t->aw->p2 - t->aw->p1 ; /* note vue du computer */
	if ( t->player == PLAYER1 ) t->note = -t->note ; /* note vue de l'humain */
	return ;	
    } 

    /* indices des fils */
    switch ( t->player ) {
    case PLAYER1:
	is = START1 , ie = END1 ;
	break ;
    case PLAYER2:
	is = START2 , ie = END2 ;
	break ;
    }

    /* remontee note des fils */
    m = alpha ;
    for ( n=0,i=is ; i<ie && !prune ; n++,i++ ) if ( t->aw->board[i]) {
	t->son[n] = create_tree( t->prof+1 , switch_player(t->player) , t->aw  ) ; 
	(void) play( i , t->son[n]->aw , t->player ) ;
	alphabeta( t->son[n] , -beta , -m ) ;
	note = -t->son[n]->note ;
	if ( note > m ) {
	    m = note ;
	    t->best = (char)i ;
	}
	if ( m >= beta ) prune=TRUE ;
	destroy_tree( &(t->son[n]) ) ;
    }
    t->note = m ;
}

/*
   routine renvoyant le meilleur coup au sens du minmax
*/
void think( char player , AWELE *a , int nbcoup , int *coup , int * note )
{
    TREE * t ;
    char npris ;
    
    maxprof = (char)nbcoup ;

    /* augmente la profondeur quand le nombre de pieces diminue */
    npris = a->p1 + a->p2 ;
    if ( npris > 20 ) maxprof ++ ;
    if ( npris > 25 ) maxprof ++ ;
    if ( npris > 30 ) maxprof ++ ;
    if ( npris > 35 ) maxprof ++ ;
    if ( npris > 40 ) maxprof ++ ;

    /* initialisation de l'arbre */
    t = create_tree( 0 , player , a ) ;

    /* recherche meilleur coup */
    alphabeta( t , -INFINI , INFINI ) ;

    (*coup) = (int)(t->best) ;
    (*note) = -(int)(t->note) ;
    destroy_tree( &t ) ;
}








