static const char
rcsid[] = "$Id: st_lib.c,v 1.4 1997/02/03 16:47:56 b1 Exp $";

/*------------ADDED BY AIX PORTER----------*/
#define  SWAPSHORT(y) \
 ( (((y)&0xff)<<8) | (((y)&0xff00)>>8) )
/*--------END ADDED BY AIX PORTER----------*/

#include <ctype.h>

#include "doomdef.h"

#include "z_zone.h"
#include "v_video.h"

#include "m_swap.h"

#include "i_system.h"

#include "w_wad.h"

#include "st_stuff.h"
#include "st_lib.h"
#include "r_local.h"


extern boolean		automapactive; 




patch_t*		sttminus;

/*------------ADDED BY AIX PORTER-------------*/

void STlib_init(void)
{
    int i;

    if ((i = W_CheckNumForName("STTMINUS")) != -1)
        sttminus = (patch_t *) W_CacheLumpNum(i, PU_STATIC);

/*    sttminus = (patch_t *) W_CacheLumpName("STTMINUS", PU_STATIC);*/
}

/*--------END ADDED BY AIX PORTER---------*/

void
STlib_initNum
( st_number_t*		n,
/*-----ADDED BY AIX PORTER---------*/
/*  int			x,
  int			y,*/

short  int			x,
short  int			y,
/*-----ADDED BY AIX PORTER---------*/
  patch_t**		pl,
  int*			num,
  boolean*		on,
  int			width )
{
    n->x	= x;
    n->y	= y;
    n->oldnum	= 0;
    n->width	= width;
    n->num	= num;
    n->on	= on;
    n->p	= pl;
}


void
STlib_drawNum
( st_number_t*	n,
  boolean	refresh )
{

    int		numdigits = n->width;
    int		num = *n->num;
    
    int		w = SWAPSHORT(n->p[0]->width);
    int		h = SWAPSHORT(n->p[0]->height);
    int		x = n->x;
    
    int		neg;

    n->oldnum = *n->num;

    neg = num < 0;

    if (neg)
    {
	if (numdigits == 2 && num < -9)
	    num = -9;
	else if (numdigits == 3 && num < -99)
	    num = -99;
	
	num = -num;
    }

    x = n->x - numdigits*w;

    if (n->y - ST_Y < 0)
	I_Error("drawNum: n->y - ST_Y < 0");

    V_CopyRect(x, n->y - ST_Y, BG, w*numdigits, h, x, n->y, FG);

    if (num == 1994)
	return;

    x = n->x;

    if (!num)
	V_DrawPatch(x - w, n->y, FG, n->p[ 0 ]);

    while (num && numdigits--)
    {
	x -= w;
	V_DrawPatch(x, n->y, FG, n->p[ num % 10 ]);
	num /= 10;
    }

    if (neg)
	V_DrawPatch(x - 8, n->y, FG, sttminus);
}


void
STlib_updateNum
( st_number_t*		n,
  boolean		refresh )
{
    if (*n->on) STlib_drawNum(n, refresh);
}


void
STlib_initPercent
( st_percent_t*		p,
/*-----ADDED BY AIX PORTER---------*/
/*  int			x,
  int			y,*/
short  int			x,
short  int			y,
/*-----ADDED BY AIX PORTER---------*/
  patch_t**		pl,
  int*			num,
  boolean*		on,
  patch_t*		percent )
{
    STlib_initNum(&p->n, x, y, pl, num, on, 3);
    p->p = percent;
}




void
STlib_updatePercent
( st_percent_t*		per,
/*-----ADDED BY AIX PORTER---------*/
/*  int			refresh )*/
short  int			refresh )
/*-----END ADDED BY AIX PORTER---------*/
{
    if (refresh && *per->n.on)
	V_DrawPatch(per->n.x, per->n.y, FG, per->p);
    
    STlib_updateNum(&per->n, refresh);
}



void
STlib_initMultIcon
( st_multicon_t*	i,
/*-----ADDED BY AIX PORTER---------*/
/*  int			x,
  int			y,*/
short  int			x,
short  int			y,
/*-------END ADDED BY AIX PORTER-------*/
  patch_t**		il,
  int*			inum,
  boolean*		on )
{
    i->x	= x;
    i->y	= y;
    i->oldinum 	= -1;
    i->inum	= inum;
    i->on	= on;
    i->p	= il;
}



void
STlib_updateMultIcon
( st_multicon_t*	mi,
  boolean		refresh )
{
/*-----ADDED BY AIX PORTER---------*/
short    int			w;
short    int			h;
short    int			x;
short    int			y;
/*    int			w;
    int			h;
    int			x;
    int			y;*/
/*-------END ADDED BY AIX PORTER-------*/

    if (*mi->on
	&& (mi->oldinum != *mi->inum || refresh)
	&& (*mi->inum!=-1))
    {
	if (mi->oldinum != -1)
	{
	    x = mi->x - SWAPSHORT(mi->p[mi->oldinum]->leftoffset);
	    y = mi->y - SWAPSHORT(mi->p[mi->oldinum]->topoffset);
	    w = SWAPSHORT(mi->p[mi->oldinum]->width);
	    h = SWAPSHORT(mi->p[mi->oldinum]->height);

	    if (y - ST_Y < 0)
		I_Error("updateMultIcon: y - ST_Y < 0");

	    V_CopyRect(x, y-ST_Y, BG, w, h, x, y, FG);
	}
	V_DrawPatch(mi->x, mi->y, FG, mi->p[*mi->inum]);
	mi->oldinum = *mi->inum;
    }
}



void
STlib_initBinIcon
( st_binicon_t*		b,
/*-----ADDED BY AIX PORTER---------*/
/*  int			x,
  int			y,*/
short  int			x,
short  int			y,
/*-------END ADDED BY AIX PORTER-------*/
  patch_t*		i,
  boolean*		val,
  boolean*		on )
{
    b->x	= x;
    b->y	= y;
    b->oldval	= 0;
    b->val	= val;
    b->on	= on;
    b->p	= i;
}



void
STlib_updateBinIcon
( st_binicon_t*		bi,
  boolean		refresh )
{
/*-----ADDED BY AIX PORTER---------*/
/*  int			x;
  int			y;*/
short  int			x;
short  int			y;
/*-------END ADDED BY AIX PORTER-------*/
    int			w;
    int			h;

    if (*bi->on
	&& (bi->oldval != *bi->val || refresh))
    {
	x = bi->x - SWAPSHORT(bi->p->leftoffset);
	y = bi->y - SWAPSHORT(bi->p->topoffset);
	w = SWAPSHORT(bi->p->width);
	h = SWAPSHORT(bi->p->height);

	if (y - ST_Y < 0)
	    I_Error("updateBinIcon: y - ST_Y < 0");

	if (*bi->val)
	    V_DrawPatch(bi->x, bi->y, FG, bi->p);
	else
	    V_CopyRect(x, y-ST_Y, BG, w, h, x, y, FG);

	bi->oldval = *bi->val;
    }

}

