#ifndef __P_MOBJ__
#define __P_MOBJ__

#include "tables.h"
#include "m_fixed.h"

#include "d_think.h"

#include "doomdata.h"

#include "info.h"



#ifdef __GNUG__
#pragma interface
#endif




typedef enum
{
    MF_SPECIAL		= 1,
    MF_SOLID		= 2,
    MF_SHOOTABLE	= 4,
    MF_NOSECTOR		= 8,
    MF_NOBLOCKMAP	= 16,                    

    MF_AMBUSH		= 32,
    MF_JUSTHIT		= 64,
    MF_JUSTATTACKED	= 128,
    MF_SPAWNCEILING	= 256,
    MF_NOGRAVITY	= 512,

    MF_DROPOFF		= 0x400,
    MF_PICKUP		= 0x800,
    MF_NOCLIP		= 0x1000,
    MF_SLIDE		= 0x2000,
    MF_FLOAT		= 0x4000,
    MF_TELEPORT		= 0x8000,
    MF_MISSILE		= 0x10000,	
    MF_DROPPED		= 0x20000,
    MF_SHADOW		= 0x40000,
    MF_NOBLOOD		= 0x80000,
    MF_CORPSE		= 0x100000,
    MF_INFLOAT		= 0x200000,

    MF_COUNTKILL	= 0x400000,
    
    MF_COUNTITEM	= 0x800000,

    MF_SKULLFLY		= 0x1000000,

    MF_NOTDMATCH    	= 0x2000000,

    MF_TRANSLATION  	= 0xc000000,
    MF_TRANSSHIFT	= 26

} mobjflag_t;


typedef struct mobj_s
{
    thinker_t		thinker;

    fixed_t		x;
    fixed_t		y;
    fixed_t		z;

    struct mobj_s*	snext;
    struct mobj_s*	sprev;

    /*More drawing info: to determine current sprite.*/
    angle_t		angle;	/* orientation*/
    spritenum_t		sprite;	/* used to find patch_t and flip value*/
    int			frame;	/* might be ORed with FF_FULLBRIGHT*/

    struct mobj_s*	bnext;
    struct mobj_s*	bprev;
    
    struct subsector_s*	subsector;

    fixed_t		floorz;
    fixed_t		ceilingz;

    fixed_t		radius;
    fixed_t		height;	

    fixed_t		momx;
    fixed_t		momy;
    fixed_t		momz;

    int			validcount;

    mobjtype_t		type;
    mobjinfo_t*		info;	/* &mobjinfo[mobj->type]*/
    
    int			tics;	/* state tic counter*/
    state_t*		state;
    int			flags;
    int			health;

    int			movedir;	/* 0-7*/
    int			movecount;	/* when 0, select a new dir*/

    struct mobj_s*	target;

    int			reactiontime;   

    int			threshold;

    struct player_s*	player;

    int			lastlook;	

    mapthing_t		spawnpoint;	

    struct mobj_s*	tracer;	
    
} mobj_t;



#endif
