#ifndef __HULIB__
#define __HULIB__

#include "r_defs.h"


#define BG			1
#define FG			0

#define HU_CHARERASE	KEY_BACKSPACE

#define HU_MAXLINES		4
#define HU_MAXLINELENGTH	80


typedef struct
{
    int		x;
    int		y;
    
    patch_t**	f;			/* font*/
    int		sc;			/* start character*/
    char	l[HU_MAXLINELENGTH+1];	/* line of text*/
    int		len;		      	/* current line length*/

    int		needsupdate;	      

} hu_textline_t;



typedef struct
{
    hu_textline_t	l[HU_MAXLINES];	/* text lines to draw*/
    int			h;		/* height in lines*/
    int			cl;		/* current line number*/

    boolean*		on;
    boolean		laston;		/* last value of *->on.*/

} hu_stext_t;



typedef struct
{
    hu_textline_t	l;		/* text line to input on*/

    int			lm;

    boolean*		on; 
    boolean		laston; /* last value of *->on;*/

} hu_itext_t;



void HUlib_init(void);


void	HUlib_clearTextLine(hu_textline_t *t);

void	HUlib_initTextLine(hu_textline_t *t, int x, int y, patch_t **f, int sc);

boolean HUlib_addCharToTextLine(hu_textline_t *t, char ch);

boolean HUlib_delCharFromTextLine(hu_textline_t *t);

void	HUlib_drawTextLine(hu_textline_t *l, boolean drawcursor);

void	HUlib_eraseTextLine(hu_textline_t *l); 



void
HUlib_initSText
( hu_stext_t*	s,
  int		x,
  int		y,
  int		h,
  patch_t**	font,
  int		startchar,
  boolean*	on );

void HUlib_addLineToSText(hu_stext_t* s);  

void
HUlib_addMessageToSText
( hu_stext_t*	s,
  char*		prefix,
  char*		msg );

void HUlib_drawSText(hu_stext_t* s);

void HUlib_eraseSText(hu_stext_t* s); 

void
HUlib_initIText
( hu_itext_t*	it,
  int		x,
  int		y,
  patch_t**	font,
  int		startchar,
  boolean*	on );

void HUlib_delCharFromIText(hu_itext_t* it);

void HUlib_eraseLineFromIText(hu_itext_t* it);

void HUlib_resetIText(hu_itext_t* it);

void
HUlib_addPrefixToIText
( hu_itext_t*	it,
  char*		str );

boolean
HUlib_keyInIText
( hu_itext_t*	it,
  unsigned char ch );

void HUlib_drawIText(hu_itext_t* it);

void HUlib_eraseIText(hu_itext_t* it); 

#endif
/*-----------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------*/
