#ifndef __DOOMDEF__
#define __DOOMDEF__

#include <stdio.h>
#include <string.h>

/*-----------ADDED BY AIX PORTER-------------*/
/*enum { VERSION =  110 };*/
enum { VERSION =  109 };
/*--------END ADDED BY AIX PORTER-----------*/



typedef enum
{
  shareware,	/* DOOM 1 shareware, E1, M9*/
  registered,	/* DOOM 1 registered, E3, M27*/
  commercial,	/* DOOM 2 retail, E1 M34*/
  retail,	/* DOOM 1 retail, E4, M36*/
  indetermined	/* Well, no IWAD found.*/
  
} GameMode_t;


typedef enum
{
  doom,		/* DOOM 1*/
  doom2,	/* DOOM 2*/
  pack_tnt,	/* TNT mission pack*/
  pack_plut,	/* Plutonia pack*/
  none

} GameMission_t;


typedef enum
{
  english,
  french,
  german,
  unknown

} Language_t;


#define RANGECHECK

/*-----------ADDED BY AIX PORTER-------------*/
/*#define SNDSERV  1*/
/*--------END ADDED BY AIX PORTER-----------*/


/*-----------ADDED BY AIX PORTER-------------*/
/*#define X11_DGA*/
/*--------END ADDED BY AIX PORTER-----------*/

#define	BASE_WIDTH		320



#define	SCREEN_MUL		1
#define	INV_ASPECT_RATIO	0.625 /* 0.75, ideally*/

#define SCREENWIDTH  320
#define SCREENHEIGHT 200

#define MAXPLAYERS		4

#define TICRATE		35

typedef enum
{
    GS_LEVEL,
    GS_INTERMISSION,
    GS_FINALE,
    GS_DEMOSCREEN
} gamestate_t;


#define	MTF_EASY		1
#define	MTF_NORMAL		2
#define	MTF_HARD		4

#define	MTF_AMBUSH		8

typedef enum
{
    sk_baby,
    sk_easy,
    sk_medium,
    sk_hard,
    sk_nightmare
} skill_t;




typedef enum
{
    it_bluecard,
    it_yellowcard,
    it_redcard,
    it_blueskull,
    it_yellowskull,
    it_redskull,
    
    NUMCARDS
    
} card_t;



typedef enum
{
    wp_fist,
    wp_pistol,
    wp_shotgun,
    wp_chaingun,
    wp_missile,
    wp_plasma,
    wp_bfg,
    wp_chainsaw,
    wp_supershotgun,

    NUMWEAPONS,
    
    wp_nochange

} weapontype_t;


typedef enum
{
    am_clip,	/* Pistol  chaingun ammo.*/
    am_shell,	/* Shotgun  double barreled shotgun.*/
    am_cell,	/* Plasma rifle, BFG.*/
    am_misl,	/* Missile launcher.*/
    NUMAMMO,
    am_noammo	/* Unlimited for chainsaw  fist.	*/

} ammotype_t;


typedef enum
{
    pw_invulnerability,
    pw_strength,
    pw_invisibility,
    pw_ironfeet,
    pw_allmap,
    pw_infrared,
    NUMPOWERS
    
} powertype_t;



typedef enum
{
    INVULNTICS	= (30*TICRATE),
    INVISTICS	= (60*TICRATE),
    INFRATICS	= (120*TICRATE),
    IRONTICS	= (60*TICRATE)
    
} powerduration_t;




#define KEY_RIGHTARROW	0xae
#define KEY_LEFTARROW	0xac
#define KEY_UPARROW	0xad
#define KEY_DOWNARROW	0xaf
#define KEY_ESCAPE	27
#define KEY_ENTER	13
#define KEY_TAB		9
#define KEY_F1		(0x80+0x3b)
#define KEY_F2		(0x80+0x3c)
#define KEY_F3		(0x80+0x3d)
#define KEY_F4		(0x80+0x3e)
#define KEY_F5		(0x80+0x3f)
#define KEY_F6		(0x80+0x40)
#define KEY_F7		(0x80+0x41)
#define KEY_F8		(0x80+0x42)
#define KEY_F9		(0x80+0x43)
#define KEY_F10		(0x80+0x44)
#define KEY_F11		(0x80+0x57)
#define KEY_F12		(0x80+0x58)

#define KEY_BACKSPACE	127
#define KEY_PAUSE	0xff

#define KEY_EQUALS	0x3d
#define KEY_MINUS	0x2d

#define KEY_RSHIFT	(0x80+0x36)
#define KEY_RCTRL	(0x80+0x1d)
#define KEY_RALT	(0x80+0x38)

#define KEY_LALT	KEY_RALT
#endif  /* __DOOMDEF__*/
/* Don't add more */
