// remap from unicode to other encodings
// (C) Copyright 1998 Herbert Duerr

#include "encoding.h"
#include <string.h>

Encoding* Encoding::first	= 0;
Encoding* Encoding::last	= 0;

Encoding::Encoding( char* mapname)
: strName( mapname), lenName( strlen( mapname))
{
	if( !first) first = this;
	else last->next = this;
	last = this;
	next = 0;
}

Encoding** Encoding::getEncodings( char* mapnames)
{
	Encoding **maps = new Encoding*[16/*###*/], **maps0 = maps;

	for(; *mapnames; ++mapnames) {
		for( Encoding* m = first; m; m = m->next)
			if( !strncmp( mapnames, m->strName, m->lenName)) {
				*(maps++) = m;
				mapnames += m->lenName;
				break;
			}
		if( *mapnames != ',')
			break;
	}

	if( maps == maps0)
		*(maps++) = first;
	*(maps++) = 0;
	return maps0;
}

Encoding* Encoding::findEncoding( char* mapname)
{
	for( Encoding* m = first; m; m = m->next)
		if( !strcmp( mapname, m->strName))
			return m;
	return 0;
}

//---
class iso8859_1
: public Encoding
{
public:
	iso8859_1() : Encoding("iso8859-1") {}
	int map2unicode( int code) { return code;}
} exemplar_iso8859_1;

//---
class iso8859_2
: public Encoding
{
public:
	iso8859_2() : Encoding("iso8859-2") {}
	int map2unicode( int code);
} exemplar_iso8859_2;

int iso8859_2::map2unicode( int code)
{
	static unsigned short table[] = {
		0x0a0, 0x104, 0x2d8, 0x141, 0x0a4, 0x13d, 0x15a, 0xa7,
		0x0a8, 0x160, 0x15e, 0x164, 0x179, 0x0ad, 0x17d, 0x17b,
		0x0b0, 0x105, 0x2db, 0x142, 0x0b4, 0x13e, 0x15b, 0x2c7,
		0x0b8, 0x161, 0x15f, 0x165, 0x17a, 0x2dd, 0x17e, 0x17c,
		0x154, 0x0c1, 0x0c2, 0x102, 0x0c4, 0x139, 0x106, 0x0c7,
		0x10c, 0x0c9, 0x118, 0x0cb, 0x11a, 0x0cd, 0x0ce, 0x10e,
		0x110, 0x143, 0x147, 0x0d3, 0x0d4, 0x150, 0x0d6, 0x0d7,
		0x158, 0x16e, 0x0da, 0x170, 0x0dc, 0x0dd, 0x162, 0x0df,
		0x155, 0x0e1, 0x0e2, 0x103, 0x0e4, 0x13a, 0x107, 0x0e7,
		0x10d, 0x0e9, 0x119, 0x0eb, 0x11b, 0x0ed, 0x0ee, 0x10f,
		0x111, 0x144, 0x148, 0x0f3, 0x0f4, 0x151, 0x0f6, 0x0f7,
		0x159, 0x16f, 0x0fa, 0x171, 0x0fc, 0x0fd, 0x163, 0x2d9
	};

	if( code <= 0xa0 || code >= 256) return code;
	return table[ code - 0xa0];
}

//---
class iso8859_3
: public Encoding
{
public:
	iso8859_3() : Encoding("iso8859-3") {}
	int map2unicode( int code);
} exemplar_iso8859_3;

int iso8859_3::map2unicode( int code)
{
	static unsigned short table[] = {
		0x0a0, 0x126, 0x2d8, 0x0a3, 0x0a4, 0x0a5, 0x124, 0x0a7,
		0x0a8, 0x130, 0x15e, 0x11e, 0x134, 0x0ad, 0x0ae, 0x17b,
		0x0b0, 0x127, 0x0b2, 0x0b3, 0x0b4, 0x0b5, 0x125, 0x0b7,
		0x0b8, 0x131, 0x15f, 0x11f, 0x135, 0x0bd, 0x0be, 0x17c,
		0x0c0, 0x0c1, 0x0c2, 0x0c3, 0x0c4, 0x10a, 0x108, 0x0c7,
		0x0c8, 0x0c9, 0x0ca, 0x0cb, 0x0cc, 0x0cd, 0x0ce, 0x0cf,
		0x0d0, 0x0d1, 0x0d2, 0x0d3, 0x0d4, 0x120, 0x0d6, 0x0d7,
		0x11c, 0x0d9, 0x0da, 0x0db, 0x0dc, 0x16c, 0x15c, 0x0df,
		0x0e0, 0x0e1, 0x0e2, 0x0e3, 0x0e4, 0x10b, 0x109, 0x0e7,
		0x0e8, 0x0e9, 0x0ea, 0x0eb, 0x0ec, 0x0ed, 0x0ee, 0x0ef,
		0x0f0, 0x0f1, 0x0f2, 0x0f3, 0x0f4, 0x121, 0x0f6, 0x0f7,
		0x11d, 0x0f9, 0x0fa, 0x0fb, 0x0fc, 0x16d, 0x15d, 0x2d9
	};

	if( code <= 0xa0 || code >= 256) return code;
	return table[ code - 0xa0];
}

//---
class iso8859_4
: public Encoding
{
public:
	iso8859_4() : Encoding("iso8859-4") {}
	int map2unicode( int code);
} exemplar_iso8859_4;

int iso8859_4::map2unicode( int code)
{
	static unsigned short table[] = {
		0x0a0, 0x104, 0x138, 0x156, 0x0a4, 0x128, 0x13b, 0x0a7,
		0x0a8, 0x160, 0x112, 0x122, 0x166, 0x0ad, 0x17d, 0x0af,
		0x0b0, 0x105, 0x2db, 0x157, 0x0b4, 0x129, 0x13c, 0x2c7,
		0x0b8, 0x161, 0x113, 0x123, 0x167, 0x14a, 0x17e, 0x14b,
		0x100, 0x0c1, 0x0c2, 0x0c3, 0x0c4, 0x0c5, 0x0c6, 0x12e,
		0x10c, 0x0c9, 0x118, 0x0cb, 0x116, 0x0cd, 0x0ce, 0x12a,
		0x110, 0x145, 0x14c, 0x136, 0x0d4, 0x0d5, 0x0d6, 0x0d7,
		0x0d8, 0x172, 0x0da, 0x0db, 0x0dc, 0x168, 0x16a, 0x0df,
		0x101, 0x0e1, 0x0e2, 0x0e3, 0x0e4, 0x0e5, 0x0e6, 0x12f,
		0x10d, 0x0e9, 0x119, 0x0eb, 0x117, 0x0ed, 0x0ee, 0x12b,
		0x111, 0x146, 0x14d, 0x137, 0x0f4, 0x0f5, 0x0f6, 0x0f7,
		0x0f8, 0x173, 0x0fa, 0x0fb, 0x0fc, 0x169, 0x16b, 0x2d9
	};

	if( code <= 0xa0 || code >= 256) return code;
	return table[ code - 0xa0];
}

//---
class iso8859_5
: public Encoding
{
public:
	iso8859_5() : Encoding("iso8859-5") {}
	int map2unicode( int code);
} exemplar_iso8859_5;

int iso8859_5::map2unicode( int code)
{
	if( code <= 0xa0 || code == 0xad || code >= 256) return code;
	if( code == 0xf0) return 0x2116;
	if( code == 0xfd) return 0xa7;
	return (code + 0x360);
}

//---
class iso8859_6
: public Encoding
{
public:
	iso8859_6() : Encoding("iso8859-6") {}
	int map2unicode( int code);
} exemplar_iso8859_6;

int iso8859_6::map2unicode( int code)
{
	if( code < 0x30 || code >= 256) return code;
	if( code <= 0x39) return (code + 0x630);
	if( code <= 0xa4) return code;
	return (code + 0x560);
}

//---
class iso8859_7
: public Encoding
{
public:
	iso8859_7() : Encoding("iso8859-7") {}
	int map2unicode( int code);
} exemplar_iso8859_7;

int iso8859_7::map2unicode( int code)
{
	static unsigned short table[] = {
		0x0a0, 0x2bd, 0x2bc, 0x0a3, 0x0a4, 0x0a5, 0x0a6, 0x0a7,
		0x0a8, 0x0a9, 0x0aa, 0x0ab, 0x0ac, 0x0ad, 0x0ae, 0x2015,
		0x0b0, 0x0b1, 0x0b2, 0x0b3, 0x384, 0x385, 0x386, 0x0b7,
		0x388, 0x389, 0x38a, 0x0bb, 0x38c, 0x0bd
	};

	if( code <= 0xa0 || code >= 256) return code;
	if( code >= 0xbe) return (code + 0x2d0);
	return table[ code - 0xa0];
}

//---
class iso8859_8
: public Encoding
{
public:
	iso8859_8() : Encoding("iso8859-8") {}
	int map2unicode( int code);
} exemplar_iso8859_8;

int iso8859_8::map2unicode( int code)
{
	if( code <= 0xa9 || code >= 256) return code;
	if( code == 0xaa) return 0xd7;
	if( code == 0xaf) return 0x203e;
	if( code == 0xdf) return 0x2017;
	return (code + 0x3f0);
}

//---
class iso8859_9
: public Encoding
{
public:
	iso8859_9() : Encoding("iso8859-9") {}
	int map2unicode( int code);
} exemplar_iso8859_9;

int iso8859_9::map2unicode( int code)
{
	if( code < 0xd0 || code >= 255) return code;
	switch( code) {
	case 0xd0:	return 0x11e;
	case 0xdd:	return 0x130;
	case 0xde:	return 0x15e;
	case 0xf0:	return 0x11f;
	case 0xfd:	return 0x131;
	case 0xfe:	return 0x15f;
	}
	return code;
}


//--- thanks Vladimir Eltsov and Nikolay Grygoryev
class koi8_r
: public Encoding
{
public:
   koi8_r() : Encoding("koi8-r") {}
   int map2unicode( int code);
} exemplar_koi8_r;

int koi8_r::map2unicode( int code)
{
   static unsigned short table[] = {
     0x2500,0x2502,0x250c,0x2510,0x2514,0x2518,0x251c,0x2524,
     0x252c,0x2534,0x253c,0x2580,0x2584,0x2588,0x258c,0x2590,
     0x2591,0x2592,0x2593,0x2320,0x25a0,0x2219,0x221a,0x2248,
     0x2264,0x2265,0x00a0,0x2321,0x00b0,0x00b2,0x00b7,0x00f7,
     0x2550,0x2551,0x2552,0x0451,0x2553,0x2554,0x2555,0x2556,
     0x2557,0x2558,0x2559,0x255a,0x255b,0x255c,0x255d,0x255e,
     0x255f,0x2560,0x2561,0x0401,0x2562,0x2563,0x2564,0x2565,
     0x2566,0x2567,0x2568,0x2569,0x256a,0x256b,0x256c,0x00a9,
     0x044e,0x0430,0x0431,0x0446,0x0434,0x0435,0x0444,0x0433,
     0x0445,0x0438,0x0439,0x043a,0x043b,0x043c,0x043d,0x043e,
     0x043f,0x044f,0x0440,0x0441,0x0442,0x0443,0x0436,0x0432,
     0x044c,0x044b,0x0437,0x0448,0x044d,0x0449,0x0447,0x044a,
     0x042e,0x0410,0x0411,0x0426,0x0414,0x0415,0x0424,0x0413,
     0x0425,0x0418,0x0419,0x041a,0x041b,0x041c,0x041d,0x041e,
     0x041f,0x042f,0x0420,0x0421,0x0422,0x0423,0x0416,0x0412,
     0x042c,0x042b,0x0417,0x0428,0x042d,0x0429,0x0427,0x042a
   };

   if( code < 128 || code >= 256) return code;
   return table[ code - 128 ];
}


//---
class windows_1251
: public Encoding
{
public:
   windows_1251() : Encoding("windows-1251") {}
   int map2unicode( int code);
} exemplar_windows_1251;

int windows_1251::map2unicode( int code)
{
   static unsigned short table[] = {
     0x0402,0x0403,0x201A,0x0453,0x201E,0x2026,0x2020,0x2021,
     0,0x2030,0x0409,0x2039,0x040A,0x040C,0x040B,0x040F,
     0x0452,0x2018,0x2019,0x201C,0x201D,0x2022,0x2013,0x2014,
     0,0x2122,0x0459,0x203A,0x045A,0x045C,0x045B,0x045F,
     0x00A0,0x040E,0x045E,0x0408,0x00A4,0x0490,0x00A6,0x00A7,
     0x0401,0x00A9,0x0404,0x00AB,0x00AC,0x00AD,0x00AE,0x0407,
     0x00B0,0x00B1,0x0406,0x0456,0x0491,0x00B5,0x00B6,0x00B7,
     0x0451,0x2116,0x0454,0x00BB,0x0458,0x0405,0x0455,0x0457,
     0x0410,0x0411,0x0412,0x0413,0x0414,0x0415,0x0416,0x0417,
     0x0418,0x0419,0x041A,0x041B,0x041C,0x041D,0x041E,0x041F,
     0x0420,0x0421,0x0422,0x0423,0x0424,0x0425,0x0426,0x0427,
     0x0428,0x0429,0x042A,0x042B,0x042C,0x042D,0x042E,0x042F,
     0x0430,0x0431,0x0432,0x0433,0x0434,0x0435,0x0436,0x0437,
     0x0438,0x0439,0x043A,0x043B,0x043C,0x043D,0x043E,0x043F,
     0x0440,0x0441,0x0442,0x0443,0x0444,0x0445,0x0446,0x0447,
     0x0448,0x0449,0x044A,0x044B,0x044C,0x044D,0x044E,0x044F
   };

   if( code < 128 || code >= 256) return code;
   return table[ code - 128 ];
}

