# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX BUFSIZ
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/* ########################################################################

			      BR_Lexer.l

   ########################################################################

   Copyright (c) : Dominique Leveque

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   ######################################################################## */


#include <string.h>
#include <sys/param.h>

#include "proto_decl.h"

#include "BR_Global.h"
#include "BR_Lexer.h"
#include "BR_Parser.h"
#include "BR_Interface.h"

   /*-----------------------------------------------------------------------*/
   /*                          External lex interface                       */
   /*-----------------------------------------------------------------------*/

#undef yywrap
#define yywrap()       (1)

#ifndef yylex
#define yylex          BR_yylex
#endif

BR_TokenPt             BR_lex_prolog;


extern BR_InfoHandler  BR_info_handler;


   /*-----------------------------------------------------------------------*/
   /*                        Internal lex variables                         */
   /*-----------------------------------------------------------------------*/
#ifndef MAXNAMELEN
#define MAXNAMELEN 256
#endif

static BR_Int          fname_len;
static BR_Str          fname[MAXPATHLEN + MAXNAMELEN];

static BR_Int          lname_len;
static BR_Str          lname[MAXPATHLEN + MAXNAMELEN];

static BR_Int          template_level;
static BR_Int          bhole_par_level;
static BR_Int          block_level;

static BR_Boolean      line_named;

static BR_Int          line_num       = 1;

static BR_Boolean      bracket_ignore = BR_FALSE;
static BR_Boolean      colon_ignore   = BR_FALSE;

static BR_TokenPt      token_frame    = BR_Null;
static BR_TokenPt      token_const    = BR_Null;

static BR_Int          str_error_cnt  = 0;


   /*-----------------------------------------------------------------------*/
   /*                        Internal lex buffers                           */
   /*-----------------------------------------------------------------------*/
 
#define MAX_TOKEN_COUNT   256
#define MAX_VAL_LEN       64 
#define VAL_BUF_SIZE      (MAX_TOKEN_COUNT * MAX_VAL_LEN)

static BR_Str       val_buf[MAX_TOKEN_COUNT * MAX_VAL_LEN];
static BR_Str*      val_next = val_buf;
static BR_Str*      val_max  = &(val_buf[VAL_BUF_SIZE - 2]);

static BR_TokenRec  token_buf[MAX_TOKEN_COUNT];
static BR_TokenPt   token_next = token_buf;
static BR_TokenPt   token_max  = &(token_buf[MAX_TOKEN_COUNT - 33]);


   /*-----------------------------------------------------------------------*/
   /*                        Lex states management                          */
   /*-----------------------------------------------------------------------*/

#define MAX_STATE      64

static BR_Int state_stack[MAX_STATE];
static BR_Int top_state = 0;


#define PUSH_STATE(state) \
    {                                         \
      if (top_state < (MAX_STATE - 1))        \
        top_state++;                          \
      state_stack[top_state] = state;         \
      BEGIN(state);                           \
    }

#define POP_STATE() \
    {                                         \
      if (top_state > ((BR_Int) token_frame->_line_num)) \
        --top_state;                          \
      BEGIN(state_stack[top_state]);          \
    }

#define SET_STATE(state) \
    {                                         \
      state_stack[top_state] = state;         \
      BEGIN(state);                           \
    }

#define TOP_STATE()         state_stack[top_state]


   /*-----------------------------------------------------------------------*/
   /*                      Related Token Constants                          */
   /*-----------------------------------------------------------------------*/

#define STR_COMMA             ", "
#define STR_LPARENTH          "( "
#define STR_RPARENTH          ") "
#define STR_STAR              "* "
#define STR_AND               "& "
#define STR_TILDE             "~ "
#define STR_PREFIX            ":: "
#define STR_ARRAY             "[] "
#define STR_ELLIPSIS          "... "
#define STR_ENUM              "enum "
#define STR_CLASS             "class "
#define STR_UNION             "union "
#define STR_STRUCT            "struct "
#define STR_OPERATOR          "operator "
#define STR_PUBLIC            "public "
#define STR_PRIVATE           "private "
#define STR_PROTECTED         "protected "
#define STR_PARENTHS          "() "
#define STR_EQUAL             "= "

#define T_COMMA               ','
#define T_LPARENTH            '('
#define T_RPARENTH            ')'
#define T_STAR                '*'
#define T_AND                 '&'
#define T_TILDE               '~'
#define T_LBRACKET            '{'
#define T_RBRACKET            '}'
#define T_SEMICOLON           ';'
#define T_COLON               ':'
#define T_EQUAL               '='
#define T_SUP                 '>'

#define BASIC_INT             ((BR_ULong) 0x00000000)
#define BASIC_CHAR            ((BR_ULong) 0x00000001)
#define BASIC_SHORT           ((BR_ULong) 0x00000002)
#define BASIC_LONG            ((BR_ULong) 0X00000003)
#define BASIC_SIGNED          ((BR_ULong) 0x00000000)
#define BASIC_UNSIGNED        ((BR_ULong) 0x00000004)
#define BASIC_CONST           ((BR_ULong) 0x00000008)


   /*-----------------------------------------------------------------------*/
   /*                         Related Token Macros                          */
   /*-----------------------------------------------------------------------*/

#define GET_FREE_TOKEN(t)           \
  if (token_next > token_max)                                 \
  {                                                           \
    fprintf(stderr, ">>>> Lexer Tokens buffer exhausted\n");  \
    return(T_LEXER_ERROR);                                    \
  }                                                           \
  t = token_next++;

#define GET_FREE_STR(val, len)      \
  val       = val_next;                                       \
  val_next += len;                                            \
  if (val_next > val_max)                                     \
  {                                                           \
    fprintf(stderr, ">>>> Lexer Strings buffer exhausted\n"); \
    return(T_LEXER_ERROR);                                    \
  }                                                           \
  *(val_next)++ = ' ';


#define TOP_TOKEN()                (token_next - 1)


#define RETURN_FRAME(info)         (token_frame->_bits |= info)

#define RETURN_CODE(key)           return(key);

#define RETURN_BIT(key, bit)       \
{                                              \
  GET_FREE_TOKEN(yylval);                      \
  yylval->_code     = key;                     \
  yylval->_bits     = bit;                     \
  yylval->_next     = BR_Null;                 \
  yylval->_last     = yylval;                  \
  yylval->_prefix   = BR_Null;                 \
  return(key);                                 \
}

#define RETURN_KEYWORD(key, str)   \
{                                              \
  GET_FREE_TOKEN(yylval);                      \
  yylval->_code     = key;                     \
  yylval->_val      = str;                     \
  yylval->_val_len  = sizeof(str) - 2;         \
  yylval->_line_num = line_num;                \
  yylval->_next     = BR_Null;                 \
  yylval->_last     = yylval;                  \
  yylval->_prefix   = BR_Null;                 \
  yylval->_bits     = BR_INFO_EMPTY;           \
  return(key);                                 \
}

#define RETURN_TOKEN(key)          \
{                                              \
  GET_FREE_TOKEN(yylval);                      \
  GET_FREE_STR(yylval->_val, yyleng);          \
  strncpy(yylval->_val, yytext, yyleng);       \
  yylval->_code     = key;                     \
  yylval->_val_len  = yyleng;                  \
  yylval->_line_num = line_num;                \
  yylval->_next     = BR_Null;                 \
  yylval->_last     = yylval;                  \
  yylval->_prefix   = BR_Null;                 \
  yylval->_bits     = BR_INFO_EMPTY;           \
  return(key);                                 \
}  


   /*-----------------------------------------------------------------------*/
   /*                         Black Hole Bits                               */
   /*-----------------------------------------------------------------------*/

typedef BR_ULong              BhExitBits;

#define BHEB_SEMI             ((BhExitBits) 0x00000001)
#define BHEB_COMMA            ((BhExitBits) 0x00000002)
#define BHEB_BRACKET          ((BhExitBits) 0x00000004)
#define BHEB_SQUARE           ((BhExitBits) 0x00000008)
#define BHEB_PARENTH          ((BhExitBits) 0x00000010)

#define BHEB_UN_SEMI          ((BhExitBits) 0x00000020)
#define BHEB_UN_COMMA         ((BhExitBits) 0x00000040)
#define BHEB_UN_BRACKET       ((BhExitBits) 0x00000080)
#define BHEB_UN_SQUARE        ((BhExitBits) 0x00000100)
#define BHEB_UN_PARENTH       ((BhExitBits) 0x00000200)


static BhExitBits             bhole_exit;


   /*-----------------------------------------------------------------------*/
   /*                         Miscellaneous macros                          */
   /*-----------------------------------------------------------------------*/

#define NEW_LINE()            line_num++


   /*-----------------------------------------------------------------------*/
   /*-----------------------------------------------------------------------*/
# define FILE_MAIN 2
# define TEMPLATE_DECL 4
# define TEMPLATE_ARG 6
# define TEMPLATE_INST 8
# define BLACK_HOLE 10
# define BLOCK_IGN 12
# define FILE_IGN 14
# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
  /*-----------------------------------------------------------------------*/

<FILE_MAIN>"register"

<FILE_MAIN>"auto"

<FILE_MAIN>"volatile"


   /*-----------------------------------------------------------------------*/

<FILE_MAIN>"extern"            { RETURN_FRAME(BR_INFO_EXTERN);        }
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
           { RETURN_FRAME(BR_INFO_INLINE);        }
break;
case 2:
           { RETURN_FRAME(BR_INFO_STATIC);        }
break;
case 3:
          { RETURN_FRAME(BR_INFO_VIRTUAL);       }
break;
case 4:
          { RETURN_FRAME(BR_INFO_TYPEDEF);       }
break;
case 5:
  /*-----------------------------------------------------------------------*/

<FILE_MAIN>"class"             { RETURN_CODE(T_CLASS);                }
break;
case 5:
           { RETURN_CODE(T_STRUCT);               }
break;
case 6:
            { RETURN_CODE(T_UNION);                }
break;
case 7:
             { RETURN_CODE(T_ENUM);                 }
break;
case 8:
           { RETURN_CODE(T_FRIEND);               }
break;
case 9:
                { RETURN_CODE(T_SEMICOLON);            }
break;
case 10:
                { RETURN_CODE(T_RBRACKET);             }
break;
case 11:
  /*-----------------------------------------------------------------------*/

<FILE_MAIN>"int"               { RETURN_BIT(T_BASIC, BASIC_INT);      }
break;
case 11:
             { RETURN_BIT(T_BASIC, BASIC_CHAR);     }
break;
case 12:
             { RETURN_BIT(T_BASIC, BASIC_LONG);     }
break;
case 13:
            { RETURN_BIT(T_BASIC, BASIC_SHORT);    }
break;
case 14:
           { RETURN_BIT(T_BASIC, BASIC_SIGNED);   }
break;
case 15:
         { RETURN_BIT(T_BASIC, BASIC_UNSIGNED); }
break;
case 16:
  /*-----------------------------------------------------------------------*/

<FILE_MAIN>"("                 {
                                 token_const = token_next;
                                 if (TOP_TOKEN()->_code == T_OPERATOR)
                                 {
                                   if (input() == ')')
                                     RETURN_KEYWORD(T_IDENT, STR_PARENTHS)
                                   else
                                     RETURN_TOKEN(T_LEXER_ERROR);
                                 }
                                 else
                                   RETURN_KEYWORD(T_LPARENTH, STR_LPARENTH);
                               }
break;
case 16:
                {
                                 token_const = token_next;
                                 RETURN_KEYWORD(T_RPARENTH, STR_RPARENTH);
                               }
break;
case 17:
                {
                                 token_const = token_next;
                                 if (TOP_TOKEN()->_code == T_OPERATOR)
                                   RETURN_KEYWORD(T_IDENT, STR_COMMA)
				 else
                                   RETURN_KEYWORD(T_COMMA, STR_COMMA);
                               }
break;
case 18:
                {
                                 token_const = token_next;
                                 if (TOP_TOKEN()->_code == T_OPERATOR)
                                   RETURN_KEYWORD(T_IDENT, STR_STAR)
				 else
                                   RETURN_KEYWORD(T_STAR, STR_STAR);
                               }
break;
case 19:
                {
                                 token_const = token_next;
                                 if (TOP_TOKEN()->_code == T_OPERATOR)
                                   RETURN_KEYWORD(T_IDENT, STR_AND)
				 else
                                   RETURN_KEYWORD(T_AND, STR_AND);
                               }
break;
case 20:
          { RETURN_KEYWORD(T_PRIVATE, STR_PRIVATE);     }
break;
case 21:
        { RETURN_KEYWORD(T_PROTECTED, STR_PROTECTED); }
break;
case 22:
           { RETURN_KEYWORD(T_PUBLIC, STR_PUBLIC);       }
break;
case 23:
                { RETURN_KEYWORD(T_TILDE, STR_TILDE);         }
break;
case 24:
              { RETURN_KEYWORD(T_ELLIPSIS, STR_ELLIPSIS);   }
break;
case 25:
               { RETURN_KEYWORD(T_PREFIX, STR_PREFIX);       }
break;
case 26:
  /*-----------------------------------------------------------------------*/

<FILE_MAIN>"const"             {
                                 if (TOP_TOKEN()->_code == T_BASIC)
                                   RETURN_BIT(T_BASIC, BASIC_CONST)
                                 else if (token_const != BR_Null)
                                   token_const->_bits |= BR_INFO_CONST;
                               }
break;
case 26:
  /*-----------------------------------------------------------------------*/

<FILE_MAIN>{OPERATOR}
break;
case 26:
                                if (TOP_TOKEN()->_code == T_OPERATOR)
                                   RETURN_TOKEN(T_IDENT)
				 else
                                   RETURN_TOKEN(T_LEXER_ERROR);
break;
case 26:
                              }

<FILE_MAIN>"operator"          {
                                 token_const = token_next;
break;
case 26:
			 RETURN_KEYWORD(T_OPERATOR, STR_OPERATOR);
break;
case 26:
                              }


   /*-----------------------------------------------------------------------*/

<TEMPLATE_DECL>"class"         { PUSH_STATE(TEMPLATE_ARG);
break;
case 26:
         { 
                                 POP_STATE();
                                 RETURN_TOKEN(T_TEMPLATE_ARG);
                               }
break;
case 27:
  { POP_STATE();      }
break;
case 28:
            {
                                 POP_STATE();
                                 RETURN_CODE(T_SUP);
                               }
break;
case 29:
            {
                                 if (TOP_STATE() == TEMPLATE_ARG)
                                   POP_STATE();
                               }
break;
case 31:
         {
                                 PUSH_STATE(TEMPLATE_DECL);
                                 RETURN_CODE(T_TEMPLATE);
                               }
break;
case 32:
  /*-----------------------------------------------------------------------*/

<TEMPLATE_INST>"<"             { template_level++; }
break;
case 32:
            {
                                 --template_level;
                                 if (template_level <= 0)
                                   POP_STATE();
                               }
break;
case 34:
                {
                                 if (TOP_TOKEN()->_code == T_OPERATOR)
                                   RETURN_TOKEN(T_IDENT)
                                 else
                                 {
                                   template_level = 1;
                                   PUSH_STATE(TEMPLATE_INST);
                                 }
                               }
break;
case 35:
  /*-----------------------------------------------------------------------*/

<FILE_MAIN>":"                 {
                                 if (colon_ignore != BR_FALSE)
                                   colon_ignore = BR_FALSE;
                                 else
                                 {
	                           PUSH_STATE(BLACK_HOLE);
                                   bhole_exit  = BHEB_SEMI;
                                   bhole_exit |= BHEB_COMMA;
                                   bhole_exit |= BHEB_BRACKET;
                                   bhole_exit |= BHEB_UN_SEMI;
                                   bhole_exit |= BHEB_UN_COMMA;
                                   bhole_exit |= BHEB_UN_BRACKET;
                                   bhole_par_level = 0;
                                 }
                                 RETURN_CODE(T_COLON);
                               }
break;
case 35:
                {
                                 if (TOP_TOKEN()->_code == T_OPERATOR)
                                   RETURN_KEYWORD(T_IDENT, STR_EQUAL)
                                 else
                                 {
	                           PUSH_STATE(BLACK_HOLE);
                                   bhole_exit  = BHEB_COMMA;
                                   bhole_exit |= BHEB_SEMI;
                                   bhole_exit |= BHEB_BRACKET;
                                   bhole_exit |= BHEB_PARENTH;
                                   bhole_exit |= BHEB_UN_COMMA;
                                   bhole_exit |= BHEB_UN_SEMI;
                                   bhole_exit |= BHEB_UN_BRACKET;
                                   bhole_exit |= BHEB_UN_PARENTH;
                                   bhole_par_level = 0;
                                   RETURN_CODE(T_EQUAL);
                                 }
                               }
break;
case 36:
                {
                                 if (TOP_TOKEN()->_code == T_OPERATOR)
                                 {
                                   if (input() == ']')
                                     RETURN_KEYWORD(T_IDENT, STR_ARRAY)
                                   else
                                     RETURN_TOKEN(T_LEXER_ERROR);
                                 }
                                 else
                                 {
	                           PUSH_STATE(BLACK_HOLE);
                                   bhole_exit  = BHEB_SQUARE;
                                   bhole_par_level = 0;
                                   RETURN_KEYWORD(T_ARRAY, STR_ARRAY);
                                 }
                               }
break;
case 37:
  /*-----------------------------------------------------------------------*/

<FILE_MAIN>{IDENT}
break;
case 37:
  /*-----------------------------------------------------------------------*/

<BLACK_HOLE>[^#{/'";,\]()\n]+
