/*	This file is part of e93.

	e93 is free software; you can redistribute it and/or modify
	it under the terms of the e93 LICENSE AGREEMENT.

	e93 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	e93 LICENSE AGREEMENT for more details.

	You should have received a copy of the e93 LICENSE AGREEMENT
	along with e93; see the file "LICENSE.TXT".
*/

#define	VIEWTOPMARGIN			4		/* number of pixels to leave at the top of the view */
#define	VIEWBOTTOMMARGIN		4		/* number of pixels to leave at the bottom of the view */
#define	VIEWLEFTMARGIN			10		/* number of pixels to the left of the text in the view that we call the left hand side */

typedef struct viewDescriptor			/* describes a view to creation routines */
	{
	EDITORUNIVERSE
		*theUniverse;					/* the editor universe on which to view */
	EDITORRECT
		theRect;						/* position and size within parent window */
	UINT32
		topLine;
	INT32
		leftPixel;
	UINT32
		tabSize;
	EDITORCOLOR
		backgroundColor;				/* color to use when drawing background */
	EDITORCOLOR
		foregroundColor;				/* color to use when drawing foreground */
	char
		*fontName;						/* initial font to use */
	BOOLEAN
		active;							/* tells if the view is created active or not */
	void
		(*viewTextChangedVector)(struct editorView *theView);	/* this vector is called by the view when it has finished a text change */
	void
		(*viewSelectionChangedVector)(struct editorView *theView);	/* this vector is called by the view when it has finished a selection change */
	void
		(*viewPositionChangedVector)(struct editorView *theView);	/* this vector is called by the view when it has finished a position change */
	} EDITORVIEWDESCRIPTOR;


BOOLEAN PointInView(EDITORVIEW *theView,INT32 x,INT32 y);
void LocalClickToViewClick(EDITORVIEW *theView,INT32 clickX,INT32 clickY,INT32 *xPosition,INT32 *lineNumber);
void HandleViewKeyEvent(EDITORVIEW *theView,XEvent *theEvent);
void DrawView(EDITORVIEW *theView);
void SetViewBounds(EDITORVIEW *theView,EDITORRECT *newBounds);
EDITORVIEW *CreateEditorView(EDITORWINDOW *theWindow,EDITORVIEWDESCRIPTOR *theDescriptor);
void DisposeEditorView(EDITORVIEW *theView);
void InvalidateViewPortion(EDITORVIEW *theView,UINT32 startLine,UINT32 endLine,UINT32 startPixel,UINT32 endPixel);
void ScrollViewPortion(EDITORVIEW *theView,UINT32 startLine,UINT32 endLine,INT32 numLines,UINT32 startPixel,UINT32 endPixel,INT32 numPixels);
void SetViewTopLeft(EDITORVIEW *theView,UINT32 newTopLine,INT32 newLeftPixel);
void GetEditorViewGraphicToTextPosition(EDITORVIEW *theView,CHUNKHEADER *theChunk,UINT32 theOffset,INT32 xPosition,UINT32 *betweenOffset,UINT32 *charOffset);
void GetEditorViewTextToGraphicPosition(EDITORVIEW *theView,CHUNKHEADER *theChunk,UINT32 theOffset,UINT32 linePosition,INT32 *xPosition);
void GetEditorViewTextToLimitedGraphicPosition(EDITORVIEW *theView,CHUNKHEADER *theChunk,UINT32 theOffset,UINT32 linePosition,INT32 maxXPosition,INT32 *xPosition);
void GetEditorViewTextInfo(EDITORVIEW *theView,UINT32 *topLine,UINT32 *numLines,INT32 *leftPixel,UINT32 *numPixels);
void SetEditorViewTopLine(EDITORVIEW *theView,UINT32 lineNumber);
UINT32 GetEditorViewTabSize(EDITORVIEW *theView);
BOOLEAN SetEditorViewTabSize(EDITORVIEW *theView,UINT32 theSize);
BOOLEAN GetEditorViewFont(EDITORVIEW *theView,char *theFont,UINT32 stringBytes);
BOOLEAN SetEditorViewFont(EDITORVIEW *theView,char *theFont);
BOOLEAN GetEditorViewColors(EDITORVIEW *theView,EDITORCOLOR *foregroundColor,EDITORCOLOR *backgroundColor);
BOOLEAN SetEditorViewColors(EDITORVIEW *theView,EDITORCOLOR foregroundColor,EDITORCOLOR backgroundColor);
void ResetEditorViewCursorBlink(EDITORVIEW *theView);
void ViewCursorTask(EDITORVIEW *theView);
void ViewsStartSelectionChange(EDITORUNIVERSE *theUniverse);
void ViewsEndSelectionChange(EDITORUNIVERSE *theUniverse);
void ViewsStartTextChange(EDITORUNIVERSE *theUniverse);
void ViewsEndTextChange(EDITORUNIVERSE *theUniverse);
BOOLEAN TrackView(EDITORVIEW *theView,XEvent *theEvent);
void EditorActivateView(EDITORVIEW *theView);
void EditorDeactivateView(EDITORVIEW *theView);
