/* Selection list management functions
   Copyright (C) 1995 Viacom New Media.

	This file is part of e93.

	e93 is free software; you can redistribute it and/or modify
	it under the terms of the e93 LICENSE AGREEMENT.

	e93 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	e93 LICENSE AGREEMENT for more details.

	You should have received a copy of the e93 LICENSE AGREEMENT
	along with e93; see the file "LICENSE.TXT".
*/

#include "includes.h"

void DeleteUniverseSelection(SELECTIONUNIVERSE *theUniverse,ARRAYCHUNKHEADER *theChunk,UINT32 theOffset,UINT32 numSelections,ARRAYCHUNKHEADER **nextChunk,UINT32 *nextOffset)
/* delete numSelections from theUniverse starting at theChunk, theOffset
 * return nextChunk/nextOffset as the chunk and offset just past the end of the
 * delete, or NULL if none exists past the end
 */
{
	DeleteUniverseArray(&(theUniverse->selectionChunks),theChunk,theOffset,numSelections,nextChunk,nextOffset);
}

BOOLEAN InsertUniverseSelection(SELECTIONUNIVERSE *theUniverse,ARRAYCHUNKHEADER *theChunk,UINT32 theOffset,UINT32 numSelections,ARRAYCHUNKHEADER **nextChunk,UINT32 *nextOffset)
/* make room in the selection list for numSelections at theChunk/theOffset
 * return nextChunk and nextOffset as the start of the place where the insertions were made
 */
{
	return(InsertUniverseArray(&(theUniverse->selectionChunks),theChunk,theOffset,numSelections,nextChunk,nextOffset));
}

SELECTIONUNIVERSE *OpenSelectionUniverse()
/* open a selection universe
 * if there is a problem, set the error, and return NULL
 */
{
	SELECTIONUNIVERSE
		*theUniverse;

	if(theUniverse=(SELECTIONUNIVERSE *)MNewPtr(sizeof(SELECTIONUNIVERSE)))
		{
		theUniverse->cursorPosition=0;					/* no cursor position yet, so just set it to 0 */
		if(InitArrayUniverse(&(theUniverse->selectionChunks),SELECTIONCHUNKELEMENTS,sizeof(SELECTIONELEMENT)))
			{
			return(theUniverse);
			}
		MDisposePtr(theUniverse);
		}
	return(NULL);
}

void CloseSelectionUniverse(SELECTIONUNIVERSE *theUniverse)
/* dispose of a selection universe
 */
{
	UnInitArrayUniverse(&(theUniverse->selectionChunks));
	MDisposePtr(theUniverse);
}

SELECTIONUNIVERSE *CopySelectionUniverse(SELECTIONUNIVERSE *theOldUniverse)
/* make a new selection universe that is a copy of the passed one
 * if there is a problem, SetError, and return NULL
 */
{
	SELECTIONUNIVERSE
		*theUniverse;
	ARRAYCHUNKHEADER
		*sourceChunk,
		*destChunk;
	UINT32
		sourceOffset,
		destOffset;

	if(theUniverse=OpenSelectionUniverse())				/* create a new one */
		{
		if(theOldUniverse->selectionChunks.totalElements)
			{
			if(InsertUniverseSelection(theUniverse,NULL,0,theOldUniverse->selectionChunks.totalElements,&destChunk,&destOffset))
				{
				sourceChunk=theOldUniverse->selectionChunks.firstChunkHeader;
				sourceOffset=0;
				theUniverse->cursorPosition=((SELECTIONELEMENT *)sourceChunk->data)[0].startOffset;	/* make cursor position point to the start of the selection list (so if all selections are later deleted, the cursor position is pointing to the start) */
				while(sourceChunk&&destChunk)
					{
					((SELECTIONELEMENT *)destChunk->data)[destOffset]=((SELECTIONELEMENT *)sourceChunk->data)[sourceOffset];
					sourceOffset++;
					if(sourceOffset>=sourceChunk->totalElements)
						{
						sourceChunk=sourceChunk->nextHeader;
						sourceOffset=0;
						}
					destOffset++;
					if(destOffset>=destChunk->totalElements)
						{
						destChunk=destChunk->nextHeader;
						destOffset=0;
						}
					}
				return(theUniverse);
				}
			}
		else
			{
			theUniverse->cursorPosition=theOldUniverse->cursorPosition;	/* copy the cursor position */
			return(theUniverse);
			}
		CloseSelectionUniverse(theUniverse);
		}
	return(NULL);
}

