;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; File:         show-busy.lsp
; RCS:          $Header: /disk3/npm/src/widgit/examples/lib-utils/RCS/show-busy.lsp,v 2.1 1994/06/06 14:54:46 npm Exp npm $
; Description:  Macro '(WINTERP-SHOW-BUSY-PROGN <progn-code>)' works just like
;		'(PROGN <progn-code>)', however, WINTERP-SHOW-BUSY-PROGN will
;               turn on WINTERP's "busy cursor" during exectution of <progn-code>. 
; Author:       Niels Mayer
; Created:      Thu Aug 26 17:24:16 1993
; Modified:     Thu May 11 15:41:48 1995 (Niels Mayer) npm@indeed
; Language:     Lisp
; Package:      N/A
; Status:       X11r6 contrib release
;
; Copyright (C) 1994, Enterprise Integration Technologies Corp. and Niels Mayer.
; WINTERP 1.15-1.99, Copyright (c) 1993, Niels P. Mayer.
; WINTERP 1.0-1.14, Copyright (c) 1989-1992 Hewlett-Packard Co. and Niels Mayer.
; 
; Permission to use, copy, modify, distribute, and sell this software and its
; documentation for any purpose is hereby granted without fee, provided that
; the above copyright notice appear in all copies and that both that
; copyright notice and this permission notice appear in supporting
; documentation, and that the name of Enterprise Integration Technologies,
; Hewlett-Packard Company, or Niels Mayer not be used in advertising or
; publicity pertaining to distribution of the software without specific,
; written prior permission. Enterprise Integration Technologies, Hewlett-Packard
; Company, and Niels Mayer makes no representations about the suitability of
; this software for any purpose.  It is provided "as is" without express or
; implied warranty.
; 
; ENTERPRISE INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY AND NIELS MAYER
; DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
; WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL ENTERPRISE
; INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY OR NIELS MAYER BE LIABLE
; FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
; RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
; CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
; CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "WINTERP")
(export '(WINTERP-SHOW-BUSY-PROGN
	  ))

(defmacro winterp-show-busy-progn (&rest progn-code)
  `(progv '(*breakenable*) '(nil)	;temporarily unset *breakenable* s.t. unwind protect works even when in "debugging" mode.
	  (winterp_show_busy t)		;set busy cursor...
	  (unwind-protect		;even if an error occurs in progn-code, always reset winterp_show_busy to "unbusy"
	      (progn ,@progn-code)	;RETURN value
	    (winterp_show_busy nil)	;always unset busy cursor via unwind-protect 
	    ))
  )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(provide "lib-utils/show-busy")
