
(defun testit (&key (test 1)
		    (foo 2)
		    )
  (format t "testit (~A ~A)\n" test foo)
  )

(testit :test 11 :foo 22)
(testit)

(defun fi				; define function FI
  (a &key ((:mykey b) 9 b-passed)	;   with some optional args
     &ALLOW-OTHER-KEYS
     )
  (print a) (print b)			;
  (if b-passed (print "b was passed")	;
    (print "b not passed")))

(fi)					; error: too few arguments
(fi 1)					; prints 1 9 "b not passed"
(fi 1 'b 'c 'd :mykey)				; prints 1 9 "b not passed"
(fi 1 :b 2)				; prints 1 9 "b not passed"
(fi 1 :mykey 2)				; prints 1 2 "b was passed"


(defun fee				; define function FEE
  (a &key (b 9 b-passed)		;   with some optional args
     &ALLOW-OTHER-KEYS)
  (print a) (print b)			;
  (if b-passed (print "b was passed")	;
    (print "b not passed")))		;
(fee)					; error: too few arguments
(fee 1)					; prints 1 9 "b not passed"
(fee 1 2)				; error: keyword value missing
(fee 1 :b 2)				; prints 1 2 "b was passed"


(defun foo 				; define function FOO
  (a &key b c )				;   with some optional args
  (print a) (print b) (print c))	;
(foo)					; error: too few arguments 
(foo 1)					; prints 1 NIL NIL
(foo 1 2)				; prints 1 NIL NIL
(foo 1 :b 2 :c 3)			; prints 1 2 3 
(foo 1 :c 3 :b 2)			; prints 1 2 3 
(foo 1 :b 3 :b 2)			; prints 1 3 NIL

(defun test (x
	     y
	     &key
	     (anchor-p :initial-value)	;if passed :anchor-p t or 
					;          :anchor-p nil
					;then set anchor toggle to that value
					;if not passed, then do nothing, pass
					;value :initial-value.
	     (attr-str nil)
	     &ALLOW-OTHER-KEYS
	     )
  (format T "x=~A\n" x)
  (format T "y=~A\n" y)
  (format T "anchor-p=~A\n" anchor-p)
  (format T "attr-str=~A\n" attr-str)
  )

(test 1 2
;      :anchor-p 'yesindeed
;      :attr-str 'dogfood
      1
      )
