; -*-Lisp-*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; File:         test-uxproc.lsp
; RCS:          $Header: /users/npm/src/widgit/examples/interactive/RCS/test-uxproc.lsp,v 1.4 1994/09/17 06:34:34 npm Exp npm $
; Description:  Tests of Unix-Subprocess-Class (see ../lib-utils/uxproc-cls.lsp)
; Author:       Niels P. Mayer
; Created:      Wed Aug 31 21:50:44 1994
; Modified:     Fri Sep 16 23:34:29 1994 (Niels Mayer) npm@indeed
; Language:     Lisp
; Package:      N/A
; Status:       X11r6 contrib release
;
; Copyright (C) 1994, Enterprise Integration Technologies Corp. and Niels Mayer.
; 
; Permission to use, copy, modify, distribute, and sell this software and its
; documentation for any purpose is hereby granted without fee, provided that
; the above copyright notice appear in all copies and that both that
; copyright notice and this permission notice appear in supporting
; documentation, and that the name of Enterprise Integration Technologies,
; Hewlett-Packard Company, or Niels Mayer not be used in advertising or
; publicity pertaining to distribution of the software without specific,
; written prior permission. Enterprise Integration Technologies, Hewlett-Packard
; Company, and Niels Mayer makes no representations about the suitability of
; this software for any purpose.  It is provided "as is" without express or
; implied warranty.
; 
; ENTERPRISE INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY AND NIELS MAYER
; DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
; WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL ENTERPRISE
; INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY OR NIELS MAYER BE LIABLE
; FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
; RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
; CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
; CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(require "lib-utils/uxproc-cls")	;define UNIX-SUBPROCESS-CLASS

(defun show-gif (gif-path-str)
  (let (toplevel_w scrl_w gif_w)

    (setq toplevel_w
	  (send TOP_LEVEL_SHELL_WIDGET_CLASS :new "gif-shell"
		))

    (setq scrl_w
	  (send XM_SCROLLED_WINDOW_WIDGET_CLASS :new :managed
		"sc" toplevel_w
		:XMN_SCROLLING_POLICY	:automatic
		))

    (setq gif_w
	  (send XM_LABEL_GADGET_CLASS :new :managed
		"gif" scrl_w
		:XMN_LABEL_TYPE	:pixmap
		:XMN_LABEL_PIXMAP	(gif_to_pixmap gif-path-str :verbose)
		))

    (send toplevel_w :realize)
    ))

(setq scrn-snap-proc
      (send UNIX-SUBPROCESS-CLASS :new :subshell
	    "( rm -f /tmp/foo.gif ; xwd -frame | xwdtopnm | ppmtogif > /tmp/foo.gif ) 2>&1"
	    ))

(send scrn-snap-proc :set-process-finished-callback
      #'(lambda (exit-status-dotted-pair)
	  (if (eq 0 (cdr exit-status-dotted-pair))
	      (show-gif "/tmp/foo.gif")
	    (error "screen-snapshot subprocess error" exit-status-dotted-pair))
	  ))

(send scrn-snap-proc :set-line-output-callback
      #'(lambda (FDINPUTCB_STRING)
	  (format T "line-out-cb: ~A\n" FDINPUTCB_STRING)
	  ))

(send scrn-snap-proc :start-process)
(send scrn-snap-proc :exists_p)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(setq bc-proc
      (send UNIX-SUBPROCESS-CLASS :new :subproc
	    "bc"
	    ))

(send bc-proc :set-process-finished-callback
      #'(lambda (exit-status-dotted-pair)
	  (format T ":SET-PROCESS-FINISHED-CALLBACK=~A\n" exit-status-dotted-pair)
	  ))

(send bc-proc :set-line-output-callback
      #'(lambda (FDINPUTCB_STRING)
	  (format T "line-out-cb: ~A\n" FDINPUTCB_STRING)
	  ))

(send bc-proc :start-process)
(send bc-proc :exists_p)
(send bc-proc :format "2\n")
(send bc-proc :format ". ^ 2\n")
(send bc-proc :signal-kill "HUP")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(setq bogus-proc
      (send UNIX-SUBPROCESS-CLASS :new :subproc
	    "bogus-process"
	    ))

(send bogus-proc :set-process-finished-callback
      #'(lambda (exit-status-dotted-pair)
	  (format T ":SET-PROCESS-FINISHED-CALLBACK=~A\n" exit-status-dotted-pair)
	  ))

(send bogus-proc :set-line-output-callback
      #'(lambda (FDINPUTCB_STRING)
	  (format T "line-out-cb: ~A\n" FDINPUTCB_STRING)
	  ))

(send bogus-proc :start-process)
(send bogus-proc :exists_p)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(setq *xwpick-output-file* "/tmp/foo.gif")
(setq xwpick-proc
      (send UNIX-SUBPROCESS-CLASS :new :subproc
	    "xwpick" *xwpick-output-file*
	    ))

(send xwpick-proc :set-process-finished-callback
      #'(lambda (exit-status-dotted-pair)
	  (format T ":SET-PROCESS-FINISHED-CALLBACK=~A\n" exit-status-dotted-pair)
	  (if (eq 0 (cdr exit-status-dotted-pair))
	      (show-gif "/tmp/foo.gif")
	    (error "screen-snapshot subprocess error" exit-status-dotted-pair))
	  ))

(let ((xwpick-ready-str "press SPACE to pick image ...")
      (str ""))
  (send xwpick-proc :set-char-output-callback
	#'(lambda (FDINPUTCB_FILE)
	    (setq str
		  (concatenate 'string str (fscanf-string FDINPUTCB_FILE "%c")))
	    (if (eq 0 (search xwpick-ready-str str))
		(progn
		  (format T "~A\n" xwpick-ready-str)
		  (send xwpick-proc :set-line-output-callback
			#'(lambda (str) (format t "~A\n" str)))
		  ))
	    ))
  )


(send xwpick-proc :start-process)
(send xwpick-proc :exists_p)
(send xwpick-proc :signal-kill "HUP")
