/* -*-C-*-
********************************************************************************
*
* File:         WWWeasel.c
* RCS:          $Id: $
* Description:  WINTERP main() file.
* Author:       Niels Mayer
* Created:      Sat Jul 16 00:00:00 1995
* Modified:     Sun Nov 23 21:44:08 1997 (Niels Mayer) npm@mayer.netcom.com
* Language:     C
* Package:      N/A
* Status:       Experimental, do not distribute.
*
* Copyright (C) 1994-1996 Enterprise Integration Technologies Corp. and Niels Mayer.
* WINTERP 1.15-1.99, Copyright (c) 1993, Niels P. Mayer.
* WINTERP 1.0-1.14, Copyright (c) 1989-1992 Hewlett-Packard Co. and Niels Mayer.
* 
* Permission to use, copy, modify, distribute, and sell this software and its
* documentation for any purpose is hereby granted without fee, provided that
* the above copyright notice appear in all copies and that both that
* copyright notice and this permission notice appear in supporting
* documentation, and that the name of Enterprise Integration Technologies,
* Hewlett-Packard Company, or Niels Mayer not be used in advertising or
* publicity pertaining to distribution of the software without specific,
* written prior permission. Enterprise Integration Technologies, Hewlett-Packard
* Company, and Niels Mayer makes no representations about the suitability of
* this software for any purpose.  It is provided "as is" without express or
* implied warranty.
* 
* ENTERPRISE INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY AND NIELS MAYER
* DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL ENTERPRISE
* INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY OR NIELS MAYER BE LIABLE
* FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
* RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
* CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
* CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
********************************************************************************
*/
static char rcs_identity[] = "@(#)$Id: $";

#include <stdio.h>
#include <stdlib.h>		/* for getenv(), etc */
#include <ctype.h>
#include <errno.h>
#include <Xm/Xm.h>
#include "winterp.h"

extern int winterp_embedded_main(); /* ../src-server/winterp.c */
extern char* app_name;		/* from ../src-server/winterp.c */

main( argc, argv )
     int argc;
     char *argv[];
{
  app_name = argv[0];
  printf("Starting %s with embedded Winterp\n", app_name);
  
  winterp_embedded_main(argc,argv);
}

int winterp_embedded_app_wrapup()
{
  printf("Exiting %s with embedded Winterp\n", app_name);
  
  return 0;			/* return 0 --> exit */
}


#ifdef PACKAGES
LVAL xlhtmlpack=NULL;
#endif /* PACKAGES */


/* This gets called in same procedure that initializes all WINTERP and
   Xtango classes/objects.
   */
void winterp_embedded_init_xlisp_objs()
{
  HTMLParseBegin();
}

/* gets called from the end of 'xlsinit()' which is the symbol initialization
   routine. this will not get called if restoring a previous envt. 
   N.B.: put calls like 'newpack = makepackage("NEW")' in here...
   */
void winterp_embedded_create_xlisp_syms()
{
  xlhtmlpack = makepackage("HTML");
  use_package(xlisppack, xlhtmlpack); /* package HTML uses XLISP */
  use_package(xlwinterppack, xlhtmlpack); /* package HTML uses WINTERP */
#if 0 /* commented out */
  use_package(xlhtmlpack, xluserpack); /* package USER uses HTML */
#endif /* commented out */
}

/* gets called from 'xlsymbols()' which gets called from 'xlirestore()'.
   This is where you'd place statements that initialize the value of a C
   variable based on an XLISP symbol value. If you've restored, then this
   may be a different value than the one created by
   winterp_embedded_create_xlisp_syms() above.
   N.B.: put calls like 'newpack = xlfindpackage("NEW")' in here...
   */
void winterp_embedded_init_xlisp_syms()
{
  xlhtmlpack = xlfindpackage("HTML");
}

