/* public.h */
#ifndef _PUBLIC_H
#define _PUBLIC_H

#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <stdlib.h>
#include <stdio.h>
#include <string>
#include <vector>
#include <list.h>

/*
 * In X11 and Motif:
 *
 * #define String char *
 *
 * but in C++ a String is a class
 *
 */

#define String XString
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <Xm/XmStrDefs.h>
#include <Xm/Xm.h>
#include <X11/xpm.h>
#include <Xm/ArrowBGP.h>
#include <Xm/ArrowBP.h>
#include <Xm/BulletinBP.h>
#include <Xm/CascadeBGP.h>
#include <Xm/CascadeBP.h>
#include <Xm/CommandP.h>
#include <Xm/DialogSP.h>
#include <Xm/DrawingAP.h>
#include <Xm/DrawnBP.h>
#include <Xm/FileSBP.h>
#include <Xm/FormP.h>
#include <Xm/FrameP.h>
#include <Xm/LabelGP.h>
#include <Xm/LabelP.h>
#include <Xm/ListP.h>
#include <Xm/MainWP.h>
#include <Xm/MenuShellP.h>
#include <Xm/MessageBP.h>
#include <Xm/PanedWP.h>
#include <Xm/PushBGP.h>
#include <Xm/PushBP.h>
#include <Xm/RowColumnP.h>
#include <Xm/ScaleP.h>
#include <Xm/ScrollBarP.h>
#include <Xm/ScrolledWP.h>
#include <Xm/SelectioBP.h>
#include <Xm/SeparatoGP.h>
#include <Xm/SeparatorP.h>
#include <Xm/TextFP.h>
#include <Xm/TextP.h>
#include <Xm/ToggleBGP.h>
#include <Xm/ToggleBP.h>
#include "TabBook.h"
#undef String

#define String string

/****** CLASSES ****/

/****** MACRO ******/
#define VOID_FUNCTION (*f)()
#define CALLBACK_FUNCTION (*f)(Widget, void *, void *)
#define MAX_ARGS 64
#define MAX_STRINGS 32
#define MAX_COLORS 1024
#define MAX_FONTS 256

#define CONSTRAINT_OFFSET 25

#define WIDGET_SPACING 24
#define WIDGET_SIZE 32
#define WIDGET_SIZE_X WIDGET_SIZE
#define WIDGET_SIZE_Y WIDGET_SIZE
#define SPACE WIDGET_SPACING + WIDGET_SIZE

#define CODE_GEN_NONE 0
#define CODE_GEN_MAKEFILE 10
#define CODE_GEN_PUBLIC_H 20
#define CODE_GEN_PUBLIC_C 21
#define CODE_GEN_INTERFACE_H 30
#define CODE_GEN_INTERFACE_C 31
#define CODE_GEN_EVENT_H 40
#define CODE_GEN_EVENT_C 41
#define CODE_GEN_CALLBACK_H 50
#define CODE_GEN_CALLBACK_C 51
#define CODE_GEN_MAIN 60
#define CODE_GEN_INTERFACES 70
#define CODE_GEN_HELP 80
#define CODE_GEN_OTHER 90

#define TEMPLATE_PATH "template/"
#define PROJECT_PATH "project/"
#define PIXMAP_PATH "pixmap/"
#define SOURCE_PATH "src/"

#define APPLICATION_CREATE "\
  %s = \n\
    XtAppCreateShell (\"%s\",\"%s\",\n\
                      applicationShellWidgetClass,display, al, ac );\n"

#undef assert
#undef __assert

#ifdef NDEBUG
#define assert(ignore) ((void) 0)
#define INSURE(ignore) ((void) 0)
#define REQUIRE(ignore) ((void) 0)
#else

#ifndef __GNUC__

#define assert(expression)  \
  ((void) ((expression) ? 0 : __assert (expression, __FILE__, __LINE__)))

#define __assert(expression, file, lineno)  \
  (printf ("%s:%u: failed assertion\n", file, lineno),  \
   abort (), 0)

#else

#if defined(__STDC__) || defined (__cplusplus)

/* Defined in libgcc.a */
#ifdef __cplusplus
extern "C" {
extern void __eprintf (const char *, const char *, unsigned, const char *)
    __attribute__ ((noreturn));
}
#else
extern void __eprintf (const char *, const char *, unsigned, const char *)
    __attribute__ ((noreturn));
#endif

#define assert(expression)  \
  ((void) ((expression) ? 0 : __assert (#expression, __FILE__, __LINE__)))

#define INSURE(expression)  \
  ((void) ((expression) ? 0 : __post_assert (#expression, __FILE__, __PRETTY_FUNCTION__, __LINE__)))

#define REQUIRE(expression)  \
  ((void) ((expression) ? 0 : __pre_assert (#expression, __FILE__, __PRETTY_FUNCTION__, __LINE__)))

#define __assert(expression, file, line)  \
  (__eprintf ("%s:%u: failed assertion `%s'\n",         \
              file, line, expression), 0)

#define __pre_assert(expression, file, func, line)  \
  (printf ("%s:%s:%u: \n  REQUIRE `%s' failed\n",         \
              file, func,line, expression), abort())

#define __post_assert(expression, file, func, line)  \
  (printf ("%s:%s:%u: \n  INSURE `%s' failed\n",         \
              file, func, line, expression), abort()) 

#else /* no __STDC__ and not C++; i.e. -traditional.  */

extern void __eprintf () __attribute__ ((noreturn)); /* Defined in libgcc.a */

#define assert(expression)  \
  ((void) ((expression) ? 0 : __assert (expression, __FILE__, __LINE__)))

#define __assert(expression, file, lineno)  \
  (__eprintf ("%s:%u: failed assertion `%s'\n",         \
              file, lineno, "expression"), 0)

#endif /* no __STDC__ and not C++; i.e. -traditional.  */
#endif /* no __GNU__; i.e., /bin/cc.  */
#endif

#define enter printf("Entering:%s:%s:%u\n",__FILE__, __PRETTY_FUNCTION__, __LINE__)
#define leave printf("Leaving:%s:%s:%u\n",__FILE__, __PRETTY_FUNCTION__, __LINE__)

/****** SET *******/
#define ADDTOSET(s)          s=(s)
#define COMPLEMENT(s)        (~((unsigned long) s))
#define DIFFERENCE(s1, s2)   (s1&(~(s2)))
#define ELEMENT(e)           |((unsigned long)((01L)<<((int)e)))
#define EMPTY(s)             (((long)s)==0L)
#define EMPTY_SET            ((set) 0)
#define INCLUDES(s1, s2)     (((s2)&(~(s1)))==0)
#define IN(s, e)             (((s)&(((unsigned long)01L)<<((int)e)))!=0)
#define INTERSECTION(s1, s2) ((s1)&(s2))
#define MAKESET(s)           s=(0L)
#define REMOVEFROM(s, e)     s=((s)&(~((unsigned long)(01L<<((int)e)))))
#define UNION(s1, s2)        ((s1)|(s2))
#define FIRST_ELEMENT(s)     (ffs(s) - 1)

/****** ENUM ******/
enum widget_type_enum {
  applicationshell_v = 1,
  toplevelshell_v,
  arrowbutton_v,
  arrowbuttongadget_v,
  bulletinboard_v,
  cascadebutton_v,
  cascadebuttongadget_v,
  command_v,
  dialogshell_v,
  drawingarea_v,
  drawnbutton_v,
  errordialog_v,
  fileselectionbox_v,
  form_v,
  formdialog_v,
  frame_v,
  informationdialog_v,
  label_v,
  labelgadget_v,
  list_v,
  mainwindow_v,
  menushell_v,
  menubar_v,
  messagebox_v,
  optionmenu_v,
  panedwindow_v,
  popupmenu_v,
  promptdialog_v,
  pulldownmenu_v,
  pushbutton_v,
  pushbuttongadget_v,
  questiondialog_v,
  radiobox_v,
  rowcolumn_v,
  scale_v,
  scrollbar_v,
  scrolledlist_v,
  scrolledtext_v,
  scrolledwindow_v,
  selectionbox_v,
  selectiondialog_v,
  separator_v,
  separatorgadget_v,
  tabbook_v,
  templatedialog_v,
  text_v,
  textfield_v,
  togglebutton_v,
  togglebuttongadget_v,
  warningdialog_v,
  workingdialog_v,
  last_widget_type_v
};
typedef enum widget_type_enum widget_type_enum;

enum side_type_enum {
  none_selected_v,
  top_selected_v,
  left_selected_v,
  right_selected_v,
  bottom_selected_v
};
typedef enum side_type_enum side_type_enum;
/****** STRUCT ******/
struct res_rec{ 
  char resource_name[64];
  char resource_type[64];
  char resource_value[64];
  char resource_default[64];
  char resource_options[1024];
  Boolean get;
  Boolean set;
  Boolean create;
  Boolean modified;
  char help[2048];
};

/****** EXTERN ******/
extern Boolean debug_set;
#endif _PUBLIC_H
