/* XMToggleButton.C */

#include "XMToggleButton.h"
// Super Class : XMLabel

/*oodB%XMToggleButton*** Global Declarations and Stuffs ****/
Pixmap XMToggleButton::XMToggleButton_pixmap = XmUNSPECIFIED_PIXMAP; 
res_rec XMToggleButton::_toggleButtonResources[10] = {
  /* name type value default option get set create modified */
  "fillOnSelect","Boolean","dynamic","dynamic","True,False",
  True,True,True,False,
  "No Help",
  "indicatorOn","Boolean","True","True","True,False",
  True,True,True,False,
  "No Help",
  "indicatorSize","Dimension","dynamic","dynamic","NONE",
  True,True,True,False,
  "No Help",
  "indicatorType","UnsignedChar","dynamic","dynamic","XmN_OF_MANY,XmONE_OF_MANY",
  True,True,True,False,
  "No Help",
  "selectColor","Pixel","dynamic","dynamic","NONE",
  True,True,True,False,
  "No Help",
  "selectInsensitivePixmap","Pixmap","XmUNSPECIFIED_PIXMAP","XmUNSPECIFIED_PIXMAP","NONE",
  True,True,True,False,
  "No Help",
  "selectPixmap","Pixmap","XmUNSPECIFIED_PIXMAP","XmUNSPECIFIED_PIXMAP","NONE",
  True,True,True,False,
  "No Help",
  "set","Boolean","True","True","True,False",
  True,True,True,False,
  "No Help",
  "spacing","Dimension","4","4","NONE",
  True,True,True,False,
  "No Help",
  "visibleWhenOff","Boolean","dynamic","dynamic","True,False",
  True,True,True,False,
  "No Help"
};
/*oodE******************************************************/

XMToggleButton::~XMToggleButton()
{
	// Empty
}

XMToggleButton::XMToggleButton(Widget self, Widget parent)
{
  setParent(parent);
  setWidget(self);
  setVirtual(True);
  _numResources = 10;

  /* IF no pixmaps has been created */
  if(XMToggleButton_pixmap == XmUNSPECIFIED_PIXMAP)
  { /* create a pixmap */ 
    if ( XpmCreatePixmapFromData ( XtDisplay(getWidget()), 
                                 DefaultRootWindow (XtDisplay(getWidget())),
                                 XMToggleButton_xpm, 
                                 &XMToggleButton_pixmap, NULL, NULL ) != 0 )
       XMToggleButton_pixmap = XmUNSPECIFIED_PIXMAP;
  } /* create a pixmap */ 

  storeResources();
}

XMToggleButton::XMToggleButton(Widget parent,Arg * al, int ac)
{
  if(ac > 0)
    setXtArgs(al,ac);

  setParent(parent);
  createWidget(togglebutton_v);
  _numResources = 10;

  /* IF no pixmaps has been created */
  if(XMToggleButton_pixmap == XmUNSPECIFIED_PIXMAP)
  { /* create a pixmap */ 
    if ( XpmCreatePixmapFromData ( XtDisplay(getWidget()), 
                                 DefaultRootWindow (XtDisplay(getWidget())),
                                 XMToggleButton_xpm, 
                                 &XMToggleButton_pixmap, NULL, NULL ) != 0 )
       XMToggleButton_pixmap = XmUNSPECIFIED_PIXMAP;
  } /* create a pixmap */ 

  /* get resources for this widget */
  storeResources();
}

Pixmap XMToggleButton::getPixmap(void)
{
  return XMToggleButton_pixmap;
}

Boolean XMToggleButton::canbeParent(void)
{
  return False;
}

res_rec * XMToggleButton::getResources(void)
{
  return _resources;
}

int XMToggleButton::getNumResources(void)      
{
  return _numResources;
}

void XMToggleButton::storeResources(void)
{
  res_rec * labelResources = XMLabel::getStaticResources();
  int labelNumResources = XMLabel::getNumStaticResources();
  res_rec * primitiveResources = XtPrimitive::getResources();
  int primitiveNumResources = XtPrimitive::getNumResources();

  int totalNumResources;

  totalNumResources = _numResources + 
                      labelNumResources + 
                      primitiveNumResources;

  _resources = (res_rec *)malloc(totalNumResources*sizeof(res_rec));
 
  memmove(_resources,_toggleButtonResources,_numResources*sizeof(res_rec));
  memmove(&_resources[_numResources],
          labelResources,labelNumResources*sizeof(res_rec));
  memmove(&_resources[_numResources+labelNumResources],
          primitiveResources,primitiveNumResources*sizeof(res_rec));

  _numResources = totalNumResources;
}
