/* XMLabel.C */

#include "XMLabel.h"
// Super Class : XtPrimitive

/*oodB%XMLabel*** Global Declarations and Stuffs ****/
Pixmap XMLabel::XMLabel_pixmap = XmUNSPECIFIED_PIXMAP; 
res_rec XMLabel::_labelResources[18] = {
  /* name type value default option get set create modified */
  { /* accelerator */ 
    "accelerator","String","NULL","NULL","NONE",
    True,True,True,False,
    "A string that describes a buttoon widget's accelerator. The string \
format is that of a translation but allows only a single key press \
event to be specified."
  }, /* accelerator */ 
  { /* acceleratorText */ 
    "acceleratorText","XmString","NULL","NULL","NONE",
    True,True,True,False,
    "The text that is displayed for an accelerator."
  }, /*acceleratorText  */ 
  { /* alignment */ 
    "alignment","UnsignedChar","dynamic","dynamic","NONE",
    True,True,True,False,
    "The alignment for a label's text or pixmap."
  }, /* alignment */ 
  "fontList","XmFontList","dynamic","dynamic","NONE",
  True,True,True,False,
  "The fontlist used for the widget's text. If this value is NULL \
the fontlist is derived from the XmNlabelFontList or buttonFontList \
resource from the nearest parent that is a subclass of BulletinBoard \
MenuSHell or VendorShell.",
  "labelInsensitivePixmap","Pixmap","XmUNSPECIFIED_PIXMAP","XmUNSPECIFIED_PIXMAP","NONE",
  True,True,True,False,
  "The pixmap label for an insensitive button (when XmNlabelType is \
XmPIXMAP).",
  "labelPixmap","Pixmap","XmUNSPECIFIED_PIXMAP","XmUNSPECIFIED_PIXMAP","NONE",
  True,True,True,False,
  "The pixmap used when XmNlabelType is XmPIXMAP.",
  "labelString","XmString","dynamic","dynamic","NONE",
  True,True,True,False,
  "The compound string used when XmNlabelType is XmSTRING. If this \
resource is NULL the appliation uses the widget's name.",
  "labelType","UnsignedChar","XmSTRING","XmSTRING","XmSTRING,XmPIXMAP",
  True,True,True,False,
  "The type of label. Determines wether text a graphic is displayed \
on label.",
  "marginBottom","Dimension","0","0","NONE",
  True,True,True,False,
  "The amount of space between one side of the label text and the nearest \
margin.",
  "marginHeight","Dimension","2","2","NONE",
  True,True,True,False,
  "The amount of space between one side of the label and the nearest edge.",
  "marginLeft","Dimension","0","0","NONE",
  True,True,True,False,
  "The amount of space between one side of the label text and the nearest \
margin.",
  "marginRight","Dimension","0","0","NONE",
  True,True,True,False,
  "The amount of space between one side of the label text and the nearest \
margin.",
  "marginTop","Dimension","0","0","NONE",
  True,True,True,False,
  "The amount of space between one side of the label text and the nearest \
margin.",
  "marginWidth","Dimension","2","2","NONE",
  True,True,True,False,
  "The amount of space between one side of the label and the nearest edge.",
  "mnemonic","KeySym","NULL","NULL","NONE",
  True,True,True,False,
  "A keysym that gives the user another way to select a button. In \
the label string, the first character matching this keysym will be \
underlined.",
  "mnemonicCharSet","String","XmFONTLIST_DEFAULT_TAG","XmFONTLIST_DEFAULT_TAG","NONE",
  True,True,True,False,
  "The character set for the label's mnemonic.",
  "recomputeSize","Booelan","True","True","NONE",
  True,True,True,False,
  "If TRUE (default), the label widget changes its size so that the \
string or pixmap fits exactly.",
  "stringDirection","XmStringDirection","dynamic","dynamic","XmSTRING_DIRECTION_L_TO_R,XmSTRING_DIRECTION_R_TO_L",
  True,True,True,False,
  "The direction in which to draw the string."
};
/*oodE***********************************************/

XMLabel::XMLabel()
{
	// Empty
}

XMLabel::~XMLabel()
{
	// Empty
}

XMLabel::XMLabel(Widget self,Widget parent)
{
  setParent(parent);
  setWidget(self);
  setVirtual(True);
  _numResources = 18;

  /* IF no pixmaps has been created */
  if(XMLabel_pixmap == XmUNSPECIFIED_PIXMAP)
  { /* create a pixmap */ 
    if ( XpmCreatePixmapFromData ( XtDisplay(getWidget()), 
                                 DefaultRootWindow (XtDisplay(getWidget())),
                                 XMLabel_xpm, 
                                 &XMLabel_pixmap, NULL, NULL ) != 0 )
       XMLabel_pixmap = XmUNSPECIFIED_PIXMAP;
  } /* create a pixmap */ 

  /* get resources for this widget */
  storeResources();
}

XMLabel::XMLabel(Widget parent,Arg * al, int ac)
{

  if(ac > 0)
    setXtArgs(al,ac);
  setParent(parent);
  createWidget(label_v);
  _numResources = 18;

  /* IF no pixmaps has been created */
  if(XMLabel_pixmap == XmUNSPECIFIED_PIXMAP)
  { /* create a pixmap */ 
    if ( XpmCreatePixmapFromData ( XtDisplay(getWidget()), 
                                 DefaultRootWindow (XtDisplay(getWidget())),
                                 XMLabel_xpm, 
                                 &XMLabel_pixmap, NULL, NULL ) != 0 )
       XMLabel_pixmap = XmUNSPECIFIED_PIXMAP;
  } /* create a pixmap */ 

  /* get resources for this widget */
  storeResources();
}

Pixmap XMLabel::getPixmap(void)
{
	return XMLabel_pixmap;
}

Boolean XMLabel::canbeParent(void)
{
  return False;
}

res_rec * XMLabel::getStaticResources(void)
{
  return _labelResources;
}

int XMLabel::getNumStaticResources(void)      
{
  return 18;
}

res_rec * XMLabel::getResources(void)
{
  return _resources;
}

int XMLabel::getNumResources(void)      
{
  return _numResources;
}

void XMLabel::storeResources(void)
{
  res_rec * primitiveResources = XtPrimitive::getResources();
  int primitiveNumResources = XtPrimitive::getNumResources();
  int totalNumResources;

  totalNumResources = _numResources + 
                      primitiveNumResources;

  memmove(_resources,_labelResources,_numResources*sizeof(res_rec));
  memmove(&_resources[_numResources],
          primitiveResources,primitiveNumResources*sizeof(res_rec));

  _numResources = totalNumResources;
}

