/* XMFrame.C */

#include "XMFrame.h"
// Super Class : XtManager

/*oodB%XMFrame*** Global Declarations and Stuffs ****/
Pixmap XMFrame::XMFrame_pixmap = XmUNSPECIFIED_PIXMAP; 
res_rec XMFrame::_frameResources[3] = {
  /* name type value default option get set create modified */
  "marginWidth","Dimension","0","0","NONE",
  True,True,True,False,
  "The spacing between the top and bottom of the frame widget's \
child and the shadow of the frame widget.",
  "marginHeight","Dimension","0","0","NONE",
  True,True,True,False,
  "The spacing between the left and right side of the frame widget's \
child and the shadow of the frame widget.",
  "shadowType","UnsignedChar","dynamic","dynamic","XmSHADOW_IN,XmSHADOW_OUT,XmSHADOW_ETCHED_IN,XmSHADOW_ETCHED_OUT",
  True,True,True,False,
  "The stype in which the shadow is drawn."
};

res_rec XMFrame::_frameConstraintResources[4] = {
  /* name type value default option get set create modified */
  "childType","UnsignedChar","XmFRAME_WORKAREA_CHILD","XmFRAME_WORKAREA_CHILD","XmFRAME_TITLE_CHILD,XmFRAME_WORKAREA_CHILD,XmFRAME_GENERIC_CHILD",
  True,True,True,False,
  "No Help defined",
  "childHorizontalAlignment","UnsignedChar","XmALIGNMENT_BEGINNING","XmALIGNMENT_BEGINNING","XmALIGNMENT_BEGINNING,XmALIGNMENT_CENTER,XmALIGNMENT_END",
  True,True,True,False,
  "No Help defined",
  "childHorizontalSpacing","Dimension","dynamic","dynamic","NONE",
  True,True,True,False,
  "No Help defined",
  "childVerticalPlacement","UnsignedChar","","","XmALIGNMENT_BASELINE_TOP,XmALIGNMENT_BASELINE_BOTTOM,XmALIGNMENT_WIDGET_TOP,XmALIGNMENT_CENTER,XmALIGNMENT_WIDGET_BOTTOM",
  True,True,True,False,
  "No Help defined"
};

/*oodE***********************************************/

XMFrame::~XMFrame()
{
	// Empty
}

XMFrame::XMFrame(Widget parent,Arg* al,int ac)
{
  if(ac > 0)
    setXtArgs(al,ac);
  setParent(parent);
  createWidget(frame_v);

  _numResources = 3;
  _constraintNumResources = 4;
  memmove(_constraintResources,_frameConstraintResources,
          _constraintNumResources*sizeof(res_rec));

  /* IF no pixmaps has been created */
  if(XMFrame_pixmap == XmUNSPECIFIED_PIXMAP)
  { /* create a pixmap */ 
    if ( XpmCreatePixmapFromData ( XtDisplay(getWidget()), 
                                 DefaultRootWindow (XtDisplay(getWidget())),
                                 XMFrame_xpm, 
                                 &XMFrame_pixmap, NULL, NULL ) != 0 )
       XMFrame_pixmap = XmUNSPECIFIED_PIXMAP;
  } /* create a pixmap */ 

  /* get resources for this widget */
  storeResources();
}

Pixmap XMFrame::getPixmap(void)
{
	return XMFrame_pixmap;
}

Boolean XMFrame::canbeParent(void)
{
  if(getList()->size() > 1)
    return False;
  else
    return True;
}

res_rec * XMFrame::getResources(void)
{
  return _resources;
}

res_rec * XMFrame::getConstraintResources(void)
{
  return _constraintResources;
}

int XMFrame::getNumConstraintResources(void)
{
  return _constraintNumResources;
}

int XMFrame::getNumResources(void)      
{
  return _numResources;
}

void XMFrame::storeResources(void)
{
  res_rec * compositeResources = XtComposite::getResources();
  int compositeNumResources = XtComposite::getNumResources();
  res_rec * managerResources = XtManager::getResources();
  int managerNumResources = XtManager::getNumResources();
  _resources = (res_rec *)malloc(_numResources*sizeof(res_rec));
  int totalNumResources;

  totalNumResources = _numResources + 
                      compositeNumResources + 
                      managerNumResources;

  _resources = (res_rec *)malloc(totalNumResources*sizeof(res_rec));
 
  if(_resources == NULL)
    cout<< "malloc failed" << endl;

  memmove(_resources,_frameResources,_numResources*sizeof(res_rec));

  memmove(&_resources[_numResources],
          compositeResources,compositeNumResources*sizeof(res_rec));

  _numResources = _numResources + compositeNumResources;
  memmove(&_resources[_numResources],
          managerResources,managerNumResources*sizeof(res_rec));

  _numResources = totalNumResources;
} 
