/* XMDrawnButton.C */

#include "XMDrawnButton.h"
// Super Class : XMLabel

/*oodB%XMDrawnButton*** Global Declarations and Stuffs ****/
Pixmap XMDrawnButton::XMDrawnButton_pixmap = XmUNSPECIFIED_PIXMAP; 
res_rec XMDrawnButton::_drawnButtonResources[3] = {
  /* name type value default option get set create modified */
  "multiClick","UnsignedChar","dynamic","dynamic","XmMULTICLICK_DISCARD,XmMULTICLICK_KEEP",
  True,True,True,False,
  "A flag that determines wether successive button clicks are processed \
or ignored.",
  "pushButtonEnabled","Boolean","False","False","True,False",
  True,True,True,False,
  "If FALSE (default), the shadow drawing doesn't appear 3 dimensional; \
if TRUE, the shading provides a pushed in or raised appearance as for \
the pushbutton widget.",
  "shadowType","UnsignedChar","XmSHADOW_ETCHED_IN","XmSHADOW_ETCHED_IN","XmSHADOW_IN,XmSHADOW_OUT,XmSHADOW_ETCHED_IN,XmSHADOW_ETCHED_OUT",
  True,True,True,False,
  "The style in which the shadows are drawn."
};
/*oodE*****************************************************/

XMDrawnButton::~XMDrawnButton()
{
	// Empty
}

XMDrawnButton::XMDrawnButton(Widget self, Widget parent)
{
  setParent(parent);
  setWidget(self);
  setVirtual(True);
  _numResources = 3;

  /* IF no pixmaps has been created */
  if(XMDrawnButton_pixmap == XmUNSPECIFIED_PIXMAP)
  { /* create a pixmap */ 
    if ( XpmCreatePixmapFromData ( XtDisplay(getWidget()), 
                                 DefaultRootWindow (XtDisplay(getWidget())),
                                 XMDrawnButton_xpm, 
                                 &XMDrawnButton_pixmap, NULL, NULL ) != 0 )
       XMDrawnButton_pixmap = XmUNSPECIFIED_PIXMAP;
  } /* create a pixmap */ 

  storeResources();
}

XMDrawnButton::XMDrawnButton(Widget parent,Arg* al,int ac)
{
  if(ac > 0)
    setXtArgs(al,ac);

  setParent(parent);
  createWidget(drawnbutton_v);
  _numResources = 3;

  /* IF no pixmaps has been created */
  if(XMDrawnButton_pixmap == XmUNSPECIFIED_PIXMAP)
  { /* create a pixmap */ 
    if ( XpmCreatePixmapFromData ( XtDisplay(getWidget()), 
                                 DefaultRootWindow (XtDisplay(getWidget())),
                                 XMDrawnButton_xpm, 
                                 &XMDrawnButton_pixmap, NULL, NULL ) != 0 )
       XMDrawnButton_pixmap = XmUNSPECIFIED_PIXMAP;
  } /* create a pixmap */ 

  /* get resources for this widget */
  storeResources();
}

Pixmap XMDrawnButton::getPixmap(void)
{
	return XMDrawnButton_pixmap;
}

res_rec * XMDrawnButton::getResources(void)
{
  return _resources;
}

int XMDrawnButton::getNumResources(void)      
{
  return _numResources;
}

void XMDrawnButton::storeResources(void)
{ /*  */ 

  res_rec * labelResources = XMLabel::getStaticResources();
  int labelNumResources = XMLabel::getNumStaticResources();
  res_rec * primitiveResources = XtPrimitive::getResources();
  int primitiveNumResources = XtPrimitive::getNumResources();

  int totalNumResources;

  totalNumResources = _numResources + 
                      labelNumResources + 
                      primitiveNumResources;

  _resources = (res_rec *)malloc(totalNumResources*sizeof(res_rec));
 
  memmove(_resources,_drawnButtonResources,_numResources*sizeof(res_rec));
  memmove(&_resources[_numResources],
          labelResources,labelNumResources*sizeof(res_rec));
  memmove(&_resources[_numResources+labelNumResources],
          primitiveResources,primitiveNumResources*sizeof(res_rec));
  _numResources = totalNumResources;
} /*  */ 
