/* ResEditor.C */

#include "ResEditor.h"
// Super Class : None

/*oodB%ResEditor*** Global Declarations and Stuffs ****/
#include "XtCore.h"
#ifdef NO_HELP
#include "DumbHelp.h"
#else
#include "Help.h"
#endif
/*oodE*************************************************/

ResEditor::ResEditor()
{
	// Empty
}

ResEditor::~ResEditor()
{
	// Empty
}

ResEditor::ResEditor(Widget parent, Guide * guide)
{
  _parent = parent;
  _guide = guide;
  _isDisplayed = False;
  _currentResList = NULL;
  _currentResNum = 0;
  _currentCoreResList = NULL;
  _currentCoreResNum = 0;
  createResEditor();
  generateColorDB();
  generateFontList();
}

void ResEditor::generateFontList(void)
{
  _numFonts = 0;

  _fontName[_numFonts++] = 
    XmStringCreate("-adobe-*-*-*-*-*-18-*-*-*-*-*-*-*",
                   XmFONTLIST_DEFAULT_TAG);
  _fontName[_numFonts++] = 
    XmStringCreate("-adobe-*-*-*-*-*-18-*-100-*-*-*-*-*",
                   XmFONTLIST_DEFAULT_TAG);
  _fontName[_numFonts++] = 
    XmStringCreate("-schumacher-*-*-*-*-*-18-*-100-*-*-*-*-*",
                   XmFONTLIST_DEFAULT_TAG);
  _fontName[_numFonts++] = 
    XmStringCreate("-bitstream-charter-*-*-*-*-18-*-100-*-*-*-*-*",
                   XmFONTLIST_DEFAULT_TAG);
  _fontName[_numFonts++] = 
    XmStringCreate("-bitstream-courier-*-*-*-*-18-*-100-*-*-*-*-*",
                   XmFONTLIST_DEFAULT_TAG);

}

void ResEditor::generateColorDB(void)
{
  char *ptr; 
  char name0[35], name1[35], name2[35];
  char *line;
  int     num, i;
  char *eof;
  char buffer[BUFSIZ];
  int x = 0;

  _numColors = 0;

  /* get the color database filename */
  ptr = XtResolvePathname(XtDisplay(_parent), 
                          NULL, 
                          "rgb.txt", 
                          NULL, 
                          NULL, 
                          NULL, 
                          0, 
                          NULL);

  ifstream * inStream = new ifstream(ptr);

  if (inStream == NULL){
    perror("Problems opening color database file rgb.txt");
  };
    
  inStream->getline(buffer,BUFSIZ);

  /* count the number of legal names in the rgb.txt file */
  while (!inStream->eof() && _numColors < MAX_COLORS)
  {
    line = buffer;
   
    x = _numColors;
    num = sscanf(line, "%*u%*u%*u%s%s%s", name0, name1, name2);
    if ( (num == 3) || (num == 2) ){
    } else if (num == 1) {
      _colorName[_numColors++] = XmStringCreate(name0,
                                                  XmFONTLIST_DEFAULT_TAG);
    };
     inStream->getline(buffer,BUFSIZ);
  };
  _numColors = x;
  delete inStream;
}

void ResEditor::createResEditor(void)
{
	Widget children[5];      /* Children to manage */
	Arg al[64];                    /* Arg List */
	register int ac = 0;           /* Arg Count */
	Widget widget1 = (Widget)NULL;
	Widget widget2 = (Widget)NULL;
	Widget widget3 = (Widget)NULL;
	Widget widget4 = (Widget)NULL;
	Widget widget6 = (Widget)NULL;
	Widget widget7 = (Widget)NULL;
	Widget widget13 = (Widget)NULL;
	Widget widget19 = (Widget)NULL;
	Widget widget23 = (Widget)NULL;
	Widget widget27 = (Widget)NULL;
	Widget widget28 = (Widget)NULL;

	XtSetArg(al[ac], XmNallowShellResize, FALSE); ac++;
	XtSetArg(al[ac], XmNminWidth, 500); ac++;
	XtSetArg(al[ac], XmNminHeight, 500); ac++;
	_resEditor = XtCreatePopupShell ( "ResEditor", topLevelShellWidgetClass, _parent, al, ac );
	ac = 0;
	XtSetArg(al[ac], XmNautoUnmanage, FALSE); ac++;
	widget1 = XmCreateForm ( _resEditor, "widget1", al, ac );
	ac = 0;
	widget2 = XmCreateMenuBar ( widget1, "widget2", al, ac );
	widget3 = XmCreateCascadeButton ( widget2, "widget3", al, ac );
	widget4 = XmCreatePulldownMenu ( widget2, "widget4", al, ac );
	_resCloseMenuButton = XmCreatePushButton ( widget4, "resCloseMenuButton", al, ac );
	widget6 = XmCreateCascadeButton ( widget2, "widget6", al, ac );
	widget7 = XmCreatePulldownMenu ( widget2, "widget7", al, ac );
	_resCoreMenuButton = XmCreatePushButton ( widget7, "resCoreMenuButton", al, ac );
	_resWidgeMenuButton = XmCreatePushButton ( widget7, "resWidgetMenuButton", al, ac );
	_resCloseButton = XmCreatePushButton ( widget1, "resCloseButton", al, ac );
	_resHelpButton = XmCreatePushButton ( widget1, "resHelpButton", al, ac );
	_resApplyButton = XmCreatePushButton ( widget1, "resApplyButton", al, ac );
	widget13 = XmCreateFrame ( widget1, "widget13", al, ac );
	_resForm = XmCreateForm ( widget13, "resForm", al, ac );
	XtSetArg(al[ac], XmNscrollingPolicy, XmAUTOMATIC); ac++;
	XtSetArg(al[ac], XmNscrollBarDisplayPolicy, XmSTATIC); ac++;
	XtSetArg(al[ac], XmNvisualPolicy, XmCONSTANT); ac++;
	_resCoreList = XmCreateScrolledList ( _resForm, "resCoreList", al, ac );
	ac = 0;
	XtSetArg(al[ac], XmNscrollBarDisplayPolicy, XmSTATIC); ac++;
        XtSetValues(_resCoreList,al,ac);
	ac = 0;
	_resSWCoreList = XtParent ( _resCoreList );

	xd_links [1] = _resSWCoreList;
	XtSetArg(al[ac], XmNscrollingPolicy, XmAUTOMATIC); ac++;
	XtSetArg(al[ac], XmNscrollBarDisplayPolicy, XmSTATIC); ac++;
	XtSetArg(al[ac], XmNvisualPolicy, XmCONSTANT); ac++;
	_resOptionList = XmCreateScrolledList ( _resForm, "resOptionList", al, ac );
	ac = 0;
	XtSetArg(al[ac], XmNscrollBarDisplayPolicy, XmSTATIC); ac++;
        XtSetValues(_resOptionList,al,ac);
	ac = 0;
	widget19 = XtParent ( _resOptionList );

	XtSetArg(al[ac], XmNscrollingPolicy, XmAUTOMATIC); ac++;
	XtSetArg(al[ac], XmNscrollBarDisplayPolicy, XmSTATIC); ac++;
	XtSetArg(al[ac], XmNeditMode, XmMULTI_LINE_EDIT); ac++;
	XtSetArg(al[ac], XmNwordWrap, TRUE); ac++;
	XtSetArg(al[ac], XmNvisualPolicy, XmCONSTANT); ac++;
	_resHelpText = XmCreateText ( _resForm, "resHelpText", al, ac );
	ac = 0;
        //	widget23 = XtParent ( _resHelpText );

	widget27 = XmCreateForm ( _resForm, "widget27", al, ac );
	widget28 = XmCreateLabel ( widget27, "widget28", al, ac );
	_resValueText = XmCreateText ( widget27, "resValueText", al, ac );
	XtSetArg(al[ac], XmNscrollingPolicy, XmAUTOMATIC); ac++;
	XtSetArg(al[ac], XmNscrollBarDisplayPolicy, XmSTATIC); ac++;
	XtSetArg(al[ac], XmNvisualPolicy, XmCONSTANT); ac++;
	_resWidgetList = XmCreateScrolledList ( _resForm, "resWidgetList", al, ac );
	ac = 0;
	XtSetArg(al[ac], XmNscrollBarDisplayPolicy, XmSTATIC); ac++;
        XtSetValues(_resWidgetList,al,ac);
	ac = 0;
	_resSWWidgetList = XtParent ( _resWidgetList );

	xd_links [0] = _resSWWidgetList;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetValues ( widget2,al, ac );
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNleftPosition, 40); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 50); ac++;
	XtSetValues ( _resCloseButton,al, ac );
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNleftPosition, 60); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 70); ac++;
	XtSetValues ( _resHelpButton,al, ac );
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNleftPosition, 20); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 30); ac++;
	XtSetValues ( _resApplyButton,al, ac );
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, widget2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNbottomOffset, 10); ac++;
	XtSetArg(al[ac], XmNbottomWidget, _resCloseButton); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetValues ( widget13,al, ac );
	ac = 0;
	children[ac++] = _resCloseMenuButton;
	XtManageChildren(children, ac);
	ac = 0;
	XtSetArg(al[ac], XmNsubMenuId, widget4); ac++;
	XtSetValues ( widget3, al, ac );
	ac = 0;
	XtAddCallback (_resCoreMenuButton,XmNactivateCallback, ResEditor::unmap_link, (XtPointer) &xd_links[0] );
	XtAddCallback (_resCoreMenuButton,XmNactivateCallback, ResEditor::map_link, (XtPointer) &xd_links[1] );
	XtAddCallback (_resWidgeMenuButton,XmNactivateCallback, ResEditor::unmap_link, (XtPointer) &xd_links[1] );
	XtAddCallback (_resWidgeMenuButton,XmNactivateCallback, ResEditor::map_link, (XtPointer) &xd_links[0] );
	children[ac++] = _resCoreMenuButton;
	children[ac++] = _resWidgeMenuButton;
	XtManageChildren(children, ac);
	ac = 0;
	XtSetArg(al[ac], XmNsubMenuId, widget7); ac++;
	XtSetValues ( widget6, al, ac );
	ac = 0;
	children[ac++] = widget3;
	children[ac++] = widget6;
	XtManageChildren(children, ac);
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNbottomWidget, widget27); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNrightWidget, widget19); ac++;
	XtSetValues ( _resSWCoreList,al, ac );
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNbottomPosition, 50); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNleftPosition, 50); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetValues ( widget19,al, ac );
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, widget19); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNbottomWidget, widget27); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, widget19); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetValues (_resHelpText,al, ac );
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetValues ( widget27,al, ac );
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNbottomWidget, widget27); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNrightWidget, widget19); ac++;
	XtSetValues ( _resSWWidgetList,al, ac );
	ac = 0;
	XtManageChild(_resCoreList);
	XtManageChild(_resOptionList);
	XtManageChild(_resHelpText);

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetValues ( widget28,al, ac );
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, widget28); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( _resValueText,al, ac );
	ac = 0;
	children[ac++] = widget28;
	children[ac++] = _resValueText;
	XtManageChildren(children, ac);
	ac = 0;
	XtManageChild(_resWidgetList);
	children[ac++] = widget27;
	XtManageChildren(children, ac);
	ac = 0;
	children[ac++] = _resForm;
	XtManageChildren(children, ac);
	ac = 0;
	children[ac++] = widget2;
	children[ac++] = _resCloseButton;
	children[ac++] = _resHelpButton;
	children[ac++] = _resApplyButton;
	children[ac++] = widget13;
	XtManageChildren(children, ac);
	ac = 0;
	XtManageChild ( widget1);
        XtAddCallback(_resHelpButton,XmNactivateCallback,ResEditor::helpCB,this);
        XtAddCallback(_resCloseButton,XmNactivateCallback,ResEditor::closeCB,this);
        XtAddCallback(_resApplyButton,XmNactivateCallback,ResEditor::applyCB,this);
        XtAddCallback(_resCloseMenuButton,XmNactivateCallback,ResEditor::closeCB,this);
        XtAddCallback(_resWidgetList,XmNbrowseSelectionCallback,ResEditor::selectResourceCB,this);
        XtAddCallback(_resCoreList,XmNbrowseSelectionCallback,ResEditor::selectResourceCB,this);
        XtAddCallback(_resOptionList,XmNbrowseSelectionCallback,ResEditor::selectOptionCB,this);

}

void ResEditor::update(void)
{
  updateWidgetResources();
  updateCoreResources();
}

void ResEditor::updateWidgetResources(void)
{
  int i;
  int j = 0;
  XmString xmstr[100];
  XtCore * selectedWidget = _guide->getSelectedWidget();

  if((selectedWidget) && (_isDisplayed))
  { /* valid widget and displayed interface*/
    _currentResNum = selectedWidget->getNumResources();
    _currentResList = selectedWidget->getResources();
cout << "_currentResNum = " << _currentResNum << endl;

    /* for each resource found */
    for(i=0;i<_currentResNum;i++)
    { /* each resource */ 

        xmstr[i] = XmStringCreate(_currentResList[i].resource_name,
                                  XmFONTLIST_DEFAULT_TAG);
    } /* each resource */  

     XmListDeleteAllItems(_resWidgetList);
     XmListAddItems(_resWidgetList,xmstr,_currentResNum,1);

    for(i=0;i<_currentResNum;i++)
      XmStringFree(xmstr[i]);
  } /* valid widget and displayed interface*/ 
}

void ResEditor::updateCoreResources(void)
{
  int i;
  XmString xmstr[100];
  XtCore * selectedWidget = _guide->getSelectedWidget();

  if((selectedWidget) && (_isDisplayed))
  { /* valid widget and displayed interface*/
    _currentCoreResNum = selectedWidget->getNumCoreResources();
    _currentCoreResList = selectedWidget->getCoreResources();
cout << "_currentCoreResNum = " << _currentCoreResNum << endl;
    for(i=0;i<_currentCoreResNum;i++)
      xmstr[i] = XmStringCreate(_currentCoreResList[i].resource_name,
                                XmFONTLIST_DEFAULT_TAG);

    XmListDeleteAllItems(_resCoreList);
    XmListAddItems(_resCoreList,xmstr,_currentCoreResNum,1);

    for(i=0;i<_currentCoreResNum;i++)
      XmStringFree(xmstr[i]);
  } /* valid widget and displayed interface*/
} 

void ResEditor::map_link (Widget w, XtPointer client_data, XtPointer call_data)
{
	if ( client_data && *(Widget *)client_data )
    XtMapWidget (*(Widget *)client_data);
}

void ResEditor::unmap_link (Widget w, XtPointer client_data, XtPointer call_data)
{
   if ( client_data && *(Widget *)client_data )
   { /*  */ 
    XtUnmapWidget (*(Widget *)client_data);
   } /*  */ 
}

void ResEditor::closeCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  ResEditor *RE = (ResEditor *) client_data;
  RE->popdown();
}

void ResEditor::helpCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  ResEditor *RE = (ResEditor *) client_data;
  RE->help();
}
void ResEditor::applyCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  ResEditor *RE = (ResEditor *) client_data;
  RE->apply();
}

void ResEditor::popup(void)
{
  XtPopup(_resEditor,XtGrabNone);
  _isDisplayed = True;
  update();
}

void ResEditor::popdown(void)
{
  XtPopdown(_resEditor);
  _isDisplayed = False;
}

void ResEditor::help(void)
{
#ifdef NO_HELP
  new DumbHelp("html/resource.html",_parent);
#else
  new Help("html/resource.html",_parent);
#endif
}

void ResEditor::apply(void)
{
  char * text;
  text = XmTextGetString(_resValueText);
  cout << "Apply called " << endl;
  _currentItem->modified = True;
  XtCore * selectedWidget = _guide->getSelectedWidget();


  if(strlen(text)== 0)
  { /*  */ 
    strcpy(_currentItem->resource_value,_currentItem->resource_default);
    _currentItem->modified = False;
  } /*  */
  else
  { /*  */ 
    if(strcmp(_currentItem->resource_default,text)==0)
      _currentItem->modified = False;
    
    strcpy(_currentItem->resource_value,text);
  } /*  */
 
  /* update widget with new resouuurce value if possible */
  selectedWidget->setResource(_currentItem);
  XtFree(text);
}

void ResEditor::updateSelection(void)
{
  // empty
}

void ResEditor::addOptions(char * options)
{
  int i = 0;
  int j = 0;
  char * token = NULL;
  char temp[BUFSIZ];
  XmString xmstr[15];

  strcpy(temp,options);

  token = strtok(temp,",");

  while( token != NULL)
  { /*  */ 
    xmstr[i++] = XmStringCreate(token,XmFONTLIST_DEFAULT_TAG);
    token = strtok(NULL,",");
  } /*  */ 

  XmListAddItems(_resOptionList,xmstr,i,1);

  for(j=0;j<i;j++)
    XmStringFree(xmstr[j]);
}

void ResEditor::selectCoreResource(int item)
{
  _currentItem = &_currentCoreResList[item-1];
  XmListDeleteAllItems(_resOptionList);

  if(_currentCoreResNum > 0)
  { /*  */ 

    if(strcmp(_currentCoreResList[item-1].resource_options,"NONE")!=0)
    { /*  */ 
      addOptions(_currentCoreResList[item-1].resource_options);
    } /*  */ 
    if(strcmp(_currentItem->resource_type,"Pixel")==0)
    { /*  */ 
      addColorOptions();
    } /*  */ 
    if(strcmp(_currentItem->resource_type,"XmFontList")==0)
    { /*  */ 
      addFontOptions();
    } /*  */ 
    XmTextSetString(_resValueText,_currentItem->resource_value);
    XmTextSetString(_resHelpText,_currentItem->help);
  } /*  */ 
}

void ResEditor::selectWidgetResource(int item)
{
  _currentItem = &_currentResList[item-1];
  XmListDeleteAllItems(_resOptionList);

  if(_currentResNum > 0)
  { /*  */ 

    if(strcmp(_currentItem->resource_options,"NONE")!=0)
    { /*  */ 
      addOptions(_currentItem->resource_options);
    } /*  */
    if(strcmp(_currentItem->resource_type,"Pixel")==0)
    { /*  */ 
      addColorOptions();
    } /*  */ 
    if(strcmp(_currentItem->resource_type,"XmFontList")==0)
    { /*  */ 
      addFontOptions();
    } /*  */ 
    XmTextSetString(_resValueText,_currentItem->resource_value);
    XmTextSetString(_resHelpText,_currentItem->help);
  } /*  */ 
}

void ResEditor::addColorOptions(void)
{   
  XmListAddItems(_resOptionList,_colorName,_numColors,1);
}

void ResEditor::addFontOptions(void)
{
  XmListAddItems(_resOptionList,_fontName,_numFonts,1);
}

void ResEditor::selectResourceCB(Widget w, XtPointer client, XtPointer call)
{
  XmListCallbackStruct *cbs = ( XmListCallbackStruct *) call;
  ResEditor *ed = (ResEditor *) client;

  if(cbs->reason == XmCR_BROWSE_SELECT)
    cout << "Browse selection" << endl;
  else
    cout << "DefaultSelection" << endl;

  if(w == ed->getWidgetResourceList())
    ed->selectWidgetResource((int)cbs->item_position);
  else
    ed->selectCoreResource((int)cbs->item_position);
}

void ResEditor::selectOption(XmString item)
{
  char * text;
  XmStringGetLtoR(item,XmFONTLIST_DEFAULT_TAG,&text);
  XmTextSetString(_resValueText,text);
  XtFree(text);
}

Widget ResEditor::getWidgetResourceList(void)
{ /*  */ 
  return _resWidgetList;
} /*  */ 

void ResEditor::selectOptionCB(Widget w, XtPointer client, XtPointer call)
{
  XmListCallbackStruct *cbs = ( XmListCallbackStruct *) call;
  ResEditor *ed = (ResEditor *) client;

  if(cbs->reason == XmCR_BROWSE_SELECT)
    cout << "Browse selection" << endl;
  else
    cout << "DefaultSelection" << endl;

  ed->selectOption(cbs->item);
}

