/* Interface.C */

#include "Interface.h"
// Super Class : None

/*oodB%Interface*** Global Declarations and Stuffs ****/
#include "XtCore.h"
/*oodE*************************************************/

Interface::~Interface()
{
  if(debug_set)
    cout << "Interface Destructor called for " << _name << endl;
  delete _top;
}

Interface::Interface(XtCore * top)
{
        _top = top;
        _name = _top->getWidName();
        _x = 0;
        _y = 0;
}

XtCore * Interface::getTop(void)
{
  return _top;
}

int Interface::getX(void)
{ 
  return _x;
} 

int Interface::getY(void)
{ 
  return _y;
} 

void Interface::setX(int x)
{
  _x = x;
} 

void Interface::setY(int y)
{
  _y = y;
}

String Interface::getName(void)
{
  return _name;
}

void Interface::drawInterface(GC gc,Widget w)
{
  XCopyArea(XtDisplay(w), _top->getLargePixmap(), XtWindow(w),
            gc,0,0,56,46,
            getX(), getY());
}

void Interface::saveChildren(ofstream *outfile,int tab)
{
  if(debug_set)
    cout << "Interface::saveChildren called for " << _name << endl;

  *outfile << "Interface:" << _name << endl << "{" << endl;

  _top->saveChildren(outfile,tab+1);

  *outfile << "}" << endl;
}

void Interface::manageAll(void)
{
  _top->manageChildren();
}

void Interface::codeExterns(ofstream *outfile)
{
  _top->codeExterns(outfile);
}

void Interface::codeIncludes(ofstream *outfile)
{
  _top->codeIncludes(outfile);
}

void Interface::codeXResources(ofstream *outfile)
{
  _top->codeXResources(outfile);
}

void Interface::codeChildren(ofstream *outfile,int tab)
{
  if(debug_set)
    cout << "Interface::codeChildren called for " << _name << endl;

  _top->codeGlobalDeclarations(outfile);

  switch(_top->getType())
  { /*  */ 
    case applicationshell_v:
      *outfile << "Widget create" << _top->getCreationFunctionName()
               << "(int argc, char ** argv, Display * display)" << endl;
      *outfile << "{ /* " << " */" << endl;
      *outfile << "  Arg al[" << MAX_ARGS << "];" << endl;
      *outfile << "  int ac = 0;" << endl;
      *outfile << "  XrmValue from_value, to_value;" << endl;
      *outfile << "  XmString xmstr[" << MAX_STRINGS << "];" << endl;
      _top->codeLocalDeclarations(outfile);
      _top->codeChildren(outfile,tab);
      *outfile << "  return " << _top->getVarName() << ";" << endl;
      *outfile << "} /* " << " */" << endl;
       break;
    case toplevelshell_v:
      *outfile << "Widget create" << _top->getCreationFunctionName() 
               << "(Widget parent)" << endl;
      *outfile << "{ /* " << " */" << endl;
      *outfile << "  Arg al[" << MAX_ARGS << "];" << endl;
      *outfile << "  int ac = 0;" << endl;
      *outfile << "  XrmValue from_value, to_value;" << endl;
      *outfile << "  XmString xmstr[" << MAX_STRINGS << "];" << endl;
      _top->codeLocalDeclarations(outfile);
      _top->codeChildren(outfile,tab);
      *outfile << "  return " << _top->getVarName() << ";" << endl;
      *outfile << "} /* " << " */" << endl;
       break;
    default:
      *outfile << "Widget create" << _top->getCreationFunctionName()
               << "(Widget parent)" << endl;
      *outfile << "{ /* " << " */" << endl;
      *outfile << "  Arg al[" << MAX_ARGS << "];" << endl;
      *outfile << "  int ac = 0;" << endl;
      *outfile << "  XrmValue from_value, to_value;" << endl;
      *outfile << "  XmString xmstr[" << MAX_STRINGS << "];" << endl;
      _top->codeLocalDeclarations(outfile);
      _top->codeChildren(outfile,tab);
      *outfile << "  return " << _top->getVarName() << ";" << endl;
      *outfile << "} /* " << " */" << endl;
      break;
  } /*  */ 
}

void Interface::codeCreateExterns(ofstream *outfile)
{
  *outfile << "extern Widget create" << _top->getCreationFunctionName();
  switch(_top->getType())
  { /*  */ 
    case applicationshell_v:
      *outfile << "(int argc, char ** argv, Display * display);" << endl;
      break;
    case toplevelshell_v:
      *outfile << "(Widget parent);" << endl;
       break;
    default:
      *outfile << "(Widget parent);" << endl;
       break;
  }
}
