/* IFileReader.C */

#include "IFileReader.h"
// Super Class : None

/*oodB%IFileReader*** Global Declarations and Stuffs ****/
#include "Guide.h"
#include "DesignEditor.h"
/*oodE***************************************************/

IFileReader::~IFileReader()
{
	// Empty
}

void IFileReader::readFile(String filename)
{
  _inStream = new ifstream((char *)filename.data());

  if(_inStream)
    readStart();
  else
    cout << "Error reading file " << _filename << endl;

  delete _inStream;
}

IFileReader::IFileReader(Guide * guide)
{
  _guide = guide;
  _designEditor = _guide->getDesignEditor();
}

void IFileReader::readLine(void)
{
  char buffer[BUFSIZ];
  _inStream->getline(buffer,BUFSIZ);
  
  _line = buffer;
}

void IFileReader::readStart(void)
{
  readLine();

  while(!_line.empty())
  { /*  */ 
    if(debug_set)
      cout << "readStart:" << _line << endl;
    
    if(_line.compare("Interface")==0)
      readInterface();
    else
      readOther();
    readLine();
  } /*  */ 
}

void IFileReader::readInterface(void)
{

  // read the first line after the "Interface" key word
  // this should be an open bracket
  readLine();

  while(!_line.find("}"))
  { /*  */ 
    if(debug_set)
      cout << "readInterface:" << _line << endl;

    if(_line.compare("Object"))
      readObject();

    readLine();
  } /*  */ 
}

void IFileReader::readObject(void)
{
  static int recurse = 0;
  recurse++;
  String type;
  String temp;
  int wtype;
  XtCore * currentWidget = NULL;

  temp = _line[_line.find_first_of(':')];
  type = temp[temp.find_last_of(':')];
  wtype = atoi((char *)type.data());
  temp = temp[temp.find_first_of(':')];

  _designEditor->createWidget(NULL,(widget_type_enum) wtype, True);
  currentWidget = _designEditor->getCurrentWidget();

  // read the first line after the "Object" key word
  // this should be an open bracket
  readLine();

  while(!_line.find("}"))
  { /*  */ 

    if(_line.compare("Resources")==0)
      readResources();
    
    if(_line.compare("Object")==0)
      readObject();

    if(_line.compare("Attachments:")==0)
      readAttachments();

    _guide->setSelectedWidget(currentWidget);
    
    readLine();
  } /*  */ 
  recurse--;
}

void IFileReader::readResources(void)
{
  XtCore * selW = _designEditor->getCurrentWidget();
  res_rec resource;
  String name;
  String value;

  while(!_line.find("}"))
  { /*  */ 

    if(debug_set)
      cout << "readResources:" << _line << endl;
    name = _line[_line.find_first_of(':')-1];

    /* use a regex to remove blank spaces in the name */
    //name.del(RXwhite);
    value = _line[_line.find_first_of(':')+1];

    strcpy(resource.resource_name,name.data());
    strcpy(resource.resource_value,value.data());

    selW->updateResource(&resource);

    readLine();
  } /*  */ 
}

void IFileReader::readOther(void)
{
  readLine();

  while(!_line.empty())
  { /*  */ 
    if(debug_set)
      cout << "readOther:" << _line << endl;

    readLine();
  } /*  */ 
}

void IFileReader::readAttachments(void)
{
  readLine();

  while(!_line.find("}"))
  { /*  */ 
    if(debug_set)
      cout << "readAttachments:" << _line << endl;

    if(_line.compare("Attachment:"))
       readAttachment();

    readLine();
  } /*  */ 
}

void IFileReader::readAttachment(void)
{
  readLine();

  while(!_line.find("}"))
  { /*  */ 

    if(debug_set)
      cout << "readAttachment:" << _line << endl;

    readLine();
  } /*  */ 
}
