/* Guide.C */

#include "Guide.h"
// Super Class : None

/*oodB%Guide*** Global Declarations and Stuffs ****/
#include "Exception.h"
#include "Information.h"
#ifdef NO_HELP
#include "DumbHelp.h"
#else
#include "Help.h"
#endif
#include "ConstraintEditor.h"
#include "OptionEditor.h"
#include "ResEditor.h"
#include "DesignEditor.h"
#include "Interface.h"
#include "IFileReader.h"
/*oodE*********************************************/

Guide::Guide()
{
	// Empty
}

Guide::~Guide()
{
  delete _resEditor;
  delete _designEditor;
  delete _optionEditor;
  delete _constraintEditor;
  delete _iFileReader;

  if(debug_set)
    cout << "Destructor for Guide called " << endl;
}

void Guide::menuCB(Widget,XtPointer client_data,XtPointer)
{
#ifdef NO_HELP
  DumbHelp *h;
#else
  Help *h;
#endif
  Exception *e;

  menu_rec *menu = (menu_rec *)client_data;
  Guide * g = menu->this_ptr;
  switch(menu->menu)
  { /*  */ 
    case MENU_FILE_EXIT:
//       e = new Information("Exit Callback called");
//       throw e;
      exit(0);
      break;
    case MENU_FILE_NEW:
    case MENU_FILE_OPEN:
    case MENU_FILE_ADD:
    case MENU_FILE_SAVE:
    case MENU_FILE_SAVE_AS:
    case MENU_FILE_SAVE_SEPERATE:
      g->fileOps(menu->menu);
      break;
    case MENU_EDIT_UNDO:
      break;
    case MENU_EDIT_CUT:
      break;
    case MENU_EDIT_COPY:
      break;
    case MENU_EDIT_PASTE:
    break;
    case MENU_EDITOR_DESIGN:
    case MENU_EDITOR_CONSTRAINT:
    case MENU_EDITOR_RESOURCE:
    case MENU_EDITOR_OPTION:
      g->popupTool(menu->menu);
      break;
    case MENU_CODE_C:
    case MENU_CODE_H:
    case MENU_CODE_X:
      g->generateCode(menu->menu);
      break;
    case MENU_HELP_WINDOW:
#ifdef NO_HELP
      h = new DumbHelp("html/main_window.html",menu->shell);
#else
      h = new Help("html/main_window.html",menu->shell);
#endif
    break;
    case MENU_HELP_VERSION:
#ifdef NO_HELP
      h = new DumbHelp("html/version.html",menu->shell,600,300);
#else
      h = new Help("html/version.html",menu->shell,600,300);
#endif
    break;
  } /*  */
}

void Guide::addCallbacks(void)
{
  menu_rec *menu;

  menu = new menu_rec;
  menu->shell = _guide;
  menu->this_ptr = this;
  menu->menu = MENU_FILE_EXIT;
  XtAddCallback(_menu_file_exit,
                XmNactivateCallback,
                Guide::menuCB,  
                (XtPointer) menu);  

  menu = new menu_rec;
  menu->shell = _guide;
  menu->this_ptr = this;
  menu->menu = MENU_HELP_WINDOW;
  XtAddCallback(_menu_help_window,   
                XmNactivateCallback,
                Guide::menuCB,      
                (XtPointer) menu); 

  menu = new menu_rec;
  menu->shell = _guide;
  menu->this_ptr = this;
  menu->menu = MENU_HELP_VERSION;
  XtAddCallback(_menu_help_version,  
                XmNactivateCallback, 
                Guide::menuCB,       
                (XtPointer) menu);

  menu = new menu_rec;
  menu->shell = _guide;
  menu->this_ptr = this;
  menu->menu = MENU_FILE_NEW;
  XtAddCallback(_menu_file_new,  
                XmNactivateCallback, 
                Guide::menuCB,       
                (XtPointer) menu);

  menu = new menu_rec;
  menu->shell = _guide;
  menu->this_ptr = this;
  menu->menu = MENU_FILE_OPEN;
  XtAddCallback(_menu_file_open,  
                XmNactivateCallback, 
                Guide::menuCB,       
                (XtPointer) menu);

  menu = new menu_rec;
  menu->shell = _guide;
  menu->this_ptr = this;
  menu->menu = MENU_FILE_SAVE;
  XtAddCallback(_menu_file_save,  
                XmNactivateCallback, 
                Guide::menuCB,       
                (XtPointer) menu);

  menu = new menu_rec;
  menu->shell = _guide;
  menu->this_ptr = this;
  menu->menu = MENU_FILE_SAVE_SEPERATE;
  XtAddCallback(_menu_file_save_seperate,  
                XmNactivateCallback, 
                Guide::menuCB,       
                (XtPointer) menu);

  menu = new menu_rec;
  menu->shell = _guide;
  menu->this_ptr = this;
  menu->menu = MENU_FILE_ADD;
  XtAddCallback(_menu_file_add,  
                XmNactivateCallback, 
                Guide::menuCB,       
                (XtPointer) menu);

  menu = new menu_rec;
  menu->shell = _guide;
  menu->this_ptr = this;
  menu->menu = MENU_FILE_SAVE_AS;
  XtAddCallback(_menu_file_save_as,  
                XmNactivateCallback, 
                Guide::menuCB,       
                (XtPointer) menu);

  menu = new menu_rec;
  menu->shell = _guide;
  menu->this_ptr = this;
  menu->menu = MENU_EDITOR_DESIGN;
  XtAddCallback(_menu_editors_design,  
                XmNactivateCallback, 
                Guide::menuCB,       
                (XtPointer) menu);

  menu = new menu_rec;
  menu->shell = _guide;
  menu->this_ptr = this;
  menu->menu = MENU_EDITOR_CONSTRAINT;
  XtAddCallback(_menu_editors_constraint,  
                XmNactivateCallback, 
                Guide::menuCB,       
                (XtPointer) menu);

  menu = new menu_rec;
  menu->shell = _guide;
  menu->this_ptr = this;
  menu->menu = MENU_EDITOR_RESOURCE;
  XtAddCallback(_menu_editors_resource,  
                XmNactivateCallback, 
                Guide::menuCB,       
                (XtPointer) menu);

  menu = new menu_rec;
  menu->shell = _guide;
  menu->this_ptr = this;
  menu->menu = MENU_EDITOR_OPTION;
  XtAddCallback(_menu_editors_option,  
                XmNactivateCallback, 
                Guide::menuCB,       
                (XtPointer) menu);

  menu = new menu_rec;
  menu->shell = _guide;
  menu->this_ptr = this;
  menu->menu = MENU_CODE_C;
  XtAddCallback(_menu_code_generate,  
                XmNactivateCallback, 
                Guide::menuCB,       
                (XtPointer) menu);

  menu = new menu_rec;
  menu->shell = _guide;
  menu->this_ptr = this;
  menu->menu = MENU_CODE_H;
  XtAddCallback(_menu_code_externs,  
                XmNactivateCallback, 
                Guide::menuCB,       
                (XtPointer) menu);

  menu = new menu_rec;
  menu->shell = _guide;
  menu->this_ptr = this;
  menu->menu = MENU_CODE_X;
  XtAddCallback(_menu_code_xresource,  
                XmNactivateCallback, 
                Guide::menuCB,       
                (XtPointer) menu);
}

void Guide::addEvents(void)
{
	// Empty
}

void Guide::generateCode(int type)
{
  /*  */  
  switch(type)
  { /*  */ 
    case MENU_CODE_C:
      generateCCode();
      cout << "MENU_CODE_C Button pressed" << endl;
      break;
    case MENU_CODE_H:
      generateHCode();
      cout << "MENU_CODE_H Button pressed" << endl;
      break;
    case MENU_CODE_X:
      generateXCode();
      cout << "MENU_CODE_X Button pressed" << endl;
      break;
  } /*  */
}

void Guide::popupTool(int type)
{
 /*  */   switch(type)
  { /*  */ 
    case MENU_EDITOR_DESIGN:
      _designEditor->popup();
      cout << "MENU_EDITOR_DESIGN Button pressed" << endl;
      break;
    case MENU_EDITOR_CONSTRAINT:
      _constraintEditor->popup();
      cout << "MENU_EDITOR_CONSTRAINT Button pressed" << endl;
      break;
    case MENU_EDITOR_RESOURCE:
      _resEditor->popup();
      cout << "MENU_EDITOR_RESOURCE Button pressed" << endl;
      break;
    case MENU_EDITOR_OPTION:
      _optionEditor->popup();
      cout << "MENU_EDITOR_OPTION Button pressed" << endl;
      break;
  } /*  */
}

void Guide::fileOps(int type)
{
 /*  */   switch(type)
  { /*  */ 
    case MENU_FILE_NEW:
      cout << "MENU_FILE_NEW Button pressed" << endl;
      deleteInterfaces();
      break;
    case MENU_FILE_ADD:
      cout << "MENU_FILE_ADD Button pressed" << endl;
      _openOp = MENU_FILE_ADD;
      XtManageChild(_xd_links[0]);
      break;
    case MENU_FILE_SAVE_SEPERATE:
      cout << "MENU_FILE_SAVE_SEPERATE Button pressed" << endl;
      _openOp = MENU_FILE_SAVE_SEPERATE;
      XtManageChild(_xd_links[1]);
      break;
    case MENU_FILE_OPEN:
      cout << "MENU_FILE_OPEN Button pressed" << endl;
      _openOp = MENU_FILE_OPEN;
      XtManageChild(_xd_links[0]);
      break;
    case MENU_FILE_SAVE:
      cout << "MENU_FILE_SAVE Button pressed" << endl;
      if(_filename.compare("Undefined.int"))
        XtManageChild(_xd_links[1]);
      else
        save();
      break;
    case MENU_FILE_SAVE_AS:
      cout << "MENU_FILE_SAVE_AS Button pressed" << endl;
      XtManageChild(_xd_links[1]);
      break;
  } /*  */
}

Guide::Guide(int argc,char** argv)
{
  _argc = argc;
  _argv = argv;
  _selectedInterface = NULL;
  _selectedWidget = NULL;
  _filename = "Undefined.int";
  _interfaces = getProjectPath() + "interfaces.c";
  _interface = getProjectPath() + "creation.c";
  _makefile = getProjectPath() + "makefile";
  _externs = getProjectPath() + "interfaces.h";
  _callbacks = getProjectPath() + "callbacks.c";
  _events = getProjectPath() + "events.c";
  _main_c = getProjectPath() + "main.c";
  _public_h = getProjectPath() + "public.h";

  XtSetLanguageProc ( (XtAppContext) NULL, 
                      (XtLanguageProc) NULL,
                      (XtPointer) NULL );
  XtToolkitInitialize ();
  _app_context = XtCreateApplicationContext ();
  _display = XtOpenDisplay (_app_context, 
                           NULL, 
                           argv[0],
                           "XGuide",
                           NULL, 
                           0, 
                           &argc,
                           argv);
  if (!_display)
  {
    printf("%s: can't open display, exiting...", argv[0]);
    exit (-1);
  }
}

void Guide::createColorMap()
{
  _colorMap = XCreateColormap(_display,
                RootWindow(_display,DefaultScreen(_display)),
                DefaultVisual(_display,DefaultScreen(_display)),AllocNone);

  if(_colorMap ==(Colormap) None)
  {
    cout << "Error creating colormap" << endl;
    exit(1);
  }
}

void Guide::init(void)
{
	// Empty
}

void Guide::createMainMenu(void)
{
  Arg al[64];
  XrmValue from_value, to_value;
  XmString xmstr;
  Pixmap new_pixmap = XmUNSPECIFIED_PIXMAP;
  int xpm_return;
  register int ac = 0;

  Widget XmPulldownMenu_7= (Widget) NULL;
  Widget XmPulldownMenu_6= (Widget) NULL;
  Widget XmPulldownMenu_17= (Widget) NULL;
  Widget XmPulldownMenu_22= (Widget) NULL;
  Widget XmPulldownMenu_28= (Widget) NULL;
  Widget XmFrame_31= (Widget) NULL;
  Widget XmForm_32= (Widget) NULL;

  //createColorMap();
  //XtSetArg(al[ac], XmNcolormap,_colorMap);ac++;
  //XtSetArg(al[ac], XmNdepth,8);ac++;
  //XtSetArg(al[ac], XmNvisual,DefaultVisual(_display,DefaultScreen(_display)));ac++;
  XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
  XtSetArg(al[ac], XmNargc, _argc); ac++;
  XtSetArg(al[ac], XmNargv, _argv); ac++;
  _guide = XtAppCreateShell ( "Graphical User Interface Design Entity - MOTIF GUIDE",
                          "XGuide",
                          applicationShellWidgetClass,
                          _display, al, ac );
  ac = 0;
  _main_form = 
    XmCreateForm(_guide, "MainForm", al, ac);
  XtManageChild (_main_form);
  ac = 0;
  _menu_bar = 
    XmCreateMenuBar(_main_form, "MenuBar", al, ac);
  XtManageChild (_menu_bar);
  ac = 0;
  _menu_file = 
    XmCreateCascadeButton(_menu_bar, "File", al, ac);
  XtManageChild (_menu_file);
  ac = 0;
  XmPulldownMenu_7 = 
    XmCreatePulldownMenu(_menu_file, "XmPulldownMenu_7", al, ac);
  ac = 0;
  XtSetArg(al[ac], XmNsubMenuId,XmPulldownMenu_7);ac++;
  XtSetValues(_menu_file,al,ac);
  ac = 0;
  _menu_file_new = 
    XmCreatePushButton(XmPulldownMenu_7, "New", al, ac);
  XtManageChild (_menu_file_new);
  ac = 0;
  _menu_file_open = 
    XmCreatePushButton(XmPulldownMenu_7, "Open", al, ac);
  XtManageChild (_menu_file_open);
  ac = 0;
  _menu_file_add = 
    XmCreatePushButton(XmPulldownMenu_7, "Add", al, ac);
  XtManageChild (_menu_file_add);
  ac = 0;
  _menu_file_save = 
    XmCreatePushButton(XmPulldownMenu_7, "Save", al, ac);
  XtManageChild (_menu_file_save);
  ac = 0;
  _menu_file_save_as = 
    XmCreatePushButton(XmPulldownMenu_7, "SaveAs", al, ac);
  XtManageChild (_menu_file_save_as);
  ac = 0;
  _menu_file_save_seperate = 
    XmCreatePushButton(XmPulldownMenu_7, "Save Seperate", al, ac);
  XtManageChild (_menu_file_save_seperate);
  ac = 0;
  _menu_file_exit = 
    XmCreatePushButton(XmPulldownMenu_7, "Exit", al, ac);
  XtManageChild (_menu_file_exit);
  ac = 0;
  _menu_edit = 
    XmCreateCascadeButton(_menu_bar, "Edit", al, ac);
  XtManageChild (_menu_edit);
  ac = 0;
  XmPulldownMenu_6 = 
    XmCreatePulldownMenu(_menu_edit, "XmPulldownMenu_6", al, ac);
  ac = 0;
  XtSetArg(al[ac], XmNsubMenuId,XmPulldownMenu_6);ac++;
  XtSetValues(_menu_edit,al,ac);
  ac = 0;
  _menu_edit_undo = 
    XmCreatePushButton(XmPulldownMenu_6, "Undo", al, ac);
  XtManageChild (_menu_edit_undo);
  ac = 0;
  _menu_edit_cut = 
    XmCreatePushButton(XmPulldownMenu_6, "Cut", al, ac);
  XtManageChild (_menu_edit_cut);
  ac = 0;
  _menu_edit_copy = 
    XmCreatePushButton(XmPulldownMenu_6, "Copy", al, ac);
  XtManageChild (_menu_edit_copy);
  ac = 0;
  _menu_edit_paste = 
    XmCreatePushButton(XmPulldownMenu_6, "Paste", al, ac);
  XtManageChild (_menu_edit_paste);
  ac = 0;
  _menu_editors = 
    XmCreateCascadeButton(_menu_bar, "Editors", al, ac);
  XtManageChild (_menu_editors);
  ac = 0;
  XmPulldownMenu_17 = 
    XmCreatePulldownMenu(_menu_editors, "XmPulldownMenu_17", al, ac);
  ac = 0;
  XtSetArg(al[ac], XmNsubMenuId,XmPulldownMenu_17);ac++;
  XtSetValues(_menu_editors,al,ac);
  ac = 0;
  _menu_editors_design = 
    XmCreatePushButton(XmPulldownMenu_17, "DesignEditor", al, ac);
  XtManageChild (_menu_editors_design);
  ac = 0;
  _menu_editors_constraint = 
    XmCreatePushButton(XmPulldownMenu_17, "ConstraintEditor", al, ac);
  XtManageChild (_menu_editors_constraint);
  ac = 0;
  _menu_editors_resource = 
    XmCreatePushButton(XmPulldownMenu_17, "ResourceEditor", al, ac);
  XtManageChild (_menu_editors_resource);
  ac = 0;
  _menu_editors_option = 
    XmCreatePushButton(XmPulldownMenu_17, "OptionEditor", al, ac);
  XtManageChild (_menu_editors_option);
  ac = 0;
  _menu_code = 
    XmCreateCascadeButton(_menu_bar, "Code", al, ac);
  XtManageChild (_menu_code);
  ac = 0;
  XmPulldownMenu_22 = 
    XmCreatePulldownMenu(_menu_code, "XmPulldownMenu_22", al, ac);
  ac = 0;
  XtSetArg(al[ac], XmNsubMenuId,XmPulldownMenu_22);ac++;
  XtSetValues(_menu_code,al,ac);
  ac = 0;
  _menu_code_generate = 
    XmCreatePushButton(XmPulldownMenu_22, "GenerateCode", al, ac);
  XtManageChild (_menu_code_generate);
  ac = 0;
  _menu_code_xresource = 
    XmCreatePushButton(XmPulldownMenu_22, "GenerateXResource", al, ac);
  XtManageChild (_menu_code_xresource);
  ac = 0;
  _menu_code_externs = 
    XmCreatePushButton(XmPulldownMenu_22, "GeneratExterns", al, ac);
  XtManageChild (_menu_code_externs);
  ac = 0;
  _menu_help = 
    XmCreateCascadeButton(_menu_bar, "Help", al, ac);
  XtManageChild (_menu_help);
  ac = 0;
  XmPulldownMenu_28 = 
    XmCreatePulldownMenu(_menu_help, "XmPulldownMenu_28", al, ac);
  ac = 0;
  XtSetArg(al[ac],XmNmenuHelpWidget,_menu_help);ac++;
  XtSetValues(_menu_bar,al,ac);
  ac = 0;
  XtSetArg(al[ac], XmNsubMenuId,XmPulldownMenu_28);ac++;
  XtSetValues(_menu_help,al,ac);
  ac = 0;
  _menu_help_window = 
    XmCreatePushButton(XmPulldownMenu_28, "HelpWindow", al, ac);
  XtManageChild (_menu_help_window);
  ac = 0;
  _menu_help_version = 
    XmCreatePushButton(XmPulldownMenu_28, "HelpVersion", al, ac);
  XtManageChild (_menu_help_version);
  ac = 0;
  XmFrame_31 = 
    XmCreateFrame(_main_form, "XmFrame_31", al, ac);
  XtManageChild (XmFrame_31);
  ac = 0;
  XmForm_32 = 
    XmCreateForm(XmFrame_31, "XmForm_32", al, ac);
  XtManageChild (XmForm_32);
  ac = 0;
  _var_name = 
    XmCreateLabel(XmForm_32, "VariableName", al, ac);
  XtManageChild (_var_name);
  ac = 0;
  _var_name_text = 
    XmCreateText(XmForm_32, "VariableText", al, ac);
  XtManageChild (_var_name_text);
  ac = 0;
  _wid_name = 
    XmCreateLabel(XmForm_32, "WidgetName", al, ac);
  XtManageChild (_wid_name);
  ac = 0;
  _wid_name_text = 
    XmCreateText(XmForm_32, "WidgetText", al, ac);
  XtManageChild (_wid_name_text);
  ac = 0;

  XtAddCallback(_var_name_text,XmNvalueChangedCallback,Guide::updateVariableNameCB,this);
  XtAddCallback(_wid_name_text,XmNvalueChangedCallback,Guide::updateWidgetNameCB,this);

  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNtopOffset,0);ac++;
  XtSetArg(al[ac],XmNtopPosition,0);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,0);ac++;
  XtSetArg(al[ac],XmNleftPosition,0);ac++;
  XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNrightOffset,0);ac++;
  XtSetArg(al[ac],XmNrightPosition,0);ac++;
  XtSetValues(_menu_bar,al,ac);
  ac = 0;

  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNtopWidget,_menu_bar);ac++;
  XtSetArg(al[ac],XmNtopOffset,0);ac++;
  XtSetArg(al[ac],XmNtopPosition,0);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,0);ac++;
  XtSetArg(al[ac],XmNleftPosition,0);ac++;
  XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNrightOffset,0);ac++;
  XtSetArg(al[ac],XmNrightPosition,0);ac++;
  XtSetValues(XmFrame_31,al,ac);
  ac = 0;

  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNtopOffset,0);ac++;
  XtSetArg(al[ac],XmNtopPosition,0);ac++;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNbottomOffset,0);ac++;
  XtSetArg(al[ac],XmNbottomPosition,0);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,0);ac++;
  XtSetArg(al[ac],XmNleftPosition,0);ac++;
  XtSetValues(_var_name,al,ac);
  ac = 0;

  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNtopOffset,0);ac++;
  XtSetArg(al[ac],XmNtopPosition,0);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNleftWidget,_var_name);ac++;
  XtSetArg(al[ac],XmNleftOffset,0);ac++;
  XtSetArg(al[ac],XmNleftPosition,0);ac++;
  XtSetValues(_var_name_text,al,ac);
  ac = 0;

  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNtopOffset,0);ac++;
  XtSetArg(al[ac],XmNtopPosition,0);ac++;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNbottomOffset,0);ac++;
  XtSetArg(al[ac],XmNbottomPosition,0);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNleftWidget,_var_name_text);ac++;
  XtSetArg(al[ac],XmNleftOffset,0);ac++;
  XtSetArg(al[ac],XmNleftPosition,0);ac++;
  XtSetValues(_wid_name,al,ac);
  ac = 0;

  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNtopOffset,0);ac++;
  XtSetArg(al[ac],XmNtopPosition,0);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNleftWidget,_wid_name);ac++;
  XtSetArg(al[ac],XmNleftOffset,0);ac++;
  XtSetArg(al[ac],XmNleftPosition,0);ac++;
  XtSetValues(_wid_name_text,al,ac);
}

void Guide::run(void)
{
  XFontStruct * font_struct;

  init();
  createMainMenu();
  addCallbacks();
  addEvents();
  createSaveDialog(_guide);
  createOpenFileDialog(_guide);

  _resEditor = new ResEditor(_guide, this);
  _designEditor = new DesignEditor(_guide, this);
  _optionEditor = new OptionEditor(_guide, this);
  _constraintEditor = new ConstraintEditor(_guide, this);
  _iFileReader = new IFileReader(this);

  font_struct = 
    XLoadQueryFont(_display, "-schumacher-clean-*-*-*-*-6-*-*-*-*-*-*-*");

  _font_gc = XCreateGC(_display, 
                 RootWindowOfScreen(XtScreen(_guide)), 
                 0,
                 NULL);

  _color_gc = XCreateGC(_display, 
                 RootWindowOfScreen(XtScreen(_guide)), 
                 0,
                 NULL);

  _gc = XCreateGC(_display, 
                 RootWindowOfScreen(XtScreen(_guide)), 
                 0,
                 NULL);

  XSetForeground(_display,_color_gc,_designEditor->getColor("red"));
  XSetForeground(_display,_font_gc,_designEditor->getColor("black"));
  XSetForeground(_display,_gc,_designEditor->getColor("white"));

  if(font_struct == (XFontStruct*) NULL)
  {
    cout << "Could not find font \n";
  }
  else
  {
    XSetFont(_display,_font_gc,font_struct->fid);
  }
  XtRealizeWidget(_guide);
  XtAppMainLoop(_app_context);
}

OptionEditor * Guide::getOptionEditor(void)
{
  return _optionEditor;
}

DesignEditor * Guide::getDesignEditor(void)
{
  return _designEditor;
}

ConstraintEditor * Guide::getConstraintEditor(void)
{
  return _constraintEditor;
}

ResEditor * Guide::getResEditor(void)
{
  return _resEditor;
}

void Guide::addInterface(Interface * interface)
{
  _list.insert(_list.begin(),interface);
}

void Guide::removeInterface(Interface * interface)
{
  int i;
  Interface * deleted = NULL;

  for(i=0;i<(int)_list.size();i++)
  { /*  */ 
    if(_list[i] == interface)
    { /*  */ 
      deleted = _list[i];
      _list.erase(&_list[i]);
      delete deleted;
      break;
    } /*  */ 
  } /*  */ 
}

vector<Interface *> * Guide::getInterfaceList(void)
{
  return &_list;
}

GC Guide::getGC(void)
{
  return _gc;
} 

GC Guide::getfontGC(void)
{
  return _font_gc;
} 

GC Guide::getcolorGC(void)
{
  return _color_gc;
}

void Guide::updateMainWindow(void)
{
  char * temp;

  if(_selectedWidget)
  { /*  */ 
    XtRemoveCallback(_var_name_text,XmNvalueChangedCallback,
                     Guide::updateVariableNameCB,this);
    XtRemoveCallback(_wid_name_text,XmNvalueChangedCallback,
                     Guide::updateWidgetNameCB,this);
    temp = (char *)(_selectedWidget->getVarName()).data();
    XmTextSetString(_var_name_text,temp);
    temp = (char *)(_selectedWidget->getWidName()).data();
    XmTextSetString(_wid_name_text,temp);
    XtAddCallback(_var_name_text,XmNvalueChangedCallback,
                     Guide::updateVariableNameCB,this);
    XtAddCallback(_wid_name_text,XmNvalueChangedCallback,
                     Guide::updateWidgetNameCB,this);
  } /*  */ 
}

XtCore * Guide::getSelectedWidget(void)
{
  return _selectedWidget;
}

void Guide::setSelectedWidget(XtCore * selectedWidget)
{
  _selectedWidget = selectedWidget;
  _selectedWidget->updateCoreResources();
  _designEditor->setSelectedWidget(selectedWidget);
}

Interface * Guide::getSelectedInterface(void)
{
  return _selectedInterface;
}

void Guide::setSelectedInterface(Interface* selectedInterface)
{
  _selectedInterface = selectedInterface;
}

void Guide::updateWidgetNameCB(Widget,XtPointer client_data,XtPointer call_data)
{
  Guide * guide = (Guide *) client_data;
  guide->updateWidgetName();
}
void Guide::updateVariableNameCB(Widget,XtPointer client_data,XtPointer call_data)
{
  Guide * guide = (Guide *) client_data;
  guide->updateVariableName();
}

void Guide::updateVariableName(void)
{
  char * varName = XmTextGetString(_var_name_text);
  String new_name;

  XtRemoveCallback(_var_name_text,XmNvalueChangedCallback,
                Guide::updateVariableNameCB,this);
  if(_selectedWidget)
  { /* a widget exists */
    if(debug_set)
      cout << "Var name = " << varName << endl;

    new_name = varName;
    _selectedWidget->setVarName(new_name);
    _selectedWidget->setGlobal(True);
  } /* a widget exists */ 
  XtAddCallback(_var_name_text,XmNvalueChangedCallback,
                Guide::updateVariableNameCB,this);
  XtFree(varName);
}

void Guide::updateWidgetName(void)
{
  char * widName = XmTextGetString(_wid_name_text);
  String new_name;

  XtRemoveCallback(_wid_name_text,XmNvalueChangedCallback,
                Guide::updateWidgetNameCB,this);
  if(_selectedWidget)
  { /* a widget exists */
    if(debug_set)
      cout << "Wid name = " << widName << endl;

    new_name = widName;
    _selectedWidget->setWidName(new_name);
  } /* a widget exists */ 
  XtAddCallback(_wid_name_text,XmNvalueChangedCallback,
                Guide::updateWidgetNameCB,this);

  XtFree(widName);
}

void Guide::save(void)
{
  ofstream filename((char *)_filename.data());
  int i = 0;

  if(debug_set)
    cout << "Guide::save called" << endl;

  for(i=0;i<(int)_list.size();i++)
  { /* for each interface in the list */
    _list[i]->saveChildren(&filename,0);
  } /* for each interface in the list */
}

void Guide::createSaveDialog(Widget parent)
{
        Widget children[7];      /* Children to manage */
        Arg al[64];                    /* Arg List */
        register int ac = 0;           /* Arg Count */
        XmString xmstrings[16];    /* temporary storage for XmStrings */
        Widget widget85 = (Widget)NULL;
        Widget widget88 = (Widget)NULL;

        XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
        _saveDialog = XmCreateDialogShell ( parent, "save_dialog", al, ac );
        ac = 0;
        widget85 = XmCreateMessageBox ( _saveDialog, "widget85", al, ac );
        widget88 = XmMessageBoxGetChild ( widget85, XmDIALOG_MESSAGE_LABEL );
        xmstrings[0] = XmStringCreateLtoR("Enter Filename:", (XmStringCharSet)XmFONTLIST_DEFAULT_TAG);
        XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
        XtSetValues ( widget88,al, ac );
        ac = 0;
        XmStringFree ( xmstrings [ 0 ] );
        _filenameText = XmCreateText ( widget85, "filename_text", al, ac );
        _xd_links [1] = widget85;
        children[ac++] = _filenameText;
        XtManageChildren(children, ac);
        ac = 0;
        _okButton = XmMessageBoxGetChild ( widget85, XmDIALOG_OK_BUTTON);
        XtAddCallback(_okButton, XmNactivateCallback, Guide::saveFileCB,this);
}

void Guide::createOpenFileDialog(Widget parent)
{
        Arg al[64];                    /* Arg List */
        register int ac = 0;           /* Arg Count */
        Widget widget19 = (Widget)NULL;
        Widget widget31 = (Widget)NULL;

        XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
        XtSetArg(al[ac], XmNtitle, "Open File"); ac++;
        _openFileDialog = XmCreateDialogShell ( parent, "open_file_dialog", al, ac );
        ac = 0;
        _fileSelection = XmCreateFileSelectionBox (_openFileDialog , "file_selection", al, ac );
        _fsApplyButton = XmSelectionBoxGetChild ( _fileSelection, XmDIALOG_APPLY_BUTTON );
        _fsCancelButton = XmSelectionBoxGetChild ( _fileSelection, XmDIALOG_CANCEL_BUTTON );
        _fsHelpButton = XmSelectionBoxGetChild ( _fileSelection, XmDIALOG_HELP_BUTTON );
        _fsItemsList = XmSelectionBoxGetChild ( _fileSelection, XmDIALOG_LIST );
        _fsItemsLabel = XmSelectionBoxGetChild ( _fileSelection, XmDIALOG_LIST_LABEL );
        _fsOKButton = XmSelectionBoxGetChild ( _fileSelection, XmDIALOG_OK_BUTTON );
        _fsSelectionLabel = XmSelectionBoxGetChild ( _fileSelection, XmDIALOG_SELECTION_LABEL );
        _fsSeparator = XmSelectionBoxGetChild ( _fileSelection, XmDIALOG_SEPARATOR );
        _fsText = XmSelectionBoxGetChild ( _fileSelection, XmDIALOG_TEXT );
        _fsFilterLabel = XmFileSelectionBoxGetChild ( _fileSelection, XmDIALOG_FILTER_LABEL );
        _fsFilterText = XmFileSelectionBoxGetChild ( _fileSelection, XmDIALOG_FILTER_TEXT );
        _fsDirLabel = XmFileSelectionBoxGetChild ( _fileSelection, XmDIALOG_DIR_LIST_LABEL );
        _fsDirList = XmFileSelectionBoxGetChild ( _fileSelection, XmDIALOG_DIR_LIST );
        widget19 = XtParent ( _fsItemsList );

        widget31 = XtParent ( _fsDirList );

        _xd_links [0] = _fileSelection;
        XtAddCallback(_fsOKButton,XmNactivateCallback,Guide::openFileCB,this);
        XtAddCallback(_fsOKButton,XmNactivateCallback,Guide::unmanageLink, (XtPointer) &_xd_links[0]);
}

void Guide::manageLink(Widget,XtPointer client_data,XtPointer)
{
  if ( client_data && *(Widget *)client_data )
    XtManageChild ( *(Widget *)client_data );
}

void Guide::unmanageLink(Widget ,XtPointer client_data,XtPointer)
{
  if ( client_data && *(Widget *)client_data )
    XtUnmanageChild ( *(Widget *)client_data );
}

void Guide::openFileCB(Widget,XtPointer client_data,XtPointer call_data)
{
  Guide * g = (Guide *) client_data;
  g->openFile();
}

void Guide::saveFileCB(Widget,XtPointer client_data,XtPointer call_data)
{
  Guide * g = (Guide *) client_data;
  g->saveFile();
}

void Guide::saveFile(void)
{
  char * filename = XmTextGetString(_filenameText);
  _filename = filename;
  if(_openOp != MENU_FILE_SAVE_SEPERATE)
    save();
  else
    saveSelected();
  XtFree(filename);
}

void Guide::openFile(void)
{
  char * filename = XmTextGetString(_fsText);
  _filename = filename;

  if(debug_set)
    cout << "Reading file " << _filename << endl;
  if(_openOp == MENU_FILE_OPEN)
    deleteInterfaces();
  _iFileReader->readFile(_filename);
  manageAll();
  XtFree(filename);
}

void Guide::deleteInterfaces(void)
{
  int i = 0;
  Interface *deleted;

  while((int)_list.size() > 0)
  { /*  */ 
    deleted = _list[0];
    _list.erase(&_list[0]);
    delete deleted;
  } /*  */ 
  
  // reset all selected interfaces and widgets in Design Editor
  _designEditor->clearSelected();
}

void Guide::codeInterfaces(ofstream * outfile)
{
  int i = 0;

  /* reset the include list */
  XtCore::resetInclude();
  *outfile << "#include <stdlib.h>" << endl;
  *outfile << "#include <stdio.h>" << endl;
  *outfile << "#include \"public.h\"" << endl;

  /* write all necessary include files but no duplicates */
  for(i=0;i<(int)_list.size();i++)
    _list[i]->codeIncludes(outfile);

  /* generate code for all interfaces */
  for(i=0;i<(int)_list.size();i++)
    _list[i]->codeChildren(outfile,1);
}

void Guide::codeXResources(ofstream * outfile)
{
  int i = 0;

  for(i=0;i<(int)_list.size();i++)
    _list[i]->codeXResources(outfile);
}

void Guide:: manageAll(void)
{
  int i = 0;

  for(i=0;i<(int)_list.size();i++)
    _list[i]->manageAll();
}

void Guide::codeExterns(ofstream * outfile)
{
  int i = 0;
  *outfile << "#include <stdlib.h>" << endl;
  *outfile << "#include <stdio.h>" << endl;
  *outfile << "#include \"public.h\"" << endl;

  for(i=0;i<(int)_list.size();i++)
    _list[i]->codeExterns(outfile);

  for(i=0;i<(int)_list.size();i++)
    _list[i]->codeCreateExterns(outfile);
}

void Guide::codeCallbacks(ofstream * outfile)
{
  *outfile << "#include <stdlib.h>" << endl;
  *outfile << "#include <stdio.h>" << endl;
  *outfile << "#include \"public.h\"" << endl;
}

void Guide::codeEvents(ofstream * outfile)
{
  *outfile << "#include <stdlib.h>" << endl;
  *outfile << "#include <stdio.h>" << endl;
  *outfile << "#include \"public.h\"" << endl;
}

void Guide::codeMakefile(ofstream * outfile)
{
  // codeLinuxMakefile(outfile);
  codeSolarisMakefile(outfile);
}

void Guide::codeLinuxMakefile(ofstream * outfile)
{
*outfile << ".SUFFIXES: .o .C .c" << endl << endl;
*outfile << "G++ = g++" << endl << endl;
*outfile << "GCC = gcc" << endl << endl;
*outfile << "STRIP = strip" << endl << endl;
*outfile << "RM = rm" << endl << endl;
*outfile << "LIB_PATH = -L/usr/X11R6/lib" << endl << endl;
*outfile << "XPM_LIB = -lXpm" << endl << endl;
*outfile << "XPM_INLCUDES =  " << endl << endl;
*outfile << "XM_LIB = -lXm" << endl << endl;
*outfile << "XM_INCLUDES =" << endl << endl;
*outfile << "XT_LIB = -lXt" << endl << endl;
*outfile << "XT_INCLUDES =" << endl << endl;
*outfile << "X11_LIB = -lX11" << endl << endl;
*outfile << "X11_INCLUDES =" << endl << endl;
*outfile << "XEXT_LIB = -lXext" << endl << endl;
*outfile << "XEXT_INCLUDES =" << endl << endl;
*outfile << "OTHER_INCLUDES = -I. -I/usr/X11R6/include" << endl << endl;
*outfile << "DEBUG = $(INCLUDES) $(OTHER_INCLUDES)" << endl << endl;
*outfile << "C++FLAGS =  $(DEBUG) " << endl << endl;
*outfile << "LIBS = $(LIB_PATH) $(XM_LIB) $(XT_LIB) $(XEXT_LIB) $(X11_LIB) $(XPM_LIB)" << endl << endl;
*outfile << ".C.o:" << endl;
*outfile << "	$(G++) $(C++FLAGS) -c $*.C" <<endl << endl;
*outfile << ".c.o:" << endl;
*outfile << "	$(GCC) $(C++FLAGS) -c $*.c" <<endl << endl;
*outfile << "all: user_interface" << endl << endl;
*outfile << "SOURCES = \\" << endl;
*outfile << "	interfaces.c \\" << endl;
*outfile << "	creation.c \\" << endl;
*outfile << "	main.c \\" << endl;
*outfile << "	events.c \\" << endl;
*outfile << "	callbacks.c " << endl << endl;
*outfile << "LIB_OBJS = \\" << endl;
*outfile << "	interfaces.o \\" << endl;
*outfile << "	creation.o \\" << endl;
*outfile << "	main.o \\" << endl;
*outfile << "	events.o \\" << endl;
*outfile << "	callbacks.o " << endl << endl;
// for each interface 

*outfile << "user_interface: $(LIB_OBJS)" << endl;
*outfile << "	$(GCC) -o $@ $(LIB_OBJS) $(LIBS)" << endl;
}

void Guide::codeSolarisMakefile(ofstream * outfile)
{
*outfile << ".SUFFIXES: .o .C .c" << endl << endl;
*outfile << "G++ = g++" << endl << endl;
*outfile << "GCC = gcc" << endl << endl;
*outfile << "STRIP = strip" << endl << endl;
*outfile << "RM = rm" << endl << endl;
*outfile << "LIB_PATH = -L/usr/local/solaris2/xpm/lib" << endl << endl;
*outfile << "XPM_LIB = -lXpm" << endl << endl;
*outfile << "XPM_INLCUDES =  " << endl << endl;
*outfile << "XM_LIB = -lXm" << endl << endl;
*outfile << "XM_INCLUDES =" << endl << endl;
*outfile << "XT_LIB = -lXt" << endl << endl;
*outfile << "XT_INCLUDES =" << endl << endl;
*outfile << "X11_LIB = -lX11" << endl << endl;
*outfile << "X11_INCLUDES =" << endl << endl;
*outfile << "XEXT_LIB = -lXext" << endl << endl;
*outfile << "XEXT_INCLUDES =" << endl << endl;
*outfile << "OTHER_INCLUDES = -I. -I/usr/include -I/usr/local/solaris2/xpm/include" << endl << endl;
*outfile << "DEBUG = $(INCLUDES) $(OTHER_INCLUDES)" << endl << endl;
*outfile << "C++FLAGS =  $(DEBUG) " << endl << endl;
*outfile << "LIBS = $(LIB_PATH) $(XM_LIB) $(XT_LIB) $(XEXT_LIB) $(X11_LIB) $(XPM_LIB)" << endl << endl;
*outfile << ".C.o:" << endl;
*outfile << "	$(G++) $(C++FLAGS) -c $*.C" <<endl << endl;
*outfile << ".c.o:" << endl;
*outfile << "	$(GCC) $(C++FLAGS) -c $*.c" <<endl << endl;
*outfile << "all: user_interface" << endl << endl;
*outfile << "SOURCES = \\" << endl;
*outfile << "	interfaces.c \\" << endl;
*outfile << "	creation.c \\" << endl;
*outfile << "	main.c \\" << endl;
*outfile << "	events.c \\" << endl;
*outfile << "	callbacks.c " << endl << endl;
*outfile << "LIB_OBJS = \\" << endl;
*outfile << "	interfaces.o \\" << endl;
*outfile << "	creation.o \\" << endl;
*outfile << "	main.o \\" << endl;
*outfile << "	events.o \\" << endl;
*outfile << "	callbacks.o " << endl << endl;
// for each interface 

*outfile << "user_interface: $(LIB_OBJS)" << endl;
*outfile << "	$(GCC) -o $@ $(LIB_OBJS) $(LIBS)" << endl;

}

void Guide::codeCreateInterfaces(ofstream * outfile)
{
  int i;

  *outfile << "#include <stdio.h>" << endl;
  *outfile << "#include <stdlib.h>" << endl;
  *outfile << "#include \"public.h\"" << endl;
  *outfile << "#include \"interfaces.h\"" << endl << endl;

  *outfile << "Widget create_interfaces(int argc, char ** argv, Display * display)" << endl;
  *outfile << "{" << endl;
  *outfile << "  Widget top = (Widget) NULL;" << endl;
  /* generate code for all interfaces */
  for(i=0;i<(int)_list.size();i++)
  {
    if(_list[i]->getTop()->getType() == applicationshell_v)
      *outfile << "  top = create" 
               << _list[i]->getTop()->getVarName()
               << "(argc,argv,display);"
               << endl;
  }
  
  /* generate code for all interfaces */
  for(i=0;i<(int)_list.size();i++)
  {
    if(_list[i]->getTop()->getType() != applicationshell_v)
    _list[i]->getTop()->codeCreateInterfaces(outfile,1);
  }
  *outfile << "  return top;" << endl;
  *outfile << "}" << endl;
}

void Guide::codePublic_h(ofstream * outfile)
{
  *outfile << "#ifndef PUBLIB_H" << endl;
  *outfile << "#define PUBLIB_H" << endl;

  *outfile << "#include <X11/Xatom.h>" << endl;
  *outfile << "#include <X11/Intrinsic.h>" << endl;
  *outfile << "#include <X11/Shell.h>" << endl;
  *outfile << "#include <Xm/XmStrDefs.h>" << endl;
  *outfile << "#include <Xm/Xm.h>" << endl;

  *outfile << "extern XtAppContext _app_context;" << endl;
  *outfile << "extern Display* _display;" << endl;

  *outfile << "#endif PUBLIB_H" << endl;
}

void Guide::codeMain(ofstream * outfile)
{
  *outfile << "#include <stdio.h>" << endl;
  *outfile << "#include <stdlib.h>" << endl;
  *outfile << "#include \"public.h\"" << endl;
  *outfile << "#include \"interfaces.h\"" << endl << endl;

  *outfile << "XtAppContext _app_context;" << endl;
  *outfile << "Display* _display;" << endl;
  *outfile << "" << endl;
  *outfile << "extern Widget create_interfaces(int argc, char ** argv, Display * display);" << endl << endl;
  *outfile << "int" << endl;
  *outfile << "main(int argc, char ** argv, char** env)" << endl;
  *outfile << "{" << endl;
  *outfile << "  XtSetLanguageProc ( (XtAppContext) NULL, " << endl;
  *outfile << "                      (XtLanguageProc) NULL," << endl;
  *outfile << "                      (XtPointer) NULL );" << endl;
  *outfile << "  XtToolkitInitialize ();" << endl;
  *outfile << "  _app_context = XtCreateApplicationContext ();" << endl;
  *outfile << "  _display = XtOpenDisplay (_app_context, " << endl;
  *outfile << "                           NULL, " << endl;
  *outfile << "                           argv[0]," << endl;
  *outfile << "                           \"XGuide\"," << endl;
  *outfile << "                           NULL, " << endl;
  *outfile << "                           0, " << endl;
  *outfile << "                           &argc," << endl;
  *outfile << "                           argv);" << endl;
  *outfile << "  if (!_display)" << endl;
  *outfile << "  {" << endl;
  *outfile << "    printf(\"%s: can't open display, exiting...\", argv[0]);" << endl;
  *outfile << "    exit (-1);" << endl;
  *outfile << "  }" << endl;
  *outfile << "  XtRealizeWidget(create_interfaces(argc,argv,_display));" << endl;
  *outfile << "  XtAppMainLoop(_app_context);" << endl;
  *outfile << "  return 0;" << endl;
  *outfile << "}" << endl;
}

void Guide::codeOthers(ofstream * outfile)
{
  *outfile << "#include <stdlib.h>" << endl;
  *outfile << "#include <stdio.h>" << endl;
  *outfile << "#include \"public.h\"" << endl;
}

void Guide::saveSelected(void)
{
  ofstream filename((char *)_filename.data());
  int i = 0;

  if(debug_set)
    cout << "Guide::saveSelected called" << endl;

  _selectedInterface->saveChildren(&filename,0);
}

String Guide::getTemplatePath(void)
{ 
  _templatePath = TEMPLATE_PATH;
  return _templatePath;
}

String Guide::getProjectPath(void)
{ 
  _projectPath = PROJECT_PATH;
  return _projectPath;
}

void Guide::generateCCode(void)
{
  ofstream *newfile;

  newfile = new ofstream(_main_c.data());
  codeMain(newfile);
  delete newfile;

  newfile = new ofstream(_interfaces.data());
  codeInterfaces(newfile);
  delete newfile;

  newfile = new ofstream(_makefile.data());
  codeMakefile(newfile);  
  delete newfile;

  newfile = new ofstream(_externs.data());
  codeExterns(newfile);
  delete newfile;

  newfile = new ofstream(_callbacks.data());
  codeCallbacks(newfile);
  delete newfile;

  newfile = new ofstream(_events.data());
  codeEvents(newfile);
  delete newfile;

  newfile = new ofstream(_interface.data());
  codeCreateInterfaces(newfile);
  delete newfile;

  newfile = new ofstream(_public_h.data());
  codePublic_h(newfile);
  delete newfile;

}

void Guide::generateHCode(void)
{
  ofstream *newfile;
  String externs("project/interfaces.h");
  newfile = new ofstream(externs.data());
  codeExterns(newfile);
  delete newfile;
}

void Guide::generateXCode(void)
{
  ofstream *newfile;
  String resources("project/Resources.ad");
  newfile = new ofstream(resources.data());
  codeXResources(newfile);
  delete newfile;
}

void Guide::generateAllCode(void)
{
  generateCCode();
  generateHCode();
  generateXCode();
}

int Guide::getColorMap()
{
  return _colorMap;
}

Display * Guide::getDisplay()
{
  return _display;
}
