/* DesignEditor.h */

#ifndef _DESIGNEDITOR_H
#define _DESIGNEDITOR_H

#include "Classes.h"

#ifndef DEFAULT_TYPE
#define DEFAULT_TYPE
typedef int DefaultType;
#endif

/*oodB:DesignEditor********** Documentation **************/
// Creation Date : Tue Mar 17 09:03:25 1998
// Programmer : Automatic
// Revised Date : 
/* Purpose of Class DesignEditor :

*/
/*oodE****************************************************/
/*oodB#DesignEditor*** Some Definitions and Stuffs *******/
#include "public.h"
#include "PixmapServer.h"

#include "XMApplicationShell.h"
#include "XMFrame.h"
#include "XMScrollbar.h"
#include "XMArrowButton.h"
#include "XMLabel.h"
#include "XMScrolledWindow.h"
#include "XMArrowButtonGadget.h"
#include "XMLabelGadget.h"
#include "XMSelectionBox.h"
#include "XMBulletinBoard.h"
#include "XMList.h"
#include "XMSeparator.h"
#include "XMCascadeButton.h"
#include "XMMainWindow.h"
#include "XMSeparatorGadget.h"
#include "XMCascadeButtonGadget.h"
#include "XMMenuShell.h"
#include "XMText.h"
#include "XMCommand.h"
#include "XMMessageBox.h"
#include "XMTextField.h"
#include "XMDialogShell.h"
#include "XMPanedWindow.h"
#include "XMToggleButton.h"
#include "XMDrawingArea.h"
#include "XMPushButton.h"
#include "XMToggleButtonGadget.h"
#include "XMDrawnButton.h"
#include "XMPushButtonGadget.h"
#include "XMTopLevelShell.h"
#include "XMFileSelectionBox.h"
#include "XMRowColumn.h"
#include "XMTransientShell.h"
#include "XMForm.h"               
#include "XMScale.h"
#include "XMErrorDialog.h"
#include "XMPromptDialog.h"
#include "XMTemplateDialog.h"
#include "XMFormDialog.h"
#include "XMQuestionDialog.h"
#include "XMWarningDialog.h"
#include "XMInformationDialog.h"
#include "XMSelectionDialog.h"
#include "XMWorkingDialog.h"
#include "XMMenuBar.h"
#include "XMOptionMenu.h"
#include "XMPulldownMenu.h"
#include "XMPopupMenu.h"
#include "XMRadioBox.h"
#include "XMScrolledList.h"
#include "XMScrolledText.h"
#include "XMTabBook.h"


struct design_rec {
  DesignEditor *design;
  XMPushButton *button;
  Widget popupMenu;
  widget_type_enum type;
};

#define UNDO_STR "Undo"
#define CUT_STR "Cut"
#define COPY_STR "Copy"
#define PASTE_STR "Paste"
#define CONSTRAINT_STR "Constraint Editor"
#define OPTION_STR "Option Editor"
#define RESOURCE_STR "Resource Editor"

/*oodE****************************************************/
class DesignEditor {
private : // data 
  Widget _parent;
  Guide * _guide;
  PixmapServer *_pixmapServer;
  XtCore * _shells;
  XtCore * _managers;
  XtCore * _primitives;
  XtCore * _gadgets;
  XtCore * _dialogs;
  XtCore * _tree;
  XtCore * _widgetDrawing;
  XtCore * _interfaceDrawing;
  XtCore * _widgetPopupMenu;
  XtCore * _interfacePopupMenu;
  XtCore * _selectedWidget;
  XtCore * _currentWidget;
  XtCore * _parentWidget;
  Widget _applicationshell_v;
  Widget _toplevelshell_v;
  Widget _arrowbutton_v;
  Widget _arrowbuttongadget_v;
  Widget _bulletinboard_v;
  Widget _cascadebutton_v;
  Widget _cascadebuttongadget_v;
  Widget _command_v;
  Widget _dialogshell_v;
  Widget _drawingarea_v;
  Widget _drawnbutton_v;
  Widget _errordialog_v;
  Widget _fileselectionbox_v;
  Widget _form_v;
  Widget _formdialog_v;
  Widget _frame_v;
  Widget _informationdialog_v;
  Widget _label_v;
  Widget _labelgadget_v;
  Widget _list_v;
  Widget _mainwindow_v;
  Widget _menushell_v;
  Widget _menubar_v;
  Widget _messagebox_v;
  Widget _optionmenu_v;
  Widget _panedwindow_v;
  Widget _popupmenu_v;
  Widget _promptdialog_v;
  Widget _pulldownmenu_v;
  Widget _pushbutton_v;
  Widget _pushbuttongadget_v;
  Widget _questiondialog_v;
  Widget _radiobox_v;
  Widget _rowcolumn_v;
  Widget _scale_v;
  Widget _scrollbar_v;
  Widget _scrolledlist_v;
  Widget _scrolledtext_v;
  Widget _scrolledwindow_v;
  Widget _selectionbox_v;
  Widget _selectiondialog_v;
  Widget _separator_v;
  Widget _separatorgadget_v;
  Widget _tabbook_v;
  Widget _templatedialog_v;
  Widget _text_v;
  Widget _textfield_v;
  Widget _togglebutton_v;
  Widget _togglebuttongadget_v;
  Widget _warningdialog_v;
  Widget _workingdialog_v;

  Interface * _selectedInterface;
  Boolean _doSensitive;
  Boolean _doWidgets;
  Boolean _doInterfaces;
  Boolean _doConstraint;
  Boolean _doResources;

private:
        void update(void);
        void updateAll(void);
        void updateResources(void);
        void updateConstraints(void);
        void updateDisplay(void);
        void updateWidgets(Boolean doSensitive);
        void updateInterfaces(void);
        void findWidget(int x, int y);
        XtCore * findWidget(XtCore * top,int x, int y);
        void findInterface(int x, int y);
        void updateWidgetDrawing(GC gc,XtCore *top, int x, int y ,int &total_x, int &total_y);
        void updateInterfaceDrawing(GC gc);
        void clearWidgetDrawing(void);
        void clearInterfaceDrawing(void);
        void resizeWidgetDrawing(int x, int y);
        void resizeInterfaceDrawing(int x, int y);
        void drawBorderWidget(void);
        void drawBorderInterface(void);
        void drawInterfaces(GC gc, Widget w);
        void setSensitive(widget_type_enum type);
        void sensitiseAll(void);
        void sensitiseUnsupported(void);
        void desensitiseAll(void);
 
public : // member functions
	DesignEditor();
	~DesignEditor();
	DesignEditor(Widget parent, Guide * guide);
	void createDesignEditor(void);
        void createWidget(XMPushButton * button, widget_type_enum type, Boolean readFromFile);
        void popup(void);
        void popdown(void);
        unsigned long getColor(char *color);
        XtCore * getCurrentWidget(void);
        void setSelectedWidget(XtCore * selectedWidget);
        void setCurrentWidget(XtCore * currentWidget);
        void clearSelected(void);

        // callbacks
        static void createWidgetCB(Widget w, XtPointer clientdata, XtPointer calldata);
        static void findInterfaceCB(Widget w,XtPointer clientdata,XtPointer calldata);
        static void findWidgetCB(Widget w,XtPointer clientdata,XtPointer calldata);
        static void refreshInterfaceCB(Widget w,XtPointer clientdata,XtPointer calldata);
        static void refreshWidgetCB(Widget w,XtPointer clientdata,XtPointer calldata);
};

#endif
