/* DesignEditor.C */
#include "DesignEditor.h"
// Super Class : None

/*oodB%DesignEditor*** Global Declarations and Stuffs ****/
#include "Interface.h"
#include "Guide.h"
#include "ResEditor.h"
#include "ConstraintEditor.h"
/*oodE****************************************************/

DesignEditor::DesignEditor()
{
	// Empty
}

DesignEditor::~DesignEditor()
{
  XtCore * deleted = NULL;

  if(debug_set)
    cout << "Destructor for DesignEditor called " << endl;

  delete _shells;
//   delete _managers;
//   delete _primitives;
//   delete _gadgets;
//   delete _dialogs;
//   delete _tree;
}

DesignEditor::DesignEditor(Widget parent, Guide * guide)
{
  _parent = parent;
  _guide = guide;
  _selectedWidget = NULL;
  _currentWidget = NULL;
  _selectedInterface = NULL;
  _doSensitive = False;
  _doWidgets = False;
  _doInterfaces = False;
  _doConstraint = False;
  _doResources = False;

  _pixmapServer = new PixmapServer(_parent);
  createDesignEditor();
  delete _pixmapServer;
  sensitiseAll();
}

void DesignEditor::clearSelected(void)
{
  _selectedWidget = NULL;
  _currentWidget = NULL;
  _selectedInterface = NULL;
  _doSensitive = False;
  _doWidgets = False;
  _doInterfaces = False;
  _doConstraint = False;
  _doResources = False;
  clearWidgetDrawing();
  clearInterfaceDrawing();
}

void DesignEditor::createDesignEditor(void)
{
  Arg al[24];
  int ac = 0;
  XtCore * row = NULL;
  XtCore * but = NULL;
  XtCore * form = NULL;
  XtCore * tab = NULL;
  XtCore * frame1 = NULL;
  XtCore * frame2 = NULL;
  XtCore * scroll1 = NULL;
  XtCore * scroll2 = NULL;
  design_rec * data = NULL;
  XtCore * shells = NULL;
  XtCore * managers = NULL;
  XtCore * primitives = NULL;
  XtCore * gadgets = NULL;
  XtCore * dialogs = NULL;
  XtCore * shellsB = NULL;
  XtCore * managersB = NULL;
  XtCore * primitivesB = NULL;
  XtCore * gadgetsB = NULL;
  XtCore * dialogsB = NULL;

  Pixmap pmap;
  XmString xmstr;
  Pixmap hide = _pixmapServer->get_pixmap((widget_type_enum) 0);

  /* create shell buttons */
  //XtSetArg(al[ac], XmNcolormap,_guide->getColorMap());ac++;
  //XtSetArg(al[ac], XmNdepth,8);ac++;
  //XtSetArg(al[ac], XmNvisual,DefaultVisual(_guide->getDisplay(),
  //                                        DefaultScreen(_guide->getDisplay())));ac++;
  XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
  XtSetArg(al[ac], XmNdeleteResponse, XmUNMAP); ac++;
  _shells = new XMTopLevelShell(_parent,al,ac);
  ((XMTopLevelShell *)_shells)->setTitle("Widget Palette");
  ac = 0;
  tab = new XMTabBook(_shells->getWidget(),al,ac);
  tab->manageChild();
  ac = 0;
  xmstr = XmStringCreate("Shells",XmFONTLIST_DEFAULT_TAG);
  XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
  shellsB = new XMPushButton(tab->getWidget(),al,ac);
  shellsB->manageChild();
  XmStringFree (xmstr);
  ac = 0;
  xmstr = XmStringCreate("Managers",XmFONTLIST_DEFAULT_TAG);
  XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
  managersB = new XMPushButton(tab->getWidget(),al,ac);
  managersB->manageChild();
  XmStringFree (xmstr);
  ac = 0;
  xmstr = XmStringCreate("Primitives",XmFONTLIST_DEFAULT_TAG);
  XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
  primitivesB = new XMPushButton(tab->getWidget(),al,ac);
  primitivesB->manageChild();
  XmStringFree (xmstr);
  ac = 0;
  xmstr = XmStringCreate("Dialogs",XmFONTLIST_DEFAULT_TAG);
  XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
  dialogsB = new XMPushButton(tab->getWidget(),al,ac);
  dialogsB->manageChild();
  XmStringFree (xmstr);
  ac = 0;
  xmstr = XmStringCreate("Gadgets",XmFONTLIST_DEFAULT_TAG);
  XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
  gadgetsB = new XMPushButton(tab->getWidget(),al,ac);
  gadgetsB->manageChild();
  XmStringFree (xmstr);
  ac = 0;
  XtSetArg(al[ac], XmNorientation,XmVERTICAL ); ac++;
  XtSetArg(al[ac], XmNpacking,XmPACK_COLUMN ); ac++;
  XtSetArg(al[ac], XmNresizeWidth,TRUE ); ac++;
  XtSetArg(al[ac], XmNresizeHeight,TRUE ); ac++;
  XtSetArg(al[ac], XmNnumColumns,7); ac++;
  XtSetArg(al[ac], XmNadjustLast,FALSE ); ac++;
  shells = new XMRowColumn(tab->getWidget(),al,ac);
  shells->manageChild();
  ac = 0;
  XtSetArg(al[ac], XmNorientation,XmVERTICAL ); ac++;
  XtSetArg(al[ac], XmNpacking,XmPACK_COLUMN ); ac++;
  XtSetArg(al[ac], XmNresizeWidth,TRUE ); ac++;
  XtSetArg(al[ac], XmNresizeHeight,TRUE ); ac++;
  XtSetArg(al[ac], XmNnumColumns,7); ac++;
  XtSetArg(al[ac], XmNadjustLast,FALSE ); ac++;
  managers = new XMRowColumn(tab->getWidget(),al,ac);
  managers->manageChild();
  ac = 0;
  XtSetArg(al[ac], XmNorientation,XmVERTICAL ); ac++;
  XtSetArg(al[ac], XmNpacking,XmPACK_COLUMN ); ac++;
  XtSetArg(al[ac], XmNresizeWidth,TRUE ); ac++;
  XtSetArg(al[ac], XmNresizeHeight,TRUE ); ac++;
  XtSetArg(al[ac], XmNnumColumns,7); ac++;
  XtSetArg(al[ac], XmNadjustLast,FALSE ); ac++;
  primitives = new XMRowColumn(tab->getWidget(),al,ac);
  primitives->manageChild();
  ac = 0;
  XtSetArg(al[ac], XmNorientation,XmVERTICAL ); ac++;
  XtSetArg(al[ac], XmNpacking,XmPACK_COLUMN ); ac++;
  XtSetArg(al[ac], XmNresizeWidth,TRUE ); ac++;
  XtSetArg(al[ac], XmNresizeHeight,TRUE ); ac++;
  XtSetArg(al[ac], XmNnumColumns,7); ac++;
  XtSetArg(al[ac], XmNadjustLast,FALSE ); ac++;
  dialogs = new XMRowColumn(tab->getWidget(),al,ac);
  dialogs->manageChild();
  ac = 0;
  XtSetArg(al[ac], XmNorientation,XmVERTICAL ); ac++;
  XtSetArg(al[ac], XmNpacking,XmPACK_COLUMN ); ac++;
  XtSetArg(al[ac], XmNresizeWidth,TRUE ); ac++;
  XtSetArg(al[ac], XmNresizeHeight,TRUE ); ac++;
  XtSetArg(al[ac], XmNnumColumns,7); ac++;
  XtSetArg(al[ac], XmNadjustLast,FALSE ); ac++;
  gadgets = new XMRowColumn(tab->getWidget(),al,ac);
  gadgets->manageChild();

  ac = 0;
  pmap = _pixmapServer->get_pixmap(applicationshell_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(shells->getWidget(),al,ac);
  _applicationshell_v = but->getWidget();
  ac = 0;
  shells->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button = (XMPushButton *)but;
  data->type = applicationshell_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(toplevelshell_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(shells->getWidget(),al,ac);
  _toplevelshell_v = but->getWidget();
  ac = 0;
  shells->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button = (XMPushButton *)but;
  data->type = toplevelshell_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(dialogshell_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(shells->getWidget(),al,ac);
  _dialogshell_v = but->getWidget();
  ac = 0;
  shells->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = dialogshell_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  /* create manager buttons */
  pmap = _pixmapServer->get_pixmap(bulletinboard_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(managers->getWidget(),al,ac);
  _bulletinboard_v = but->getWidget();
  ac = 0;
  managers->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = bulletinboard_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(command_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(managers->getWidget(),al,ac);
  _command_v = but->getWidget();
  ac = 0;
  managers->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = command_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(drawingarea_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(managers->getWidget(),al,ac);
  _drawingarea_v = but->getWidget();
  ac = 0;
  managers->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = drawingarea_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(tabbook_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(managers->getWidget(),al,ac);
  _tabbook_v = but->getWidget();
  ac = 0;
  managers->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = tabbook_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(fileselectionbox_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(managers->getWidget(),al,ac);
  _fileselectionbox_v = but->getWidget();
  ac = 0;
  managers->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = fileselectionbox_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(form_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(managers->getWidget(),al,ac);
  _form_v = but->getWidget();
  ac = 0;
  managers->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = form_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(frame_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(managers->getWidget(),al,ac);
  _frame_v = but->getWidget();
  ac = 0;
  managers->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = frame_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(messagebox_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(managers->getWidget(),al,ac);
  _messagebox_v = but->getWidget();
  ac = 0;
  managers->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = messagebox_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(rowcolumn_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(managers->getWidget(),al,ac);
  _rowcolumn_v = but->getWidget();
  ac = 0;
  managers->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = rowcolumn_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(scale_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(managers->getWidget(),al,ac);
  _scale_v = but->getWidget();
  ac = 0;
  managers->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = scale_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(scrolledwindow_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(managers->getWidget(),al,ac);
  _scrolledwindow_v = but->getWidget();
  ac = 0;
  managers->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = scrolledwindow_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(selectionbox_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(managers->getWidget(),al,ac);
  _selectionbox_v = but->getWidget();
  ac = 0;
  managers->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = selectionbox_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(panedwindow_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(managers->getWidget(),al,ac);
  _panedwindow_v = but->getWidget();
  ac = 0;
  managers->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = panedwindow_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(menubar_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(managers->getWidget(),al,ac);
  _menubar_v = but->getWidget();
  ac = 0;
  managers->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = menubar_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(mainwindow_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(managers->getWidget(),al,ac);
  _mainwindow_v = but->getWidget();
  ac = 0;
  managers->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = mainwindow_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(pulldownmenu_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  cout << "Pulldownmenu started with Pixmap = " << (int) pmap << endl;
  but = new XMPushButton(managers->getWidget(),al,ac);
  cout << "Pulldownmenu finished" << endl;
  cout << "" << endl;
  _pulldownmenu_v = but->getWidget();
  ac = 0;
  managers->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = pulldownmenu_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(popupmenu_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(managers->getWidget(),al,ac);
  _popupmenu_v = but->getWidget();
  ac = 0;
  managers->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = popupmenu_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);


  /* create primitive buttons */
  pmap = _pixmapServer->get_pixmap(arrowbutton_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(primitives->getWidget(),al,ac);
  _arrowbutton_v = but->getWidget();
  ac = 0;
  primitives->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = arrowbutton_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(label_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(primitives->getWidget(),al,ac);
  _label_v = but->getWidget();
  ac = 0;
  primitives->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = label_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(list_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(primitives->getWidget(),al,ac);
  _list_v = but->getWidget();
  ac = 0;
  primitives->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = list_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(scrollbar_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(primitives->getWidget(),al,ac);
  _scrollbar_v = but->getWidget();
  ac = 0;
  primitives->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = scrollbar_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(separator_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(primitives->getWidget(),al,ac);
  _separator_v = but->getWidget();
  ac = 0;
  primitives->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = separator_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(text_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(primitives->getWidget(),al,ac);
  _text_v = but->getWidget();
  ac = 0;
  primitives->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = text_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(textfield_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(primitives->getWidget(),al,ac);
  _textfield_v = but->getWidget();
  ac = 0;
  primitives->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = textfield_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(cascadebutton_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(primitives->getWidget(),al,ac);
  _cascadebutton_v = but->getWidget();
  ac = 0;
  primitives->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = cascadebutton_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(drawnbutton_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(primitives->getWidget(),al,ac);
  _drawnbutton_v = but->getWidget();
  ac = 0;
  primitives->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = drawnbutton_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(pushbutton_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(primitives->getWidget(),al,ac);
  _pushbutton_v = but->getWidget();
  ac = 0;
  primitives->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = pushbutton_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(togglebutton_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(primitives->getWidget(),al,ac);
  _togglebutton_v = but->getWidget();
  ac = 0;
  primitives->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = togglebutton_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(scrolledlist_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(primitives->getWidget(),al,ac);
  _scrolledlist_v = but->getWidget();
  ac = 0;
  primitives->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = scrolledlist_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(scrolledtext_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(primitives->getWidget(),al,ac);
  _scrolledtext_v = but->getWidget();
  ac = 0;
  primitives->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = scrolledtext_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(optionmenu_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(primitives->getWidget(),al,ac);
  _optionmenu_v = but->getWidget();
  ac = 0;
  primitives->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = optionmenu_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);


  /* create gadget buttons */
  pmap = _pixmapServer->get_pixmap(arrowbuttongadget_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(gadgets->getWidget(),al,ac);
  _arrowbuttongadget_v = but->getWidget();
  ac = 0;
  gadgets->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = arrowbuttongadget_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(cascadebuttongadget_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(gadgets->getWidget(),al,ac);
  _cascadebuttongadget_v = but->getWidget();
  ac = 0;
  gadgets->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = cascadebuttongadget_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(labelgadget_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(gadgets->getWidget(),al,ac);
  _labelgadget_v = but->getWidget();
  ac = 0;
  gadgets->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = labelgadget_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(pushbuttongadget_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(gadgets->getWidget(),al,ac);
  _pushbuttongadget_v = but->getWidget();
  ac = 0;
  gadgets->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = pushbuttongadget_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(separatorgadget_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(gadgets->getWidget(),al,ac);
  _separatorgadget_v = but->getWidget();
  ac = 0;
  gadgets->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = separatorgadget_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(togglebuttongadget_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(gadgets->getWidget(),al,ac);
  _togglebuttongadget_v = but->getWidget();
  ac = 0;
  gadgets->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = togglebuttongadget_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  /* create dialog buttons */
  pmap = _pixmapServer->get_pixmap(errordialog_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(dialogs->getWidget(),al,ac);
  _errordialog_v = but->getWidget();
  ac = 0;
  dialogs->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = errordialog_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(formdialog_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(dialogs->getWidget(),al,ac);
  _formdialog_v = but->getWidget();
  ac = 0;
  dialogs->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = formdialog_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(informationdialog_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(dialogs->getWidget(),al,ac);
  _informationdialog_v = but->getWidget();
  ac = 0;
  dialogs->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = informationdialog_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(promptdialog_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(dialogs->getWidget(),al,ac);
  _promptdialog_v = but->getWidget();
  ac = 0;
  dialogs->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = promptdialog_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(questiondialog_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(dialogs->getWidget(),al,ac);
  _questiondialog_v = but->getWidget();
  ac = 0;
  dialogs->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = questiondialog_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(selectiondialog_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(dialogs->getWidget(),al,ac);
  _selectiondialog_v = but->getWidget();
  ac = 0;
  dialogs->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = selectiondialog_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(templatedialog_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(dialogs->getWidget(),al,ac);
  _templatedialog_v = but->getWidget();
  ac = 0;
  dialogs->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = templatedialog_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(warningdialog_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(dialogs->getWidget(),al,ac);
  _warningdialog_v = but->getWidget();
  ac = 0;
  dialogs->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = warningdialog_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  pmap = _pixmapServer->get_pixmap(workingdialog_v);
  XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
  XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
  XtSetArg(al[ac],XmNlabelInsensitivePixmap,hide);ac++;
  but = new XMPushButton(dialogs->getWidget(),al,ac);
  _workingdialog_v = but->getWidget();
  ac = 0;
  dialogs->addChild(but);
  but->manageChild();
  data = new design_rec;
  data->design = this;
  data->button =(XMPushButton *) but;
  data->type = workingdialog_v;
  (data->button)->addCallback(XmNactivateCallback,
                              DesignEditor::createWidgetCB,
                              data);

  /* create the widget and interface tree */
  XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
  XtSetArg(al[ac], XmNdeleteResponse, XmUNMAP); ac++;
  _tree = new XMTopLevelShell(_parent,al,ac);
  ((XMTopLevelShell *)_tree)->setTitle("Widget Interface Tree");
  ac = 0;

  form = new XMForm(_tree->getWidget(),al,ac);
  _tree->addChild(form);
  form->manageChild();
  ac = 0;

  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNrightOffset,110);ac++;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_FORM);ac++;
  frame1 = new XMFrame(form->getWidget(),al,ac);
  form->addChild(frame1);
  frame1->manageChild();
  ac = 0;

  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_FORM);ac++;
  frame2 = new XMFrame(form->getWidget(),al,ac);
  form->addChild(frame2);
  frame2->manageChild();
  ac = 0;

  XtSetArg(al[ac],XmNwidth,400);ac++;
  XtSetArg(al[ac],XmNheight,200);ac++;
  XtSetArg(al[ac], XmNscrollingPolicy, XmAUTOMATIC); ac++;
  scroll1 = new XMScrolledWindow(frame1->getWidget(),al,ac);
  frame1->addChild(scroll1);
  scroll1->manageChild();
  ac = 0;

  XtSetArg(al[ac],XmNwidth,110);ac++;
  XtSetArg(al[ac],XmNheight,200);ac++;
  XtSetArg(al[ac], XmNscrollingPolicy, XmAUTOMATIC); ac++;
  scroll2 = new XMScrolledWindow(frame2->getWidget(),al,ac);
  frame2->addChild(scroll2);
  scroll2->manageChild();
  ac = 0;

  
  XtSetArg(al[ac],XmNwidth,400);ac++;
  XtSetArg(al[ac],XmNheight,400);ac++;
  _widgetDrawing = new XMDrawingArea(scroll1->getWidget(),al,ac);
  scroll1->addChild(_widgetDrawing);
  _widgetDrawing->manageChild();
  ac = 0;

  _widgetPopupMenu = new XMPopupMenu(_widgetDrawing->getWidget(),al,ac);
  _widgetDrawing->addChild(_widgetPopupMenu);
  ac = 0;

  xmstr = XmStringCreate(UNDO_STR,XmFONTLIST_DEFAULT_TAG);
  XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
  but = new XMPushButton(_widgetPopupMenu->getWidget(),al,ac);
  _widgetPopupMenu->addChild(but);
  but->manageChild();
  XmStringFree (xmstr);
  ac = 0;

  xmstr = XmStringCreate(CUT_STR,XmFONTLIST_DEFAULT_TAG);
  XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
  but = new XMPushButton(_widgetPopupMenu->getWidget(),al,ac);
  _widgetPopupMenu->addChild(but);
  but->manageChild();
  XmStringFree (xmstr);
  ac = 0;

  xmstr = XmStringCreate(COPY_STR,XmFONTLIST_DEFAULT_TAG);
  XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
  but = new XMPushButton(_widgetPopupMenu->getWidget(),al,ac);
  _widgetPopupMenu->addChild(but);
  but->manageChild();
  XmStringFree (xmstr);
  ac = 0;

  xmstr = XmStringCreate(PASTE_STR,XmFONTLIST_DEFAULT_TAG);
  XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
  but = new XMPushButton(_widgetPopupMenu->getWidget(),al,ac);
  _widgetPopupMenu->addChild(but);
  but->manageChild();
  XmStringFree (xmstr);
  ac = 0;

  xmstr = XmStringCreate(CONSTRAINT_STR,XmFONTLIST_DEFAULT_TAG);
  XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
  but = new XMPushButton(_widgetPopupMenu->getWidget(),al,ac);
  _widgetPopupMenu->addChild(but);
  but->manageChild();
  XmStringFree (xmstr);
  ac = 0;

  xmstr = XmStringCreate(RESOURCE_STR,XmFONTLIST_DEFAULT_TAG);
  XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
  but = new XMPushButton(_widgetPopupMenu->getWidget(),al,ac);
  _widgetPopupMenu->addChild(but);
  but->manageChild();
  XmStringFree (xmstr);
  ac = 0;

  xmstr = XmStringCreate(OPTION_STR,XmFONTLIST_DEFAULT_TAG);
  XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
  but = new XMPushButton(_widgetPopupMenu->getWidget(),al,ac);
  _widgetPopupMenu->addChild(but);
  but->manageChild();
  XmStringFree (xmstr);
  ac = 0;

  data = new design_rec;
  data->design = this;
  data->popupMenu = _widgetPopupMenu->getWidget();
  _widgetDrawing->addCallback(XmNinputCallback,
                                 DesignEditor::findWidgetCB,
                                 data);
  _widgetDrawing->addCallback(XmNexposeCallback,
                                 DesignEditor::refreshWidgetCB,
                                 this);

  XtSetArg(al[ac],XmNwidth,80);ac++;
  XtSetArg(al[ac],XmNheight,500);ac++;
  _interfaceDrawing = new XMDrawingArea(scroll2->getWidget(),al,ac);
  scroll2->addChild(_interfaceDrawing);
  _interfaceDrawing->manageChild();
  ac = 0;

  _interfacePopupMenu = new XMPopupMenu(_interfaceDrawing->getWidget(),al,ac);
  _interfaceDrawing->addChild(_interfacePopupMenu);
  ac = 0;

  xmstr = XmStringCreate(UNDO_STR,XmFONTLIST_DEFAULT_TAG);
  XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
  but = new XMPushButton(_interfacePopupMenu->getWidget(),al,ac);
  _interfacePopupMenu->addChild(but);
  but->manageChild();
  XmStringFree (xmstr);
  ac = 0;

  xmstr = XmStringCreate(CUT_STR,XmFONTLIST_DEFAULT_TAG);
  XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
  but = new XMPushButton(_interfacePopupMenu->getWidget(),al,ac);
  _interfacePopupMenu->addChild(but);
  but->manageChild();
  XmStringFree (xmstr);
  ac = 0;

  xmstr = XmStringCreate(COPY_STR,XmFONTLIST_DEFAULT_TAG);
  XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
  but = new XMPushButton(_interfacePopupMenu->getWidget(),al,ac);
  _interfacePopupMenu->addChild(but);
  but->manageChild();
  XmStringFree (xmstr);
  ac = 0;

  xmstr = XmStringCreate(PASTE_STR,XmFONTLIST_DEFAULT_TAG);
  XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
  but = new XMPushButton(_interfacePopupMenu->getWidget(),al,ac);
  _interfacePopupMenu->addChild(but);
  but->manageChild();
  XmStringFree (xmstr);
  ac = 0;

  data = new design_rec;
  data->design = this;
  data->popupMenu = _interfacePopupMenu->getWidget();
  _interfaceDrawing->addCallback(XmNinputCallback,
                                 DesignEditor::findInterfaceCB,
                                 data);
  _interfaceDrawing->addCallback(XmNexposeCallback,
                                 DesignEditor::refreshInterfaceCB,
                                 this);

#ifdef MOTIF_2_0
  /* create Motif 2.0 buttons */
#endif MOTIF_2_0
}

void DesignEditor::popup(void)
{
  _shells->popup();
//   _managers->popup();
//   _primitives->popup();
//   _gadgets->popup();
//   _dialogs->popup();
  _tree->popup();
}

void DesignEditor::popdown(void)
{
  _shells->popdown();
//   _managers->popdown();
//   _primitives->popdown();
//   _gadgets->popdown();
//   _dialogs->popdown();
  _tree->popdown();
}

void DesignEditor::createWidget(XMPushButton * button, widget_type_enum type, Boolean readFromFile)
{
  Arg al[36];
  int ac = 0;  
  vector<XtCore *> * list;

  if(_selectedInterface == NULL)
    XtCore::setID(0);

  if((_selectedWidget) && (_selectedWidget->canbeParent()))
  { /* not a toplevel and can be a parent */ 
    _parentWidget = _selectedWidget;
    if((_parentWidget->getType() == frame_v) &&
       ((_parentWidget->getList())->size() == 1))
    { /* frame label */ 
      XtSetArg(al[ac], XmNchildType, XmFRAME_TITLE_CHILD); ac++;
    } /* frame label */ 

    else if(_parentWidget->getType() == pulldownmenu_v)
    { /* pulldown menu */
      
    } /* pulldown menu */  

    /* if this is a form and there is at least one child */
    else if((_parentWidget->getType() == form_v) &&
       ((_parentWidget->getList())->size()))
    { /* form with children */
        list = _parentWidget->getList();
        XtCore * child = (*list)[0];
        XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
        XtSetArg(al[ac],XmNtopWidget,child->getWidget());ac++;
        XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
        XtSetArg(al[ac],XmNrightAttachment,XmATTACH_NONE);ac++;
        XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_NONE);ac++;
    } /* form with children */
    else if(_parentWidget->getType() == form_v)
    { /* form without children */
        XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
        XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
        XtSetArg(al[ac],XmNrightAttachment,XmATTACH_NONE);ac++;
        XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_NONE);ac++;
    } /* form without children */
  } /* not a toplevel and can be a parent */ 
  else if((_selectedWidget) && (type == popupmenu_v))
    _parentWidget = _selectedWidget;
  else
    _parentWidget = NULL;

  switch(type)
  {
    case applicationshell_v:
      if(debug_set)
        cout << "Create applicationshell_v" << endl;
      XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
      XtSetArg(al[ac], XmNdeleteResponse, XmUNMAP); ac++;
      XtSetArg(al[ac], XmNwidth, 200); ac++;
      XtSetArg(al[ac], XmNheight, 50); ac++;
      _currentWidget = _selectedWidget = 
        new XMApplicationShell(_parent,al,ac);
      _selectedWidget->popup();
      _selectedInterface = new Interface(_selectedWidget);
      _guide->addInterface(_selectedInterface);
      ac = 0;
      break;
    case toplevelshell_v:
      if(debug_set)
        cout << "Create toplevelshell_v" << endl;
      XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
      XtSetArg(al[ac], XmNdeleteResponse, XmUNMAP); ac++;
      XtSetArg(al[ac], XmNwidth, 200); ac++;
      XtSetArg(al[ac], XmNheight, 50); ac++;
      _currentWidget = _selectedWidget = 
        new XMTopLevelShell(_parent,al,ac);
      _selectedInterface = new Interface(_selectedWidget);
      _guide->addInterface(_selectedInterface);
      _selectedWidget->popup();
      ac = 0;
      break;
    case arrowbutton_v:
      if(debug_set)
        cout << "Create arrowbutton_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      _currentWidget = _selectedWidget = 
        new XMArrowButton(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case arrowbuttongadget_v:
      if(debug_set)
        cout << "Create arrowbuttongadget_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      _currentWidget = _selectedWidget = 
        new XMArrowButtonGadget(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case bulletinboard_v:
      if(debug_set)
        cout << "Create bulletinboard_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      _currentWidget = _selectedWidget = 
        new XMBulletinBoard(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case cascadebutton_v:
      if(debug_set)
        cout << "Create cascadebutton_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      _currentWidget = _selectedWidget = 
        new XMCascadeButton(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case cascadebuttongadget_v:
      if(debug_set)
        cout << "Create cascadebuttongadget_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      _currentWidget = _selectedWidget = 
        new XMCascadeButtonGadget(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case command_v:
      if(debug_set)
        cout << "Create command_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      _currentWidget = _selectedWidget = 
        new XMCommand(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case dialogshell_v:
      if(debug_set)
        cout << "Create dialogshell_v" << endl;
      XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
      XtSetArg(al[ac], XmNdeleteResponse, XmUNMAP); ac++;
      XtSetArg(al[ac], XmNwidth, 200); ac++;
      XtSetArg(al[ac], XmNheight, 50); ac++;
      _currentWidget = _selectedWidget = 
        new XMDialogShell(_parent,al,ac);
      _selectedInterface = new Interface(_selectedWidget);
      _guide->addInterface(_selectedInterface);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      break;
    case drawingarea_v:
      if(debug_set)
        cout << "Create drawingarea_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      _currentWidget = _selectedWidget = 
        new XMDrawingArea(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case drawnbutton_v:
      if(debug_set)
        cout << "Create drawnbutton_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      _currentWidget = _selectedWidget = 
        new XMDrawnButton(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case errordialog_v:
      if(debug_set)
        cout << "Create errordialog_v" << endl;
      XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
      XtSetArg(al[ac], XmNdeleteResponse, XmUNMAP); ac++;
      XtSetArg(al[ac], XmNwidth, 300); ac++;
      XtSetArg(al[ac], XmNheight, 50); ac++;
      _currentWidget = _selectedWidget = 
        new XMErrorDialog(_parent,al,ac);
      _selectedInterface = new Interface(_selectedWidget);
      _guide->addInterface(_selectedInterface);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      break;
    case fileselectionbox_v:
      if(debug_set)
        cout << "Create fileselectionbox_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      _currentWidget = _selectedWidget = 
        new XMFileSelectionBox(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case form_v:
      if(debug_set)
        cout << "Create form_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      XtSetArg(al[ac], XmNwidth, 100); ac++;
      XtSetArg(al[ac], XmNheight, 50); ac++;
      _currentWidget = _selectedWidget = 
        new XMForm(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case formdialog_v:
      if(debug_set)
        cout << "Create formdialog_v" << endl;
      XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
      XtSetArg(al[ac], XmNdeleteResponse, XmUNMAP); ac++;
      XtSetArg(al[ac], XmNwidth, 200); ac++;
      XtSetArg(al[ac], XmNheight, 50); ac++;
      _currentWidget = _selectedWidget = 
        new XMFormDialog(_parent,al,ac);
      _selectedInterface = new Interface(_selectedWidget);
      _guide->addInterface(_selectedInterface);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      break;
    case frame_v:
      if(debug_set)
        cout << "Create frame_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      XtSetArg(al[ac], XmNwidth, 100); ac++;
      XtSetArg(al[ac], XmNheight, 50); ac++;
        _currentWidget = _selectedWidget = 
          new XMFrame(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
        _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
          _selectedWidget->manageChild();
        ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case informationdialog_v:
      if(debug_set)
        cout << "Create informationdialog_v" << endl;
      XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
      XtSetArg(al[ac], XmNdeleteResponse, XmUNMAP); ac++;
      XtSetArg(al[ac], XmNwidth, 300); ac++;
      XtSetArg(al[ac], XmNheight, 50); ac++;
      _currentWidget = _selectedWidget = 
        new XMInformationDialog(_parent,al,ac);
      _selectedInterface = new Interface(_selectedWidget);
      _guide->addInterface(_selectedInterface);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      break;
    case label_v:
      if(debug_set)
        cout << "Create label_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      _currentWidget = _selectedWidget = 
        new XMLabel(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case labelgadget_v:
      if(debug_set)
        cout << "Create labelgadget_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      _currentWidget = _selectedWidget = 
        new XMLabelGadget(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case list_v:
      if(debug_set)
        cout << "Create list_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      XtSetArg(al[ac], XmNwidth, 100); ac++;
      XtSetArg(al[ac], XmNheight, 100); ac++;
      _currentWidget = _selectedWidget = 
        new XMList(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case mainwindow_v:
      if(debug_set)
        cout << "Create mainwindow_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      XtSetArg(al[ac], XmNwidth, 300); ac++;
      XtSetArg(al[ac], XmNheight, 400); ac++;
      _currentWidget = _selectedWidget = 
        new XMMainWindow(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case menubar_v:
      if(debug_set)
        cout << "Create menubar_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      _currentWidget = _selectedWidget = 
        new XMMenuBar(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case messagebox_v:
      if(debug_set)
        cout << "Create messagebox_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      _currentWidget = _selectedWidget = 
        new XMMessageBox(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case optionmenu_v:
      if(debug_set)
        cout << "Create optionmenu_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
       _currentWidget = _selectedWidget = 
        new XMOptionMenu(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
     break;
    case panedwindow_v:
      if(debug_set)
        cout << "Create panedwindow_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      XtSetArg(al[ac], XmNwidth, 100); ac++;
      XtSetArg(al[ac], XmNheight, 100); ac++;
      _currentWidget = _selectedWidget = 
        new XMPanedWindow(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case popupmenu_v:
      if(debug_set)
        cout << "Create popupmenu_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      _currentWidget = _selectedWidget = 
        new XMPopupMenu(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case promptdialog_v:
      if(debug_set)
        cout << "Create promptdialog_v" << endl;
      XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
      XtSetArg(al[ac], XmNdeleteResponse, XmUNMAP); ac++;
      XtSetArg(al[ac], XmNwidth, 300); ac++;
      XtSetArg(al[ac], XmNheight, 50); ac++;
      _currentWidget = _selectedWidget = 
        new XMPromptDialog(_parent,al,ac);
      _selectedInterface = new Interface(_selectedWidget);
      _guide->addInterface(_selectedInterface);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      break;
    case pulldownmenu_v:
      if(debug_set)
        cout << "Create pulldownmenu_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
        _currentWidget = _selectedWidget = 
          new XMPulldownMenu(_parentWidget->getWidget(),al,ac);
        _selectedWidget->setCoreParent(_parentWidget);
        _parentWidget->addChild(_selectedWidget);
        ac = 0;
        if(_parentWidget->getType() == optionmenu_v)
        { /* option menu parent */ 
        } /* option menu parent */ 
        else
        { /* other - cascade button ? - parent */ 
          ac = 0;
          XtSetArg(al[ac], XmNsubMenuId,_selectedWidget->getWidget());ac++;
          XtSetValues(_parentWidget->getWidget(),al,ac);
        } /* other - cascade button ? - parent */  
        ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case pushbutton_v:
      if(debug_set)
        cout << "Create pushbutton_v" << endl;
      if(_parentWidget)
      { /* Valid parent */
        _currentWidget = _selectedWidget = 
          new XMPushButton(_parentWidget->getWidget(),al,ac);
        _selectedWidget->setCoreParent(_parentWidget);
        _parentWidget->addChild(_selectedWidget);
        _selectedWidget->manageChild();
        _selectedWidget = _parentWidget;
        ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case pushbuttongadget_v:
      if(debug_set)
        cout << "Create pushbuttongadget_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
        _currentWidget = _selectedWidget = 
          new XMPushButtonGadget(_parentWidget->getWidget(),al,ac);
        _selectedWidget->setCoreParent(_parentWidget);
      _selectedWidget->setCoreParent(_parentWidget);
        _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
          _selectedWidget->manageChild();
        _selectedWidget = _parentWidget;
        ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case questiondialog_v:
      if(debug_set)
        cout << "Create questiondialog_v" << endl;
      XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
      XtSetArg(al[ac], XmNdeleteResponse, XmUNMAP); ac++;
      XtSetArg(al[ac], XmNwidth, 300); ac++;
      XtSetArg(al[ac], XmNheight, 50); ac++;
      _currentWidget = _selectedWidget = 
        new XMQuestionDialog(_parent,al,ac);
      _selectedInterface = new Interface(_selectedWidget);
      _guide->addInterface(_selectedInterface);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      break;
    case radiobox_v:
      if(debug_set)
        cout << "Create radiobox_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      _currentWidget = _selectedWidget = 
        new XMRadioBox(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case rowcolumn_v:
      if(debug_set)
        cout << "Create rowcolumn_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      XtSetArg(al[ac], XmNwidth, 100); ac++;
      XtSetArg(al[ac], XmNheight, 100); ac++;
      _currentWidget = _selectedWidget = 
        new XMRowColumn(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case scale_v:
      if(debug_set)
        cout << "Create scale_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      XtSetArg(al[ac], XmNwidth, 20); ac++;
      XtSetArg(al[ac], XmNheight, 100); ac++;
      _currentWidget = _selectedWidget = 
        new XMScale(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      _selectedWidget = _parentWidget;
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case scrollbar_v:
      if(debug_set)
        cout << "Create scrollbar_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      XtSetArg(al[ac], XmNwidth, 10); ac++;
      XtSetArg(al[ac], XmNheight, 100); ac++;
      _currentWidget = _selectedWidget = 
        new XMScrollbar(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      _selectedWidget = _parentWidget;
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case scrolledlist_v:
      if(debug_set)
        cout << "Create scrolledlist_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      _currentWidget = _selectedWidget = 
        new XMScrolledList(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case scrolledtext_v:
      if(debug_set)
        cout << "Create scrolledtext_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      _currentWidget = _selectedWidget = 
        new XMScrolledText(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case scrolledwindow_v:
      if(debug_set)
        cout << "Create scrolledwindow_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      _currentWidget = _selectedWidget = 
        new XMScrolledWindow(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case selectionbox_v:
      if(debug_set)
        cout << "Create selectionbox_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      _currentWidget = _selectedWidget = 
        new XMSelectionBox(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case selectiondialog_v:
      if(debug_set)
        cout << "Create selectiondialog_v" << endl;
      XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
      XtSetArg(al[ac], XmNdeleteResponse, XmUNMAP); ac++;
      XtSetArg(al[ac], XmNwidth, 350); ac++;
      XtSetArg(al[ac], XmNheight, 200); ac++;
      _currentWidget = _selectedWidget = 
        new XMSelectionDialog(_parent,al,ac);
      _selectedInterface = new Interface(_selectedWidget);
      _guide->addInterface(_selectedInterface);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      break;
    case separator_v:
      if(debug_set)
        cout << "Create separator_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      XtSetArg(al[ac], XmNwidth, 100); ac++;
      XtSetArg(al[ac], XmNheight, 10); ac++;
      _currentWidget = _selectedWidget = 
        new XMSeparator(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      _selectedWidget = _parentWidget;
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case separatorgadget_v:
      if(debug_set)
        cout << "Create separatorgadget_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      _currentWidget = _selectedWidget = 
        new XMSeparatorGadget(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      _selectedWidget = _parentWidget;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case tabbook_v:
      if(debug_set)
        cout << "Create tabbook_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
        _currentWidget = _selectedWidget = 
          new XMTabBook(_parentWidget->getWidget(),al,ac);
        _selectedWidget->setCoreParent(_parentWidget);
        _parentWidget->addChild(_selectedWidget);
        if(!readFromFile)
          _selectedWidget->manageChild();
        ac = 0;
        _selectedWidget = _parentWidget;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case templatedialog_v:
      if(debug_set)
        cout << "Create templatedialog_v" << endl;
      XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
      XtSetArg(al[ac], XmNdeleteResponse, XmUNMAP); ac++;
      XtSetArg(al[ac], XmNwidth, 300); ac++;
      XtSetArg(al[ac], XmNheight, 50); ac++;
      _currentWidget = _selectedWidget = 
        new XMTemplateDialog(_parent,al,ac);
      _selectedInterface = new Interface(_selectedWidget);
      _guide->addInterface(_selectedInterface);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      break;
    case text_v:
      if(debug_set)
        cout << "Create text_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
        _currentWidget = _selectedWidget = 
          new XMText(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
        _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
          _selectedWidget->manageChild();
        _selectedWidget = _parentWidget;
        ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case textfield_v:
      if(debug_set)
        cout << "Create textfield_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
       _currentWidget = _selectedWidget = 
         new XMTextField(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
       _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
         _selectedWidget->manageChild();
        _selectedWidget = _parentWidget;
       ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case togglebutton_v:
      if(debug_set)
        cout << "Create togglebutton_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      _currentWidget = _selectedWidget = 
        new XMToggleButton(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
        _selectedWidget = _parentWidget;
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case togglebuttongadget_v:
      if(debug_set)
        cout << "Create togglebuttongadget_v" << endl;
      if(_parentWidget)
      { /* Valid parent */ 
      _currentWidget = _selectedWidget = 
        new XMToggleButtonGadget(_parentWidget->getWidget(),al,ac);
      _selectedWidget->setCoreParent(_parentWidget);
      _parentWidget->addChild(_selectedWidget);
      if(!readFromFile)
        _selectedWidget->manageChild();
        _selectedWidget = _parentWidget;
      ac = 0;
      } /* Valid parent */ 
      else
      { /* raise exception */
      } /* raise exception */
      break;
    case warningdialog_v:
      if(debug_set)
        cout << "Create warningdialog_v" << endl;
      XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
      XtSetArg(al[ac], XmNdeleteResponse, XmUNMAP); ac++;
      XtSetArg(al[ac], XmNwidth, 300); ac++;
      XtSetArg(al[ac], XmNheight, 50); ac++;
      _currentWidget = _selectedWidget = 
        new XMWarningDialog(_parent,al,ac);
      _selectedInterface = new Interface(_selectedWidget);
      _guide->addInterface(_selectedInterface);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      break;
    case workingdialog_v:
      if(debug_set)
        cout << "Create workingdialog_v" << endl;
      XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
      XtSetArg(al[ac], XmNdeleteResponse, XmUNMAP); ac++;
      XtSetArg(al[ac], XmNwidth, 300); ac++;
      XtSetArg(al[ac], XmNheight, 50); ac++;
      _currentWidget = _selectedWidget = 
        new XMWorkingDialog(_parent,al,ac);
      _selectedInterface = new Interface(_selectedWidget);
      _guide->addInterface(_selectedInterface);
      if(!readFromFile)
        _selectedWidget->manageChild();
      ac = 0;
      break;
    case last_widget_type_v:
      if(debug_set)
        cout << "last_widget_type_v" << endl;
      break;
  }
  _doSensitive = True;
  _doWidgets = True;
  _doInterfaces = True;

  if(_parentWidget)
  { /* parent exists */ 
    if(_parentWidget->getType() == form_v)
    { /* form */ 
      _doConstraint = True;
      // store currently selected widget 
      XtCore * oldSelected = _selectedWidget;
      list = _parentWidget->getList();
      _selectedWidget= (*list)[0];
      if((_parentWidget->getList())->size() > 1)
      {
        _selectedWidget->setTopWidget((*list)[1]);
        _selectedWidget->setTopAttachment(XmATTACH_WIDGET);
        _selectedWidget->setLeftAttachment(XmATTACH_FORM);
      }
      else
      {
        _selectedWidget->setTopAttachment(XmATTACH_FORM);
        _selectedWidget->setLeftAttachment(XmATTACH_FORM);
      }
      // re-store currently selected widget 
      _selectedWidget = oldSelected;
    } /* form */ 
    else if(_parentWidget->getType() == pulldownmenu_v)
    { /* pulldown */
       
    } /* pulldown */
  } /* parent exists */ 

  _doResources = True;
  _guide->setSelectedInterface(_selectedInterface);
  _guide->setSelectedWidget(_selectedWidget);
  update();
}

void DesignEditor::createWidgetCB(Widget w, XtPointer clientdata, XtPointer calldata)
{
  design_rec * d = (design_rec *) clientdata;
  DesignEditor * des = d->design;
  des->createWidget(d->button,d->type,False);
}

void DesignEditor::updateAll(void)
{
  _doSensitive = True;
  _doWidgets = True;
  _doInterfaces = True;
  _doConstraint = True;
  _doResources = True;
  update();
}

void DesignEditor::updateResources(void)
{ /*  */ 
  (_guide->getResEditor())->update();
} /*  */

void DesignEditor::updateConstraints(void)
{ /*  */ 
  (_guide->getConstraintEditor())->update();
} /*  */ 

void DesignEditor::update(void)
{
  if(_doSensitive)
  { /* update design display */
    updateDisplay();
  } /* update design display */
  if(_doWidgets)
  { /* `update widget display */
    updateWidgets(False);
  } /* `update widget display */
  if(_doInterfaces)
  { /* update interface display */
    updateInterfaces();
  } /* update interface display */
  if(_doConstraint)
  { /* update constraint editor */
    updateConstraints();
  } /* update constraint editor */
  if(_doResources)
  { /* update resource editor */
    updateResources();
  } /* update resource editor */

  _doSensitive = False;
  _doWidgets = False;
  _doInterfaces = False;
  _doConstraint = False;
  _doResources = False;
}

void DesignEditor::updateDisplay(void)
{
  setSensitive(_selectedWidget->getType());
  _doSensitive = False;
}

void DesignEditor::updateWidgets(Boolean doSensitive)
{
  int x = SPACE/2;
  int y = SPACE/2;
  int total_x = SPACE/2;
  int total_y = SPACE/2;
  GC gc = _guide->getGC();
  XtCore *top = NULL;
  _doWidgets = False;

  if(_selectedInterface)
  { /*  */ 
    top = _selectedInterface->getTop();
  } /*  */ 

  if(top)
  { /*  */ 
    updateWidgetDrawing(gc,top,x,y,total_x,total_y);
    if((_selectedWidget) &&(doSensitive))
    {
      setSensitive(_selectedWidget->getType());
    }
  } /*  */ 
}

void DesignEditor::updateInterfaces(void)
{
  GC gc = _guide->getGC();
  _doInterfaces = False;

  if(_selectedInterface)
    updateInterfaceDrawing(gc);   
}

void DesignEditor::findInterface(int x, int y)
{
  vector<Interface *> *list = _guide->getInterfaceList();
  int i = 0;

  if(debug_set)
    cout << "Pressed button at " << x << "," 
         << y << " in Interface area" << endl;

  if((list->size() > 0) &&(_selectedInterface != NULL))
  { /* list has interfaces */

    for(i=0;i<(int)list->size();i++)
    { /* next interface */
      if((x > ((*list)[i])->getX()) &&
         (x < ((*list)[i])->getX() + 56) &&
         (y > ((*list)[i])->getY()) &&
         (y < ((*list)[i])->getY() + 42))
      { /* found interface */
        _selectedInterface = (*list)[i];
        if(debug_set)
          cout << "Found interface" << _selectedInterface->getName() << endl;
        _currentWidget = _selectedWidget = _selectedInterface->getTop();
        _selectedWidget->popup();
        _guide->setSelectedInterface(_selectedInterface);
        _guide->setSelectedWidget(_selectedWidget);
      } /* found interface */
    } /* next interface */
  } /* list has interfaces */
  if(_selectedInterface!= NULL)
    drawBorderInterface();
}

XtCore * DesignEditor::findWidget(XtCore * top,int x, int y)
{
  XtCore * found = NULL;
  XtCore * temp = NULL;
  vector<XtCore *> *list = NULL;
  int i =0;
 
  if((x > top->getX()) && 
     (x < top->getX() + SPACE + 4) && 
     (y > top->getY()) && 
     (y < top->getY() + SPACE + 4))
    found = top;
  else
  { /*  */ 
    list = top->getList();
    for(i=0;i<(int)list->size() && !found;i++)
    { /*  */ 
      temp = (*list)[i];
      found = findWidget(temp,x,y);
    } /*  */ 
  } /*  */ 
  return found;
}

void DesignEditor::findWidget(int x, int y)
{ 
  XtCore * temp = NULL;
  XtCore * top = NULL;
    
  if(debug_set)
    cout << "Pressed button at " << x << "," << y << " in Widget area" << endl;

  if(_selectedInterface)
  { /* there is at least one interface */ 
    top = _selectedInterface->getTop();
    temp = findWidget(top,x,y);
    if(temp != NULL)
    { /*  */ 
      _currentWidget = _selectedWidget = temp;
      _guide->setSelectedWidget(_selectedWidget);
      drawBorderWidget();
    } /*  */
  } /* there is at least one interface */  
}

unsigned long DesignEditor::getColor(char *color)
{
  XrmValue from_value, to_value;
  from_value.addr = color;
  from_value.size = strlen( from_value.addr ) + 1;
  to_value.addr = NULL;
  XtConvertAndStore (_parent,XmRString, &from_value, 
                     XmRPixel, &to_value);
  if ( to_value.addr )
  {
    return( *(unsigned int *)to_value.addr);
  }
  else
    return(0);
}

void DesignEditor::drawBorderWidget(void)
{
  Widget w = _widgetDrawing->getWidget();
  int x = _selectedWidget->getX();
  int y = _selectedWidget->getY();
  GC color_gc = _guide->getcolorGC();
  GC gc = _guide->getGC();
  XtCore * top = _selectedInterface->getTop();
  clearWidgetDrawing();

  /* draw a shadow */
  XSetForeground(XtDisplay(w),color_gc,getColor("grey35"));
  XSetLineAttributes(XtDisplay(w),color_gc,5,LineSolid,CapRound,JoinRound);
  XDrawRectangle(XtDisplay(w),
                 XtWindow(w),
                 color_gc,
                 x+2,
                 y+2,
                 42,
                 42);

  top->drawWidgets(gc,w);

  /* draw select box */
  XSetForeground(XtDisplay(w),color_gc,getColor("red"));
  XSetLineAttributes(XtDisplay(w),color_gc,5,LineSolid,CapRound,JoinRound);
  XDrawRectangle(XtDisplay(w),
                 XtWindow(w),
                 color_gc,
                 x-5,
                 y-5,
                 42,
                 42);

  _guide->updateMainWindow();
}

void DesignEditor::drawBorderInterface(void)
{
  int total_x = SPACE/2;
  int total_y = SPACE/2;
  Widget w = _interfaceDrawing->getWidget();
  int x = _selectedInterface->getX();
  int y = _selectedInterface->getY();
  GC color_gc = _guide->getcolorGC();
  GC gc = _guide->getGC();
  clearInterfaceDrawing();
  drawInterfaces(gc,w);

  XSetForeground(XtDisplay(w),color_gc,getColor("red"));
  XSetLineAttributes(XtDisplay(w),color_gc,5,LineSolid,CapRound,JoinRound);
  XDrawRectangle(XtDisplay(w),
                 XtWindow(w),
                 color_gc,
                 x-5,
                 y-5,
                 66,
                 56);

  x = y = SPACE/2;
}

void DesignEditor::drawInterfaces(GC gc, Widget w)
{
  vector<Interface *> * list = _guide->getInterfaceList();
  Interface * temp = NULL;
  int i = 0;
 
  for(i=0;i<(int)list->size();i++)
  { /* next interface */
     temp = (*list)[i];
     temp->drawInterface(gc,w);
  } /* next interface */ 
}

void DesignEditor::findWidgetCB(Widget w, XtPointer clientdata, XtPointer calldata)
{  
  design_rec  * design = (design_rec  *) clientdata;
  DesignEditor * Ed = design->design;
  Widget popupMenu = design->popupMenu;
  
  XmDrawingAreaCallbackStruct *cbs = (XmDrawingAreaCallbackStruct *) calldata;

  /* check which button has been pressed */
  if(cbs->event->xany.type != ButtonPress)
    return;

  switch(cbs->event->xbutton.button)
  {
    case 1:
       Ed->findWidget(cbs->event->xbutton.x,cbs->event->xbutton.y);
       Ed->updateWidgets(True);
       Ed->updateResources();
       Ed->updateConstraints();
    break;
    case 2:
    break;
    case 3:  
      XmMenuPosition(popupMenu, (XButtonPressedEvent *) (cbs->event));
      XtManageChild(popupMenu);
    break;
  }
}

void DesignEditor::findInterfaceCB(Widget w, XtPointer clientdata, XtPointer calldata)
{
  design_rec  * design = (design_rec  *) clientdata;
  DesignEditor * Ed = design->design;
  Widget popupMenu = design->popupMenu;
  
  XmDrawingAreaCallbackStruct *cbs = (XmDrawingAreaCallbackStruct *) calldata;

  /* check which button has been pressed */
  if(cbs->event->xany.type != ButtonPress)
    return;

  switch(cbs->event->xbutton.button)
  {
    case 1:
       Ed->findInterface(cbs->event->xbutton.x,cbs->event->xbutton.y);
       Ed->updateInterfaces();
       Ed->updateWidgets(True);
       Ed->updateResources();
    break;
    case 2:
    break;
    case 3:  
      XmMenuPosition(popupMenu, (XButtonPressedEvent *) (cbs->event));
      XtManageChild(popupMenu);
    break;
  }
}

void DesignEditor::updateInterfaceDrawing(GC gc)
{
  vector<Interface *> * list = _guide->getInterfaceList();
  int i = 0;
  int x = 10;
  int y = 10;

  if(list->size() > 0)
  { /* interfaces found */

    for(i=0;i<(int)list->size();i++)
    { /* next interface */
      ((*list)[i])->setX(x);
      ((*list)[i])->setY(x + (60 * i));
      y = x + (60 * i);
    } /* next interface */
  } /* interfaces found */
  resizeInterfaceDrawing(x + 80 ,y + 80);
  drawBorderInterface();
}

void DesignEditor::updateWidgetDrawing(GC gc,XtCore *top, int x, int y ,int &total_x,int &total_y)
{
  top->widgetPosition(x,y,total_x,total_y);
  resizeWidgetDrawing(total_x + SPACE,total_y + SPACE);
  top->setX((x + total_x) / 2 );
  top->setY(y);
  drawBorderWidget();
}

void DesignEditor::refreshInterfaceCB(Widget w, XtPointer clientdata, XtPointer calldata)
{
  DesignEditor *_d= (DesignEditor *)clientdata;
  _d->updateInterfaces();
}

void DesignEditor::refreshWidgetCB(Widget w, XtPointer clientdata, XtPointer calldata)
{
  DesignEditor *_d = (DesignEditor *)clientdata;
  _d->updateWidgets(False);
}

void DesignEditor::clearWidgetDrawing(void)
{
  Widget w = _widgetDrawing->getWidget();
  XClearWindow(XtDisplay(w), XtWindow(w));
}

void DesignEditor::clearInterfaceDrawing(void)
{ 
  Widget w = _interfaceDrawing->getWidget();
  XClearWindow(XtDisplay(w), XtWindow(w));
}

void DesignEditor::resizeWidgetDrawing(int x, int y)
{
  Arg al[5];
  int ac = 0;

  XtSetArg(al[ac],XmNwidth,(Dimension)x);ac++;
  XtSetArg(al[ac],XmNheight,(Dimension)y);ac++;
  XtSetValues(_widgetDrawing->getWidget(),al,ac);
}

void DesignEditor::resizeInterfaceDrawing(int x, int y)
{
  Arg al[5];
  int ac = 0;

  XtSetArg(al[ac],XmNwidth,(Dimension)x);ac++;
  XtSetArg(al[ac],XmNheight,(Dimension)y);ac++;
  XtSetValues(_interfaceDrawing->getWidget(),al,ac);
}

XtCore * DesignEditor::getCurrentWidget(void)
{
  return _currentWidget;
}

void DesignEditor::setCurrentWidget(XtCore * currentWidget)
{
  _currentWidget = currentWidget;
}

void DesignEditor::setSelectedWidget(XtCore * selectedWidget)
{
  _selectedWidget = selectedWidget;
}

void DesignEditor::setSensitive(widget_type_enum type)
{
  desensitiseAll();
  cout << "DesignEditor::setSensitive " << (int)type << endl;

  if(_selectedWidget->canbeParent() == False)
    sensitiseAll();
  else
  { /*  */ 
    switch(type)
    { /*  */ 
    case applicationshell_v:
      break;
    case toplevelshell_v:
      break;
    case arrowbutton_v:
      sensitiseAll();
      XtSetSensitive(_popupmenu_v, True);
      break;
    case arrowbuttongadget_v:
      sensitiseAll();
      break;
    case bulletinboard_v:
        XtSetSensitive(_command_v, False);
        XtSetSensitive(_fileselectionbox_v, False);
        XtSetSensitive(_mainwindow_v, False);
        XtSetSensitive(_menubar_v, False);
        XtSetSensitive(_messagebox_v, False);
        XtSetSensitive(_optionmenu_v, False);
        XtSetSensitive(_scrolledlist_v, False);
        XtSetSensitive(_scrolledtext_v, False);
        XtSetSensitive(_scrolledwindow_v, False);
        XtSetSensitive(_selectionbox_v, False);
      break;
    case cascadebutton_v:
      sensitiseAll();
      XtSetSensitive(_pulldownmenu_v, True);
      break;
    case cascadebuttongadget_v:
      sensitiseAll();
      break;
    case command_v:
      sensitiseAll();
      XtSetSensitive(_popupmenu_v, True);
      break;
    case dialogshell_v:
      XtSetSensitive(_popupmenu_v, True);
      break;
    case drawingarea_v:
        XtSetSensitive(_command_v, False);
        XtSetSensitive(_fileselectionbox_v, False);
        XtSetSensitive(_mainwindow_v, False);
        XtSetSensitive(_menubar_v, False);
        XtSetSensitive(_messagebox_v, False);
        XtSetSensitive(_optionmenu_v, False);
        XtSetSensitive(_scrolledlist_v, False);
        XtSetSensitive(_scrolledtext_v, False);
        XtSetSensitive(_scrolledwindow_v, False);
        XtSetSensitive(_selectionbox_v, False);
      break;
    case drawnbutton_v:
      sensitiseAll();
      XtSetSensitive(_popupmenu_v, True);
      break;
    case errordialog_v:
      sensitiseAll();
      break;
    case fileselectionbox_v:
      sensitiseAll();
      break;
    case form_v:
        XtSetSensitive(_command_v, False);
        XtSetSensitive(_fileselectionbox_v, False);
        XtSetSensitive(_mainwindow_v, False);
        XtSetSensitive(_messagebox_v, False);
        XtSetSensitive(_selectionbox_v, False);
      break;
    case formdialog_v:
      sensitiseAll();
      break;
    case frame_v:
      XtSetSensitive(_mainwindow_v, False);
      XtSetSensitive(_popupmenu_v, True);
      break;
    case informationdialog_v:
      sensitiseAll();
      break;
    case label_v:
      sensitiseAll();
      XtSetSensitive(_popupmenu_v, True);
      break;
    case labelgadget_v:
      sensitiseAll();
      break;
    case list_v:
      sensitiseAll();
      XtSetSensitive(_popupmenu_v, True);
      break;
    case mainwindow_v:
      XtSetSensitive(_command_v, False);
      XtSetSensitive(_fileselectionbox_v, False);
      XtSetSensitive(_mainwindow_v, False);
      XtSetSensitive(_messagebox_v, False);
      XtSetSensitive(_optionmenu_v, False);
      XtSetSensitive(_scrolledlist_v, False);
      XtSetSensitive(_scrolledtext_v, False);
      XtSetSensitive(_scrolledwindow_v, False);
      XtSetSensitive(_selectionbox_v, False);
      break;
    case menushell_v:
      sensitiseAll();
      break;
    case menubar_v:
      sensitiseAll();
      XtSetSensitive(_cascadebutton_v, True);
      break;
    case messagebox_v:
      sensitiseAll();
      XtSetSensitive(_popupmenu_v, True);
      break;
    case optionmenu_v:
      sensitiseAll();
      break;
    case panedwindow_v:
      XtSetSensitive(_command_v, False);
      XtSetSensitive(_fileselectionbox_v, False);
      XtSetSensitive(_mainwindow_v, False);
      XtSetSensitive(_menubar_v, False);
      XtSetSensitive(_messagebox_v, False);
      XtSetSensitive(_optionmenu_v, False);
      XtSetSensitive(_scrolledlist_v, False);
      XtSetSensitive(_scrolledtext_v, False);
      XtSetSensitive(_scrolledwindow_v, False);
      XtSetSensitive(_selectionbox_v, False);
      break;
    case popupmenu_v:
      sensitiseAll();
      XtSetSensitive(_pushbutton_v, True);
      break;
    case promptdialog_v:
      sensitiseAll();
      break;
    case pulldownmenu_v:
      sensitiseAll();
      XtSetSensitive(_pushbutton_v, True);
      XtSetSensitive(_separator_v, True);
      XtSetSensitive(_cascadebutton_v, True);
      break;
    case pushbutton_v:
      sensitiseAll();
      XtSetSensitive(_popupmenu_v, True);
      break;
    case pushbuttongadget_v:
      sensitiseAll();
      break;
    case questiondialog_v:
      sensitiseAll();
      break;
    case radiobox_v:
      sensitiseAll();
      XtSetSensitive(_popupmenu_v, True);
      break;
    case rowcolumn_v:
      XtSetSensitive(_command_v, False);
      XtSetSensitive(_fileselectionbox_v, False);
      XtSetSensitive(_mainwindow_v, False);
      XtSetSensitive(_menubar_v, False);
      XtSetSensitive(_messagebox_v, False);
      XtSetSensitive(_optionmenu_v, False);
      XtSetSensitive(_scrolledlist_v, False);
      XtSetSensitive(_scrolledtext_v, False);
      XtSetSensitive(_scrolledwindow_v, False);
      XtSetSensitive(_selectionbox_v, False);
      break;
    case scale_v:
      sensitiseAll();
      XtSetSensitive(_popupmenu_v, True);
      break;
    case scrollbar_v:
      sensitiseAll();
      break;
    case scrolledlist_v:
      sensitiseAll();
      XtSetSensitive(_popupmenu_v, True);
      break;
    case scrolledtext_v:
      sensitiseAll();
      XtSetSensitive(_popupmenu_v, True);
      break;
    case scrolledwindow_v:
      XtSetSensitive(_command_v, False);
      XtSetSensitive(_fileselectionbox_v, False);
      XtSetSensitive(_mainwindow_v, False);
      XtSetSensitive(_menubar_v, False);
      XtSetSensitive(_messagebox_v, False);
      XtSetSensitive(_optionmenu_v, False);
      XtSetSensitive(_scrolledlist_v, False);
      XtSetSensitive(_scrolledtext_v, False);
      XtSetSensitive(_scrolledwindow_v, False);
      XtSetSensitive(_mainwindow_v, False);
      break;
    case selectionbox_v:
      sensitiseAll();
      break;
    case selectiondialog_v:
      sensitiseAll();
      break;
    case separator_v:
      sensitiseAll();
      break;
    case separatorgadget_v:
      sensitiseAll();
      break;
    case tabbook_v:
      sensitiseAll();
      XtSetSensitive(_form_v, True);
      XtSetSensitive(_rowcolumn_v, True);
      XtSetSensitive(_mainwindow_v, True);
      XtSetSensitive(_pushbutton_v, True);
      XtSetSensitive(_popupmenu_v, True);
      break;
    case templatedialog_v:
      sensitiseAll();
      break;
    case text_v:
      sensitiseAll();
      XtSetSensitive(_popupmenu_v, True);
      break;
    case textfield_v:
      sensitiseAll();
      XtSetSensitive(_popupmenu_v, True);
      break;
    case togglebutton_v:
      sensitiseAll();
      XtSetSensitive(_popupmenu_v, True);
      break;
    case togglebuttongadget_v:
      sensitiseAll();
      break;
    case warningdialog_v:
      sensitiseAll();
      break;
    case workingdialog_v:
      sensitiseAll();
      break;
    case last_widget_type_v:
      break;
    default:
      break;
    } /*  */ 
    sensitiseUnsupported();
  } /*  */ 
}

void DesignEditor::sensitiseUnsupported(void)
{
  XtSetSensitive(_arrowbuttongadget_v, False);
  XtSetSensitive(_cascadebuttongadget_v, False);
  XtSetSensitive(_command_v, False);
  XtSetSensitive(_errordialog_v, False);
  XtSetSensitive(_questiondialog_v, False);
  XtSetSensitive(_informationdialog_v, False);
  XtSetSensitive(_warningdialog_v, False);
  XtSetSensitive(_workingdialog_v, False);
  XtSetSensitive(_formdialog_v, False);
  XtSetSensitive(_selectiondialog_v, False);
  XtSetSensitive(_promptdialog_v, False);
  XtSetSensitive(_fileselectionbox_v, False);
  XtSetSensitive(_labelgadget_v, False);
  XtSetSensitive(_messagebox_v, False);
  XtSetSensitive(_label_v, False);
  XtSetSensitive(_pushbuttongadget_v, False);
  // XtSetSensitive(_radiobox_v, False);
  XtSetSensitive(_scrolledlist_v, False);
  XtSetSensitive(_scrolledtext_v, False);
  XtSetSensitive(_scrolledwindow_v, False);
  XtSetSensitive(_selectionbox_v, False);
  XtSetSensitive(_separatorgadget_v, False);
  XtSetSensitive(_textfield_v, False);
  XtSetSensitive(_togglebuttongadget_v, False);
}

void DesignEditor::sensitiseAll(void)
{
  XtSetSensitive(_arrowbutton_v, False);
  XtSetSensitive(_arrowbuttongadget_v, False);
  XtSetSensitive(_bulletinboard_v, False);
  XtSetSensitive(_cascadebutton_v, False);
  XtSetSensitive(_cascadebuttongadget_v, False);
  XtSetSensitive(_command_v, False);
  XtSetSensitive(_drawingarea_v, False);
  XtSetSensitive(_drawnbutton_v, False);
  XtSetSensitive(_fileselectionbox_v, False);
  XtSetSensitive(_form_v, False);
  XtSetSensitive(_frame_v, False);
  XtSetSensitive(_label_v, False);
  XtSetSensitive(_labelgadget_v, False);
  XtSetSensitive(_list_v, False);
  XtSetSensitive(_mainwindow_v, False);
  XtSetSensitive(_menubar_v, False);
  XtSetSensitive(_messagebox_v, False);
  XtSetSensitive(_optionmenu_v, False);
  XtSetSensitive(_panedwindow_v, False);
  XtSetSensitive(_popupmenu_v, False);
  XtSetSensitive(_pulldownmenu_v, False);
  XtSetSensitive(_pushbutton_v, False);
  XtSetSensitive(_pushbuttongadget_v, False);
  XtSetSensitive(_errordialog_v, False);
  XtSetSensitive(_questiondialog_v, False);
  XtSetSensitive(_informationdialog_v, False);
  XtSetSensitive(_warningdialog_v, False);
  XtSetSensitive(_workingdialog_v, False);
  XtSetSensitive(_formdialog_v, False);
  XtSetSensitive(_selectiondialog_v, False);
  XtSetSensitive(_templatedialog_v, False);
  XtSetSensitive(_promptdialog_v, False);
  // XtSetSensitive(_radiobox_v, False);
  XtSetSensitive(_rowcolumn_v, False);
  XtSetSensitive(_scale_v, False);
  XtSetSensitive(_scrollbar_v, False);
  XtSetSensitive(_scrolledlist_v, False);
  XtSetSensitive(_scrolledtext_v, False);
  XtSetSensitive(_scrolledwindow_v, False);
  XtSetSensitive(_selectionbox_v, False);
  XtSetSensitive(_separator_v, False);
  XtSetSensitive(_separatorgadget_v, False);
  XtSetSensitive(_tabbook_v, False);
  XtSetSensitive(_text_v, False);
  XtSetSensitive(_textfield_v, False);
  XtSetSensitive(_togglebutton_v, False);
  XtSetSensitive(_togglebuttongadget_v, False);
}

void DesignEditor::desensitiseAll(void)
{
  XtSetSensitive(_arrowbutton_v, True);
  XtSetSensitive(_arrowbuttongadget_v, True);
  XtSetSensitive(_bulletinboard_v, True);
  XtSetSensitive(_cascadebutton_v, True);
  XtSetSensitive(_cascadebuttongadget_v, True);
  XtSetSensitive(_command_v, True);
  XtSetSensitive(_drawingarea_v, True);
  XtSetSensitive(_drawnbutton_v, True);
  XtSetSensitive(_fileselectionbox_v, True);
  XtSetSensitive(_form_v, True);
  XtSetSensitive(_frame_v, True);
  XtSetSensitive(_label_v, True);
  XtSetSensitive(_labelgadget_v, True);
  XtSetSensitive(_list_v, True);
  XtSetSensitive(_mainwindow_v, True);
  XtSetSensitive(_menubar_v, True);
  XtSetSensitive(_messagebox_v, True);
  XtSetSensitive(_optionmenu_v, True);
  XtSetSensitive(_panedwindow_v, True);
  XtSetSensitive(_popupmenu_v, True);
  XtSetSensitive(_pulldownmenu_v, True);
  XtSetSensitive(_pushbutton_v, True);
  XtSetSensitive(_pushbuttongadget_v, True);
  //  XtSetSensitive(_radiobox_v, True);
  XtSetSensitive(_rowcolumn_v, True);
  XtSetSensitive(_scale_v, True);
  XtSetSensitive(_scrollbar_v, True);
  XtSetSensitive(_scrolledlist_v, True);
  XtSetSensitive(_scrolledtext_v, True);
  XtSetSensitive(_scrolledwindow_v, True);
  XtSetSensitive(_selectionbox_v, True);
  XtSetSensitive(_separator_v, True);
  XtSetSensitive(_separatorgadget_v, True);
  XtSetSensitive(_tabbook_v, True);
  XtSetSensitive(_text_v, True);
  XtSetSensitive(_textfield_v, True);
  XtSetSensitive(_togglebutton_v, True);
  XtSetSensitive(_togglebuttongadget_v, True);
}
