/* ConstraintEditor.C */

#include "ConstraintEditor.h"
// Super Class : None

/*oodB%ConstraintEditor*** Global Declarations and Stuffs ****/
#include "XtCore.h"
#ifdef NO_HELP
#include "DumbHelp.h"
#else
#include "Help.h"
#endif
/*oodE********************************************************/

ConstraintEditor::ConstraintEditor()
{
	// Empty
}

ConstraintEditor::~ConstraintEditor()
{
	// Empty
}

ConstraintEditor::ConstraintEditor(Widget parent, Guide *guide)
{
  _guide = guide;
  _parent = parent;
  _sourceWidget = NULL;
  _targetWidget = NULL;
  _isDisplayed = False;
  _startDrawX = -1;
  _startDrawY = -1;
  _startMoveX = -1;
  _startMoveY = -1;
  _startResizeX = -1;
  _startResizeY = -1;
  _oldLineX = -1;
  _oldLineY = -1;
  _selected = NULL;
  _offset = 0;
  _position = 0;
  createConstraintEditor();
  _rubber_line_gc = CreateXorGC(XtDisplay(parent), 
              RootWindowOfScreen(XtScreen(parent)), 
              XBlackPixelOfScreen(XtScreen(parent)),
              XWhitePixelOfScreen(XtScreen(parent)));
  _rubber_box_gc = CreateXorGC(XtDisplay(parent), 
              RootWindowOfScreen(XtScreen(parent)), 
              XBlackPixelOfScreen(XtScreen(parent)),
              XWhitePixelOfScreen(XtScreen(parent)));
}

GC ConstraintEditor::CreateXorGC(Display * display, 
               Drawable drawable,
               unsigned long fg,
               unsigned long bg)
{
  XGCValues xgcvalues;
  GC gc;
  
  xgcvalues.foreground = fg ^ bg;
  xgcvalues.background = 0;
  xgcvalues.function = GXxor;
  
  gc = XCreateGC(display,drawable,
                (GCForeground | GCBackground | GCFunction),
                &xgcvalues);
  return(gc);
}


void ConstraintEditor::createConstraintEditor(void)
{
	Widget children[9];      /* Children to manage */
	Arg al[64];                    /* Arg List */
	register int ac = 0;           /* Arg Count */

        Widget horScroll;
        Widget verScroll;
        XtSetArg(al[ac], XmNdeleteResponse, XmUNMAP); ac++;
	XtSetArg(al[ac], XmNminWidth, 400); ac++;
	XtSetArg(al[ac], XmNminHeight, 500); ac++;
	_conEditor = XtCreatePopupShell ( "_conEditor", topLevelShellWidgetClass, _parent, al, ac );
	ac = 0;
	XtSetArg(al[ac], XmNautoUnmanage, FALSE); ac++;
	_conForm = XmCreateForm ( _conEditor, "_conForm", al, ac );
	ac = 0;
	_conDrawFrame = XmCreateFrame ( _conForm, "_conDrawFrame", al, ac );

	ac = 0;
        XtSetArg(al[ac], XmNscrollingPolicy, XmAUTOMATIC); ac++;
	XtSetArg(al[ac], XmNscrollBarDisplayPolicy, XmSTATIC); ac++;
	XtSetArg(al[ac], XmNvisualPolicy, XmCONSTANT); ac++;
        _conDrawSW = XmCreateScrolledWindow(_conDrawFrame,"conDrawSW", al, ac );
	ac = 0;
        XtSetArg(al[ac], XmNhorizontalScrollBar, &horScroll ); ac++;
        XtSetArg(al[ac], XmNverticalScrollBar, &verScroll ); ac++;
        XtGetValues(_conDrawSW, al, ac );

	ac = 0;
	_conDrawingArea = XmCreateDrawingArea (_conDrawSW , "_conDrawingArea", al, ac );
	ac = 0;
	XtSetArg(al[ac], XmNchildType, XmFRAME_TITLE_CHILD); ac++;
	_conDrawFrameLabel = XmCreateLabel ( _conDrawFrame, "_conDrawFrameLabel", al, ac );
	ac = 0;
	_conHelpButton = XmCreatePushButton ( _conForm, "_conHelpButton", al, ac );
	_conCloseButton = XmCreatePushButton ( _conForm, "_conCloseButton", al, ac );
	_conRadioFrame = XmCreateFrame ( _conForm, "_conRadioFrame", al, ac );
	_conRadio = XmCreateRadioBox ( _conRadioFrame, "_conRadio", al, ac );
	_conAttachToggle = XmCreateToggleButtonGadget ( _conRadio, "_conAttachToggle", al, ac );
	_conPositionToggle = XmCreateToggleButtonGadget ( _conRadio, "_conPositionToggle", al, ac );
	_conGroupToggle = XmCreateToggleButtonGadget ( _conRadio, "_conGroupToggle", al, ac );
	XtSetArg(al[ac], XmNchildType, XmFRAME_TITLE_CHILD); ac++;
	_conRadioFrameLabel = XmCreateLabel ( _conRadioFrame, "_conRadioFrameLabel", al, ac );
	ac = 0;
	XtSetArg(al[ac], XmNwidth, 60); ac++;
	_conOffsetText = XmCreateText ( _conForm, "_conOffsetText", al, ac );
	ac = 0;
	XtSetArg(al[ac], XmNwidth, 60); ac++;
	_conPositionText = XmCreateText ( _conForm, "_conPositionText", al, ac );
	ac = 0;
	_conOffsetLabel = XmCreateLabel ( _conForm, "_conOffsetLabel", al, ac );
	_conPositionLabel = XmCreateLabel ( _conForm, "_conPositionLabel", al, ac );
	XtSetArg(al[ac], XmNshowValue, TRUE); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	_conGridScale = XmCreateScale ( _conForm, "_conGridScale", al, ac );
	ac = 0;

	XtAddCallback (_conCloseButton,XmNactivateCallback, ConstraintEditor::closeCB, (XtPointer) this );
	XtAddCallback (_conHelpButton,XmNactivateCallback, ConstraintEditor::helpCB, (XtPointer) this );
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNtopOffset, 0); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomOffset, 75); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 0); ac++;
	XtSetArg(al[ac], XmNleftWidget, _conRadioFrame); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightOffset, 0); ac++;
	XtSetValues ( _conDrawFrame,al, ac );
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomOffset, 20); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNleftPosition, 50); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 65); ac++;
	XtSetValues ( _conHelpButton,al, ac );
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomOffset, 20); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNleftPosition, 25); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 40); ac++;
	XtSetValues ( _conCloseButton,al, ac );
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNtopOffset, 0); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftOffset, 0); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( _conRadioFrame,al, ac );
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, _conOffsetLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( _conOffsetText,al, ac );
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, _conPositionLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( _conPositionText,al, ac );
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, _conRadioFrame); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( _conOffsetLabel,al, ac );
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, _conOffsetText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( _conPositionLabel,al, ac );
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, _conPositionText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNrightWidget, _conDrawFrame); ac++;
	XtSetValues ( _conGridScale,al, ac );
	ac = 0;
	children[ac++] = _conDrawingArea;
	XtManageChildren(children, ac);
	ac = 0;
	children[ac++] = _conDrawSW;
	children[ac++] = _conDrawFrameLabel;
	XtManageChildren(children, ac);
	ac = 0;
	children[ac++] = _conAttachToggle;
	children[ac++] = _conPositionToggle;
	children[ac++] = _conGroupToggle;
	XtManageChildren(children, ac);
	ac = 0;
	children[ac++] = _conRadio;
	children[ac++] = _conRadioFrameLabel;
	XtManageChildren(children, ac);
	ac = 0;
	children[ac++] = _conDrawFrame;
	children[ac++] = _conHelpButton;
	children[ac++] = _conCloseButton;
	children[ac++] = _conRadioFrame;
	children[ac++] = _conOffsetText;
	children[ac++] = _conPositionText;
	children[ac++] = _conOffsetLabel;
	children[ac++] = _conPositionLabel;
	children[ac++] = _conGridScale;
	XtManageChildren(children, ac);
	ac = 0;
	XtManageChild ( _conForm);
        XmScrolledWindowSetAreas(_conDrawSW, 
                                 horScroll, 
                                 verScroll, 
                                 _conDrawingArea);

  cout << "Add event handler for line events " << endl;

  XtAddEventHandler(_conDrawingArea , /* Widget */
                     (EventMask) (Button1MotionMask | 
                      ButtonReleaseMask |
                      ButtonPressMask |
                      EnterWindowMask |
                      LeaveWindowMask), /* events desired */
                      0, /* non_maskable events */
                      ConstraintEditor::drawLineEV,  /* function */
                      (XtPointer) this /* clientdata */);

  XtAddEventHandler(_conDrawingArea , /* Widget */
                     (EventMask) (Button2MotionMask | 
                      ButtonReleaseMask |
                      ButtonPressMask |
                      EnterWindowMask |
                      LeaveWindowMask), /* events desired */
                      0, /* non_maskable events */
                      ConstraintEditor::drawBoxEV,  /* function */
                      (XtPointer) this /* clientdata */);

  XtAddEventHandler(_conDrawingArea , /* Widget */
                     (EventMask) (Button3MotionMask | 
                      ButtonReleaseMask |
                      ButtonPressMask |
                      EnterWindowMask |
                      LeaveWindowMask), /* events desired */
                      0, /* non_maskable events */
                      ConstraintEditor::drawResizeEV,  /* function */
                      (XtPointer) this /* clientdata */);

  XtAddCallback(_conDrawingArea, XmNinputCallback, 
                  ConstraintEditor::inputCB,(XtPointer) this);
    
  XtAddCallback(_conDrawingArea, XmNexposeCallback, 
                  ConstraintEditor::refreshCB,(XtPointer) this);

  XtAddCallback(_conOffsetText, XmNvalueChangedCallback, 
                  ConstraintEditor::offsetCB,(XtPointer) this);

  XtAddCallback(_conPositionText, XmNvalueChangedCallback, 
                  ConstraintEditor::positionCB,(XtPointer) this);
}

void ConstraintEditor::map_link (Widget w, XtPointer client_data, XtPointer call_data)
{
	if ( client_data && *(Widget *)client_data )
    XtMapWidget (*(Widget *)client_data);
}

void ConstraintEditor::unmap_link (Widget w, XtPointer client_data, XtPointer call_data)
{
	if ( client_data && *(Widget *)client_data )
    XtUnmapWidget (*(Widget *)client_data);
}

void ConstraintEditor::closeCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  ConstraintEditor *CE = (ConstraintEditor *) client_data;
  CE->popdown();
}

void ConstraintEditor::helpCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  ConstraintEditor *CE = (ConstraintEditor *) client_data;
  CE->help();
}

void ConstraintEditor::offsetCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  ConstraintEditor *CE = (ConstraintEditor *) client_data;
  CE->offset();
}

void ConstraintEditor::positionCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  ConstraintEditor *CE = (ConstraintEditor *) client_data;
  CE->position();
}

void ConstraintEditor::offset(void)
{
  char * text = XmTextGetString(_conOffsetText);
  _offset = atoi(text);
  XtFree(text);
}

void ConstraintEditor::position(void)
{
  char * text = XmTextGetString(_conPositionText);
  _position = atoi(text);
  XtFree(text);
}

void ConstraintEditor::popup(void)
{
  XtPopup(_conEditor,XtGrabNone);
  _isDisplayed = True;
  update();
}

void ConstraintEditor::popdown(void)
{
  XtPopdown(_conEditor);
  _isDisplayed = False;
}

void ConstraintEditor::help(void)
{
#ifdef NO_HELP
  new DumbHelp("html/main_window.html",_parent);
#else
  new Help("html/main_window.html",_parent);
#endif
}

void ConstraintEditor::update(void)
{
  XtCore * currS = _guide->getSelectedWidget();
  XtCore * temp;
  int i;
  vector<XtCore *> *list;

  if(_isDisplayed)
  { /* Constraint window is up */ 
    cout << "ConstraintEditor::update" << endl;
    /* clear the drawingarea */
    XClearWindow(XtDisplay(_conDrawingArea), XtWindow(_conDrawingArea));

    /* if any selected */ 
    if(currS)
    { /* selected */ 
    
      /* if this is a form widget */
      if(currS->getType() == form_v)
      { /* form */ 
        /* draw a border around form */
        currS->draw(_conDrawingArea);

        /* get list of children */
        list = currS->getList();

        /* draw children in drawing area */
        for(i=(int)list->size()-1;i>=0;i--)
        { /* for each child */
          temp = (*list)[i];
          temp->draw(_conDrawingArea);
        } /* for each child */

        /* draw childrens attachments */
        for(i=(int)list->size()-1;i>=0;i--)
        { /* for each child */
          temp = (*list)[i];
          temp->drawAttachments(_conDrawingArea);
        } /* for each child */
      } /* form */  
    } /* selected */  
  } /* Constraint window is up */ 
}

void ConstraintEditor::drawLineEV(Widget w, 
                                    XtPointer client_data, 
                                    XEvent * event, 
                                    char * dummy) // needed for C++
{  
  XEvent new_event;
  memmove(&new_event,event,sizeof(XEvent));

  ConstraintEditor * ce = (ConstraintEditor *) client_data;
  ce->drawLine(w,&new_event);
}

void ConstraintEditor::drawBoxEV(Widget w, 
                                    XtPointer client_data, 
                                    XEvent * event, 
                                    char * dummy) // needed for C++
{  
  XEvent new_event;
  memmove(&new_event,event,sizeof(XEvent));

  ConstraintEditor * ce = (ConstraintEditor *) client_data;
  ce->drawBox(w,&new_event);
}

void ConstraintEditor::drawResizeEV(Widget w, 
                                    XtPointer client_data, 
                                    XEvent * event, 
                                    char * dummy) // needed for C++
{  
  XEvent new_event;
  memmove(&new_event,event,sizeof(XEvent));

  ConstraintEditor * ce = (ConstraintEditor *) client_data;
  ce->drawResize(w,&new_event);
}

void ConstraintEditor::startDraw(int x,int y)
{
  _startDrawX = x;
  _startDrawY = y;
}

void ConstraintEditor::startMove(int x,int y)
{
  _startMoveX = x;
  _startMoveY = y;
}

void ConstraintEditor::startResize(int x,int y)
{
  _startResizeX = x;
  _startResizeY = y;
}

void ConstraintEditor::drawLine(Widget w,XEvent * event)
{
  cout << " DrawLine event = " 
       << event->type
       << endl;

  if(!_sourceWidget)
    return;

  if((event->type == MotionNotify) &&
     ((event->xbutton.button  == Button1) || 
      (event->xbutton.button == AnyButton)))
  { // start drawing

    /* if there was a line drawn before */
    if(_oldLineX != -1)
    { /* remove the line */
      XDrawLine(XtDisplay(w),XtWindow(w), 
                _rubber_line_gc,
                _startDrawX,_startDrawY,
                _oldLineX,_oldLineY);
      if(_targetWidget)
      {
        _targetWidget->drawSelected(_conDrawingArea,False);
        _targetWidget->setSelectedSide(none_selected_v);
        _targetWidget = NULL;
      }
    } /* remove the line */

    findTargetWidget(event->xbutton.x,event->xbutton.y);
    cout << "XDrawLine" << endl;
    /* draw the new line */
    XDrawLine(XtDisplay(w),XtWindow(w), 
              _rubber_line_gc,
              _startDrawX,_startDrawY,
              event->xbutton.x,event->xbutton.y);

    /* save end points of new line */
    _oldLineX = event->xbutton.x;
    _oldLineY = event->xbutton.y;
  } // start drawing
  if((event->type == LeaveNotify)&&
     ((event->xbutton.button == Button1) ||
      (event->xbutton.button == AnyButton)))
  { // stop drawing
    cout << "stop drawing" << endl;

    /* if there was a line drawn before */
    if(_oldLineX != -1)
    { /* remove the line */
      XDrawLine(XtDisplay(w),XtWindow(w), 
                _rubber_line_gc,
                _startDrawX,_startDrawY,
                _oldLineX,_oldLineY);
      if(_targetWidget)
      {
        _targetWidget->drawSelected(_conDrawingArea,False);
        _targetWidget->setSelectedSide(none_selected_v);
        _targetWidget = NULL;
      }

    } /* remove the line */
    findTargetWidget(event->xbutton.x,event->xbutton.y);
    _oldLineX = -1;
    _oldLineY = -1;
  } // stop drawing
  if((event->type == EnterNotify)&&
     ((event->xbutton.button == Button1) || 
     (event->xbutton.button == AnyButton)))
  { // start drawing
    cout << "start drawing" << endl;

    /* if there was a line drawn before */
    if(_oldLineX != -1)
    { /* remove the line */
      XDrawLine(XtDisplay(w),XtWindow(w), 
                _rubber_line_gc,
                _startDrawX,_startDrawY,
                _oldLineX,_oldLineY);
      if(_targetWidget)
      {
        _targetWidget->drawSelected(_conDrawingArea,False);
        _targetWidget->setSelectedSide(none_selected_v);
        _targetWidget = NULL;
      }

    } /* remove the line */
    findTargetWidget(event->xbutton.x,event->xbutton.y);

    /* draw the new line */
    XDrawLine(XtDisplay(w),XtWindow(w), 
              _rubber_line_gc,
              _startDrawX,_startDrawY,
              event->xbutton.x,event->xbutton.y);

    /* save end points of new line */
    _oldLineX = event->xbutton.x;
    _oldLineY = event->xbutton.y;
  } // start drawing
  if((event->type == ButtonRelease)&&
     ((event->xbutton.button == Button1) || 
      (event->xbutton.button == AnyButton)))
  { // stop drawing
    cout << "stop drawing" << endl;
    /* if there was a line drawn before */
    if(_oldLineX != -1)
    { /* remove the line */
      XDrawLine(XtDisplay(w),XtWindow(w), 
                _rubber_line_gc,
                _startDrawX,_startDrawY,
                _oldLineX,_oldLineY);
      if(_targetWidget)
      {
        _targetWidget->drawSelected(_conDrawingArea,False);
        _targetWidget->setSelectedSide(none_selected_v);
        _targetWidget = NULL;
      }

    } /* remove the line */
    findTargetWidget(event->xbutton.x,event->xbutton.y);
    _oldLineX = -1;
    _oldLineY = -1;
  } // stop drawing
}

void ConstraintEditor::drawResize(Widget w,XEvent * event)
{
  int x,y;
  int wi,h;

  if(_selected)
  { // selected
  if((event->type == MotionNotify) &&
     ((event->xbutton.button == Button3) || 
      (event->xbutton.button == AnyButton)))
  { // start drawing

    x = _selected->getXpos() + CONSTRAINT_OFFSET;
    y = _selected->getYpos() + CONSTRAINT_OFFSET;
    wi = event->xbutton.x - _selected->getXpos();
    h = event->xbutton.y - _selected->getYpos();
    /* if there was a line drawn before */
    if(_oldLineX != -1)
    { /* remove the line */
      XDrawRectangle(XtDisplay(w),XtWindow(w), 
                _rubber_line_gc,
                x,y,_oldLineX,_oldLineY);
    } /* remove the line */

    /* draw the new line */
    XDrawRectangle(XtDisplay(w),XtWindow(w), 
              _rubber_line_gc,
              x,y,wi,h);

    /* save end points of new line */
    _oldLineX = wi;
    _oldLineY = h;
  } // start drawing
  if((event->type == LeaveNotify)&&
     ((event->xbutton.button == Button3) || 
      (event->xbutton.button == AnyButton)))
  { // stop drawing
    cout << "stop drawing" << endl;

    x = _selected->getXpos() + CONSTRAINT_OFFSET;
    y = _selected->getYpos() + CONSTRAINT_OFFSET;
    /* if there was a line drawn before */
    if(_oldLineX != -1)
    { /* remove the line */
      XDrawRectangle(XtDisplay(w),XtWindow(w), 
                _rubber_line_gc,
                x,y,_oldLineX,_oldLineY);
    } /* remove the line */
    _oldLineX = -1;
    _oldLineY = -1;
  } // stop drawing
  if((event->type == EnterNotify)&&
     ((event->xbutton.button == Button3) || 
      (event->xbutton.button == AnyButton)))
  { // start drawing
    cout << "start drawing" << endl;

    x = _selected->getXpos() + CONSTRAINT_OFFSET;
    y = _selected->getYpos() + CONSTRAINT_OFFSET;
    wi = event->xbutton.x - _selected->getXpos();
    h = event->xbutton.y - _selected->getYpos();
    /* if there was a line drawn before */
    if(_oldLineX != -1)
    { /* remove the line */
      XDrawRectangle(XtDisplay(w),XtWindow(w), 
                _rubber_line_gc,
                x,y,_oldLineX,_oldLineY);
    } /* remove the line */

    /* draw the new line */
    XDrawRectangle(XtDisplay(w),XtWindow(w), 
              _rubber_line_gc,
              x,y,wi,h);

    /* save end points of new line */
    _oldLineX = wi;
    _oldLineY = h;
  } // start drawing
  if((event->type == ButtonRelease)&&
     ((event->xbutton.button == Button3) || 
      (event->xbutton.button == AnyButton)))
  { // stop drawing
    cout << "stop drawing" << endl;
    x = _selected->getXpos() + CONSTRAINT_OFFSET;
    y = _selected->getYpos() + CONSTRAINT_OFFSET;
    /* if there was a line drawn before */
    if(_oldLineX != -1)
    { /* remove the line */
      XDrawRectangle(XtDisplay(w),XtWindow(w), 
                _rubber_line_gc,
                x,y,_oldLineX,_oldLineY);
    } /* remove the line */
    _oldLineX = -1;
    _oldLineY = -1;
  } // stop drawing
  } // selected
}

void ConstraintEditor::drawBox(Widget w,XEvent * event)
{
  if(_selected)
  { // selected
  if((event->type == MotionNotify) &&
     ((event->xbutton.button == Button2) || 
      (event->xbutton.button == AnyButton)))
  { // start drawing

    /* if there was a line drawn before */
    if(_oldLineX != -1)
    { /* remove the line */
      XDrawRectangle(XtDisplay(w),XtWindow(w), 
                _rubber_line_gc,
                 _oldLineX,_oldLineY,
                _selected->getWidth(),_selected->getHeight());
    } /* remove the line */

    /* draw the new line */
    XDrawRectangle(XtDisplay(w),XtWindow(w), 
              _rubber_line_gc,
              event->xbutton.x,event->xbutton.y,
              _selected->getWidth(),_selected->getHeight());

    /* save end points of new line */
    _oldLineX = event->xbutton.x;
    _oldLineY = event->xbutton.y;
  } // start drawing
  if((event->type == LeaveNotify)&&
     ((event->xbutton.button == Button2) || 
      (event->xbutton.button == AnyButton)))
  { // stop drawing
    cout << "stop drawing" << endl;

    /* if there was a line drawn before */
    if(_oldLineX != -1)
    { /* remove the line */
      XDrawRectangle(XtDisplay(w),XtWindow(w), 
                _rubber_line_gc,
                 _oldLineX,_oldLineY,
                _selected->getWidth(),_selected->getHeight());
    } /* remove the line */
    _oldLineX = -1;
    _oldLineY = -1;
  } // stop drawing
  if((event->type == EnterNotify)&&
     ((event->xbutton.button == Button2) || 
      (event->xbutton.button == AnyButton)))
  { // start drawing
    cout << "start drawing" << endl;

    /* if there was a line drawn before */
    if(_oldLineX != -1)
    { /* remove the line */
      XDrawRectangle(XtDisplay(w),XtWindow(w), 
                _rubber_line_gc,
                 _oldLineX,_oldLineY,
                _selected->getWidth(),_selected->getHeight());
    } /* remove the line */

    /* draw the new line */
    XDrawRectangle(XtDisplay(w),XtWindow(w), 
              _rubber_line_gc,
              event->xbutton.x,event->xbutton.y,
              _selected->getWidth(),_selected->getHeight());

    /* save end points of new line */
    _oldLineX = event->xbutton.x;
    _oldLineY = event->xbutton.y;
  } // start drawing
  if((event->type == ButtonRelease)&&
     ((event->xbutton.button == Button2) || 
      (event->xbutton.button == AnyButton)))
  { // stop drawing
    cout << "stop drawing" << endl;
    /* if there was a line drawn before */
    if(_oldLineX != -1)
    { /* remove the line */
      XDrawRectangle(XtDisplay(w),XtWindow(w), 
                _rubber_line_gc,
                 _oldLineX,_oldLineY,
                _selected->getWidth(),_selected->getHeight());
    } /* remove the line */
    _oldLineX = -1;
    _oldLineY = -1;
  } // stop drawing
  } // selected
}

void ConstraintEditor::refreshCB(Widget w, 
                                  XtPointer client_data, 
                                  XtPointer call_data)
{
  ConstraintEditor * ce = (ConstraintEditor *) client_data;
  ce->update();
}

void ConstraintEditor::inputCB(Widget w, 
                                XtPointer client_data, 
                                XtPointer call_data)
{ 
  XmDrawingAreaCallbackStruct *cbs = (XmDrawingAreaCallbackStruct *) call_data;
  ConstraintEditor * ce = (ConstraintEditor *) client_data;

  // check which button has been pressed
  if((cbs->event->xany.type != ButtonPress) &&
     (cbs->event->xany.type != ButtonRelease))
    return;

  if(cbs->event->xany.type == ButtonPress)
  {
    switch(cbs->event->xbutton.button)
    {
    case 1:
      cout << "Button 1 at " << cbs->event->xbutton.x << ", " << cbs->event->xbutton.y << " pressed\n";
      if(ce->findSourceWidget(cbs->event->xbutton.x,cbs->event->xbutton.y))
        ce->startDraw(cbs->event->xbutton.x,cbs->event->xbutton.y);
      break;
    case 2:
      cout << "Button 2 at " << cbs->event->xbutton.x << ", " << cbs->event->xbutton.y << " pressed\n";
      if(ce->findWidget(cbs->event->xbutton.x,cbs->event->xbutton.y))
        ce->startMove(cbs->event->xbutton.x,cbs->event->xbutton.y);
      break;
    case 3:  
      cout << "Button 3 at " << cbs->event->xbutton.x << ", " << cbs->event->xbutton.y << " pressed\n";
      if(ce->findWidget(cbs->event->xbutton.x,cbs->event->xbutton.y))
        ce->startResize(cbs->event->xbutton.x+CONSTRAINT_OFFSET,
                        cbs->event->xbutton.y+CONSTRAINT_OFFSET);
      break;
    }
  }
  // must be a button release
  else{
    switch(cbs->event->xbutton.button)
    {
    case 1:
      cout << "Button 1 at " << cbs->event->xbutton.x << ", " << cbs->event->xbutton.y << " released\n";
      ce->startDraw(-1,-1);
      ce->attachSourceToTarget();
      break;
    case 2:
      cout << "Button 2 at " << cbs->event->xbutton.x << ", " << cbs->event->xbutton.y << " released\n";
      ce->moveWidget(cbs->event->xbutton.x,cbs->event->xbutton.y);
      ce->startMove(-1,-1);
      break;
    case 3:  
      cout << "Button 3 at " << cbs->event->xbutton.x << ", " << cbs->event->xbutton.y << " released\n";
      ce->resizeWidget(cbs->event->xbutton.x,cbs->event->xbutton.y);
      ce->startResize(-1,-1);
      break;
    }
  }
}

Boolean ConstraintEditor::findSourceWidget(int x, int y)
{
  XtCore * form = _guide->getSelectedWidget();
  vector<XtCore *> * list = NULL;
  int i = 0;
  Boolean found = False;

  if(form)
  {
    list = form->getList();
    for(i=0;i<(int)list->size();i++)
    {
      if((*list)[i]->isAt(x-CONSTRAINT_OFFSET,y-CONSTRAINT_OFFSET))
      {
        _sourceWidget = (*list)[i];
        _sourceWidget->findSelectedSide(x-CONSTRAINT_OFFSET,
                                        y-CONSTRAINT_OFFSET);
        _sourceWidget->drawSelected(_conDrawingArea,True);
        cout << "SOURCE " << _sourceWidget->getVarName() << " found" << endl;
        found = True;
        break;
      }
    } 
    if(!found)
    { /*  */ 
      _sourceWidget = NULL;
      _targetWidget = NULL;
    } /*  */ 
  }
  return found;
}

Boolean ConstraintEditor::findTargetWidget(int x, int y)
{
  XtCore * form = _guide->getSelectedWidget();
  vector<XtCore *> * list = NULL;
  int i = 0;
  Boolean found = False;
  Boolean validSide = False;
  
  if((form) && (_sourceWidget))
  { /* if form and a source is selected */
    list = form->getList();
    cout << "Looking for target..." << endl;
    for(i=0;i<(int)list->size();i++)
    { /* for each child of form */
      if((*list)[i]->isAt(x-CONSTRAINT_OFFSET,y-CONSTRAINT_OFFSET))
      { /* found possible target */
        _targetWidget = (*list)[i];

        if(_targetWidget != _sourceWidget)
        { /* valid target */ 

          _targetWidget->findSelectedSide(x-CONSTRAINT_OFFSET,
                                          y-CONSTRAINT_OFFSET);

          /* make sure this is a valid connection */
          switch(_targetWidget->getSelectedSide())
          { /*  */ 
            case top_selected_v:
              if((_sourceWidget->getSelectedSide() == top_selected_v) ||
                 (_sourceWidget->getSelectedSide() == bottom_selected_v))
                validSide = True;
              else
                validSide = False;
              break;
            case left_selected_v:
              if((_sourceWidget->getSelectedSide() == left_selected_v) ||
                 (_sourceWidget->getSelectedSide() == right_selected_v))
                validSide = True;
              else
                validSide = False;
              break;
            case right_selected_v:
              if((_sourceWidget->getSelectedSide() == left_selected_v) ||
                 (_sourceWidget->getSelectedSide() == right_selected_v))
                validSide = True;
              else
                validSide = False;
              break;
            case bottom_selected_v:
              if((_sourceWidget->getSelectedSide() == top_selected_v) ||
                 (_sourceWidget->getSelectedSide() == bottom_selected_v))
                validSide = True;
              else
                validSide = False;
              break;
            case none_selected_v:
                validSide = False;
              break;
          } /*  */  

          if(validSide == True)
          { /* a valid side was selected */ 
            _targetWidget->drawSelected(_conDrawingArea,True);

            cout << "TARGET " << _targetWidget->getVarName() 
                 << " found" << endl;
            found = True;
            break;
          } /* a valid side was selected */ 
          else
          { /* not a valid target */ 
          _targetWidget = NULL;
          } /* not a valid target */  
        } /* valid target */  
        else
        { /* continue search*/ 
          _targetWidget = NULL;
        } /* continue search*/ 
      } /* found possible target */
    } /* for each child of form */ 

    /* check for form attachment */
    _attachToForm = getFormAttachment(x-CONSTRAINT_OFFSET,
                                      y-CONSTRAINT_OFFSET);
  } /* if form and a source is selected */
  return found;
}

void ConstraintEditor::attachSourceToTarget(void)
{
  cout << "Trying to make attachment" << endl;
  if(_sourceWidget)
  {
    if(_targetWidget)
    {
      cout << "Both source and target exist " << endl;
      makeAttachment(_sourceWidget,_targetWidget);
      _targetWidget->setSelectedSide(none_selected_v);
      _targetWidget = NULL;
    }
    else
    {
      if(_attachToForm)
      { /* attach to form widgets border - Offset */
        makeAttachment(_sourceWidget,NULL);       
      } /* attach to form widgets border - Offset */
      else
      { /* no attachment */
        makeAttachment(_sourceWidget,NULL);       
        _sourceWidget->setSelectedSide(none_selected_v);
        _sourceWidget = NULL;
      } /* no attachment */
    }
  }
  update();
}

Boolean ConstraintEditor::findWidget(int x, int y)
{
  XtCore * form = _guide->getSelectedWidget();
  vector<XtCore *> * list = NULL;
  int i = 0;
  Boolean found = False;

  if(form)
  {
    list = form->getList();
    for(i=0;i<(int)list->size();i++)
    {
      if((*list)[i]->isAt(x-CONSTRAINT_OFFSET,y-CONSTRAINT_OFFSET))
      {
        _selected = (*list)[i];
        found = True;
        break;
      }
    } 
  }
  return found;
}

side_type_enum ConstraintEditor::getFormAttachment(int x, int y)
{
  XtCore * form = _guide->getSelectedWidget();

  if(x < 0)
    return left_selected_v;

  if(y < 0)
    return top_selected_v;

  if(x > form->getWidth() + CONSTRAINT_OFFSET)
    return right_selected_v;

  if(y > form->getHeight() + CONSTRAINT_OFFSET)
    return bottom_selected_v;

  return none_selected_v;
}

void ConstraintEditor::moveWidget(Position x, Position y)
{
  if(_selected)
  {
    _selected->moveTo(x-CONSTRAINT_OFFSET,y-CONSTRAINT_OFFSET);
    update();
  }
  _selected = NULL;
}

void ConstraintEditor::resizeWidget(int x, int y)
{
  if(_selected)
  {
    _selected->resizeTo(x - _selected->getXpos(),
                        y - _selected->getYpos());
    update();
  }
  _selected = NULL;
}

void ConstraintEditor::makeAttachment(XtCore *source, XtCore * target)
{
  int ac = 0;
  Arg al[6];
  Widget sw = source->getWidget();
  Widget tw = NULL;

  assert(source != NULL);

  if(target)
    tw = target->getWidget();

  cout << "ConstraintEditor::makeAttachment" << endl;
  switch(source->getSelectedSide())
  { /*  */
    case top_selected_v:
      /* if no target specified */
      if(target == NULL)
      { /* attache to form widget */ 
        switch(_attachToForm)
        { /*  */ 
          case top_selected_v:
            XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
            XtSetArg(al[ac],XmNtopOffset,_offset);ac++;
            cout << "Attach top source to top form" << endl;
          break;
          case none_selected_v:
            XtSetArg(al[ac],XmNtopAttachment,XmATTACH_NONE);ac++;
          break;
        } /*  */ 
      } /* attache to form widget */ 
      else
      { /* attach to target widget */
        switch(target->getSelectedSide())
        { /*  */ 
          case top_selected_v:
            XtSetArg(al[ac],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
            XtSetArg(al[ac],XmNtopOffset,_offset);ac++;
            XtSetArg(al[ac],XmNtopWidget,target->getWidget());ac++;
            cout << "Attach top source to top target" << endl;
          break;
          case bottom_selected_v:
            XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
            XtSetArg(al[ac],XmNtopOffset,_offset);ac++;
            XtSetArg(al[ac],XmNtopWidget,target->getWidget());ac++;
            cout << "Attach top source to bottom target" << endl;
          break;
        } /*  */ 
      } /* attach to target widget */
    break;
    case left_selected_v:
      /* if no target specified */
      if(target == NULL)
      { /* attache to form widget */ 
        switch(_attachToForm)
        { /*  */ 
          case left_selected_v:
            XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
            XtSetArg(al[ac],XmNleftOffset,_offset);ac++;
            cout << "Attach left source to left form" << endl;
          break;
          case none_selected_v:
            XtSetArg(al[ac],XmNleftAttachment,XmATTACH_NONE);ac++;
          break;
        } /*  */ 
      } /* attache to form widget */ 
      else
      { /* attach to target widget */
        switch(target->getSelectedSide())
        { /*  */ 
          case left_selected_v:
            XtSetArg(al[ac],XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
            XtSetArg(al[ac],XmNleftOffset,_offset);ac++;
            XtSetArg(al[ac],XmNleftWidget,target->getWidget());ac++;
            cout << "Attach right source to left target" << endl;
          break;
          case right_selected_v:
            XtSetArg(al[ac],XmNleftAttachment,XmATTACH_WIDGET);ac++;
            XtSetArg(al[ac],XmNleftOffset,_offset);ac++;
            XtSetArg(al[ac],XmNleftWidget,target->getWidget());ac++;
            cout << "Attach right source to right target" << endl;
          break;
        } /*  */ 
      } /* attach to target widget */
    break;
    case right_selected_v:
      /* if no target specified */
      if(target == NULL)
      { /* attache to form widget */ 
        switch(_attachToForm)
        { /*  */ 
          case right_selected_v:
            XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM);ac++;
            XtSetArg(al[ac],XmNrightOffset,_offset);ac++;
            cout << "Attach right source to right form" << endl;
          break;
          case none_selected_v:
            XtSetArg(al[ac],XmNrightAttachment,XmATTACH_NONE);ac++;
          break;
        } /*  */ 
      } /* attache to form widget */ 
      else
      { /* attach to target widget */
        switch(target->getSelectedSide())
        { /*  */ 
          case left_selected_v:
            XtSetArg(al[ac],XmNrightAttachment,XmATTACH_WIDGET);ac++;
            XtSetArg(al[ac],XmNrightOffset,_offset);ac++;
            XtSetArg(al[ac],XmNrightWidget,target->getWidget());ac++;
            cout << "Attach right source to left target" << endl;
          break;
          case right_selected_v:
            XtSetArg(al[ac],XmNrightAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
            XtSetArg(al[ac],XmNrightOffset,_offset);ac++;
            XtSetArg(al[ac],XmNrightWidget,target->getWidget());ac++;
            cout << "Attach right source to right target" << endl;
          break;
        } /*  */ 
      } /* attach to target widget */
    break;
    case bottom_selected_v:
      /* if no target specified */
      if(target == NULL)
      { /* attache to form widget */ 
        switch(_attachToForm)
        { /*  */ 
          case bottom_selected_v:
            XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_FORM);ac++;
            XtSetArg(al[ac],XmNbottomOffset,_offset);ac++;
            cout << "Attach bottom source to bottom form" << endl;
          break;
          case none_selected_v:
            XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_NONE);ac++;
          break;
        } /*  */ 
      } /* attache to form widget */ 
      else
      { /* attach to target widget */
        switch(target->getSelectedSide())
        { /*  */ 
          case top_selected_v:
            XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_WIDGET);ac++;
            XtSetArg(al[ac],XmNbottomOffset,_offset);ac++;
            XtSetArg(al[ac],XmNbottomWidget,target->getWidget());ac++;
            cout << "Attach top source to top target" << endl;
          break;
          case bottom_selected_v:
            XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
            XtSetArg(al[ac],XmNbottomOffset,_offset);ac++;
            XtSetArg(al[ac],XmNbottomWidget,target->getWidget());ac++;
            cout << "Attach top source to bottom target" << endl;
          break;
        } /*  */ 
      } /* attach to target widget */
    break;
  } /*  */
  
  if(ac)
  { /* something changed */ 
    XtSetValues(sw,al,ac);
    source->updateAttachments();
  } /* something changed */ 
}
