.TH XPLORE 1 "31 March 1997" "X Version 11"
.SH NAME
xplore \- yet another X11/Motif-based file manager

.SH SYNOPSIS
.B xplore
[\fIoptions\fP ...] [\fIdirectory\fP]
.sp
.SH DESCRIPTION
\fBXplore\fP is a Motif-based file manager which combines a directory tree
view a la Windows95(TM) Explorer, a ``shelf,'' kind of clipboard inspired by
the NeXT(TM) file manager, and user-definable push and drop actions as well as
an automounting facility a la \fBxfm/moxfm\fP. In addition, \fBxplore\fP also
provides a global command menu and a file popup menu which can be configured
for type-specific operations. All devices and file type information is
contained in a single configuration file. The configuration language has a
reasonable free-format syntax and supports C preprocessor commands, which
makes it possible to set up rather complex configurations with moderate
effort. A lot of other configuration options can be set via resources. Most of
these options can also be set interactively and saved to your personal X
resource file.
.PP
\fBXplore\fP is usually far more easy to use than this extensive manpage may
suggest. ;-) Most of the time you will simply drag around files or select
commands from popup menus. Occasionally, however, you might wish to make use
of \fBxplore\fP's more advanced operations and configuration options, which
are documented in the following.
.SH "OPTIONS"
If \fIdirectory\fP is specified, it denotes the name of the directory to be
displayed upon startup (default is usually the user's home directory or the
directory last visited when the \fBSave setup\fP command was used). Besides
the usual toolkit options, the following options are recognized (see also
Section \fICUSTOMIZATION\fP below):
.TP
.BI \-f " config-file"
Specify the name of the configuration file.
.TP
.BI \-m " magic-file"
Specify the name of the \fBmagic\fP file used to determine file types.
.TP
.BI \-o " cpp-options"
Specify the options to pass to the C preprocessor when parsing the
configuration file.
.TP
.BI \-r " res-file"
Specify the name of the personal resource file in which \fBxplore\fP saves
option settings.
.TP
.BI \-s " shelf"
Specify the name of the shelf to be selected initially (see \fIUSING THE
SHELF\fP).
.SH "USAGE"
We assume that the reader is familiar with the basic principles of using Motif
applications (if not please refer to the \fIOSF/Motif User's Guide\fP).
.PP
The main window of \fBxplore\fP is divided into three ``panes:'' the
\fIshelf\fP, which is used as a kind of clipboard, the \fItree pane\fP which
shows the directory tree and the \fIfile pane\fP which shows the contents of
the current directory (the name of which is displayed in the title bar of the
\fBxplore\fP window). Furthermore, at the bottom of the main window there is a
\fIstatus line\fP which displays useful information about the current
directory and automounted devices. The status line is also used temporarily to
give feedback for some operations, e.g., when copying or deleting files.
.PP
Files in the file pane are selected using the left mouse button (using any of
the selection techniques described in the Motif User's Guide), or the
\fBSelect\fP, \fBSelect all\fP and \fBInvert all\fP options of the \fBFile\fP
menu. The \fBFilter\fP option allows you to restrict the set of files shown in
the file pane to files matching a given pattern. The \fBSelect\fP and
\fBFilter\fP options accept a space-delimited list of filename patterns. The
usual wildcards, i.e., *, ? and character classes, are recognized. As one
expects, the remaining operations in the \fBFile\fP menu (\fBMove\fP,
\fBCopy\fP, \fBLink\fP, \fBDelete\fP, etc.) apply to the list of selected
files in the file pane.
.PP
Selected files can be dragged from the file pane with the middle mouse button
to the background of the file pane, as well as a directory in the file or tree
pane, to perform move, copy (press Ctrl while dragging) or link (press Shift +
Ctrl) actions. In an analogous manner you can also drag a directory from the
tree pane. Valid drop sites are indicated by showing the name of the
corresponding item in the status line. Dropping selected files on another
(non-directory) file executes the \fIdrop action\fP of that file, as
configured in the \fBxplorerc\fP file (see \fICUSTOMIZATION\fP below). If the
file has no associated drop action, but is an executable, it is invoked on the
selected files through the shell. Of course, files can also be transferred
between different \fBxplore\fP windows.
.PP
Pressing the right mouse button on a file in the file pane pops up a menu with
operations for that file (including type-specific commands as configured in
the \fBxplorerc\fP file). A double click with the left mouse button on a
directory icon in the file pane shows that directory in the file pane. Double
clicking on another file invokes the \fIpush action\fP of the file. In any
case, double clicking on a file is equivalent to the \fBOpen\fP command in the
\fBFile\fP menu. If a file has no associated push action, but is an
executable, it is invoked through the shell.
.PP
In the tree pane, a single click with the left mouse button is used to select
the current directory to be shown in the file pane. To expand/collapse a
subdirectory shown in the tree pane, click on the outline (arrowhead) symbol
in front of the corresponding directory icon.
.PP
\fBXplore\fP automatically updates the display of the panes in regular
intervals whenever directory contents change. To force such an update
immediately, use the \fBUpdate\fP option of the \fBView\fP menu. Automatic
updates can also be inhibited using the \fBAutomatic updates\fP option of the
\fBOptions\fP menu.
.PP
Many menu commands can also be activated using keyboard shortcuts. The
shortcut for a command is shown in the corresponding menu, with the notations
S-\fIX\fP, C-\fIX\fP and A-\fIX\fP meaning that you should press key \fIX\fP
along with the Shift, Ctrl or Alt modifier, respectively. The shortcuts can be
configured in \fBxplore\fP's application defaults file.
.SH "USING THE SHELF"
The shelf provides a kind of work area where the user can place (links to)
directories, applications and other files. It is also useful as a clipboard
for moving and copying files. \fBXplore\fP allows you to set up multiple
shelves for different purposes. The shelf is associated with a fixed directory
(usually \fB~/shelf\fP) which is created automatically at startup if it does
not yet exist. Inside the shelf directory there are different subdirectories
which correspond to the different shelves configured in the \fBxplorerc\fP
file. You can switch between shelves using a strip of tabs, which is usually
located right above the shelf pane.
.PP
The shelf functions pretty much like the file pane. A restricted set of file
commands is available in the \fBShelf\fP menu. The file popup menu can be used
on shelf items as usual. Furthermore, files can be double-clicked, selected
and dragged from the shelf, and the shelf can also be used as a drop site for
items dragged from the tree or file pane. The shelf differs from the file pane
in that directories, executables and symbolic links are treated
specially. When double-clicking on a directory in the shelf, the contents of
that directory are shown in the file pane. Executables in the shelf are
normally executed in the current directory shown in the file
pane. Furthermore, when a push, drop or menu action is invoked on a symbolic
link, the action applies to the directory or file pointed to rather than the
link itself.
.PP
These features turn the shelf into a useful repository for shortcuts to
frequently used files, directories and applications. For instance, you can
link the directories and documents you are currently working with to the shelf
and then open these items by simply double-clicking on the corresponding icon
in the shelf. Or you can add links to frequently used commands and then run
these command in the current directory with a single double-click.
.SH DEVICES
\fBXplore\fP includes an automounting facility which allows you to access
special ``devices'' in a transparent manner. For this purpose, mount and
unmount commands for the corresponding mount points can be configured in the
\fBxplorerc\fP file (see \fICUSTOMIZATION\fP). Whenever such a mount point is
accessed (e.g., by opening a directory contained in it, or by executing a copy
or move operation), \fBxplore\fP automatically carries out the corresponding
mount action for the device. When the device is no longer needed (e.g., after
having carried out the requested operation, after closing the last directory
on the device, or when exiting \fBxplore\fP), it is unmounted automatically.
.PP
Automounted devices are usually represented by corresponding icon gadgets in a
tiny panel on the right end of the status line, which provides a convenient
means to quickly check the status of these devices. The \fBxplorerc\fP file
specifies which devices will be represented, and which icons and labels are
used to indicate the devices. Unmounted devices are indicated by a stippled
label. Furthermore, ``premounted'' devices (i.e., devices which have already
been mounted by another program or the system, see below) are shown using a
special foreground color.
.PP
Note that a device remains mounted as long as the corresponding mount point is
visible in the file or tree pane (even if these panes are not currently
visible). Also note that \fBxplore\fP cannot automatically detect that the
user changes removable media like floppies and cdroms. Therefore, before
removing such media, you have to make sure that the corresponding device is
unmounted. For this purpose, \fBxplore\fP provides the \fBUnmount\fP (C-G) and
\fBUnmount all\fP (S-C-G) commands in the \fBView\fP which can be used to
explicitly unmount the file system currently shown in the file pane, or all
devices which have been automounted by \fBxplore\fP, respectively. After
changing media, you can use the \fBReread\fP (C-R) command of the \fBView\fP
menu to remount all devices and reread the contents of the panes.
.PP
\fBXplore\fP keeps track of the system's mount table, and will only mount
those devices which have not already been mounted by other programs in general
or other \fBxplore\fP windows in particular. Furthermore, each instance of
\fBxplore\fP will only try to unmount those file systems which it has actually
mounted successfully. If a mount or unmount operation fails, you are given the
option to retry, ignore or cancel the failed operation. If you ignore the
failed operation, \fBxplore\fP will pretend that the operation has
succeeded. You can then try to carry out the failed operation manually. In
particular, if you ignore a failed unmount operation, the corresponding file
system becomes ``premounted'' which means that you will have to unmount it
manually. You can also entirely turn off the checking of mount/unmount
operations, using the \fBCheck mounts\fP option of the \fBOptions\fP
menu. (Use this option with care, otherwise \fBxplore\fP may get confused
about the state of the file systems it manages.)
.SH "CUSTOMIZATION"
File types, automounted devices, shelves and the contents of the command menu
are configured in the \fBsystem.xplorerc\fP file which is installed in the
\fBxplore\fP library directory (usually something like
\fB/usr/lib/X11/xplore\fP). It can be overridden with a \fB.xplorerc\fP file
in the user's home directory or with the \fB-f\fP option. The syntax of the
\fBxplorerc\fP file is described in Section \fICONFIGURATION FILE\fP below.
.PP
File types are determined using magic headers, employing Juan D. Martin's
extension of the UNIX magic file format (the distribution also includes a tiny
program which can be used to check the magic type of a file; see
\fBxploretype\fP(1)). A suitable \fBmagic\fP file is installed along with
\fBsystem.xplorerc\fP in the \fBxplore\fP library directory. It can be
overridden with a \fB.magic\fP file in the user's home directory or with the
\fB-m\fP option. (On slow devices you might wish to turn off this feature,
using the \fBMagic headers\fP option in the \fBView\fP menu. Also, you can
disable the rescanning of directory contents for determining whether a
directory has been modified, using the \fBRescan files\fP option.)
.PP
A number of other options can be set using the \fBView\fP and \fBOption\fP
menus. Most of these should be self-explanatory. There are some options
affecting the current directory view (\fBSort by name\fP thru \fBMagic
headers\fP in the \fBView\fP menu). These options, as well as the \fBFilter\fP
command of the \fBFile\fP menu, only apply to the current
directory. Furthermore, subdirectories inherit these options from their
parents when they are opened (unless options are overridden by corresponding
device entries in the \fBxplorerc\fP file). All remaining options are
global. In particular, the \fBIcons\fP and \fBText\fP options of the
\fBView\fP menu can be used to change the type of view shown in the file
pane. The \fBShelf pane\fP, \fP Tree pane\fP and \fBFile pane\fP commands are
used to select the panes which are to be shown in the \fBxplore\fP main
window.
.PP
System-wide defaults for option values can be changed by editing the first
section of the \fBXplore\fP application defaults file; for personal
customization, you can change options using the \fBView\fP and \fBOptions\fP
menus and then save settings to your personal resource file with the \fBSave
setup\fP command of the \fBOptions\fP menu. This command saves the current
status of various option settings in the \fBView\fP and \fBOptions\fP menus
(including the view options of the current directory) as the new defaults in
the user's personal resource file, using the file name given by the \fB-r\fP
option or the \fBresfile\fP resource; the default is usually \fB.Xresources\fP
in the user's home directory. It also saves the geometry of the main window
and the panes, as well as the current directory and the selected
shelf. Furthermore, it updates the resource database by running the command
specified by the \fBrescmd\fP resource (\fBxrdb\fP(1) by default) on the
resource file. When this command is used for the first time, it adds a special
section to the resource file which is overwritten each time the command is
invoked; the remaining contents of the file are left unchanged.
.SH "MENU COMMANDS"
.sp
FILE MENU
.PP
File manipulation operations. These commands apply to the file pane.
.TP 4
.B Open
.br
Open the selected file (i.e., execute its push action).
.TP 4
.B Command
.br
Pops up a menu of global commands as configured in the \fBxplorerc\fP
file. (Clicking on the tear-off control at the top of the menu gives you a
kind of toolbar which is convenient if the command menu is accessed
frequently.)
.TP 4
.B Mkdir...
.br
Create a new directory.
.TP 4
.B Chdir...
.br
Change the current directory shown in the file pane. The new path may be
specified using an absolute path or a relative path w.r.t. the current
directory; \fB~\fP denotes the user's home directory.
.TP 4
.B Parent
.br
Go up one level to the parent of the current directory.
.TP 4
.B Home
.br
Go to the user's home directory.
.TP 4
.B Rename...
.br
Rename the selected file. (In fact this is nothing but a specialized form of
the \fBMove\fP command \- see below \- in which the current name of the file
is displayed as a default for the new name.)
.TP 4
.B Move...
.TP 4
.B Copy...
.TP 4
.B Link...
.br
Move, copy or link the selected files to the specified target. If multiple
files are selected then the target must be a directory. The target may denote
an absolute path or a relative path w.r.t. the current directory; \fB~\fP
denotes the user's home directory. Existing files of the same name are
overwritten or renamed, depending on the current status of the \fBBackups\fP
option (see OPTIONS MENU below). If the \fBConfirm overwrite\fP option is
enabled, the user is prompted for confirmation before an existing file is
overwritten or renamed.
.TP 4
.B Delete
.br
Remove the selected files. The user is prompted for confirmation if the
\fBConfirm delete\fP option is set. Confirmation for the deletion of
individual directories and files can be requested using the \fBConfirm delete
dir\fP and \fBConfirm delete file\fP options. Please note that this operation
is destructive, i.e., there is no provision for recovering the deleted files
later. As a safer alternative, you can use the trashcan shelf included in the
standard setup (see \fISTANDARD SETUP\fP below).
.TP 4
.B Properties...
.br
Displays the \fBProperties\fP dialog which allows you to view and change
attributes of the selected files (owner, group, permissions and such). Note
that changes to properties simultaneously apply to \fIall\fP selected
files. This allows you to change owner, permissions etc. for a whole
collection of files with one command. Also note that the permission toggles
cycle through \fIthree\fP states: set, unset and indeterminate. The
indeterminate state is used to indicate permissions which should be left
unchanged; it is also used initially for permissions which take on different
values for different files in the selection.
.TP 4
.B Filter...
.br
Specify a pattern of files to be shown in the file pane. The usual wildcards
(*, ?, character classes) are recognized, and multiple patterns can be
specified by delimiting the different patterns with whitespace. This operation
allows you to restrict the set of files shown in the file pane; the current
filter pattern is shown in the status line. Use the \fBClear\fP button in the
\fBFilter\fP dialog to remove the current filter pattern.
.TP 4
.B Select...
.br
Select a set of files in the file pane by specifying a filename pattern. The
\fBReplace\fP button is used to define a new selection. With the \fBAdd\fP and
\fPRemove\fP buttons, you can add files to or remove them from the current
selection, respectively.
.TP 4
.B Select all
.br
Select all files in the file pane (except the parent directory).
.TP 4
.B Invert all
.br
Invert the set of selected files in the file pane.
.TP 4
.B Quit
.br
Terminate \fBxplore\fP.
.PP
SHELF MENU
.PP
This menu provides some commands which are analogous to those of the
\fBFile\fP menu, but apply to the currently selected shelf.
.PP
VIEW MENU
.PP
Options and commands which affect the display of the panes.
.TP 4
.B Icons
.TP 4
.B Text
.br
Switch between icons and text display in the file pane. In icons view, the
files are represented using large icons, while in text view a list is shown
which consists of small icons and file attributes similar to \fBls -l\fP.
.TP 4
.B Shelf pane
.TP 4
.B Tree pane
.TP 4
.B File pane
.br
Select the panes to be shown in the main window.
.TP 4
.B Sort by name
.br
Sort files by name, with lexicographically smaller files first.
.TP 4
.B Sort by size
.br
Sort files by size, with larger files first.
.TP 4
.B Sort by date
.br
Sort files by date, with newer files first.
.TP 4
.B Reverse order
.br
Sort files in reverse order.
.TP 4
.B Directories first
.br
Specify whether directories should be listed first.
.TP 4
.B Show hidden files
.br
Specify whether hidden files (i.e., the ``dot'' files) should be displayed.
.TP 4
.B Show files
.TP 4
.B Show directories
.br
Specify whether files and/or directories should be displayed.
.TP 4
.B Show parent dir
.br
Specify whether to show the parent directory.
.TP 4
.B Rescan files
.br
If enabled then rescan directory contents in order to determine if a directory
has been changed.
.TP 4
.B Magic headers
.br
Use magic headers to determine file types. Disabling this option on slow
devices may considerably increase performance.
.TP 4
.B Update
.br
Force an immediate update of the panes.
.TP 4
.B Reread
.br
Force the contents of the panes to be reread. This command also remounts and
rereads the contents of directories which have previously been unmounted with
the \fBUnmount\fP and \fBUnmount all\fP commands (see below).
.TP 4
.B Unmount
.br
Unmount the file system currently shown in the file pane and update the panes
accordingly. Note that this only works for those ``automounted'' file systems
which are managed by \fBxplore\fP (see Section \fIDEVICES\fP).
.TP 4
.B Unmount all
.br
Unmount \fIall\fP automounted file systems and update the panes accordingly.
.PP
OPTIONS MENU
.PP
Global options which control the behaviour of various commands.
.TP 4
.B Absolute paths
.br
Determine whether paths in arguments to drop actions or in symbolic links
should be absolute or relative w.r.t. the directory in which the command is
invoked.
.TP 4
.B Push in current dir
.br
If enabled then push actions on (links to) executables in the shelf are
executed in the current directory instead of the shelf directory (or the
directory of the executable).
.TP 4
.B Drop in target dir
.br
If enabled then drop actions are executed in the directory containing the
target file. Otherwise they are executed in the directory containing the
dropped files.
.TP 4
.B Echo commands
.br
Echo commands in push, drop and mount actions which are invoked through the
shell. This allows you to trace the shell commands executed by \fBxplore\fP
which is particularly useful when debugging new configuration entries.
.TP 4
.B Check mounts
.br
This option controls whether \fBxplore\fP should report an error when a mount
or unmount action fails (indicated by a nonzero return code of the
action). Disabling this option can sometimes save trouble when \fBxplore\fP
tries to mount file systems which are already in use by other programs (see
the \fINOTES\fP section).
.TP 4
.B Backups
.br
If this option is enabled then \fBxplore\fP creates numbered backups of files
and directories which are to be replaced during a \fBMove\fP, \fBCopy\fP or
\fBLink\fP operation, in a manner similar to GNU \fBmv\fP with options \fB-b
-V numbered\fP.
.TP 4
.B Confirm drop
.TP 4
.B Confirm move
.TP 4
.B Confirm copy
.TP 4
.B Confirm link
.TP 4
.B Confirm delete
.br
Request confirmation for the corresponding operations.
.TP 4
.B Confirm delete dir
.TP 4
.B Confirm delete file
.br
Request extra confirmation when a directory or ordinary file is to be
deleted. The \fBCancel\fP button is used to abort the operation, while the
\fBAll\fP button allows to proceed without further confirmation.
.TP 4
.B Confirm overwrite
.br
Request extra confirmation when a file is to be overwritten or renamed
(depending on the status of the \fBBackups\fP option) in the course of a
\fBMove\fP, \fBCopy\fP or \fBLink\fP operation.
.TP 4
.B Confirm quit
.br
Request confirmation for the \fBQuit\fP command in the \fBFile\fP menu.
.TP 4
.B Automatic updates
.br
Enables or disables automatic updates of the panes.
.TP 4
.B Save setup
.br
Save the current status of various option settings in the \fBView\fP and
\fBOptions\fP menus, as well as the geometry of the main window and the panes,
and the name of the current directory and the selected shelf.
.TP 4
.B Reload configuration file
.br
Reloads both the \fBxplorerc\fP and the \fBmagic\fP file and updates the panes
accordingly.
.PP
HELP MENU
.PP
Currently the \fBHelp\fP menu contains only one option, \fBAbout\fP, which
pops up a message box with some version and copyright information about
\fBxplore\fP.
.PP
FILE POPUP MENU
.PP
Operations on a single file.
.PP
As already mentioned, this menu pops up when pressing the right mouse button
on a file in the file or shelf pane. It contains some entries from the
\fBFile\fP menu, as well as file type-specific commands configured in the
\fBxplorerc\fP file.
.SH "CONFIGURATION FILE"
The \fBxplorerc\fP configuration file consists of a sequence of sections in
the format described below. Whitespace outside of strings is ignored except if
it serves to delimit different keywords. Strings follow C-like syntax,
including the common escape conventions and the possibility to specify a
whitespace-delimited sequence of strings which is interpreted as the
concatenation of the given strings. The usual C preprocessor directives are
recognized as well, and comments may be specified using C syntax.
.IP "\fBDevice\fP \fIstring\fP [ , \fIstring\fP ] { \fIdevice-fields\fP }" 8
Defines a device that is to be mounted on the directory given by the first
\fIstring\fP argument. If specified, the second string denotes a label for the
device which is used for representing the device in the status line (see
\fIDEVICES\fP). Only devices for which a label is specified will be shown in
the status line. The commands to be executed for mounting and unmounting the
file system as well as other options are specified in the \fIdevice-fields\fP
list.
.IP "\fBShelf\fP { \fIshelf-fields\fP }" 8
Specifies the different shelves which can be accessed using the tabs above the
shelf pane. Each item specifies the name of a shelf and (optionally) the
corresponding subdirectory of the shelf directory.
.IP "\fBType\fP \fIstring-list\fP { \fItype-fields\fP }" 8
Specifies a file type. The magic key of the file (as specified in the
\fBmagic\fP file) and the filename is matched against the given
comma-separated list of pattern strings. The icons and actions defined for the
type are given in the \fItype-fields\fP list.
.sp
Each pattern consists of an optional magic pattern (enclosed in < >) and a
filename pattern. The usual wildcards, i.e., *, ? and character classes, are
recognized inside these patterns. If the current directory has magic headers
disabled the magic part of the pattern is ignored. The filename pattern can
also start with a path specification, meaning that the file only matches if it
is contained in the specified directory. No wildcards are recognized in the
path specification, but the tilde ~ may be used as an abbreviation for the
user's home directory.
.IP "\fBMagic\fP \fIpattern-list\fP { \fItype-fields\fP }" 8
Same as the \fBType\fP section, but patterns containing a magic part are only
matched when the current directory has magic headers enabled. Note that
special files (i.e. directories and executables) can only be matched by a
\fBMagic\fP pattern with nonempty magic part, to ensure consistent behaviour
between the magic and the non-magic mode of operation.
.IP "\fBDefault\fP { \fItype-fields\fP }" 8
Specifies the icons and actions for all files which do not match any of the
\fBType\fP and \fBMagic\fP sections.
.IP "\fBCommand\fP { \fIcommand-fields\fP }" 8
Specifies the contents of the \fBCommand\fP submenu.
.PP
The sections are considered in the order in which they are specified. In
particular, more specific file type patterns should come before more general
ones.
.PP
The following fields are recognized in a device specification:
.IP "\fBIcon\fP \fIstring\fP" 8
Specifies the name of a file in XPM format which denotes the icon used to
denote the device in the status line.
.IP "\fBMount\fP \fIstring\fP" 8
.IP "\fBUnmount\fP \fIstring\fP" 8
Specifies the command used to mount and unmount the device. As a special case,
if both these commands are empty or omitted, the entry denotes a ``pseudo
device'' which is ignored by the \fBUnmount all\fP command. Such pseudo
devices are used for the sole purpose of overriding general option settings
for some special directories.
.IP "\fBOptions\fP [+|-]\fIoption\fP [ , [+|-]\fIoption\fP ... ]" 8
Specifies the default view options used for the device. The following
\fIoption\fP keywords are recognized, with the equivalent options in the
\fBView\fP menu given in parentheses (cf. \fIMENU COMMANDS\fP above):
\fBSortByName\fP (Sort by name), \fBSortBySize\fP (Sort by size),
\fBSortByDate\fP (Sort by date), \fBReverse\fP (Reverse order),
\fBDirsFirst\fP (Directories first), \fBHidden\fP (Show hidden files),
\fBFiles\fP (Show files), \fBDirs\fP (Show directories), \fBUpdir\fP (Show
parent dir), \fBRescan\fP (Rescan files), \fBMagic\fP (Magic headers).
.sp
Option keywords prefixed with \fB+\fP or \fB-\fP denote options to be added to
or removed from the current option set, respectively; if more than one entry
for a given option is present, the last entry for that option in the list
takes precedence. It is possible to specify only prefixed options; in this
case the settings are taken relative to the current option settings (which are
usually inherited from the parent directory). For instance, an option list of
the form \fBOptions +Hidden\fP enforces that hidden files are displayed while
retaining all other option settings from the parent directory.
.PP
In the \fBShelf\fP section, the following fields are recognized:
.IP "\fBItem\fP \fIstring\fP [ , \fIstring\fP ]" 8
Specifies a shelf and its associated directory. The first string denotes the
label displayed on the corresponding tab, and the second string the
subdirectory of the shelf directory which is to be associated with this
shelf. If the second string is omitted, the directory name and label are
assumed to be identical.
.IP "\fBDefault\fP \fIstring\fP [ , \fIstring\fP ]" 8
Like the \fBItem\fP field, but denotes the shelf to be selected initially
(this setting can be overridden with the \fB-s\fP option or by setting the
\fBcurshelf\fP resource accordingly).
.PP
In a \fBType\fP or \fBMagic\fP section, as well as in the \fBDefault\fP
section, the following fields are recognized:
.IP "\fBComment\fP \fIstring\fP" 8
Specifies a description to be displayed in the properties dialog for files of
this type.
.IP "\fBLargeIcon\fP \fIstring\fP" 8
Specifies the name of a file in XPM format which denotes the large icon used
to display the file.
.IP "\fBSmallIcon\fP \fIstring\fP" 8
Specifies the name of a file in XPM format which denotes the small icon used
to display the file.
.IP "\fBPush\fP \fIstring\fP [ , \fIstring\fP ]" 8
Specifies the push action associated with the file. The second string argument
is optional; if it is present, it denotes the directory in which the command
is to be invoked.
.IP "\fBDrop\fP \fIstring\fP [ , \fIstring\fP ]" 8
Specifies the drop action associated with the file. The second string argument
is optional; if it is present, it denotes the directory in which the command
is to be invoked.
.IP "\fBItem\fP \fIstring\fP, \fIstring\fP [ , \fIstring\fP ]" 8
Specifies a type-specific item in the popup menu for files belonging to the
type. The first string argument denotes the label to display in the popup
menu. The second string argument specifies the action to execute. The third
string argument is optional; if it is present, it denotes the directory in
which the command is to be invoked.
.IP "\fBSeparator\fP" 8
Adds a separator to the popup menu for the file type.
.PP
The \fBCommand\fP section is like a file type section, but only \fBItem\fP and
\fBSeparator\fP fields are allowed. Each item specifies an entry of the
\fBCommand\fP submenu of the \fBFile\fP menu.
.PP
A sample configuration making use of the features described above (including
the extensive use of C preprocessor directives) can be found in the
distributed \fBsystem.xplorerc\fP file. You will probably wish to edit this
file to reflect your system configuration and preferences.
.SH "ACTIONS"
Commands invoked through push and drop actions, mount actions, the
\fBCommand\fP submenu and the file popup menu are executed using the shell (as
given by the \fBSHELL\fP environment variable). \fBXplore\fP waits for the
command to finish and then updates the display, unless the command is executed
in the background (using the shell's \fB&\fP operator). The command is echoed
to stdout when the \fBEcho commands\fP option of the \fBOptions\fP menu is
enabled. Mount actions are invoked in the directory in which \fBxplore\fP was
started. Commands from the \fBCommand\fP submenu and the file popup menu are
executed in the current directory, with positional parameters $1, $2, ... set
to the currently selected files. $* may be used to denote the list of all
selected files.
.PP
Push actions on executables in the shelf are invoked in the current directory
(instead of the shelf directory) when the \fBPush in current dir\fP option is
enabled, which is the default. In the case of a drop action, the command is
executed in the directory containing the target file, if the \fBDrop in target
dir\fP option is enabled, and in the directory containing the dropped files
otherwise. The latter is the default setting. For the default drop action on
an executable, the positional parameters are simply set to the list of dropped
files. Otherwise, the first positional parameter is set to the target of the
drop action (i.e., the name of the file onto which the selection was dropped),
and the remaining parameters are set to the list of dropped files.
.PP
The directory in which a command is invoked can be overridden with an
appropriate setting in the corresponding action in the \fBxplorerc\fP
file. The selected files are specified using absolute pathnames if the
\fBAbsolute paths\fP option is enabled, and using pathnames relative to the
directory in which the command is executed otherwise. This is true for
\fBLink\fP commands as well; thus a link action will produce links to absolute
or relative pathnames, depending on the status of the \fBAbsolute paths\fP
option.
.PP
For all types of actions the environment variables \fBCURDIR\fP and
\fBCURSHELF\fP are set to the pathnames of the current directory and the
current shelf, respectively. This is useful, e.g., if you set up actions which
have to access these directories explicitly.
.PP
\fBXplore\fP lets you prompt the user for additional parameters when a command
is invoked. In such a case a dialog form appears with one field for each
parameter, into which the user can enter the required arguments. Currently, no
checking is done on the supplied parameters; in fact, the user can simply
leave all fields empty. Parameters are specified in action strings using the
format %\fIparameter-name\fP% where \fIparameter-name\fP is an arbitrary text
not containing the % character. The given text will be displayed in the dialog
form, and the parameter will be replaced with the corresponding value entered
by the user. (A literal % character can be escaped with two backslashes.)
.PP
A default value for a parameter can be specified using the notation
%\fIparameter-name\fP--\fIdefault-value\fP%. The given value will be used as
the initial contents of the corresponding input field. Furthermore, there are
two special constructs for denoting non-input fields. The notation %--%
inserts a separator in the parameter dialog, and the construct %-\fIlabel\fP%
adds a label with the given text on a line by itself. These constructs are
simply replaced by empty strings during parameter substitution.
.SH "STANDARD SETUP"
As already indicated, the distribution includes a sample configuration which
you can customize according to your needs. When \fBxplore\fP is invoked for
the first time, it automatically runs the \fBsetup\fP script in the
\fBxplore\fP library directory which installs a shelf directory in the user's
home directory. The distributed shelf directory contains a \fBDesk\fP shelf
which provides some links to devices, a clipboard and a trashcan. Both the
clipboard and the trashcan are simply links to other shelves which can also be
accessed with the \fBClipboard\fP and \fBTrash\fP tabs. Thus no special
built-in operations are needed to implement these facilities. The standard
setup also includes a \fBPrograms\fP shelf with links to some applications,
and a configuration file which contains some sample device descriptions, a lot
of useful file type definitions and a command menu with common operations. The
options of the command menu, as it is defined in the distributed
\fBsystem.xplorerc\fP file, are described below.
.TP 4
.B Bookmark
.br
Put a symbolic link to the current directory into the current shelf.
.TP 4
.B Install...
.br
Locate an application (given by the name of the program) using \fBwhich\fP(1)
and put a symbolic link to it into the current shelf. This option provides a
convenient method to quickly install a shortcut for an application on the
shelf.
.TP 4
.B Editor
.br
Invoke the editor (\fBemacs\fP(1) by default) in the current directory.
.TP 4
.B Calculator
.br
Invoke the calculator (\fBxcalc\fP(1)).
.TP 4
.B Manual
.br
Read manual pages (\fBxman\fP(1)).
.TP 4
.B Xterm
.br
Start an \fBxterm\fP(1) in the current directory.
.TP 4
.B Find...
.br
Invoke the \fBfind\fP(1) program on the current directory. The results are
displayed using \fBxless\fP(1).
.TP 4
.B Grep...
.br
Run \fBgrep\fP(1) on the selected files, display results using \fBxless\fP.
.TP 4
.B Diff
.br
Run \fBdiff\fP(1) on two selected files, display results using \fBxless\fP.
.TP 4
.B Shell command...
.br
Invoke a shell command in the current directory, with the positional
parameters set to the currently selected files.
.TP 4
.B Make...
.br
Invoke \fBmake\fP(1) on the specified target in the current directory.
.TP 4
.B Tar...
.TP 4
.B Tar gzipped...
.TP 4
.B Tar compressed...
.br
Create a new \fBtar\fP(1) file (with compression using \fBgzip\fP(1) or
\fBcompress\fP(1)) from the selected files.
.TP 4
.B Zip...
.br
Create a \fBzip\fP(1) archive from the selected files.
.TP 4
.B Gzip
.TP 4
.B Compress
.br
Compress the selected files using \fBgzip\fP(1) or \fBcompress\fP(1).
.TP 4
.B Uuencode
.br
Encode the selected files using \fBuuencode\fP(1).
.SH "ICONS"
\fBXplore\fP supports icons in Arnaud Le Hors' XPM format. A collection of
file and application icons is included in the distribution; it is installed in
the \fBxplore\fP library directory. The icon files are located using the
search path given by the \fBiconpath\fP resource in the \fBXplore\fP
application defaults file.
.SH "ENVIRONMENT"
\fBXplore\fP depends on the proper setting of two environment variables,
\fBHOME\fP which denotes the user's home directory, and \fBSHELL\fP, which
indicates the shell to be used for executing commands. When a command is
invoked through the shell, the environment variables \fBCURDIR\fP and
\fBCURSHELF\fP are set to the pathnames of the current directory and the
current shelf, respectively.
.PP
In addition, the \fBXPLORELIBDIR\fP environment variable can be used to denote
an alternative path to the \fBxplore\fP library directory, which is convenient
for the purpose of testing alternative setups or for relocating the library
directory without having to recompile the program. If this variable is not set
in \fBxplore\fP's environment, \fBxplore\fP sets it to the built-in library
path. Thus actions in the configuration file can rely on the proper setting of
this variable, which is useful, e.g., if actions access scripts in the library
directory.
.SH "FILES"
Following is a typical list of files and directories used by \fBxplore\fP
according to the standard setup. Please note that the path to the X library
directory may be different on your system, and that the actual names and
locations of the personal configuration files depend on your local setup.
.TP
.B /usr/lib/X11/xplore/system.xplorerc
System-wide configuration file.
.TP
.B /usr/lib/X11/xplore/magic
System-wide magic file.
.TP
.B /usr/lib/X11/xplore/shelf
Sample shelf directory.
.TP
.B /usr/lib/X11/xplore/icons
Standard location for icons in XPM format used by \fBxplore\fP.
.TP
.B ~/.xplorerc
Personal configuration file.
.TP
.B ~/.magic
Personal magic file.
.TP
.B ~/shelf
Personal shelf directory.
.TP
.B ~/.Xresources
Personal resource file used to save option values.
.SH "NOTES"
This section discusses some common pitfalls you may encounter when using
\fBxplore\fP.
.PP
It is not possible to drag the root directory from the tree pane. In order to
create a link to the root directory, you must therefore use a shell command.
.PP
Drop actions are carried out asynchronously in the destination instance of
xplore. Thus when files are moved by dragging them to a second xplore window,
the window from which the files were dragged may not be updated
immediately. You can use the \fBUpdate\fP (C-U) command to force an update of
the source window in such circumstances.
.PP
Some devices (like, e.g., msdos filesystems under Linux) require that the
\fBRescan\fP option is set (\fBDevice\fP section in \fBxplorerc\fP), otherwise
directory contents may not be updated properly.
.PP
The default mount actions for devices in the \fBsystem.xplorerc\fP file assume
the \fBmount\fP(8) and \fBumount\fP(8) commands which on many systems are only
accessible to root. Thus you might have to replace these commands in the
\fBxplorerc\fP file by something which can be used by an ordinary user.
.PP
Mount/unmount actions are invoked in the directory in which \fBxplore\fP was
started. Thus you should make sure that this directory exists through the
entire session (otherwise \fBxplore\fP will keep complaining that it cannot
chdir to the startup directory and will be unable to execute mount and unmount
actions). The best idea is to start xplore from your home directory which
presumably will exist for a long time. ;-)
.PP
The automounting facility is still a bit experimental, and in fact I don't
know whether it works on anything else but Linux. Please let me know if you
run into any problems. If all else fails, you may disable this feature (by
commenting out the \fBDevice\fP sections in the \fBxplorerc\fP file) and try
running a more comprehensive utility like, e.g., AMD (available from
sunsite.unc.edu).
.PP
\fBXplore\fP saves options by writing them to your personal resource file. You
should make sure that this file is merged into your resource database when you
start up X, otherwise \fBxplore\fP will not be able to use the modified option
settings after restarting X. The default resource file name
is \fB.Xresources\fP, which seems to be appropriate for most X-based systems.
On some systems, however, the personal resource file may have a different name
(for instance, SUN's OpenLook uses a file named \fB.Xdefaults\fP), and thus
you might have to change the value of the \fBresfile\fP resource in
\fBxplore\fP's application defaults file accordingly.
.PP
Filenames containing embedded whitespace often cause problems when replaced
for positional parameters in drop actions executed through the shell. This is
actually due to the way in which these parameters are expanded by the shell
and hence there seems no way around this in the current version. Note that
filenames containing special characters are treated properly as far as the
built-in operations are concerned.
.PP
Since parameter passing conventions depend on the shell, \fBxplore\fP performs
an automatic test at startup which tries to determine whether your shell
passes its name as the zeroth argument to a command invoked using the \fB-c\fP
option. This test may fail, e.g., if your shell's initialization files write
to standard output. If this happens, you should set the \fBBourneShells\fP
resource in the \fBXplore\fP application defaults file to a list of
Bourne-compatible shells on your system.
.PP
\fBXplore\fP catches the TERM signal to gracefully terminate the program and
unmount all automounted file systems. However, many window and session
managers simply kill their client applications when exiting X, leaving their
clients without a chance to terminate in a decent manner. Therefore it might
be necessary to explicitly quit \fBxplore\fP or unmount mounted file systems
using the \fBUnmount all\fP command before exiting X.
.PP
Programs started by \fBxplore\fP inherit their standard output and error
streams from \fBxplore\fP. Therefore, if you start \fBxplore\fP from your
session or window manager instead of an xterm, you should redirect
\fBxplore\fP's standard output and error to something which you can read while
\fBxplore\fP is running, if the window manager does not already do that for
you. Usually, you will reassign both \fBstdout\fP and \fBstderr\fP to
\fB/dev/console\fP, using the command:
.sp
.nf
xplore >/dev/console 2>&1
.fi
.sp
Then you can read error messages and other output produced by launched
applications in the console window on your desktop (such as \fBxconsole\fP(1)
or \fBxterm -C\fP).
.SH "SEE ALSO"
\fBmoxfm\fP(1), \fBxfm\fP(1), \fBxploretype\fP(1), \fBmagic\fP(5)
.SH "AUTHOR"
Albert Graef, with portions of code from \fBxfm\fP (written by Simon Marlow
and Albert Graef, with contributions from numerous other people), \fBmoxfm\fP
(written by Oliver Mai, based on \fBxfm\fP), and \fBxfsm\fP (the X file system
monitor, written by Robert Gasch). The magic headers code and the shell auto
detection feature have been written for \fBxfm\fP by Juan D. Martin and Robert
Vogelgesang, respectively.
