
/* interface.h: user interface **********************************************/

#ifndef INTERFACE_H
#define INTERFACE_H

#include "xplore.h"
#include "dirs.h"

/* application context, shell and display: */

extern XtAppContext app;
extern Widget app_shell;
extern Display *display;

/* widgets in the main window */

extern Widget main_window, menubar, form, shelf_tabs, work_area, file_view,
file_pane, file_scroll, tree_pane, tree_scroll, shelf_pane, shelf_scroll,
status_line, message_frame, message, indicators_frame, indicators, curgadget;

/* the menu bar */

extern Widget file_pulldown, view_pulldown, options_pulldown, help_pulldown;
extern Widget command_pulldown, shelf_pulldown;

/* file popup */
extern Widget file_popup;

/* cascade buttons */
extern Widget file_button, view_button, options_button, help_button;
extern Widget command_button, shelf_button;

/* file menu */
extern Widget open_button, mkdir_button, chdir_button, parent_button,
home_button, rename_button, move_button, copy_button, link_button,
delete_button, properties_button,
filter_button, select_button, select_all_button, invert_all_button,
quit_button;

/* command menu */
extern Widget *command_menu_button;
extern int command_menu_size;

extern Widget shelf_open_button, shelf_rename_button, shelf_move_button,
shelf_copy_button, shelf_link_button, shelf_delete_button,
shelf_properties_button, shelf_select_button, shelf_select_all_button,
shelf_invert_all_button;

/* view menu */
extern Widget icons_button, text_button, tree_pane_button, file_pane_button,
shelf_pane_button, shelf_button,
sort_by_name_button, sort_by_size_button, sort_by_date_button,
reverse_button, dirs_first_button,
show_hidden_button, show_parent_dir_button,
show_files_button, show_dirs_button,
rescan_files_button, magic_headers_button,
update_button, reread_button, unmount_button, unmount_all_button;

/* options menu */
extern Widget absolute_paths_button, target_dir_button, push_dir_button,
echo_commands_button, check_mounts_button, backups_button,
auto_updates_button,
confirm_drop_button, confirm_move_button, confirm_copy_button,
confirm_link_button, confirm_delete_button, confirm_deldir_button,
confirm_delfile_button, confirm_overwrite_button, confirm_quit_button,
save_setup_button, reload_config_button;

/* help menu */
extern Widget about_button;

/* wait cursor */
extern Cursor wait_cursor;

/* global resource values: */

extern String progname;        /* name of program */

extern char magicfile[];       /* name of user's magic file */
extern char configfile[];      /* name of user's config file */
extern char resfile[];         /* name of X resource file */
extern String rescmd;          /* merge X resource file into database */
extern String curshelf;	       /* default shelf */
extern String cpp_options;     /* options to pass to the C preprocessor */
extern String iconpath;        /* search path for pixmaps */
extern String sh_list;         /* value of bourneShells resource */

extern unsigned char keyboardFocusPolicy;

extern char rootdirname[];     /* base directory of tree pane */
extern char curdirname[];      /* current directory in file pane */
extern char shelfdirname[];    /* the shelf directory */

extern Boolean show_getwd;     /* show getwd in window title */
extern int update_time;        /* update cycle in milliseconds */
extern Boolean updates;        /* automatic updates enabled? */

typedef enum _ViewType {
    IconView, TextView,
} ViewType;

extern ViewType viewtype;      /* current view type */
extern Boolean filepane;       /* whether or not the file pane is shown */
extern Boolean treepane;       /* whether or not the tree pane is shown */
extern Boolean shelfpane;      /* whether or not the shelf is shown */

extern Boolean absolute;       /* enable/disable absolute paths */
extern Boolean dirtarget;      /* do drop action in target dir? */
extern Boolean pushdir;        /* do push action in current dir? */

extern Boolean                 /* enable/disable confirmation options */
confirm_drop,
confirm_move,
confirm_copy,
confirm_link,
confirm_delete,
confirm_deldir,
confirm_delfile,
confirm_overwrt,
confirm_quit;

/* update timer id */

extern XtIntervalId timer_id;

/* source directory in a tree drag operation */

extern DirPtr tree_drag_dir;

/* routines for managing the application */

void init_app(int argc, char **argv);
/* initialize the application */

void create_app(void);
/* create the application widgets */

void run_app(void);
/* run the application */

void exit_app(int val);
/* exit the application */

void reinit(void);
/* reinitialize after configuration has been reread */

/* hide and show the panes */

void HideTreePane(void);
void ShowTreePane(void);

void HideFilePane(void);
void ShowFilePane(void);

void HideShelfPane(void);
void ShowShelfPane(void);

void UpdatePanes(Boolean do_shelf, Boolean do_tree, Boolean do_file,
		 Boolean save_shelf, Boolean save_tree, Boolean save_file);

/* expand/collapse an item in the tree pane */

void Expand(Widget w);
void Collapse(Widget w);

/* status line */

void UpdateStatusLine(void);
void RestoreStatusLine(void);
void StatusMessage(String msg);

#endif /* INTERFACE_H */
