
! Xplore application defaults file
! 03-09-96, revised 03-31-97 AG

! application-specific resources: *****************************************

! Note that most of the following resources can also be set interactively
! and be saved to your personal resources file which will override the
! settings in this file (see the xplore(1) man page).

! base directory of the tree pane (default: /)
?.rootdir:		/

! directory initially shown in the file pane (default: ~; . specifies the
! directory in which xplore is invoked); this *must* be a subdirectory of
! rootdir
?.curdir:		~

! shelf directory (default: ~/shelf)
?.shelfdir:		~/shelf

! shelf to be shown initially (this is commented out to denote the default
! which is the shelf marked as "Default" in the xplorerc file; can also be
! set using the -s command line option)
!?.curshelf:		Desk

! path to search for pixmaps
?.iconpath:		XPLORELIBDIR/icons

! user-specific magic and configuration file loaded at startup; command line
! options -m and -f
?.magicfile:		~/.magic
?.configfile:		~/.xplorerc

! resource file for Save setup command (-r command line option)
?.resfile:		~/.Xresources

! command to merge the resource file into the database (must contain exactly
! one %s specifier which is replaced by the resource file name given by the
! resfile resource)
?.rescmd:		xrdb -merge %s

! options to pass to the C preprocessor when parsing the config file (-o
! command line option)
?.cppoptions:		-I XPLORELIBDIR

! list of Bourne-compatible shells (only needed when shell test at startup
! fails)
!?.bourneShells:	AUTO
!?.bourneShells:	/bin/sh /bin/bash

! list of shell metacharacters which cause parameters in echoed commands to be
! quoted; the following should do for most shells
! NOTE: this is only for cosmetic purposes; it does not change the way in
! which parameters are actually passed to the shell
?.metachars:		\ \	\n'"`$|&;()<>

! show "real" name of current directory (as returned by getwd) in title bar
! (default: True)
?.getwd:		True

! multiclick time in milliseconds (default: 300)
?.multiclick:		300

! update cycle in milliseconds for the directory view (default: 10000; set to
! zero to completely disable automatic updates)
?.update:		10000

! enable automatic updates (default: True)
?.updates:		True

! default view type for directory displays; recognized values are Icons
! (default) and Text
?.view:			Icons

! specify the panes to show in the main window (default: all); these all
! belong to class Panes (i.e., the following is equivalent to ?.Panes: True)
?.tree:			True
?.file:			True
?.shelf:		True

! enable various items in the directory display (class Items)
?.updir:		True
?.hidden:		False
?.files:		True
?.dirs:			True

! list subdirectories first in directory display (default)
?.dirsfirst:		True

! sort type for directory displays; recognized values are ByName (default),
! BySize and ByDate
?.sort:			ByName

! sort files in reverse order (default: disabled)
?.reverse:		False

! rescan all files in the directory to check whether directory contents
! has changed, and enable magic headers (both enabled by default)
?.rescan:		True
?.magic:		True

! determine whether mount/umount errors should be handled (default: True)
?.check:		True

! determine whether pathnames in selections are specified as relative or
! absolute pathnames (default: False)
?.absolute:		False

! determine whether push actions on executables in the shelf should be
! invoked in the current directory (True, default) or in the shelf
?.pushdir:		True

! determine whether drop actions should be invoked in the target directory
! (True) or in the directory containing the dropped files (default: False)
?.dirtarget:		False

! echo commands (default: False)
?.echo:			False

! create backups of files to be overwritten (default: True)
?.backups:		True

! confirmation for various operations (class Confirm; all enabled by default)
?.drop:			True
?.move:			True
?.copy:			True
?.link:			True
?.delete:		True
?.deldir:		True
?.delfile:		True
?.overwrt:		True
?.quit:			True

! application widget resources **********************************************

! make sure to specify some reasonable minimum window size
?.minHeight: 300
?.minWidth: 400

! keyboard focus policy (default: XmEXPLICIT); set this resource to XmPOINTER
! to disable keyboard navigation
?.keyboardFocusPolicy: XmEXPLICIT

! orientation and positioning of the panes
*work_area.orientation: XmVERTICAL
*shelf_pane.positionIndex: 0
*file_view.positionIndex: 1
*file_view.orientation: XmHORIZONTAL
*tree_pane.positionIndex: 0
*file_pane.positionIndex: 1

! appearance of the shelf tabs (location: 0 = top, 1 = bottom, 2 = left,
! 3 = right; shape: 0 = chamferred, 1 = slanted)
*shelf_tabs.tabLocation: 0
*shelf_tabs.tabShape: 1

! dialog input fields
*XmMessageBox*Line*Input*background: RosyBrown2

! file view frame
*frame.shadowType: XmSHADOW_OUT
*frame.shadowThickness: 1

! default sizes
*shelf_pane.width: 620
*shelf_pane.height: 70
*file_view.height: 386
*tree_pane.width: 250
*tree_pane.height: 380
*file_pane.width: 350
*file_pane.height: 380

! status line
*message_frame.shadowType: XmSHADOW_IN
*message_frame.shadowThickness: 1
*indicators_frame.shadowType: XmSHADOW_IN
*indicators_frame.shadowThickness: 1
*indicators.height: 16

! tree container
*tree_scroll.outlineIndentation: 20
*tree_scroll.OutlineButton.shadowThickness: 0

! file container
*file_scroll_icons.marginWidth: 5
*file_scroll_icons.marginHeight: 5
*file_scroll_icons.XmIconGadget.borderWidth: 5
*file_scroll_icons.largeCellWidth: 64
*file_scroll_text.detailTabList: +2cm,+2cm,+2cm,+3cm,+6cm

! shelf container
*shelf_scroll.marginWidth: 5
*shelf_scroll.marginHeight: 5
*shelf_scroll.file_icon.borderWidth: 5
*shelf_scroll.largeCellWidth: 64

! labels for dummy entries
*unreadable.labelString: <DIRECTORY IS UNREADABLE>
*subdir.labelString: <SUBDIR>
*empty.labelString: 

! make the dummy entries insensitive s.t. they cannot be selected or activated
*unreadable.sensitive: False
*subdir.sensitive: False
*empty.sensitive: False

! dialog resources
*Line.Label.alignment: XmALIGNMENT_END
*Line.Input.columns: 40
*Line.Input.leftOffset: 0.5cm
*Line.Value.columns: 40
*Line.Value.leftOffset: 0.5cm
*Line.Button.leftOffset: 0.5cm

! colors

!*foreground: black
!*background: slate gray
*background: #c0c0c0

!*highlightColor: black
*highlightThickness: 1

! shelf tab colors
!*shelf_tabs.tabColor: gray
!*shelf_tabs.selectedTabColor: light gray

! icon gadget text colors

*file_icon.foreground: black
*file_link_icon.foreground: maroon
*file_link_bad_icon.foreground: dark slate grey
*dir_icon.foreground: black
*dir_up_icon.foreground: black
*dir_link_icon.foreground: maroon
*exec_icon.foreground: black
*exec_link_icon.foreground: maroon

! you can also specify different colors for the individual panes like this:
!*shelf_scroll.XmIconGadget.foreground: black

! highlight premounted devices in the status line
*status_line*indicators.highlightColor: maroon

! fonts

! menubar
*menubar*fontList:			-adobe-helvetica-bold-r-*-*-14-*
*menubar*XmRowColumn*fontList:		-adobe-helvetica-bold-r-*-*-12-*

! shelf tabs
*shelf_tabs.fontList:			-adobe-helvetica-bold-r-*-*-12-*

! file popup
*XmContainer*file_popup*fontList:	-adobe-helvetica-medium-r-*-*-12-*

! dialogs
!*XmMessageBox*Message*fontList:	-adobe-helvetica-bold-r-*-*-12-*
*XmMessageBox*Label*fontList:		-adobe-helvetica-bold-o-*-*-12-*
*XmMessageBox*Line*Label*fontList:	-adobe-helvetica-bold-r-*-*-12-*
*XmMessageBox*Line*Input*fontList:	-adobe-helvetica-medium-r-*-*-12-*
*XmMessageBox*Line*Value*fontList:	-adobe-helvetica-medium-r-*-*-12-*
*XmMessageBox*Line*Button*fontList:	-adobe-helvetica-medium-r-*-*-12-*
*XmMessageBox*fontList:			-adobe-helvetica-medium-r-*-*-12-*
*XmPushButtonGadget*fontList:		-adobe-helvetica-medium-r-*-*-12-*

*param_dlg*Label*fontList:		-adobe-helvetica-medium-r-*-*-12-*
*param_dlg*Line*Label*fontList:		-adobe-helvetica-bold-r-*-*-12-*
*param_dlg*Line*Input*fontList:		-adobe-helvetica-medium-r-*-*-12-*
*param_dlg*Line*Value*fontList:		-adobe-helvetica-medium-r-*-*-12-*

! panes
*XmContainer*fontList:			-adobe-helvetica-medium-r-*-*-10-*

! status line
*status_line*XmLabelGadget*fontList:	-adobe-helvetica-medium-r-*-*-10-*
*status_line*XmIconGadget*fontList:	-adobe-helvetica-medium-r-*-*-10-*

! dialog titles

*confirm_drop_dlg_popup.title:		Confirm
*confirm_move_dlg_popup.title:		Confirm
*confirm_copy_dlg_popup.title:		Confirm
*confirm_link_dlg_popup.title:		Confirm
*confirm_delete_dlg_popup.title:	Confirm
*confirm_overwrite_dir_dlg_popup.title:	Confirm
*confirm_overwrite_file_dlg_popup.title:Confirm
*confirm_rename_dir_dlg_popup.title:	Confirm
*confirm_rename_file_dlg_popup.title:	Confirm
*confirm_delete_dir_dlg_popup.title:	Confirm
*confirm_delete_file_dlg_popup.title:	Confirm
*confirm_quit_dlg_popup.title:		Confirm
*mount_dlg_popup.title:			Mount
*umount_dlg_popup.title:		Unmount
*mkdir_dlg_popup.title:			Mkdir
*chdir_dlg_popup.title:			Chdir
*rename_dlg_popup.title:		Rename
*move_dlg_popup.title:			Move
*copy_dlg_popup.title:			Copy
*link_dlg_popup.title:			Link
*props_dlg_popup.title:			Properties
*filter_dlg_popup.title:		Filter
*select_dlg_popup.title:		Select
*param_dlg_popup.title:			Command
*about_dlg_popup.title:			About
*error_dlg_popup.title:			Error

! mnemonics and accelerators

! menubar
*menubar*File.mnemonic: F
*menubar*Shelf.mnemonic: S
*menubar*View.mnemonic: V
*menubar*Options.mnemonic: O
*menubar*Help.mnemonic: H

! file pulldown
*FilePulldown*Open.mnemonic: O
*FilePulldown*Open.accelerator: Ctrl<Key>O
*FilePulldown*Open.acceleratorText: C-O
*FilePulldown*Mkdir.mnemonic: k
*FilePulldown*Mkdir.accelerator: Ctrl<Key>K
*FilePulldown*Mkdir.acceleratorText: C-K
*FilePulldown*Chdir.accelerator: <Key>F5
*FilePulldown*Chdir.acceleratorText: F5
*FilePulldown*Parent.accelerator: Ctrl<Key>F5
*FilePulldown*Parent.acceleratorText: C-F5
*FilePulldown*Home.accelerator: Shift<Key>F5
*FilePulldown*Home.acceleratorText: S-F5
*FilePulldown*Rename.mnemonic: n
*FilePulldown*Rename.accelerator: Ctrl<Key>N
*FilePulldown*Rename.acceleratorText: C-N
*FilePulldown*Move.mnemonic: M
*FilePulldown*Move.accelerator: Ctrl<Key>M
*FilePulldown*Move.acceleratorText: C-M
*FilePulldown*Copy.mnemonic: C
*FilePulldown*Copy.accelerator: Ctrl<Key>C
*FilePulldown*Copy.acceleratorText: C-C
*FilePulldown*Link.mnemonic: L
*FilePulldown*Link.accelerator: Ctrl<Key>L
*FilePulldown*Link.acceleratorText: C-L
*FilePulldown*Delete.mnemonic: D
*FilePulldown*Delete.accelerator: Ctrl<Key>D
*FilePulldown*Delete.acceleratorText: C-D
*FilePulldown*Properties.mnemonic: P
*FilePulldown*Properties.accelerator: Ctrl<Key>P
*FilePulldown*Properties.acceleratorText: C-P
*FilePulldown*Filter.mnemonic: F
*FilePulldown*Filter.accelerator: Ctrl<Key>F
*FilePulldown*Filter.acceleratorText: C-F
*FilePulldown*Select.mnemonic: S
*FilePulldown*Select.accelerator: Ctrl<Key>S
*FilePulldown*Select.acceleratorText: C-S
*FilePulldown*Select_all.mnemonic: a
*FilePulldown*Select_all.accelerator: Ctrl<Key>A
*FilePulldown*Select_all.acceleratorText: C-A
*FilePulldown*Invert_all.mnemonic: v
*FilePulldown*Invert_all.accelerator: Ctrl<Key>V
*FilePulldown*Invert_all.acceleratorText: C-V
*FilePulldown*Quit.mnemonic: Q
*FilePulldown*Quit.accelerator: Ctrl<Key>Q
*FilePulldown*Quit.acceleratorText: C-Q

! shelf pulldown
*ShelfPulldown*Open.mnemonic: O
*ShelfPulldown*Open.accelerator: Shift Ctrl<Key>O
*ShelfPulldown*Open.acceleratorText: S-C-O
*ShelfPulldown*Rename.mnemonic: n
*ShelfPulldown*Rename.accelerator: Shift Ctrl<Key>N
*ShelfPulldown*Rename.acceleratorText: S-C-N
*ShelfPulldown*Move.mnemonic: M
*ShelfPulldown*Move.accelerator: Shift Ctrl<Key>M
*ShelfPulldown*Move.acceleratorText: S-C-M
*ShelfPulldown*Copy.mnemonic: C
*ShelfPulldown*Copy.accelerator: Shift Ctrl<Key>C
*ShelfPulldown*Copy.acceleratorText: S-C-C
*ShelfPulldown*Link.mnemonic: L
*ShelfPulldown*Link.accelerator: Shift Ctrl<Key>L
*ShelfPulldown*Link.acceleratorText: S-C-L
*ShelfPulldown*Delete.mnemonic: D
*ShelfPulldown*Delete.accelerator: Shift Ctrl<Key>D
*ShelfPulldown*Delete.acceleratorText: S-C-D
*ShelfPulldown*Properties.mnemonic: P
*ShelfPulldown*Properties.accelerator: Shift Ctrl<Key>P
*ShelfPulldown*Properties.acceleratorText: S-C-P
*ShelfPulldown*Select.mnemonic: S
*ShelfPulldown*Select.accelerator: Shift Ctrl<Key>S
*ShelfPulldown*Select.acceleratorText: S-C-S
*ShelfPulldown*Select_all.mnemonic: a
*ShelfPulldown*Select_all.accelerator: Shift Ctrl<Key>A
*ShelfPulldown*Select_all.acceleratorText: S-C-A
*ShelfPulldown*Invert_all.mnemonic: v
*ShelfPulldown*Invert_all.accelerator: Shift Ctrl<Key>V
*ShelfPulldown*Invert_all.acceleratorText: S-C-V

! view pulldown
*ViewPulldown*Icons.mnemonic: I
*ViewPulldown*Icons.accelerator: Ctrl<Key>I
*ViewPulldown*Icons.acceleratorText: C-I
*ViewPulldown*Text.mnemonic: T
*ViewPulldown*Text.accelerator: Ctrl<Key>T
*ViewPulldown*Text.acceleratorText: C-T
*ViewPulldown*Show_hidden_files.mnemonic: h
*ViewPulldown*Show_hidden_files.accelerator: Ctrl<Key>H
*ViewPulldown*Show_hidden_files.acceleratorText: C-H
*ViewPulldown*Update.mnemonic: U
*ViewPulldown*Update.accelerator: Ctrl<Key>U
*ViewPulldown*Update.acceleratorText: C-U
*ViewPulldown*Reread.mnemonic: R
*ViewPulldown*Reread.accelerator: Ctrl<Key>R
*ViewPulldown*Reread.acceleratorText: C-R
*ViewPulldown*Unmount.accelerator: Ctrl<Key>G
*ViewPulldown*Unmount.acceleratorText: C-G
*ViewPulldown*Unmount_all.accelerator: Shift Ctrl<Key>G
*ViewPulldown*Unmount_all.acceleratorText: S-C-G

! options pulldown
*OptionsPulldown*Save_setup.mnemonic: S
*OptionsPulldown*Save_setup.accelerator: Alt<Key>S
*OptionsPulldown*Save_setup.acceleratorText: A-S
*OptionsPulldown*Reload_configuration_file.mnemonic: R
*OptionsPulldown*Reload_configuration_file.accelerator: Alt<Key>R
*OptionsPulldown*Reload_configuration_file.acceleratorText: A-R

! Some convenient accelerators for the Command menu ... Of course these
! depend on the contents of the command menu (Command section in the
! xplorerc file).

*CommandPulldown.Bookmark.mnemonic: B
*CommandPulldown.Bookmark.accelerator: Alt<Key>B
*CommandPulldown.Bookmark.acceleratorText: A-B
*CommandPulldown.Install.mnemonic: I
*CommandPulldown.Install.accelerator: Alt<Key>I
*CommandPulldown.Install.acceleratorText: A-I
*CommandPulldown.Editor.mnemonic: E
*CommandPulldown.Editor.accelerator: Alt<Key>E
*CommandPulldown.Editor.acceleratorText: A-E
*CommandPulldown.Calculator.mnemonic: C
*CommandPulldown.Calculator.accelerator: Alt<Key>C
*CommandPulldown.Calculator.acceleratorText: A-C
*CommandPulldown.Manual.mnemonic: M
*CommandPulldown.Manual.accelerator: Alt<Key>M
*CommandPulldown.Manual.acceleratorText: A-M
*CommandPulldown.Xterm.mnemonic: X
*CommandPulldown.Xterm.accelerator: Alt<Key>X
*CommandPulldown.Xterm.acceleratorText: A-X
*CommandPulldown.Find.mnemonic: F
*CommandPulldown.Find.accelerator: Alt<Key>F
*CommandPulldown.Find.acceleratorText: A-F
*CommandPulldown.Grep.mnemonic: G
*CommandPulldown.Grep.accelerator: Alt<Key>G
*CommandPulldown.Grep.acceleratorText: A-G
*CommandPulldown.Diff.mnemonic: D
*CommandPulldown.Diff.accelerator: Alt<Key>D
*CommandPulldown.Diff.acceleratorText: A-D
*CommandPulldown.Shell_command.accelerator: <Key>F8
*CommandPulldown.Shell_command.acceleratorText: F8
*CommandPulldown.Make.accelerator: <Key>F9
*CommandPulldown.Make.acceleratorText: F9

! dummy button for empty command menu
*CommandPulldown.Empty.sensitive: False

! enable tear off (lets you use the command menu like a toolbar)
*CommandPulldown.tearOffModel: XmTEAR_OFF_ENABLED

! you can also have buttons with icons like this:
!*CommandPulldown.Xterm.labelType: XmPIXMAP
!*CommandPulldown.Xterm.labelPixmap: XPLORELIBDIR/icons/term.xpm
