/****************************************************************************
*  Copyright (C) 1996-97 by Leo Khramov
*  email:     leo@unix1.jinr.dubna.su
*  
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
 ****************************************************************************/

#include "panel.h"
#include "xnc.icon"
#include "xncm.icon"
#include "bookmark.h"

char   home_files_dir[1024];

void   make_home_file_dir()
{
  char   str[256];
  int    fp;
  sprintf(str, "%s/.xnc/.xnc.ini", getenv("HOME"));
  fp = open(str, O_RDONLY);
  if (fp == -1)
    {
      fprintf(stderr, "\nWARNING: User configuration files not found - using system ones...\n");
      fprintf(stderr, "and running 'xncsetup' for configuration user settings.....\n");
      psystem("xncsetup");
      sleep(3);
      sprintf(str, "%s/xnc/.xnc.ini", XNC_DIR);
      strcpy(home_files_dir, XNC_DIR);
      strcat(home_files_dir, "/xnc");
      fp = open(str, O_RDONLY);
      if (fp == -1)
        fprintf(stderr, "\nWARNING: System default configuration files not found ...\n");
      else
        close(fp);
      return;
    }
  else
    close(fp);
  strcpy(home_files_dir, getenv("HOME"));
  strcat(home_files_dir, "/.xnc");
}


extern BookMark *bmark;
extern char hidechr[];

extern char build_chr[];
char   xncvt[100];
char   geom[30];
extern char host[];
extern int afs_disabled;
extern int ftp_cache_disabled;

char  *mnt[60];
int    mntmax = 0;
int    margc;
int    centerx, centery;
char **margv;
int    ScreenL, ScreenH;
int    allow_t_raising = 1;

char **ext = NULL;
char **extcom;
char **menunames;
char **menucom;
KeySym *mkeys = NULL;
int    extmax = 0, menumax = 0;
int    term_sticky = 1;
int    hide_hidden = 0;

int    findmenukey(KeySym ks)
{
  for (int i = 0; i < menumax; i++)
    if (mkeys[i] == ks)
      return i;
  return -1;
}

int    fstring(FILE * fp, char *str)
{
  char  *s = str;
  while (!feof(fp))
    {
      *str = (char)fgetc(fp);
      if (*str == '\n')
        {
          *str = 0;
          return 1;
        };
      str++;
    };
  *str = 0;
  if (*s)
    return 1;
  return 0;
}

char  *strscan(char *src, char *dest)
{
  while (*src != 0 && *src != ':')
    *dest++ = *src++;
  *dest = 0;
  return ++src;
}

char  *strscan2(char *src, char *dest)
{
  while (*src == ' ')
    src++;
  while (*src != 0 && *src != ' ' && *src != 0xa)
    *dest++ = *src++;
  *dest = 0;
  return ++src;
}

void   del_ext()
{
  int    i;
  if (ext != NULL)
    {
      for (i = 0; i < extmax; i++)
        {
          delete ext[i];
          delete extcom[i];
        }
      delete ext;
      delete extcom;
      ext = NULL;
    }
}

void   del_menu()
{
  int    i;
  if (mkeys != NULL)
    {
      for (i = 0; i < menumax; i++)
        {
          if (menunames[i])
            delete menunames[i];
          if (menucom[i])
            delete menucom[i];
        }
      delete menunames;
      delete menucom;
      delete mkeys;
      mkeys = NULL;
    }
}

int    ext_find(char *name)
{
  int    l = strlen(name), i, nl, el, fl;
  for (i = 0; i < extmax; i++)
    {
      el = strlen(ext[i]);
      nl = l;
      fl = 1;
      while (el >= 0)
        if (name[nl] != ext[i][el])
          {
            fl = 0;
            break;
          }
        else
          {
            el--;
            nl--;
          };
      if (fl)
        return i;
    }
  return -1;
}

int    ext_find2(char *name, int n)
{
  int    l = strlen(name), i, nl, el, fl, k = 0;
  for (i = 0; i < extmax; i++)
    {
      el = strlen(ext[i]);
      nl = l;
      fl = 1;
      while (el >= 0)
        if (name[nl] != ext[i][el])
          {
            fl = 0;
            break;
          }
        else
          {
            el--;
            nl--;
          };
      if (fl)
        {
          if (k == n)
            return i;
          else
            k++;
        };
    }
  return -1;
}

void   load_ext()
{
  FILE  *fp;
  int    i;
  char   str[120];
  char   str1[80];
  char  *chr;
  int    show_dots = 1;
  if (ext != NULL)
    show_dots = 0;
  del_ext();
  strcpy(rfile, home_files_dir);
  strcat(rfile, "/.xnc.ext");
  if ((fp = fopen(rfile, "r")) != NULL)
    {
      i = 0;
      while (fstring(fp, str))
        if (str[0] == '.')
          i++;
      fseek(fp, 0l, SEEK_SET);
      ext = new char *[i];
      extcom = new char *[i];
      i = 0;
      while (fstring(fp, str))
        {
          chr = strscan(str, str1);
          if (str1[0] == '.')
            {
              ext[i] = new char[strlen(str1) + 1];
              strcpy(ext[i], str1);
              strscan(chr, str1);
              extcom[i] = new char[strlen(str1) + 1];
              strcpy(extcom[i], str1);
              i++;
              if (show_dots)
                fprintf(stderr, ".");
            }
        }
      extmax = i;
      fclose(fp);
    }
  else
    fprintf(stderr, "XNC Error: No extension file found...");
}

void   load_menu()
{
  FILE  *fp;
  int    i, j;
  char   str[120];
  char   str1[120];
  char  *chr;
  int    show_dots = 1;
  if (mkeys != NULL)
    show_dots = 0;
  del_menu();
  strcpy(rfile, home_files_dir);
  strcat(rfile, "/.xnc.menu");
  if ((fp = fopen(rfile, "r")) != NULL)
    {
      i = 0;
      while (fstring(fp, str))
        if (str[0] != '#' && str[0] != ' ' && str[0] != 0xa && str[0] != 0)
          i++;
      fseek(fp, 0l, SEEK_SET);
      mkeys = new KeySym[i];
      menucom = new char *[i];
      menunames = new char *[i];
      menumax = i;
      for (j = 0; i < j; j++)
        {
          menucom[i] = NULL;
          menunames[i] = NULL;
        }
      i = 0;
      while (fstring(fp, str))
        {
          chr = strscan(str, str1);
          if (str1[0] != '#')
            {
              mkeys[i] = XStringToKeysym(str1);
              chr = strscan(chr, str1);
              *(chr - 1) = 0;
              menunames[i] = new char[strlen(str) + 1];
              strcpy(menunames[i], str);
              strscan(chr, str1);
              menucom[i] = new char[strlen(str1) + 1];
              strcpy(menucom[i], str1);
              i++;
              if (show_dots)
                fprintf(stderr, ".");
            }
        }
      fclose(fp);
    }
  else
    fprintf(stderr, "XNC Error: No menu file found...");
}

void   load_mnt()
{
  FILE  *fp;
  fprintf(stderr, "Scaning for mounting devices");
#ifdef HAVE_MNTENT_H
  mntent *mntstr;
  if ((fp = setmntent(MNTTAB, "r")) != NULL)
    {
      while ((mntstr = getmntent(fp)) != NULL)
        {
          mnt[mntmax] = new char[strlen(mntstr->mnt_dir) + 1];
          strcpy(mnt[mntmax], mntstr->mnt_dir);
          mntmax++;
          fprintf(stderr, ".");
        }
      endmntent(fp);
      fprintf(stderr, "OK\n");
    }
  else
    fprintf(stderr, ".....failed\n");
#else
  char   str[256];
  char   s1[256], *s2;
  fp = popen("mount", "r");
  if (fp == NULL)
    {
      fprintf(stderr, "...disabled [Porting problems]\n");
      return;
    }
  mntmax = 0;
  while (fgets(str, 255, fp) != NULL)
    {
      s2 = strscan2(str, s1);
      s2 = strscan2(s2, s1);
      strscan2(s2, s1);
      mnt[mntmax] = new char[strlen(s1) + 1];
      strcpy(mnt[mntmax], s1);
      mntmax++;
      fprintf(stderr, ".");
    }
  fprintf(stderr, "OK\n");
  pclose(fp);
#endif
}

char  *findmntent(char *p)
{
  for (int i = 0; i < mntmax; i++)
    if (strcmp(mnt[i], p) == 0)
      return mnt[i];
  return NULL;
}

void   del_mnt()
{
  for (int i = 0; i < mntmax; i++)
    delete mnt[i];
}



USR    users;
USR    groups;
char   unuser[] = "unknown";

void   init_users()
{
  FILE  *fp;
  USR   *us;
  char  *chr;
  char   str[140];
  char   chr2[40];
  struct passwd *pw;
  struct group *gr;
  fprintf(stderr, "Scaning users");
#ifndef OLD_STYLE
  while ((pw = getpwent()) != NULL)
    {
      fprintf(stderr, ".");
      us = new USR;
      strcpy(us->name, pw->pw_name);
      us->uid = pw->pw_uid;
      us->gid = pw->pw_gid;
      us->next = users.next;
      users.next = us;
    }
  endpwent();
#else
  fp = (FILE *) popen("users.xnc", "r");
  if (fp)
    {
      while (fgets(str, 140, fp) != NULL)
        {
          us = new USR;
          sscanf(str, "%s %d %d", us->name, &us->uid, &us->gid);
          us->next = users.next;
          users.next = us;
          fprintf(stderr, ".");
        }
      pclose(fp);
      fprintf(stderr, "OK\n");
    }
  else
    fprintf(stderr, "Can't scan users!!!\n");
#endif
  fprintf(stderr, "Scaning groups");
#ifndef OLD_STYLE
  while ((gr = getgrent()) != NULL)
    {
      fprintf(stderr, ".");
      us = new USR;
      strcpy(us->name, gr->gr_name);
      us->uid = gr->gr_gid;
      us->next = groups.next;
      groups.next = us;
    }
  endgrent();
  fprintf(stderr, "OK\n");
#else
  fp = (FILE *) popen("groups.xnc", "r");
  if (fp)
    {
      while (fgets(str, 140, fp) != NULL)
        {
          us = new USR;
          sscanf(str, "%s %d", us->name, &us->uid);
          us->next = groups.next;
          groups.next = us;
          fprintf(stderr, ".");
        }
      pclose(fp);
      fprintf(stderr, "OK\n");
    }
  else
    fprintf(stderr, "Can't scan groups!!!\n");
#endif
}

void   deinit_users()
{
  USR   *us;
  while (users.next != NULL)
    {
      us = users.next->next;
      delete users.next;
      users.next = us;
    }
  while (groups.next != NULL)
    {
      us = groups.next->next;
      delete groups.next;
      groups.next = us;
    }
}

char  *finduser(int uid)
{
  USR   *us = users.next;
  while (us != NULL)
    if (us->uid == uid)
      return us->name;
    else
      us = us->next;
  return unuser;
}

int    finduserid_by_name(char *n)
{
  USR   *us = users.next;
  while (us != NULL)
    if (strcmp(us->name, n) == 0)
      return us->uid;
    else
      us = us->next;
  return -1;
}

char  *(*finduserbyuid) (int) = finduser;
char  *findgroup(int uid)
{
  USR   *us = groups.next;
  while (us != NULL)
    if (us->uid == uid)
      return us->name;
    else
      us = us->next;
  return unuser;
}

int    findgroupid_by_name(char *n)
{
  USR   *us = groups.next;
  while (us != NULL)
    if (strcmp(us->name, n) == 0)
      return us->uid;
    else
      us = us->next;
  return -1;
}

//////////////////////////////////////////////////////////////////////////

char  *bgchr = "white", *fgchr = "black", *fontchr = "fixed", *lfontchr = "fixed",
      *vfontchr = "fixed", *fixfontchr = "fixed", *mfixfontchr = "fixed",
      *kbgchr = "#9cb0c4", *dispchr = NULL, *selectchr = "#4000f0", *editname = "internal",
      *viewname = "internal", *syspath = ".", *traise = "yes", *tsticky = "yes",
      *geometrychr = "0x1000+0+0", *viewgeom = "400x400+20+40", *banim = "yes",
      *bshow = "yes", *diriconchr = "yes", *fileiconchr = "yes", *updatechr = "never";

char   rfile[80];
int    allow_animation = 1;
int    allow_bookmark = 1;
int    allow_dir_icon = 1;
extern int dont_update;
int    allow_file_icon = 1;

Lister *panel = NULL;

X_PAR  resources[] =
{
  "leoprogs.background", "LeoProgs.Background", &bgchr,
  "leoprogs.foreground", "LeoProgs.Foreground", &fgchr,
  "leoprogs.keys.background", "LeoProgs.Keys.Background", &kbgchr,
  "leoprogs.font", "LeoProgs.Font", &fontchr,
  "leoprogs.selectedcolor", "LeoProgs.SelectedColor", &selectchr,
  "leoprogs.list.font", "LeoProgs.List.Font", &lfontchr,
  "leoprogs.font.fixed", "LeoProgs.Font.Fixed", &fixfontchr,
  "xnc.editor.name", "Xnc.Editor.Name", &editname,
  "xnc.sysfiles.path", "Xnc.SysFiles.Path", &syspath,
  "xnc.geometry", "Xnc.Geometry", &geometrychr,
  "leoprogs.viewer.font", "LeoProgs.Viewer.Font", &vfontchr,
  "xnc.viewer.name", "Xnc.Viewer.Name", &viewname,
  "xnc.viewer.geometry", "Xnc.Viewer.Geometry", &viewgeom,
  "xnc.terminal.allow_raising", "Xnc.Terminal.Allow_Raising", &traise,
  "xnc.terminal.stick_both", "Xnc.Terminal.Stick_Both", &tsticky,
  "xnc.bookmark.allow_animation", "Xnc.BookMark.Allow_Animation", &banim,
  "xnc.bookmark.show_and_use", "Xnc.BookMark.Show_and_Use", &bshow,
  "leoprogs.font.minifixed", "LeoProgs.Font.MiniFixed", &mfixfontchr,
  "xnc.icons.dir", "Xnc.Icons.Dir", &diriconchr,
  "xnc.icons.files", "Xnc.Icons.Files", &fileiconchr,
  "xnc.afs.update", "Xnc.AFS.Update", &updatechr
};

int    resn = sizeof(resources) / sizeof(X_PAR);

X_PAR  colors[] =
{
  "leoprogs.syscolor1", "LeoProgs.SysColor1", &bgchr,
  "leoprogs.syscolor2", "LeoProgs.SysColor2", &bgchr,
  "leoprogs.syscolor3", "LeoProgs.SysColor3", &bgchr,
  "leoprogs.syscolor4", "LeoProgs.SysColor4", &bgchr,
  "leoprogs.syscolor5", "LeoProgs.SysColor5", &bgchr,
  "leoprogs.syscolor6", "LeoProgs.SysColor6", &bgchr,
  "leoprogs.list.normfile", "LeoProgs.SysColor7", &bgchr,
  "leoprogs.list.directory", "LeoProgs.SysColor8", &bgchr,
  "leoprogs.list.execution", "LeoProgs.SysColor9", &bgchr,
  "leoprogs.list.extensions", "LeoProgs.SysColor10", &bgchr,
  "leoprogs.list.link", "LeoProgs.SysColor11", &bgchr,
  "leoprogs.afs.color", "LeoProgs.AFS.Color", &bgchr
};

int    coln = sizeof(colors) / sizeof(X_PAR);

unsigned long keyscol[3];
unsigned long cols[12];

XFontStruct *fontstr;
XFontStruct *lfontstr;
XFontStruct *vfontstr;
XFontStruct *fixfontstr;
XFontStruct *mfixfontstr;
unsigned long bgpix, fgpix, selectpix;

XWMHints *pxwmh;
XSizeHints *pxsh;
XClassHint *pch;
XTextProperty wname;
XTextProperty iname;
Display *disp;
Window Main;
Window Key;
GC     gc;
XGCValues gcv;
XEvent ev;
XrmDatabase rdb;
XrmValue rmv;
XColor color;
Colormap defcmp;
int    done = 0;
int    scr;
int    Mainl, Mainh, Mainx, Mainy;

int    viewx, viewy;
uint   viewl, viewh;

List   el, exp;

Gui   *find(Window ww)
{
  List  *cur = el.next;
  while (cur != NULL)
    if (cur->w == ww)
      break;
    else
      cur = cur->next;
  if (cur)
    return cur->obj;
  return NULL;
}


Gui   *findexp(Window ww)
{
  List  *cur = exp.next;
  while (cur != NULL)
    if (cur->w == ww)
      break;
    else
      cur = cur->next;
  if (cur)
    return cur->obj;
  return NULL;
}

void   addto_exp(Gui * o, Window w)
{
  List  *cur = new List;
  cur->obj = o;
  cur->w = w;
  cur->next = exp.next;
  if (exp.next)
    exp.next->prev = cur;
  exp.next = cur;
  cur->prev = &exp;
}

void   addto_el(Gui * o, Window w)
{
  List  *cur = new List;
  cur->obj = o;
  cur->w = w;
  cur->next = el.next;
  if (el.next)
    el.next->prev = cur;
  el.next = cur;
  cur->prev = &el;
  addto_exp(o, w);
}

void   delfrom_exp(Gui * o)
{
  List  *cur = exp.next;
  while (cur != NULL)
    if (cur->obj == o)
      break;
    else
      cur = cur->next;
  if (cur != NULL)
    {
      cur->prev->next = cur->next;
      if (cur->next)
        cur->next->prev = cur->prev;
      delete cur;
    }
}

void   delfrom_el(Gui * o)
{
  List  *cur = el.next;
  while (cur != NULL)
    if (cur->obj == o)
      break;
    else
      cur = cur->next;
  if (cur != NULL)
    {
      cur->prev->next = cur->next;
      if (cur->next)
        cur->next->prev = cur->prev;
      delete cur;
    }
}

void   delall_el()
{
  List  *cur, *cur2;
  cur = el.next;
  while (cur != NULL)
    {
      cur2 = cur->next;
      delete cur;
      cur = cur2;
    }
}

void   delall_exp()
{
  List  *cur, *cur2;
  cur = exp.next;
  while (cur != NULL)
    {
      cur2 = cur->next;
      delete cur;
      cur = cur2;
    }
}


unsigned long gencol(XColor & col, int per)
{
  int    r = 0, g = 0, b = 0, pr;
  XColor cl = col;
  r = (int)col.red;
  b = (int)col.blue;
  g = (int)col.green;
  pr = 100 + per;
  r = r * pr / 100;
  g = g * pr / 100;
  b = b * pr / 100;
  if (r > 65535)
    r = 65535;
  if (g > 65535)
    g = 65535;
  if (b > 65535)
    b = 65535;
  cl.red = r;
  cl.green = g;
  cl.blue = b;
  cl.flags = DoGreen | DoRed | DoBlue;
  if (XAllocColor(disp, defcmp, &cl) != 0)
    return cl.pixel;
  else
    fprintf(stderr, "Error in gencol\n");
  return 0;
}

void   GenerateColors()
{
  if (XParseColor(disp, defcmp, *resources[2].pstr, &color) == 0 ||
      XAllocColor(disp, defcmp, &color) == 0)
    keyscol[1] = WhitePixel(disp, scr);
  else
    keyscol[1] = color.pixel;
  keyscol[0] = gencol(color, -40);
  keyscol[2] = gencol(color, 30);
}

Pixmap picon;
Pixmap piconmask;
char  *icname = "XNC";
int    layout = 1;
char   winame[200];
extern Display *Xdisplay;
extern char l_bg_string[];
void   InitXClient(int argc, char **argv, int wx, int wy, int wl, int wh, char
                   *winname)
{
  int    i, ppx, ppy;
  XWindowAttributes xwinattr;
  uint   ppl, pph;
  char  *rmt;
  char   tmppath[256];
  XSetWindowAttributes xswa;
  make_home_file_dir();
  fprintf(stderr, "XClient..........OK\n");
/*
   for(i=1;i<argc;i++)
   if(strcmp("-display",argv[i])==0 || strcmp("-d",argv[i])==0) dispchr=argv[i+1];
   if((disp=XOpenDisplay(dispchr))==NULL)
   {
   fprintf(stderr,"%s: connection to X server failed on display %s.....\n",argv[0],dispchr);
   exit(1);
   } */
  disp = Xdisplay;
  gethostname(host, 80);
  sprintf(winame, "%s  launched from host '%s'", winname, host);
  sprintf(xncvt, "VT100 for %s  Host:%s", ver, host);
  strcat(host, ":");
  winname = winame;
  scr = DefaultScreen(disp);
  XrmInitialize();
  fprintf(stderr, "Loading resources....");
  strcpy(rfile, home_files_dir);
  strcat(rfile, "/.xnc.ini");
  rdb = XrmGetFileDatabase(rfile);
  if (rdb != NULL)
    for (i = 0; i < resn; i++)
      {
        fprintf(stderr, ".");
        if (XrmGetResource(rdb, resources[i].name, resources[i].cname, &rmt, &rmv))
          *resources[i].pstr = rmv.addr;
        else
          fprintf(stderr, "%s: Error getting resource: %s\n", argv[0], resources[i].name);
      }
  else
    fprintf(stderr, "!!!XNC PANIC!!!: Can't open resource file.\n");
  strcpy(l_bg_string, *resources[2].pstr);
  if (strcasecmp(traise, "yes") == 0)
    allow_t_raising = 1;
  else
    allow_t_raising = 0;
  if (strcasecmp(tsticky, "yes") == 0)
    term_sticky = 1;
  else
    term_sticky = 0;
  XParseGeometry(geometrychr, &ppx, &ppy, &ppl, &pph);
  if (ppl > 0)
    {
      wx = ppx;
      wy = ppy;
      wl = ppl;
      wh = pph;
      if (wl < 640)
        wl = 640;
      if (wh < 300)
        wh = 300;
    }
  XParseGeometry(viewgeom, &viewx, &viewy, &viewl, &viewh);
  defcmp = DefaultColormap(disp, scr);

  if (XParseColor(disp, defcmp, *resources[0].pstr, &color) == 0 ||
      XAllocColor(disp, defcmp, &color) == 0)
    bgpix = WhitePixel(disp, scr);
  else
    bgpix = color.pixel;
  if (XParseColor(disp, defcmp, *resources[4].pstr, &color) == 0 ||
      XAllocColor(disp, defcmp, &color) == 0)
    selectpix = BlackPixel(disp, scr);
  else
    selectpix = color.pixel;
  if (XParseColor(disp, defcmp, *resources[1].pstr, &color) == 0 ||
      XAllocColor(disp, defcmp, &color) == 0)
    fgpix = BlackPixel(disp, scr);
  else
    fgpix = color.pixel;

  for (i = 0; i < coln; i++)
    if (XrmGetResource(rdb, colors[i].name, colors[i].cname, &rmt, &rmv))
      {
        fprintf(stderr, ".");
        *colors[i].pstr = rmv.addr;
        if (XParseColor(disp, defcmp, *colors[i].pstr, &color) == 0 ||
            XAllocColor(disp, defcmp, &color) == 0)
          {
            fprintf(stderr, "!!!XNC Panic!!!: Can't allocate color!\n");
            cols[i] = BlackPixel(disp, scr);
          }
        else
          cols[i] = color.pixel;
      }

  if (XrmGetResource(rdb, "xnc.panels.layout", "Xnc.Panels.Layout", &rmt, &rmv))
    {
      if (strcmp(rmv.addr, "horizontal") == 0)
        layout = 0;
      else if (strcmp(rmv.addr, "vertical") == 0)
        layout = 1;
      else
        layout = 2;
    }
  else
    fprintf(stderr, "!!!XNC Panic!!!: Error getting resource: Xnc.Panels.Layout\n");

  if ((fontstr = XLoadQueryFont(disp, *resources[3].pstr)) == NULL)
    {
      fprintf(stderr, "!!!XNC Panic!!!: Error loading font %s\n", fontchr);
      exit(1);
    }

  if ((lfontstr = XLoadQueryFont(disp, *resources[5].pstr)) == NULL)
    {
      fprintf(stderr, "!!!XNC Panic!!!: Error loading font %s\n", lfontchr);
      exit(1);
    }

  if ((fixfontstr = XLoadQueryFont(disp, *resources[6].pstr)) == NULL)
    {
      fprintf(stderr, "!!!XNC Panic!!!: Error loading font %s\n", fixfontchr);
      exit(1);
    }
  if ((vfontstr = XLoadQueryFont(disp, *resources[10].pstr)) == NULL)
    {
      fprintf(stderr, "!!!XNC Panic!!!: Error loading font %s\n", vfontchr);
      exit(1);
    }
  if ((mfixfontstr = XLoadQueryFont(disp, mfixfontchr)) == NULL)
    {
      fprintf(stderr, "!!!XNC Panic!!!: Error loading font %s\n", mfixfontchr);
      exit(1);
    }


  fprintf(stderr, "OK\n");
  GenerateColors();
  if ((pxsh = XAllocSizeHints()) == NULL)
    {
      fprintf(stderr, "%s: Error allocating size hints\n", argv[0]);
      exit(1);
    }

  if (strcmp(banim, "no") == 0)
    allow_animation = 0;
  if (strcmp(bshow, "no") == 0)
    {
      allow_bookmark = 0;
      allow_animation = 0;
    };
  if (strcmp(diriconchr, "no") == 0)
    allow_dir_icon = 0;
  if (strcmp(fileiconchr, "no") == 0)
    allow_file_icon = 0;
  if (strcmp(updatechr, "always") == 0)
    dont_update = 1;
  else if (strcmp(updatechr, "prompt") == 0)
    dont_update = 0;
  else
    dont_update = 2;
  pxsh->flags = (PPosition | PSize | PMinSize);                // | PMaxSize);

  pxsh->height = wh;
  pxsh->width = wl;
  pxsh->min_width = 450;
  pxsh->min_height = 350;
/* pxsh->max_width=pxsh->width;
   pxsh->max_height=pxsh->height; */
  pxsh->x = wx;
  pxsh->y = wy;
  Mainl = wl;
  Mainh = wh;
  sprintf(geom, "%dx%d+%d+%d", pxsh->width, pxsh->height, pxsh->x, pxsh->y);
  i = XGeometry(disp, scr, geom, geom, BDWIDTH, fontstr->max_bounds.width,
                fontstr->max_bounds.ascent + fontstr->max_bounds.descent,
             1, 1, &(pxsh->x), &(pxsh->y), &(pxsh->width), &(pxsh->height));
  if (i & (XValue | YValue))
    pxsh->flags |= USPosition;
  if (i & (WidthValue | HeightValue))
    pxsh->flags |= USSize;
  Mainx = pxsh->x;
  Mainy = pxsh->y;
  Main = XCreateSimpleWindow(disp, DefaultRootWindow(disp),
                             pxsh->x, pxsh->y, pxsh->width, pxsh->height,
                             BDWIDTH, fgpix, keyscol[1]);
  centerx = pxsh->width / 2;
  centery = pxsh->height / 2;
  if ((pch = XAllocClassHint()) == NULL)
    {
      fprintf(stderr, "%s: Error allocating ClassHint\n", argv[0]);
      exit(1);
    }
  pch->res_name = "leoprogs";
  pch->res_class = "LeoProgs";
  if (winname == NULL)
    winname = argv[0];
  if (XStringListToTextProperty(&winname, 1, &wname) == 0)
    {
      fprintf(stderr, "%s: Error creating TextProperty\n", argv[0]);
      exit(1);
    }
  if (XStringListToTextProperty(&icname, 1, &iname) == 0)
    {
      fprintf(stderr, "%s: Error creating TextProperty\n", argv[0]);
      exit(1);
    }
  if ((pxwmh = XAllocWMHints()) == NULL)
    {
      fprintf(stderr, "%s: Error allocating WMHints\n", argv[0]);
      exit(0);
    }
  picon = XCreateBitmapFromData(disp, Main, (char *)xnc_bits, xnc_width, xnc_height);
  piconmask = XCreateBitmapFromData(disp, DefaultRootWindow(disp), (char *)xncm_bits, xnc_width, xnc_height);
  pxwmh->flags = (InputHint | StateHint | IconMaskHint | IconPixmapHint);
  pxwmh->input = True;
  pxwmh->initial_state = NormalState;
  pxwmh->icon_pixmap = picon;
  pxwmh->icon_mask = piconmask;
  XSetWMProperties(disp, Main, &wname, &iname, argv, argc, pxsh, pxwmh, pch);

  gcv.font = fontstr->fid;
  gcv.foreground = fgpix;
  gcv.background = bgpix;
  gc = XCreateGC(disp, Main, (GCFont | GCForeground | GCBackground), &gcv);
  xswa.colormap = defcmp;
  xswa.bit_gravity = CenterGravity;
  XChangeWindowAttributes(disp, Main, (CWColormap | CWBitGravity), &xswa);
// XSelectInput(disp,Main,ExposureMask | StructureNotifyMask);
  XSelectInput(disp, Main, FocusChangeMask | StructureNotifyMask);
  XGetWindowAttributes(disp, DefaultRootWindow(disp), &xwinattr);
  ScreenL = xwinattr.width;
  ScreenH = xwinattr.height;
  if (strcmp(syspath, ".") == 0)
    syspath = home_files_dir;
  sprintf(tmppath, "%s/AFS", syspath);
  if (mkdir(tmppath, 0700) == -1 && errno != EEXIST)
    {
      fprintf(stderr, "!!!XNC Panic!!!!: Can't access tmp directory '%s'!\n", syspath);
      fprintf(stderr, "Archive file system will be disabled!!!\n");
      afs_disabled = 1;
    }
  sprintf(tmppath, "%s/FTPFS", syspath);
  if (mkdir(tmppath, 0700) == -1 && errno != EEXIST)
    {
      fprintf(stderr, "!!!XNC Warning!!!!: Can't access FTP tmp directory '%s'!\n", syspath);
      fprintf(stderr, "FTP cache will be disabled!!!\n");
      ftp_cache_disabled= 1;
    }
}

void   DeinitXClient()
{
// XFreePixmap(disp,picon);

// XFreePixmap(disp,piconmask);
  delall_el();
// delall_exp();
  XFreeGC(disp, gc);
  XUnloadFont(disp, fontstr->fid);
  XUnloadFont(disp, lfontstr->fid);
  XDestroyWindow(disp, Main);
// XCloseDisplay(disp);

// exit(0);
}


Window create_win(char *winname, int wx, int wy, int wl, int wh, int mask, int inp = 1)
{
  int    i;
  Window W;
  XSetWindowAttributes xswa;
  pxsh->flags = (PPosition | PSize | PMinSize | PMaxSize);
  pxsh->height = wh;
  pxsh->width = wl;
  pxsh->min_width = pxsh->width;
  pxsh->min_height = pxsh->height;
  pxsh->max_width = pxsh->width;
  pxsh->max_height = pxsh->height;
  pxsh->x = wx;
  pxsh->y = wy;
  sprintf(geom, "%dx%d+%d+%d", pxsh->width, pxsh->height, pxsh->x, pxsh->y);
  i = XGeometry(disp, scr, geom, geom, BDWIDTH, fontstr->max_bounds.width,
                fontstr->max_bounds.ascent + fontstr->max_bounds.descent,
             1, 1, &(pxsh->x), &(pxsh->y), &(pxsh->width), &(pxsh->height));
  if (i & (XValue | YValue))
    pxsh->flags |= USPosition;
  if (i & (WidthValue | HeightValue))
    pxsh->flags |= USSize;
  W = XCreateSimpleWindow(disp, DefaultRootWindow(disp),
                          pxsh->x, pxsh->y, pxsh->width, pxsh->height,
                          BDWIDTH, fgpix, keyscol[1]);
  pch->res_name = "leoprogs";
  pch->res_class = "LeoProgs";
  if (XStringListToTextProperty(&winname, 1, &wname) == 0)
    {
      fprintf(stderr, "Error creating TextProperty\n");
      exit(1);
    }
  pxwmh->flags = (InputHint | StateHint);
  if (inp)
    pxwmh->input = True;
  else
    pxwmh->input = False;
  pxwmh->initial_state = NormalState;
  XSetWMProperties(disp, W, &wname, &iname, margv, margc, pxsh, pxwmh, pch);
  xswa.colormap = defcmp;
  xswa.bit_gravity = CenterGravity;
  XChangeWindowAttributes(disp, W, (CWColormap | CWBitGravity), &xswa);
  XSelectInput(disp, W, mask);

  return W;
}

Win   *msgw;
KEY   *msgok;

void   msgdone()
{
  msgok->hide();
  msgw->hide();
  delete msgok;
  delete msgw;
  if (panel)
    XSetInputFocus(disp, panel->w, RevertToNone, CurrentTime);
}

void   msg(char *meshead, char *mes, int col, FList * o)
{
  int    tl = XTextWidth(fontstr, mes, strlen(mes)) + 140;
  char   attr[] = "Status: rwxrwxrwx";
  char   size[40] = " ";
  char   name[80] = " ";
  int    i, mask = S_IRUSR;
  int    al = XTextWidth(fontstr, attr, strlen(attr)) + 140, sl = 0, fl = 0;
  if (o)
    {
      sprintf(name, "File:   %s", o->name);
      sprintf(size, "Owner:  %s.%s", finduser(o->uid), findgroup(o->gid));
      for (i = 0; i < 9; i++)
        {
          if ((o->mode & mask) == 0)
            attr[i + 8] = '-';
          mask >>= 1;
        }
      sl = XTextWidth(fontstr, attr, strlen(attr)) + 140;
      fl = XTextWidth(fontstr, attr, strlen(attr)) + 140;
    }
  if (sl > tl && sl > al && sl > fl)
    tl = sl;
  if (al > sl && al > tl && al > fl)
    tl = al;
  if (fl > tl && fl > al && fl > sl)
    tl = fl;
  msgw = new Win(Mainl / 2 - tl / 2, Mainh / 2 - 90, tl, 120, meshead, 5);
  msgok = new KEY(-20, -20, 80, 25, "Agree", 1, msgdone);
  msgw->init(Main);
  msgok->init(msgw->w);
  msgw->link(msgok);
  msgw->show();
  msgok->show();
  XSetForeground(disp, msgw->gcw, cols[0]);
  XDrawString(disp, msgw->w, msgw->gcw, 20, 40, mes, strlen(mes));
  XDrawString(disp, msgw->w, msgw->gcw, 20, 60, name, strlen(name));
  XDrawString(disp, msgw->w, msgw->gcw, 20, 80, attr, strlen(attr));
  XDrawString(disp, msgw->w, msgw->gcw, 20, 100, size, strlen(size));
  XSetForeground(disp, msgw->gcw, cols[col]);
  XDrawString(disp, msgw->w, msgw->gcw, 19, 39, mes, strlen(mes));
  XSetForeground(disp, msgw->gcw, cols[1]);
  XDrawString(disp, msgw->w, msgw->gcw, 19, 59, name, strlen(name));
  XDrawString(disp, msgw->w, msgw->gcw, 19, 79, attr, strlen(attr));
  XDrawString(disp, msgw->w, msgw->gcw, 19, 99, size, strlen(size));
}

extern int extcmp(char *, int, int, char *, int, int);
extern int sizecmp(char *, int, int, char *, int, int);
extern int timecmp(char *, int, int, char *, int, int);
extern int mystrcmp(char *, int, int, char *, int, int);
extern Menu submenu1, submenu2;
extern Window main_win;

char  *confref[] =
{"panel1.path", "panel2.path", "panel.active", "panel1.columns", "panel2.columns",
 "panel1.sortby", "panel2.sortby", "panel1.style", "panel2.style", "bookmark.book1", "bookmark.book2",
 "bookmark.book3", "bookmark.book4", "bookmark.book5", "bookmark.book6", "bookmark.book7",
 "bookmark.book8", "bookmark.book9", "panels.show_hidden_files", "panels.percentage"};

const int confmax = 20;

char  *getseq(char *str, char *w, int nocase = 1)
{
  while ((*str == ' ' || *str == ':') && *str != 0)
    str++;
  while (*str != 0 && *str != 0xa && *str != ':')
    if (nocase)
      *w++ = tolower(*str++);
    else
      *w++ = *str++;
  *w = 0;
  return str;
}

int    load_config(char *fname, Lister * l1, Lister * l2)
{
  char   str[200], *s;
  char   w[200];
  int    i, nn, j;
  FILE  *fp = fopen(fname, "r");
  if (fp == NULL)
    return 0;
  while (fgets(str, 200, fp) != NULL)
    {
      if (str[0] != '#')
        {
          s = getseq(str, w);
//    fprintf(stderr,"%s\n",w);
          for (i = 0; i < confmax; i++)
            if (strcmp(w, confref[i]) == 0)
              break;
          if (i == confmax)
            fprintf(stderr, "Unknown sequence...\n");
          else
            {
              if (i < 2 || (i > 8 && i < 18))
                s = getseq(s, w, 0);        //Do case sensitive parsing for directory contains entries...

              else
                s = getseq(s, w);        //otherwise insensitive  :)

              switch (i)
                {
                case 0:
                  strcpy(l1->curdir, w);
                  break;
                case 1:
                  strcpy(l2->curdir, w);
                  break;
                case 2:
                  if (strcmp("panel2", w) == 0)
                    panel = l2;
                  else
                    panel = l1;
                  break;
                case 3:
                  sscanf(w, "%d", &nn);
                  if (nn == 0 || nn > 4)
                    nn = 2;
                  l1->repanel(nn);
                  submenu1.set(1 + nn);
                  break;
                case 4:
                  sscanf(w, "%d", &nn);
                  if (nn == 0 || nn > 4)
                    nn = 2;
                  l2->repanel(nn);
                  submenu2.set(1 + nn);
                  break;
                case 5:
                  if (strcmp(w, "extension") == 0)
                    {
                      l1->comp = extcmp;
                      submenu1.set(7);
                    }
                  else if (strcmp(w, "size") == 0)
                    {
                      l1->comp = sizecmp;
                      submenu1.set(8);
                    }
                  else if (strcmp(w, "time") == 0)
                    {
                      l1->comp = timecmp;
                      submenu1.set(9);
                    }
                  else
                    {
                      l1->comp = mystrcmp;
                      submenu1.set(6);
                    };
                  break;
                case 6:
                  if (strcmp(w, "extension") == 0)
                    {
                      l2->comp = extcmp;
                      submenu2.set(7);
                    }
                  else if (strcmp(w, "size") == 0)
                    {
                      l2->comp = sizecmp;
                      submenu2.set(8);
                    }
                  else if (strcmp(w, "time") == 0)
                    {
                      l2->comp = timecmp;
                      submenu2.set(9);
                    }
                  else
                    {
                      l2->comp = mystrcmp;
                      submenu2.set(6);
                    };
                  break;
                case 7:
                  if (strcmp(w, "brief") == 0)
                    {
                      l1->brief = 1;
                      submenu1.set(0);
                    }
                  else
                    {
                      l1->brief = 0;
                      submenu1.set(1);
                    };
                  break;
                case 8:
                  if (strcmp(w, "brief") == 0)
                    {
                      l2->brief = 1;
                      submenu2.set(0);
                    }
                  else
                    {
                      l2->brief = 0;
                      submenu2.set(1);
                    };
                  break;
                case 9:
                  j = detect_fs(w);
                  getseq(s, w, 0);
                  bmark->add_book(0, w, j);
                  break;
                case 10:
                  j = detect_fs(w);
                  getseq(s, w, 0);
                  bmark->add_book(1, w, j);
                  break;
                case 11:
                  j = detect_fs(w);
                  getseq(s, w, 0);
                  bmark->add_book(2, w, j);
                  break;
                case 12:
                  j = detect_fs(w);
                  getseq(s, w, 0);
                  bmark->add_book(3, w, j);
                  break;
                case 13:
                  j = detect_fs(w);
                  getseq(s, w, 0);
                  bmark->add_book(4, w, j);
                  break;
                case 14:
                  j = detect_fs(w);
                  getseq(s, w, 0);
                  bmark->add_book(5, w, j);
                  break;
                case 15:
                  j = detect_fs(w);
                  getseq(s, w, 0);
                  bmark->add_book(6, w, j);
                  break;
                case 16:
                  j = detect_fs(w);
                  getseq(s, w, 0);
                  bmark->add_book(7, w, j);
                  break;
                case 17:
                  j = detect_fs(w);
                  getseq(s, w, 0);
                  bmark->add_book(8, w, j);
                  break;
                case 18:
                  if (strcmp(w, "no") == 0)
                    {
                      hide_hidden = 1;
                      hidechr[0] = 's';
                    }
                  else
                    {
                      hide_hidden = 0;
                      hidechr[0] = 'S';
                    }
                  break;
                case 19:
                  sscanf(w, "%d", &bmark->percent);
                  if (bmark->percent < 15)
                    bmark->percent = 15;
                };
            }
        }
    }
  fprintf(stderr, "OK\n");
  return 1;
}

void   load_cfg(Lister * l1, Lister * l2)
{
  char  *winname;
  XTextProperty wname;
  init_users();
  load_mnt();
  fprintf(stderr, "Loading extension file......");
  load_ext();
  fprintf(stderr, "OK\nLoading menu file......");
  load_menu();
  fprintf(stderr, "OK\nLoading config......");
  strcpy(rfile, home_files_dir);
  strcat(rfile, "/.xnc.cfg");
  panel = l1;
  l1->repanel(3);
  submenu1.set(4);
  l2->repanel(3);
  submenu2.set(4);
  l1->comp = extcmp;
  submenu1.set(7);
  l2->comp = extcmp;
  submenu2.set(7);
  l2->brief = 1;
  submenu2.set(0);
  l1->brief = 1;
  submenu1.set(0);
  if (load_config(rfile, l1, l2) == 0)
    {
      fprintf(stderr, "\n!!!XNC Panic!!!: Can't open configuration file.\n");
    }
  fprintf(stderr, "Starting %s Build%s.....\n", ver, build_chr);
  strcat(winame, "         User: ");
  strcat(winame, finduser(getuid()));
  strcat(winame, "  Group: ");
  strcat(winame, findgroup(getgid()));
  sprintf(xncvt, "VT100 for %s", winame);
  winname = winame;
  if (XStringListToTextProperty(&winname, 1, &wname) == 0)
    {
      fprintf(stderr, "XNC: Error creating TextProperty\n");
      exit(1);
    }
  else
    XSetWMName(disp, Main, &wname);
  winname = xncvt;
  if (XStringListToTextProperty(&winname, 1, &wname) == 0)
    {
      fprintf(stderr, "XNC: Error creating TextProperty\n");
      exit(1);
    }
  else
    XSetWMName(disp, main_win, &wname);
}

void   save_cfg(Lister * l1, Lister * l2)
{
  FILE  *fp;
  deinit_users();
  del_mnt();
  if (l1 == NULL || l2 == NULL)
    return;
  strcpy(rfile, home_files_dir);
  strcat(rfile, "/.xnc.cfg");
  if ((fp = fopen(rfile, "w")) != NULL)
    {
      fprintf(fp, "#This is configuration file for %s...\n", ver);
      fprintf(fp, "#WARNING: Do NOT EDIT this file. It will be overwritten...\n");
      fprintf(fp, "panel1.path:        %s\n", l1->curdir);
      fprintf(fp, "panel1.columns:     %d\n", l1->col);
      if (l1->comp == mystrcmp)
        fprintf(fp, "panel1.sortby:     name\n");
      else if (l1->comp == extcmp)
        fprintf(fp, "panel1.sortby:     extension\n");
      else if (l1->comp == sizecmp)
        fprintf(fp, "panel1.sortby:     size\n");
      else if (l1->comp == timecmp)
        fprintf(fp, "panel1.sortby:     time\n");
      fprintf(fp, "panel1.style:      ");
      if (l1->brief)
        fprintf(fp, "brief\n");
      else
        fprintf(fp, "full\n");
      fprintf(fp, "panel2.path:        %s\n", l2->curdir);
      fprintf(fp, "panel2.columns:     %d\n", l2->col);
      if (l2->comp == mystrcmp)
        fprintf(fp, "panel2.sortby:     name\n");
      else if (l2->comp == extcmp)
        fprintf(fp, "panel2.sortby:     extension\n");
      else if (l2->comp == sizecmp)
        fprintf(fp, "panel2.sortby:     size\n");
      else if (l2->comp == timecmp)
        fprintf(fp, "panel2.sortby:     time\n");
      fprintf(fp, "panel2.style:      ");
      if (l2->brief)
        fprintf(fp, "brief\n");
      else
        fprintf(fp, "full\n");
      fprintf(fp, "panel.active:       ");
      if (panel == l1)
        fprintf(fp, "panel1\n");
      else
        fprintf(fp, "panel2\n");
      bmark->save_books(fp);
      if (hide_hidden)
        fprintf(fp, "panels.show_hidden_files: no\n");
      else
        fprintf(fp, "panels.show_hidden_files: yes\n");
      fprintf(fp, "panels.percentage:  %d\n", bmark->percent);
      fclose(fp);
    }
  else
    fprintf(stderr, "!!!XNC PANIC!!!: Can't create configuration file. BAD!\n");
}
